/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.loader.AstClass;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warning;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class CAstAbstractLoader
implements IClassLoader {
    protected final Map<TypeName, IClass> types = HashMapFactory.make();
    protected final IClassHierarchy cha;
    protected final IClassLoader parent;
    private final Map<ModuleEntry, Set<Warning>> errors = new HashMap<ModuleEntry, Set<Warning>>();

    public CAstAbstractLoader(IClassHierarchy cha, IClassLoader parent) {
        this.cha = cha;
        this.parent = parent;
    }

    public CAstAbstractLoader(IClassHierarchy cha) {
        this(cha, null);
    }

    public void addMessage(ModuleEntry module, Set<Warning> message) {
        if (!this.errors.containsKey(module)) {
            this.errors.put(module, new HashSet());
        }
        this.errors.get(module).addAll(message);
    }

    public void addMessage(ModuleEntry module, Warning message) {
        if (!this.errors.containsKey(module)) {
            this.errors.put(module, new HashSet());
        }
        this.errors.get(module).add(message);
    }

    private Iterator<ModuleEntry> getMessages(final byte severity) {
        return new MapIterator((Iterator)new FilterIterator(this.errors.entrySet().iterator(), (Predicate)new Predicate<Map.Entry<ModuleEntry, Set<Warning>>>(){

            public boolean test(Map.Entry<ModuleEntry, Set<Warning>> o) {
                for (Warning w : o.getValue()) {
                    if (w.getLevel() != severity) continue;
                    return true;
                }
                return false;
            }
        }), (Function)new Function<Map.Entry<ModuleEntry, Set<Warning>>, ModuleEntry>(){

            public ModuleEntry apply(Map.Entry<ModuleEntry, Set<Warning>> object) {
                return object.getKey();
            }
        });
    }

    public Iterator<ModuleEntry> getModulesWithParseErrors() {
        return this.getMessages((byte)2);
    }

    public Iterator<ModuleEntry> getModulesWithWarnings() {
        return this.getMessages((byte)0);
    }

    public Set<Warning> getMessages(ModuleEntry m) {
        return this.errors.get(m);
    }

    public void clearMessages() {
        this.errors.clear();
    }

    public IClass lookupClass(String className, IClassHierarchy cha) {
        assert (this.cha == cha);
        return this.types.get(TypeName.string2TypeName((String)className));
    }

    public IClass lookupClass(TypeName className) {
        return this.types.get(className);
    }

    public Iterator<IClass> iterateAllClasses() {
        return this.types.values().iterator();
    }

    public int getNumberOfClasses() {
        return this.types.size();
    }

    public Atom getName() {
        return this.getReference().getName();
    }

    public int getNumberOfMethods() {
        int i = 0;
        Iterator<IClass> cls = this.types.values().iterator();
        while (cls.hasNext()) {
            Iterator ms = cls.next().getDeclaredMethods().iterator();
            while (ms.hasNext()) {
                ++i;
                ms.next();
            }
        }
        return i;
    }

    public String getSourceFileName(IMethod method, int bcOffset) {
        if (!(method instanceof AstMethod)) {
            return null;
        }
        CAstSourcePositionMap.Position pos = ((AstMethod)method).getSourcePosition(bcOffset);
        if (pos == null) {
            return null;
        }
        return pos.getURL().getFile();
    }

    public String getSourceFileName(IClass klass) {
        return ((AstClass)klass).getSourcePosition().getURL().getFile();
    }

    public Reader getSource(IClass klass) {
        try {
            return ((AstClass)klass).getSourcePosition().getReader();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Reader getSource(IMethod method, int bcOffset) {
        try {
            return ((AstMethod)method).getSourcePosition(bcOffset).getReader();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IClassLoader getParent() {
        assert (this.parent != null);
        return this.parent;
    }

    public void removeAll(Collection<IClass> toRemove) {
        HashSet keys = HashSetFactory.make();
        for (Map.Entry<TypeName, IClass> E : this.types.entrySet()) {
            if (!toRemove.contains(E.getValue())) continue;
            keys.add(E.getKey());
        }
        Iterator KK = keys.iterator();
        while (KK.hasNext()) {
            this.types.remove(KK.next());
        }
    }
}

