/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.translator;

import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.CAstBinaryOp;
import com.ibm.wala.cast.ir.ssa.CAstUnaryOp;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.ArrayOpHandler;
import com.ibm.wala.cast.ir.translator.ExposedNamesCollector;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.CAstAbstractLoader;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstSymbol;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.cast.tree.impl.CAstSymbolImpl;
import com.ibm.wala.cast.tree.impl.CAstSymbolImplBase;
import com.ibm.wala.cast.tree.rewrite.CAstBasicRewriter;
import com.ibm.wala.cast.tree.rewrite.CAstCloner;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AstTranslator
extends CAstVisitor<WalkContext>
implements ArrayOpHandler,
TranslatorToIR {
    private ArrayOpHandler arrayOpHandler;
    protected final IClassLoader loader;
    protected final Map namedEntityResolver;
    protected final SSAInstructionFactory insts;
    public static final boolean DEBUG_ALL = false;
    public static final boolean DEBUG_TOP = false;
    public static final boolean DEBUG_CFG = false;
    public static final boolean DEBUG_NAMES = false;
    public static final boolean DEBUG_LEXICAL = false;
    private static final boolean DEBUG = false;
    protected Map<CAstEntity, Set<String>> entity2ExposedNames;

    protected abstract boolean useDefaultInitValues();

    protected abstract boolean treatGlobalsAsLexicallyScoped();

    protected boolean topLevelFunctionsInGlobalScope() {
        return true;
    }

    protected abstract TypeReference defaultCatchType();

    protected abstract TypeReference makeType(CAstType var1);

    protected abstract boolean defineType(CAstEntity var1, WalkContext var2);

    protected abstract void declareFunction(CAstEntity var1, WalkContext var2);

    protected abstract void defineFunction(CAstEntity var1, WalkContext var2, AbstractCFG<SSAInstruction, ? extends IBasicBlock<SSAInstruction>> var3, SymbolTable var4, boolean var5, Map<IBasicBlock<SSAInstruction>, TypeReference[]> var6, boolean var7, AstLexicalInformation var8, AstMethod.DebuggingInformation var9);

    protected abstract void defineField(CAstEntity var1, WalkContext var2, CAstEntity var3);

    protected abstract String composeEntityName(WalkContext var1, CAstEntity var2);

    protected abstract void doThrow(WalkContext var1, int var2);

    @Override
    public abstract void doArrayRead(WalkContext var1, int var2, int var3, CAstNode var4, int[] var5);

    @Override
    public abstract void doArrayWrite(WalkContext var1, int var2, CAstNode var3, int[] var4, int var5);

    protected abstract void doFieldRead(WalkContext var1, int var2, int var3, CAstNode var4, CAstNode var5);

    protected abstract void doFieldWrite(WalkContext var1, int var2, CAstNode var3, CAstNode var4, int var5);

    protected abstract void doMaterializeFunction(CAstNode var1, WalkContext var2, int var3, int var4, CAstEntity var5);

    protected abstract void doNewObject(WalkContext var1, CAstNode var2, int var3, Object var4, int[] var5);

    protected abstract void doCall(WalkContext var1, CAstNode var2, int var3, int var4, CAstNode var5, int var6, int[] var7);

    protected abstract CAstType topType();

    protected abstract CAstType exceptionType();

    protected boolean isExceptionLabel(Object label) {
        if (label == null) {
            return false;
        }
        if (label instanceof Boolean) {
            return false;
        }
        if (label instanceof Number) {
            return false;
        }
        return label != CAstControlFlowMap.SWITCH_DEFAULT;
    }

    protected boolean hasImplicitGlobals() {
        return false;
    }

    protected boolean hasSpecialUndeclaredVariables() {
        return false;
    }

    protected void handleUnspecifiedLiteralKey(WalkContext context, CAstNode objectLiteralNode, int unspecifiedLiteralIndex, CAstVisitor<WalkContext> visitor) {
        Assertions.UNREACHABLE();
    }

    protected void doPrologue(WalkContext context) {
        CAstEntity entity = context.top();
        Set<String> exposedNames = this.entity2ExposedNames.get(entity);
        if (exposedNames != null) {
            int i = 0;
            String[] stringArray = entity.getArgumentNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (exposedNames.contains(arg)) {
                    Scope currentScope = context.currentScope();
                    Symbol symbol = currentScope.lookup(arg);
                    assert (symbol.getDefiningScope() == currentScope);
                    int argVN = symbol.valueNumber();
                    CAstType type = entity.getType() instanceof CAstType.Method ? ((CAstType.Method)entity.getType()).getArgumentTypes().get(i) : this.topType();
                    AstLexicalAccess.Access A = new AstLexicalAccess.Access(arg, context.getEntityName(entity), this.makeType(type), argVN);
                    context.cfg().addInstruction(new AstLexicalWrite(context.cfg().currentInstruction, A));
                }
                ++n2;
            }
        }
    }

    protected abstract void doPrimitive(int var1, WalkContext var2, CAstNode var3);

    protected int doLocalRead(WalkContext context, String name, TypeReference type) {
        CAstEntity entity = context.top();
        Set<String> exposed = this.entity2ExposedNames.get(entity);
        if (exposed != null && exposed.contains(name)) {
            return this.doLexReadHelper(context, name, type);
        }
        return context.currentScope().lookup(name).valueNumber();
    }

    protected void doLocalWrite(WalkContext context, String nm, TypeReference type, int rval) {
        CAstEntity entity = context.top();
        Set<String> exposed = this.entity2ExposedNames.get(entity);
        if (exposed != null && exposed.contains(nm)) {
            this.doLexicallyScopedWrite(context, nm, type, rval);
            return;
        }
        int lval = context.currentScope().lookup(nm).valueNumber();
        if (lval != rval) {
            context.cfg().addInstruction((SSAInstruction)new AssignInstruction(context.cfg().currentInstruction, lval, rval));
        }
    }

    protected int doLexicallyScopedRead(CAstNode node, WalkContext context, String name, TypeReference type) {
        return this.doLexReadHelper(context, name, type);
    }

    protected boolean ignoreName(String name) {
        return false;
    }

    private int doLexReadHelper(WalkContext context, String name, TypeReference type) {
        Symbol S = context.currentScope().lookup(name);
        Scope definingScope = S.getDefiningScope();
        CAstEntity E = definingScope.getEntity();
        this.addExposedName(E, E, name, definingScope.lookup(name).valueNumber(), false, context);
        String entityName = context.getEntityName(E);
        int result = context.currentScope().allocateTempValue();
        AstLexicalAccess.Access A = new AstLexicalAccess.Access(name, entityName, type, result);
        context.cfg().addInstruction(new AstLexicalRead(context.cfg().currentInstruction, A));
        this.markExposedInEnclosingEntities(context, name, definingScope, type, E, entityName, false);
        return result;
    }

    private void markExposedInEnclosingEntities(WalkContext context, String name, Scope definingScope, TypeReference type, CAstEntity E, String entityName, boolean isWrite) {
        Scope curScope = context.currentScope();
        while (!curScope.equals(definingScope)) {
            Symbol curSymbol = curScope.lookup(name);
            int vn = curSymbol.valueNumber();
            AstLexicalAccess.Access A = new AstLexicalAccess.Access(name, entityName, type, vn);
            CAstEntity entity = curScope.getEntity();
            if (entity != definingScope.getEntity()) {
                this.addExposedName(entity, E, name, vn, isWrite, context);
                this.addAccess(context, entity, A);
            }
            curScope = curScope.getParent();
        }
    }

    protected void doLexicallyScopedWrite(WalkContext context, String name, TypeReference type, int rval) {
        Symbol S = context.currentScope().lookup(name);
        Scope definingScope = S.getDefiningScope();
        CAstEntity E = definingScope.getEntity();
        this.addExposedName(E, E, name, definingScope.lookup(name).valueNumber(), true, context);
        AstLexicalAccess.Access A = new AstLexicalAccess.Access(name, context.getEntityName(E), type, rval);
        context.cfg().addInstruction(new AstLexicalWrite(context.cfg().currentInstruction, A));
        this.markExposedInEnclosingEntities(context, name, definingScope, type, E, context.getEntityName(E), true);
    }

    protected int doGlobalRead(CAstNode node, WalkContext context, String name, TypeReference type) {
        if (this.treatGlobalsAsLexicallyScoped()) {
            int result = context.currentScope().allocateTempValue();
            AstLexicalAccess.Access A = new AstLexicalAccess.Access(name, null, type, result);
            context.cfg().addInstruction(new AstLexicalRead(context.cfg().currentInstruction, A));
            this.addAccess(context, context.top(), A);
            return result;
        }
        int result = context.currentScope().allocateTempValue();
        FieldReference global = this.makeGlobalRef(name);
        context.cfg().addInstruction((SSAInstruction)new AstGlobalRead(context.cfg().currentInstruction, result, global));
        return result;
    }

    protected void doGlobalWrite(WalkContext context, String name, TypeReference type, int rval) {
        if (this.treatGlobalsAsLexicallyScoped()) {
            AstLexicalAccess.Access A = new AstLexicalAccess.Access(name, null, type, rval);
            context.cfg().addInstruction(new AstLexicalWrite(context.cfg().currentInstruction, A));
            this.addAccess(context, context.top(), A);
        } else {
            FieldReference global = this.makeGlobalRef(name);
            context.cfg().addInstruction((SSAInstruction)new AstGlobalWrite(context.cfg().currentInstruction, global, rval));
        }
    }

    protected void doIsFieldDefined(WalkContext context, int result, int ref, CAstNode field) {
        Assertions.UNREACHABLE();
    }

    protected FieldReference makeGlobalRef(String globalName) {
        TypeReference rootTypeRef = TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)AstTypeReference.rootTypeName);
        return FieldReference.findOrCreate((TypeReference)rootTypeRef, (Atom)Atom.findOrCreateUnicodeAtom((String)("global " + globalName)), (TypeReference)rootTypeRef);
    }

    protected AstTranslator(IClassLoader loader, Map namedEntityResolver, ArrayOpHandler arrayOpHandler) {
        this.loader = loader;
        this.namedEntityResolver = namedEntityResolver;
        this.arrayOpHandler = arrayOpHandler != null ? arrayOpHandler : this;
        this.insts = loader.getInstructionFactory();
    }

    protected AstTranslator(IClassLoader loader, Map namedEntityResolver) {
        this(loader, namedEntityResolver, null);
    }

    protected AstTranslator(IClassLoader loader) {
        this(loader, null);
    }

    protected AbstractScope makeScriptScope(final CAstEntity s, Scope parent) {
        return new AbstractScope(this, parent){
            SymbolTable scriptGlobalSymtab;
            {
                super($anonymous0);
                this.scriptGlobalSymtab = new SymbolTable(cAstEntity.getArgumentCount());
            }

            @Override
            public SymbolTable getUnderlyingSymtab() {
                return this.scriptGlobalSymtab;
            }

            @Override
            protected AbstractScope getEntityScope() {
                return this;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s2) {
                if (this.isGlobal(s2)) {
                    return false;
                }
                return ((AbstractScope)s2.getDefiningScope()).getEntity() != this.getEntity();
            }

            @Override
            public CAstEntity getEntity() {
                return s;
            }

            @Override
            public ScopeType type() {
                return ScopeType.SCRIPT;
            }

            @Override
            protected Symbol makeSymbol(final String nm, final CAstType type, boolean isFinal, final boolean isInternalName, Object defaultInitValue, int vn, Scope definer) {
                int v;
                if (!$assertionsDisabled && nm == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
                int n = v = vn == -1 ? this.getUnderlyingSymtab().newSymbol() : vn;
                if (this.useDefaultInitValues() && defaultInitValue != null && this.getUnderlyingSymtab().getValue(v) == null) {
                    this.setDefaultValue(this.getUnderlyingSymtab(), v, defaultInitValue);
                }
                return new AbstractSymbol(definer, isFinal, defaultInitValue){

                    public String toString() {
                        return String.valueOf(nm) + ":" + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return type;
                    }

                    @Override
                    public int valueNumber() {
                        return v;
                    }

                    @Override
                    public boolean isInternalName() {
                        return isInternalName;
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }
                };
            }
        };
    }

    protected int getArgumentCount(CAstEntity f) {
        return f.getArgumentCount();
    }

    protected String[] getArgumentNames(CAstEntity f) {
        return f.getArgumentNames();
    }

    private AbstractScope makeFunctionScope(final CAstEntity f, Scope parent) {
        return new AbstractScope(this, parent){
            private final String[] params;
            private final SymbolTable functionSymtab;
            {
                super($anonymous0);
                this.params = astTranslator2.getArgumentNames(cAstEntity);
                this.functionSymtab = new SymbolTable(astTranslator2.getArgumentCount(cAstEntity));
                int i = 0;
                while (i < astTranslator2.getArgumentCount(cAstEntity)) {
                    final int yuck = i++;
                    this.declare(new CAstSymbol(){

                        @Override
                        public String name() {
                            return params[yuck];
                        }

                        @Override
                        public CAstType type() {
                            if (cAstEntity.getType() instanceof CAstType.Method) {
                                if (yuck == 0) {
                                    return ((CAstType.Method)cAstEntity.getType()).getDeclaringType();
                                }
                                return ((CAstType.Method)cAstEntity.getType()).getArgumentTypes().get(yuck - 1);
                            }
                            if (cAstEntity.getType() instanceof CAstType.Function) {
                                return ((CAstType.Function)cAstEntity.getType()).getArgumentTypes().get(yuck);
                            }
                            return this.topType();
                        }

                        @Override
                        public boolean isFinal() {
                            return false;
                        }

                        @Override
                        public boolean isCaseInsensitive() {
                            return false;
                        }

                        @Override
                        public boolean isInternalName() {
                            return false;
                        }

                        @Override
                        public Object defaultInitValue() {
                            return null;
                        }
                    });
                }
            }

            public String toString() {
                return "scope for " + f.getName();
            }

            @Override
            public SymbolTable getUnderlyingSymtab() {
                return this.functionSymtab;
            }

            @Override
            protected AbstractScope getEntityScope() {
                return this;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s) {
                if (this.isGlobal(s)) {
                    return false;
                }
                return ((AbstractScope)s.getDefiningScope()).getEntity() != this.getEntity();
            }

            @Override
            public CAstEntity getEntity() {
                return f;
            }

            @Override
            public ScopeType type() {
                return ScopeType.FUNCTION;
            }

            private int find(String n) {
                int i = 0;
                while (i < this.params.length) {
                    if (n.equals(this.params[i])) {
                        return i + 1;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            protected Symbol makeSymbol(final String nm, final CAstType type, boolean isFinal, final boolean isInternalName, Object defaultInitValue, int valueNumber, Scope definer) {
                if (!$assertionsDisabled && nm == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
                return new AbstractSymbol(definer, isFinal, defaultInitValue, valueNumber, defaultInitValue){
                    final int vn;
                    {
                        super($anonymous0, $anonymous1, $anonymous2);
                        int x = this.find(string);
                        if (x != -1) {
                            if (!$assertionsDisabled && n != -1) {
                                throw new AssertionError();
                            }
                            this.vn = x;
                        } else {
                            this.vn = n != -1 ? n : this.getUnderlyingSymtab().newSymbol();
                        }
                        if (this.useDefaultInitValues() && object != null && this.getUnderlyingSymtab().getValue(this.vn) == null) {
                            this.setDefaultValue(this.getUnderlyingSymtab(), this.vn, object);
                        }
                    }

                    @Override
                    public CAstType type() {
                        return type;
                    }

                    public String toString() {
                        return String.valueOf(nm) + ":" + System.identityHashCode(this);
                    }

                    @Override
                    public int valueNumber() {
                        return this.vn;
                    }

                    @Override
                    public boolean isInternalName() {
                        return isInternalName;
                    }

                    @Override
                    public boolean isParameter() {
                        return this.vn <= params.length;
                    }
                };
            }
        };
    }

    private Scope makeLocalScope(CAstNode s, final Scope parent) {
        return new AbstractScope(this, parent){

            @Override
            public ScopeType type() {
                return ScopeType.LOCAL;
            }

            @Override
            public SymbolTable getUnderlyingSymtab() {
                return ((AbstractScope)parent).getUnderlyingSymtab();
            }

            @Override
            protected AbstractScope getEntityScope() {
                return ((AbstractScope)parent).getEntityScope();
            }

            @Override
            public boolean isLexicallyScoped(Symbol s) {
                return this.getEntityScope().isLexicallyScoped(s);
            }

            @Override
            public CAstEntity getEntity() {
                return this.getEntityScope().getEntity();
            }

            @Override
            protected Symbol makeSymbol(final String nm, final CAstType type, boolean isFinal, final boolean isInternalName, Object defaultInitValue, int vn, Scope definer) {
                int v;
                int n = v = vn == -1 ? this.getUnderlyingSymtab().newSymbol() : vn;
                if (this.useDefaultInitValues() && defaultInitValue != null && this.getUnderlyingSymtab().getValue(v) == null) {
                    this.setDefaultValue(this.getUnderlyingSymtab(), v, defaultInitValue);
                }
                if (!$assertionsDisabled && nm == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
                return new AbstractSymbol(definer, isFinal, defaultInitValue){

                    public String toString() {
                        return String.valueOf(nm) + ":" + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return type;
                    }

                    @Override
                    public int valueNumber() {
                        return v;
                    }

                    @Override
                    public boolean isInternalName() {
                        return isInternalName;
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }
                };
            }
        };
    }

    private Scope makeGlobalScope() {
        final LinkedHashMap globalSymbols = new LinkedHashMap();
        final LinkedHashMap caseInsensitiveNames = new LinkedHashMap();
        return new Scope(){

            public String toString() {
                return "global scope";
            }

            private final String mapName(String nm) {
                String mappedName = (String)caseInsensitiveNames.get(nm.toLowerCase());
                return mappedName == null ? nm : mappedName;
            }

            @Override
            public Scope getParent() {
                return null;
            }

            @Override
            public boolean isGlobal(Symbol s) {
                return true;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s) {
                return false;
            }

            @Override
            public CAstEntity getEntity() {
                return null;
            }

            @Override
            public int size() {
                return globalSymbols.size();
            }

            @Override
            public Iterator<String> getAllNames() {
                return globalSymbols.keySet().iterator();
            }

            @Override
            public int allocateTempValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getConstantValue(Object c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getConstantObject(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ScopeType type() {
                return ScopeType.GLOBAL;
            }

            @Override
            public boolean contains(String name) {
                return AstTranslator.this.hasImplicitGlobals() || globalSymbols.containsKey(this.mapName(name));
            }

            @Override
            public boolean isCaseInsensitive(String name) {
                return caseInsensitiveNames.containsKey(name.toLowerCase());
            }

            @Override
            public Symbol lookup(final String name) {
                if (!globalSymbols.containsKey(this.mapName(name))) {
                    if (AstTranslator.this.hasImplicitGlobals()) {
                        this.declare(new CAstSymbol(){

                            @Override
                            public String name() {
                                return name;
                            }

                            @Override
                            public boolean isFinal() {
                                return false;
                            }

                            @Override
                            public boolean isCaseInsensitive() {
                                return false;
                            }

                            @Override
                            public boolean isInternalName() {
                                return false;
                            }

                            @Override
                            public Object defaultInitValue() {
                                return null;
                            }

                            @Override
                            public CAstType type() {
                                return AstTranslator.this.topType();
                            }
                        });
                    } else {
                        if (AstTranslator.this.hasSpecialUndeclaredVariables()) {
                            return null;
                        }
                        throw new Error("cannot find " + name);
                    }
                }
                return (Symbol)globalSymbols.get(this.mapName(name));
            }

            @Override
            public void declare(CAstSymbol s, int vn) {
                if (!$assertionsDisabled && vn != -1) {
                    throw new AssertionError();
                }
                this.declare(s);
            }

            @Override
            public void declare(final CAstSymbol s) {
                final String name = s.name();
                if (s.isCaseInsensitive()) {
                    caseInsensitiveNames.put(name.toLowerCase(), name);
                }
                globalSymbols.put(name, new AbstractSymbol(this, s.isFinal(), s.defaultInitValue()){

                    public String toString() {
                        return String.valueOf(name) + ":" + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return s.type();
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }

                    @Override
                    public boolean isInternalName() {
                        return s.isInternalName();
                    }

                    @Override
                    public int valueNumber() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    protected Scope makeTypeScope(final CAstEntity type, final Scope parent) {
        final LinkedHashMap typeSymbols = new LinkedHashMap();
        final LinkedHashMap caseInsensitiveNames = new LinkedHashMap();
        return new Scope(){

            private final String mapName(String nm) {
                String mappedName = (String)caseInsensitiveNames.get(nm.toLowerCase());
                return mappedName == null ? nm : mappedName;
            }

            @Override
            public Scope getParent() {
                return parent;
            }

            @Override
            public boolean isGlobal(Symbol s) {
                return false;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s) {
                return false;
            }

            @Override
            public CAstEntity getEntity() {
                return type;
            }

            @Override
            public int size() {
                return typeSymbols.size();
            }

            @Override
            public Iterator<String> getAllNames() {
                return typeSymbols.keySet().iterator();
            }

            @Override
            public int allocateTempValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getConstantValue(Object c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getConstantObject(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ScopeType type() {
                return ScopeType.TYPE;
            }

            @Override
            public boolean contains(String name) {
                return typeSymbols.containsKey(this.mapName(name));
            }

            @Override
            public boolean isCaseInsensitive(String name) {
                return caseInsensitiveNames.containsKey(name.toLowerCase());
            }

            @Override
            public Symbol lookup(String nm) {
                if (typeSymbols.containsKey(this.mapName(nm))) {
                    return (Symbol)typeSymbols.get(this.mapName(nm));
                }
                return parent.lookup(nm);
            }

            @Override
            public void declare(CAstSymbol s, int vn) {
                if (!$assertionsDisabled && vn != -1) {
                    throw new AssertionError();
                }
                this.declare(s);
            }

            @Override
            public void declare(final CAstSymbol s) {
                final String name = s.name();
                if (!$assertionsDisabled && s.isFinal()) {
                    throw new AssertionError();
                }
                if (s.isCaseInsensitive()) {
                    caseInsensitiveNames.put(name.toLowerCase(), name);
                }
                typeSymbols.put(name, new AbstractSymbol(this, s.isFinal(), s.defaultInitValue()){

                    public String toString() {
                        return String.valueOf(name) + ":" + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return s.type();
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }

                    @Override
                    public boolean isInternalName() {
                        return s.isInternalName();
                    }

                    @Override
                    public int valueNumber() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    private void addAccess(WalkContext context, CAstEntity e, AstLexicalAccess.Access access) {
        context.getAccesses(e).add(access);
    }

    private void addExposedName(CAstEntity entity, CAstEntity declaration, String name, int valueNumber, boolean isWrite, WalkContext context) {
        Pair newVal = Pair.make((Object)Pair.make((Object)name, (Object)context.getEntityName(declaration)), (Object)valueNumber);
        context.exposeNameSet(entity, isWrite).add((Pair<Pair<String, String>, Integer>)newVal);
    }

    public void setDefaultValue(SymbolTable symtab, int vn, Object value) {
        if (value == CAstSymbol.NULL_DEFAULT_VALUE) {
            symtab.setDefaultValue(vn, null);
        } else {
            symtab.setDefaultValue(vn, value);
        }
    }

    protected IUnaryOpInstruction.IOperator translateUnaryOpcode(CAstNode op) {
        if (op == CAstOperator.OP_BITNOT) {
            return CAstUnaryOp.BITNOT;
        }
        if (op == CAstOperator.OP_NOT) {
            return IUnaryOpInstruction.Operator.NEG;
        }
        if (op == CAstOperator.OP_SUB) {
            return CAstUnaryOp.MINUS;
        }
        if (op == CAstOperator.OP_ADD) {
            return CAstUnaryOp.PLUS;
        }
        Assertions.UNREACHABLE((String)("cannot translate " + CAstPrinter.print(op)));
        return null;
    }

    protected IBinaryOpInstruction.IOperator translateBinaryOpcode(CAstNode op) {
        if (op == CAstOperator.OP_ADD) {
            return IBinaryOpInstruction.Operator.ADD;
        }
        if (op == CAstOperator.OP_DIV) {
            return IBinaryOpInstruction.Operator.DIV;
        }
        if (op == CAstOperator.OP_LSH) {
            return IShiftInstruction.Operator.SHL;
        }
        if (op == CAstOperator.OP_MOD) {
            return IBinaryOpInstruction.Operator.REM;
        }
        if (op == CAstOperator.OP_MUL) {
            return IBinaryOpInstruction.Operator.MUL;
        }
        if (op == CAstOperator.OP_RSH) {
            return IShiftInstruction.Operator.SHR;
        }
        if (op == CAstOperator.OP_SUB) {
            return IBinaryOpInstruction.Operator.SUB;
        }
        if (op == CAstOperator.OP_URSH) {
            return IShiftInstruction.Operator.USHR;
        }
        if (op == CAstOperator.OP_BIT_AND) {
            return IBinaryOpInstruction.Operator.AND;
        }
        if (op == CAstOperator.OP_BIT_OR) {
            return IBinaryOpInstruction.Operator.OR;
        }
        if (op == CAstOperator.OP_BIT_XOR) {
            return IBinaryOpInstruction.Operator.XOR;
        }
        if (op == CAstOperator.OP_CONCAT) {
            return CAstBinaryOp.CONCAT;
        }
        if (op == CAstOperator.OP_EQ) {
            return CAstBinaryOp.EQ;
        }
        if (op == CAstOperator.OP_STRICT_EQ) {
            return CAstBinaryOp.STRICT_EQ;
        }
        if (op == CAstOperator.OP_GE) {
            return CAstBinaryOp.GE;
        }
        if (op == CAstOperator.OP_GT) {
            return CAstBinaryOp.GT;
        }
        if (op == CAstOperator.OP_LE) {
            return CAstBinaryOp.LE;
        }
        if (op == CAstOperator.OP_LT) {
            return CAstBinaryOp.LT;
        }
        if (op == CAstOperator.OP_NE) {
            return CAstBinaryOp.NE;
        }
        if (op == CAstOperator.OP_STRICT_NE) {
            return CAstBinaryOp.STRICT_NE;
        }
        Assertions.UNREACHABLE((String)("cannot translate " + CAstPrinter.print(op)));
        return null;
    }

    protected IConditionalBranchInstruction.IOperator translateConditionOpcode(CAstNode op) {
        if (op == CAstOperator.OP_EQ) {
            return IConditionalBranchInstruction.Operator.EQ;
        }
        if (op == CAstOperator.OP_GE) {
            return IConditionalBranchInstruction.Operator.GE;
        }
        if (op == CAstOperator.OP_GT) {
            return IConditionalBranchInstruction.Operator.GT;
        }
        if (op == CAstOperator.OP_LE) {
            return IConditionalBranchInstruction.Operator.LE;
        }
        if (op == CAstOperator.OP_LT) {
            return IConditionalBranchInstruction.Operator.LT;
        }
        if (op == CAstOperator.OP_NE) {
            return IConditionalBranchInstruction.Operator.NE;
        }
        assert (false) : "cannot translate " + CAstPrinter.print(op);
        return null;
    }

    protected String[] makeNameMap(CAstEntity n, Set<Scope> scopes, SSAInstruction[] insts) {
        String[] map = new String[scopes.iterator().next().size() + 1];
        for (Scope scope : scopes) {
            Iterator<String> I = scope.getAllNames();
            while (I.hasNext()) {
                Symbol v;
                String nm = I.next();
                if (this.ignoreName(nm) || (v = scope.lookup(nm)).isInternalName() || scope.isConstant(v.valueNumber())) continue;
                assert (map[v.valueNumber()] == null || map[v.valueNumber()].equals(nm) || this.ignoreName(map[v.valueNumber()])) : "value number " + v.valueNumber() + " mapped to multiple names in " + n.getName() + ": " + nm + " and " + map[v.valueNumber()];
                map[v.valueNumber()] = nm;
            }
        }
        return map;
    }

    protected final CAstType getTypeForNode(WalkContext context, CAstNode node) {
        if (context.top().getNodeTypeMap() != null) {
            return context.top().getNodeTypeMap().getNodeType(node);
        }
        return null;
    }

    private CAstSourcePositionMap.Position getPosition(CAstSourcePositionMap map, CAstNode n) {
        if (map.getPosition(n) != null) {
            return map.getPosition(n);
        }
        int i = 0;
        while (i < n.getChildCount()) {
            CAstSourcePositionMap.Position p = this.getPosition(map, n.getChild(i));
            if (p != null) {
                return p;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected WalkContext makeFileContext(WalkContext c, CAstEntity n) {
        return new FileContext(c, n.getName());
    }

    @Override
    protected WalkContext makeTypeContext(WalkContext c, CAstEntity n) {
        return new TypeContext(c, n);
    }

    @Override
    protected WalkContext makeCodeContext(WalkContext context, CAstEntity n) {
        AbstractScope scope = n.getKind() == 2 ? this.makeScriptScope(n, context.currentScope()) : this.makeFunctionScope(n, context.currentScope());
        return new CodeEntityContext(context, scope, n);
    }

    @Override
    protected boolean enterEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected boolean visitFileEntity(CAstEntity n, WalkContext context, WalkContext fileContext, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFileEntity(CAstEntity n, WalkContext context, WalkContext fileContext, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitFieldEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFieldEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        CAstEntity topEntity = context.top();
        assert (topEntity.getKind() == 3) : "Parent of field entity is not a type???";
        this.defineField(topEntity, context, n);
    }

    @Override
    protected boolean visitGlobalEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveGlobalEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        context.getGlobalScope().declare(new CAstSymbolImpl(n.getName(), n.getType()));
    }

    @Override
    protected boolean visitTypeEntity(CAstEntity n, WalkContext context, WalkContext typeContext, CAstVisitor<WalkContext> visitor) {
        return !this.defineType(n, context);
    }

    @Override
    protected void leaveTypeEntity(CAstEntity n, WalkContext context, WalkContext typeContext, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitFunctionEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        if (n.getAST() == null) {
            this.declareFunction(n, context);
        } else {
            this.initFunctionEntity(n, context, codeContext);
        }
        return false;
    }

    @Override
    protected void leaveFunctionEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        if (n.getAST() != null) {
            this.closeFunctionEntity(n, context, codeContext);
        }
    }

    @Override
    protected boolean visitMacroEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        return true;
    }

    @Override
    protected boolean visitScriptEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        this.declareFunction(n, codeContext);
        this.initFunctionEntity(n, context, codeContext);
        return false;
    }

    @Override
    protected void leaveScriptEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        this.closeFunctionEntity(n, context, codeContext);
    }

    public void initFunctionEntity(CAstEntity n, WalkContext parentContext, WalkContext functionContext) {
        functionContext.cfg().makeEntryBlock(functionContext.cfg().newBlock(false));
        functionContext.cfg().newBlock(true);
        this.doPrologue(functionContext);
    }

    public void closeFunctionEntity(CAstEntity n, WalkContext parentContext, WalkContext functionContext) {
        functionContext.cfg().makeExitBlock(functionContext.cfg().newBlock(true));
        SymbolTable symtab = ((AbstractScope)functionContext.currentScope()).getUnderlyingSymtab();
        Map<IBasicBlock<SSAInstruction>, TypeReference[]> catchTypes = functionContext.getCatchTypes();
        AstCFG cfg = new AstCFG(n, functionContext.cfg(), symtab, this.insts);
        CAstSourcePositionMap.Position[] line = functionContext.cfg().getLinePositionMap();
        boolean katch = functionContext.cfg().hasCatchBlock();
        boolean monitor = functionContext.cfg().hasMonitorOp();
        String[] nms = this.makeNameMap(n, functionContext.entityScopes(), cfg.getInstructions());
        AstLexicalInformation LI = new AstLexicalInformation(functionContext.getEntityName(n), functionContext.currentScope(), cfg.getInstructions(), functionContext.exposeNameSet(n, false), functionContext.exposeNameSet(n, true), functionContext.getAccesses(n));
        AstDebuggingInformation DBG = new AstDebuggingInformation(n.getPosition(), line, nms);
        this.defineFunction(n, parentContext, cfg, symtab, katch, catchTypes, monitor, LI, DBG);
    }

    @Override
    protected WalkContext makeLocalContext(WalkContext context, CAstNode n) {
        return new LocalContext(context, this.makeLocalScope(n, context.currentScope()));
    }

    @Override
    protected WalkContext makeSpecialParentContext(final WalkContext context, CAstNode n) {
        final String specialName = (String)n.getChild(0).getValue();
        return new LocalContext(context, new AbstractScope(this, context.currentScope()){
            private Scope parent;
            {
                super($anonymous0);
                this.parent = null;
            }

            private Scope parent() {
                if (this.parent == null) {
                    this.parent = ((AbstractScope)context.currentScope()).getEntityScope().getParent();
                }
                return this.parent;
            }

            @Override
            public ScopeType type() {
                return ScopeType.LOCAL;
            }

            private Scope scopeFor(String name) {
                if (name.equals(specialName)) {
                    return this.parent();
                }
                return context.currentScope();
            }

            @Override
            public boolean contains(String name) {
                return this.scopeFor(name).contains(name);
            }

            @Override
            public Symbol lookup(String name) {
                return this.scopeFor(name).lookup(name);
            }

            @Override
            protected SymbolTable getUnderlyingSymtab() {
                return ((AbstractScope)context.currentScope()).getUnderlyingSymtab();
            }

            @Override
            protected Symbol makeSymbol(String nm, CAstType type, boolean isFinal, boolean isInternalName, Object defaultInitValue, int vn, Scope parent) {
                return ((AbstractScope)context.currentScope()).makeSymbol(nm, type, isFinal, isInternalName, defaultInitValue, vn, parent);
            }

            @Override
            protected AbstractScope getEntityScope() {
                return ((AbstractScope)context.currentScope()).getEntityScope();
            }

            @Override
            public boolean isLexicallyScoped(Symbol s) {
                return context.currentScope().isLexicallyScoped(s);
            }

            @Override
            public CAstEntity getEntity() {
                return context.top();
            }
        });
    }

    @Override
    protected WalkContext makeUnwindContext(WalkContext context, CAstNode n, CAstVisitor<WalkContext> visitor) {
        return new UnwindContext(n, context, visitor);
    }

    protected int processFunctionExpr(CAstNode n, WalkContext context) {
        CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
        this.declareFunction(fn, context);
        int result = context.currentScope().allocateTempValue();
        int ex = context.currentScope().allocateTempValue();
        this.doMaterializeFunction(n, context, result, ex, fn);
        return result;
    }

    @Override
    protected boolean visitFunctionExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFunctionExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int result = this.processFunctionExpr(n, c);
        c.setValue(n, result);
    }

    @Override
    protected boolean visitFunctionStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFunctionStmt(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        int result = this.processFunctionExpr(n, context);
        CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
        Scope cs = context.currentScope();
        if (cs.contains(fn.getName()) && !cs.isLexicallyScoped(cs.lookup(fn.getName())) && !cs.isGlobal(cs.lookup(fn.getName()))) {
            this.assignValue(n, context, cs.lookup(fn.getName()), fn.getName(), result);
        } else if (this.topLevelFunctionsInGlobalScope() && context.top().getKind() == 2) {
            context.getGlobalScope().declare(new FinalCAstSymbol(fn.getName(), fn.getType()));
            this.assignValue(n, context, cs.lookup(fn.getName()), fn.getName(), result);
        } else {
            context.currentScope().declare(new FinalCAstSymbol(fn.getName(), fn.getType()), result);
        }
    }

    @Override
    protected boolean visitLocalScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected boolean visitSpecialParentScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveLocalScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(0)));
    }

    @Override
    protected void leaveSpecialParentScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(1)));
    }

    @Override
    protected boolean visitBlockExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(n.getChildCount() - 1)));
    }

    @Override
    protected boolean visitBlockStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitLoop(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        context.cfg().newBlock(true);
        PreBasicBlock headerB = context.cfg().getCurrentBlock();
        visitor.visit(n.getChild(0), context, visitor);
        assert (c.getValue(n.getChild(0)) != -1) : "error in loop test " + CAstPrinter.print(n.getChild(0), context.top().getSourceMap()) + " of loop " + CAstPrinter.print(n, context.top().getSourceMap());
        context.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(context.cfg().currentInstruction, this.translateConditionOpcode(CAstOperator.OP_EQ), null, c.getValue(n.getChild(0)), context.currentScope().getConstantValue(new Integer(0)), -1));
        PreBasicBlock branchB = context.cfg().getCurrentBlock();
        context.cfg().newBlock(true);
        visitor.visit(n.getChild(1), context, visitor);
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            context.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
            PreBasicBlock bodyB = context.cfg().getCurrentBlock();
            context.cfg().addEdge(bodyB, headerB);
            context.cfg().newBlock(false);
        }
        PreBasicBlock nextB = context.cfg().getCurrentBlock();
        context.cfg().addEdge(branchB, nextB);
        return true;
    }

    @Override
    protected final void leaveLoopHeader(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveLoop(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitGetCaughtException(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveGetCaughtException(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        String nm = (String)n.getChild(0).getValue();
        context.currentScope().declare(new FinalCAstSymbol(nm, this.exceptionType()));
        context.cfg().addInstruction((SSAInstruction)this.insts.GetCaughtExceptionInstruction(context.cfg().currentInstruction, context.cfg().getCurrentBlock().getNumber(), context.currentScope().lookup(nm).valueNumber()));
    }

    @Override
    protected boolean visitThis(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveThis(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, 1);
    }

    @Override
    protected boolean visitSuper(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveSuper(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, 1);
    }

    @Override
    protected boolean visitCall(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveCall(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        int exp = context.currentScope().allocateTempValue();
        int fun = c.getValue(n.getChild(0));
        CAstNode functionName = n.getChild(1);
        int[] args = new int[n.getChildCount() - 2];
        int i = 0;
        while (i < args.length) {
            args[i] = c.getValue(n.getChild(i + 2));
            ++i;
        }
        this.doCall(context, n, result, exp, functionName, fun, args);
    }

    @Override
    protected boolean visitVar(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveVar(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        String nm = (String)n.getChild(0).getValue();
        assert (nm != null) : "cannot find var for " + CAstPrinter.print(n, context.getSourceMap());
        Symbol s = context.currentScope().lookup(nm);
        assert (s != null) : "cannot find symbol for " + nm + " at " + CAstPrinter.print(n, context.getSourceMap());
        assert (s.type() != null) : "no type for " + nm + " at " + CAstPrinter.print(n, context.getSourceMap());
        TypeReference type = this.makeType(s.type());
        if (context.currentScope().isGlobal(s)) {
            c.setValue(n, this.doGlobalRead(n, context, nm, type));
        } else if (context.currentScope().isLexicallyScoped(s)) {
            c.setValue(n, this.doLexicallyScopedRead(n, context, nm, type));
        } else {
            c.setValue(n, this.doLocalRead(context, nm, type));
        }
    }

    @Override
    protected boolean visitConstant(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveConstant(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        c.setValue(n, context.currentScope().getConstantValue(n.getValue()));
    }

    @Override
    protected boolean visitBinaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    private boolean handleBinaryOpThrow(CAstNode n, CAstNode op, WalkContext context) {
        boolean mayBeInteger = false;
        Collection<Object> labels = context.getControlFlow().getTargetLabels(n);
        if (!labels.isEmpty()) {
            context.cfg().addPreNode(n, context.getUnwindState());
            mayBeInteger = true;
            assert (op == CAstOperator.OP_DIV || op == CAstOperator.OP_MOD) : CAstPrinter.print(n);
            for (Object label : labels) {
                CAstNode target = context.getControlFlow().getTarget(n, label);
                if (target == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                    context.cfg().addPreEdgeToExit(n, true);
                    continue;
                }
                context.cfg().addPreEdge(n, target, true);
            }
        }
        return mayBeInteger;
    }

    @Override
    protected void leaveBinaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode l = n.getChild(1);
        CAstNode r = n.getChild(2);
        assert (c.getValue(r) != -1) : CAstPrinter.print(n);
        assert (c.getValue(l) != -1) : CAstPrinter.print(n);
        boolean mayBeInteger = this.handleBinaryOpThrow(n, n.getChild(0), context);
        context.cfg().addInstruction((SSAInstruction)this.insts.BinaryOpInstruction(context.cfg().currentInstruction, this.translateBinaryOpcode(n.getChild(0)), false, false, result, c.getValue(l), c.getValue(r), mayBeInteger));
        if (mayBeInteger) {
            context.cfg().newBlock(true);
        }
    }

    @Override
    protected boolean visitUnaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveUnaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode v = n.getChild(1);
        context.cfg().addInstruction((SSAInstruction)this.insts.UnaryOpInstruction(context.cfg().currentInstruction, this.translateUnaryOpcode(n.getChild(0)), result, c.getValue(v)));
    }

    @Override
    protected boolean visitArrayLength(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveArrayLength(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        int arrayValue = c.getValue(n.getChild(0));
        context.cfg().addInstruction((SSAInstruction)this.insts.ArrayLengthInstruction(context.cfg().currentInstruction, result, arrayValue));
    }

    @Override
    protected boolean visitArrayRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int arrayValue = c.getValue(n.getChild(0));
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        this.arrayOpHandler.doArrayRead(context, result, arrayValue, n, this.gatherArrayDims(c, n));
    }

    @Override
    protected boolean visitDeclStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveDeclStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        CAstSymbol s = (CAstSymbol)n.getChild(0).getValue();
        String nm = s.name();
        CAstType t = s.type();
        Scope scope = c.currentScope();
        if (n.getChildCount() == 2) {
            CAstNode v = n.getChild(1);
            if (scope.contains(nm) && scope.lookup(nm).getDefiningScope() == scope) {
                assert (!s.isFinal());
                this.doLocalWrite(c, nm, this.makeType(t), c.getValue(v));
            } else if (v.getKind() != 300 && v.getKind() != 111 && v.getKind() != 116) {
                scope.declare(s, c.getValue(v));
            } else {
                scope.declare(s);
                this.doLocalWrite(c, nm, this.makeType(t), c.getValue(v));
            }
        } else {
            c.currentScope().declare(s);
        }
    }

    @Override
    protected boolean visitReturn(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveReturn(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (n.getChildCount() > 0) {
            context.cfg().addInstruction((SSAInstruction)this.insts.ReturnInstruction(context.cfg().currentInstruction, c.getValue(n.getChild(0)), false));
        } else {
            context.cfg().addInstruction((SSAInstruction)this.insts.ReturnInstruction(context.cfg().currentInstruction));
        }
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(false);
        context.cfg().addPreEdgeToExit(n, false);
    }

    @Override
    protected boolean visitIfgoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveIfgoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (n.getChildCount() == 1) {
            context.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(context.cfg().currentInstruction, this.translateConditionOpcode(CAstOperator.OP_NE), null, c.getValue(n.getChild(0)), context.currentScope().getConstantValue(new Integer(0)), -1));
        } else if (n.getChildCount() == 3) {
            context.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(context.cfg().currentInstruction, this.translateConditionOpcode(n.getChild(0)), null, c.getValue(n.getChild(1)), c.getValue(n.getChild(2)), -1));
        } else {
            Assertions.UNREACHABLE();
        }
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().addPreEdge(n, context.getControlFlow().getTarget(n, Boolean.TRUE), false);
        context.cfg().newBlock(true);
    }

    @Override
    protected boolean visitGoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveGoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            context.cfg().addPreNode(n, context.getUnwindState());
            context.cfg().addPreEdge(n, context.getControlFlow().getTarget(n, null), false);
            context.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
            if (context.getControlFlow().getTarget(n, null) == null) assert (context.getControlFlow().getTarget(n, null) != null) : context.getControlFlow() + " does not map " + n + " (" + context.getSourceMap().getPosition(n) + ")";
            context.cfg().newBlock(false);
        }
    }

    @Override
    protected boolean visitLabelStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (!context.getControlFlow().getSourceNodes(n).isEmpty()) {
            context.cfg().newBlock(true);
            context.cfg().addPreNode(n, context.getUnwindState());
        }
        return false;
    }

    @Override
    protected void leaveLabelStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    protected void processIf(CAstNode n, boolean isExpr, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        PreBasicBlock trueB = null;
        PreBasicBlock falseB = null;
        CAstNode l = n.getChild(0);
        visitor.visit(l, context, visitor);
        context.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(context.cfg().currentInstruction, this.translateConditionOpcode(CAstOperator.OP_EQ), null, c.getValue(l), context.currentScope().getConstantValue(new Integer(0)), -1));
        PreBasicBlock srcB = context.cfg().getCurrentBlock();
        context.cfg().newBlock(true);
        CAstNode r = n.getChild(1);
        visitor.visit(r, context, visitor);
        if (isExpr) {
            context.cfg().addInstruction((SSAInstruction)new AssignInstruction(context.cfg().currentInstruction, c.getValue(n), c.getValue(r)));
        }
        if (n.getChildCount() == 3) {
            if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
                context.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
                trueB = context.cfg().getCurrentBlock();
                context.cfg().newBlock(false);
            }
            falseB = context.cfg().getCurrentBlock();
            CAstNode f = n.getChild(2);
            context.cfg().deadBlocks.remove(falseB);
            visitor.visit(f, context, visitor);
            if (isExpr) {
                context.cfg().addInstruction((SSAInstruction)new AssignInstruction(context.cfg().currentInstruction, c.getValue(n), c.getValue(f)));
            }
        }
        context.cfg().newBlock(true);
        if (n.getChildCount() == 3) {
            if (trueB != null) {
                context.cfg().addEdge(trueB, context.cfg().getCurrentBlock());
            }
            context.cfg().addEdge(srcB, falseB);
        } else {
            context.cfg().addEdge(srcB, context.cfg().getCurrentBlock());
        }
    }

    @Override
    protected final void leaveIfStmtCondition(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfStmtTrueClause(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfExprCondition(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfExprTrueClause(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitIfStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        this.processIf(n, false, c, visitor);
        return true;
    }

    @Override
    protected boolean visitIfExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        this.processIf(n, true, c, visitor);
        return true;
    }

    @Override
    protected boolean visitNew(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveNew(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int[] arguments;
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        if (n.getChildCount() <= 1) {
            arguments = null;
        } else {
            arguments = new int[n.getChildCount() - 1];
            int i = 1;
            while (i < n.getChildCount()) {
                arguments[i - 1] = c.getValue(n.getChild(i));
                ++i;
            }
        }
        this.doNewObject(context, n, result, n.getChild(0).getValue(), arguments);
    }

    @Override
    protected boolean visitObjectLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveObjectLiteralFieldInit(CAstNode n, int i, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (n.getChild(i).getKind() == 19) {
            this.handleUnspecifiedLiteralKey(context, n, i, visitor);
        }
        this.doFieldWrite(context, c.getValue(n.getChild(0)), n.getChild(i), n, c.getValue(n.getChild(i + 1)));
    }

    @Override
    protected void leaveObjectLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(0)));
    }

    @Override
    protected boolean visitArrayLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayLiteralObject(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(0)));
    }

    @Override
    protected void leaveArrayLiteralInitElement(CAstNode n, int i, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        this.arrayOpHandler.doArrayWrite(context, c.getValue(n.getChild(0)), n, new int[]{context.currentScope().getConstantValue(new Integer(i - 1))}, c.getValue(n.getChild(i)));
    }

    @Override
    protected void leaveArrayLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitObjectRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveObjectRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode elt = n.getChild(1);
        this.doFieldRead(context, result, c.getValue(n.getChild(0)), elt, n);
    }

    @Override
    public boolean visitAssign(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    public void leaveAssign(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        if (n.getKind() == 14) {
            c.setValue(n, c.getValue(n.getChild(1)));
        } else {
            c.setValue(n, c.getValue(n.getChild(0)));
        }
    }

    private int[] gatherArrayDims(WalkContext c, CAstNode n) {
        int numDims = n.getChildCount() - 2;
        int[] dims = new int[numDims];
        int i = 0;
        while (i < numDims) {
            dims[i] = c.getValue(n.getChild(i + 2));
            ++i;
        }
        return dims;
    }

    protected int processAssignOp(CAstNode n, CAstNode v, CAstNode a, int temp, boolean post, WalkContext c) {
        WalkContext context = c;
        int rval = c.getValue(v);
        CAstNode op = a.getChild(2);
        int temp2 = context.currentScope().allocateTempValue();
        boolean mayBeInteger = this.handleBinaryOpThrow(a, op, context);
        context.cfg().addInstruction((SSAInstruction)this.insts.BinaryOpInstruction(context.cfg().currentInstruction, this.translateBinaryOpcode(op), false, false, temp2, temp, rval, mayBeInteger));
        if (mayBeInteger) {
            context.cfg().newBlock(true);
        }
        return temp2;
    }

    @Override
    protected boolean visitArrayRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int rval = c.getValue(v);
        c.setValue(n, rval);
        this.arrayOpHandler.doArrayWrite(context, c.getValue(n.getChild(0)), n, this.gatherArrayDims(c, n), rval);
    }

    @Override
    protected boolean visitArrayRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int temp = context.currentScope().allocateTempValue();
        int[] dims = this.gatherArrayDims(c, n);
        this.arrayOpHandler.doArrayRead(context, temp, c.getValue(n.getChild(0)), n, dims);
        int rval = this.processAssignOp(n, v, a, temp, !pre, c);
        c.setValue(n, pre ? rval : temp);
        this.arrayOpHandler.doArrayWrite(context, c.getValue(n.getChild(0)), n, dims, rval);
    }

    @Override
    protected boolean visitObjectRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveObjectRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int rval = c.getValue(v);
        c.setValue(n, rval);
        this.doFieldWrite(context, c.getValue(n.getChild(0)), n.getChild(1), n, rval);
    }

    protected void processObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, WalkContext c) {
    }

    @Override
    protected boolean visitObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int temp = context.currentScope().allocateTempValue();
        this.doFieldRead(context, temp, c.getValue(n.getChild(0)), n.getChild(1), n);
        int rval = this.processAssignOp(n, v, a, temp, !pre, c);
        c.setValue(n, pre ? rval : temp);
        this.doFieldWrite(context, c.getValue(n.getChild(0)), n.getChild(1), n, rval);
    }

    @Override
    protected boolean visitBlockExprAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockExprAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(n.getChildCount() - 1)));
    }

    @Override
    protected boolean visitBlockExprAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockExprAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(n.getChildCount() - 1)));
    }

    @Override
    protected boolean visitVarAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    protected void assignValue(CAstNode n, WalkContext context, Symbol ls, String nm, int rval) {
        if (context.currentScope().isGlobal(ls)) {
            this.doGlobalWrite(context, nm, this.makeType(ls.type()), rval);
        } else if (context.currentScope().isLexicallyScoped(ls)) {
            this.doLexicallyScopedWrite(context, nm, this.makeType(ls.type()), rval);
        } else {
            assert (rval != -1) : CAstPrinter.print(n, context.top().getSourceMap());
            this.doLocalWrite(context, nm, this.makeType(ls.type()), rval);
        }
    }

    @Override
    protected void leaveVarAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int rval = c.getValue(v);
        String nm = (String)n.getChild(0).getValue();
        Symbol ls = context.currentScope().lookup(nm);
        c.setValue(n, rval);
        this.assignValue(n, context, ls, nm, rval);
    }

    @Override
    protected boolean visitVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        String nm = (String)n.getChild(0).getValue();
        Symbol ls = context.currentScope().lookup(nm);
        TypeReference type = this.makeType(ls.type());
        int temp = context.currentScope().isGlobal(ls) ? this.doGlobalRead(n, context, nm, type) : (context.currentScope().isLexicallyScoped(ls) ? this.doLexicallyScopedRead(n, context, nm, type) : this.doLocalRead(context, nm, type));
        if (!pre) {
            int ret = context.currentScope().allocateTempValue();
            context.cfg().addInstruction((SSAInstruction)new AssignInstruction(context.cfg().currentInstruction, ret, temp));
            c.setValue(n, ret);
        }
        int rval = this.processAssignOp(n, v, a, temp, !pre, c);
        if (pre) {
            c.setValue(n, rval);
        }
        if (context.currentScope().isGlobal(ls)) {
            this.doGlobalWrite(context, nm, type, rval);
        } else if (context.currentScope().isLexicallyScoped(ls)) {
            this.doLexicallyScopedWrite(context, nm, type, rval);
        } else {
            this.doLocalWrite(context, nm, type, rval);
        }
    }

    private boolean isSimpleSwitch(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        CAstControlFlowMap ctrl = context.getControlFlow();
        Collection<Object> caseLabels = ctrl.getTargetLabels(n);
        for (Object x : caseLabels) {
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            CAstNode xn = (CAstNode)x;
            if (xn.getKind() == 300) {
                Number num;
                Object val;
                visitor.visit(xn, context, visitor);
                if (context.getValue(xn) != -1 && context.currentScope().isConstant(context.getValue(xn)) && (val = context.currentScope().getConstantObject(context.getValue(xn))) instanceof Number && (double)(num = (Number)val).intValue() == num.doubleValue()) continue;
            }
            return false;
        }
        return true;
    }

    private void doSimpleSwitch(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        PreBasicBlock defaultHackBlock = null;
        CAstControlFlowMap ctrl = context.getControlFlow();
        CAstNode switchValue = n.getChild(0);
        visitor.visit(switchValue, context, visitor);
        int v = context.getValue(switchValue);
        boolean hasExplicitDefault = ctrl.getTarget(n, CAstControlFlowMap.SWITCH_DEFAULT) != null;
        Collection<Object> caseLabels = ctrl.getTargetLabels(n);
        int cases = caseLabels.size();
        if (hasExplicitDefault) {
            --cases;
        }
        int[] casesAndLabels = new int[cases * 2];
        int defaultBlock = context.cfg().getCurrentBlock().getGraphNodeId() + 1;
        context.cfg().addInstruction((SSAInstruction)this.insts.SwitchInstruction(context.cfg().currentInstruction, v, defaultBlock, casesAndLabels));
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(true);
        context.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
        defaultHackBlock = context.cfg().getCurrentBlock();
        context.cfg().newBlock(false);
        CAstNode switchBody = n.getChild(1);
        visitor.visit(switchBody, context, visitor);
        context.cfg().newBlock(true);
        if (!hasExplicitDefault) {
            context.cfg().addEdge(defaultHackBlock, context.cfg().getCurrentBlock());
        }
        int cn = 0;
        for (Object x : caseLabels) {
            CAstNode target = ctrl.getTarget(n, x);
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) {
                context.cfg().addEdge(defaultHackBlock, context.cfg().getBlock(target));
                continue;
            }
            Number caseLabel = (Number)context.currentScope().getConstantObject(context.getValue((CAstNode)x));
            casesAndLabels[2 * cn] = caseLabel.intValue();
            casesAndLabels[2 * cn + 1] = context.cfg().getBlock(target).getGraphNodeId();
            ++cn;
            context.cfg().addPreEdge(n, target, false);
        }
    }

    private void doIfConvertSwitch(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        CAstControlFlowMap ctrl = context.getControlFlow();
        context.cfg().addPreNode(n, context.getUnwindState());
        CAstNode switchValue = n.getChild(0);
        visitor.visit(switchValue, context, visitor);
        int v = context.getValue(switchValue);
        Collection<Object> caseLabels = ctrl.getTargetLabels(n);
        LinkedHashMap<Object, PreBasicBlock> labelToBlock = new LinkedHashMap<Object, PreBasicBlock>();
        for (Object x : caseLabels) {
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            visitor.visit((CAstNode)x, context, visitor);
            context.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(context.cfg().currentInstruction, this.translateConditionOpcode(CAstOperator.OP_EQ), null, v, context.getValue((CAstNode)x), -1));
            labelToBlock.put(x, context.cfg().getCurrentBlock());
            context.cfg().newBlock(true);
        }
        PreBasicBlock defaultGotoBlock = context.cfg().getCurrentBlock();
        context.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
        context.cfg().newBlock(false);
        CAstNode switchBody = n.getChild(1);
        visitor.visit(switchBody, context, visitor);
        context.cfg().newBlock(true);
        for (Object x : caseLabels) {
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            CAstNode target = ctrl.getTarget(n, x);
            context.cfg().addEdge((PreBasicBlock)labelToBlock.get(x), context.cfg().getBlock(target));
        }
        if (ctrl.getTarget(n, CAstControlFlowMap.SWITCH_DEFAULT) == null) {
            context.cfg().addEdge(defaultGotoBlock, context.cfg().getCurrentBlock());
        } else {
            CAstNode target = ctrl.getTarget(n, CAstControlFlowMap.SWITCH_DEFAULT);
            context.cfg().addEdge(defaultGotoBlock, context.cfg().getBlock(target));
        }
    }

    @Override
    protected boolean visitSwitch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (this.isSimpleSwitch(n, context, visitor)) {
            this.doSimpleSwitch(n, context, visitor);
        } else {
            this.doIfConvertSwitch(n, context, visitor);
        }
        return true;
    }

    @Override
    protected final void leaveSwitchValue(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveSwitch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitThrow(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveThrow(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        this.doThrow(context, c.getValue(n.getChild(0)));
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(false);
        Collection<Object> labels = context.getControlFlow().getTargetLabels(n);
        for (Object label : labels) {
            CAstNode target = context.getControlFlow().getTarget(n, label);
            if (target == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                context.cfg().addPreEdgeToExit(n, true);
                continue;
            }
            context.cfg().addPreEdge(n, target, true);
        }
    }

    @Override
    protected boolean visitCatch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (context.getControlFlow().getSourceNodes(n).isEmpty()) {
            return true;
        }
        String id = (String)n.getChild(0).getValue();
        context.cfg().setCurrentBlockAsHandler();
        if (!context.currentScope().contains(id)) {
            context.currentScope().declare(new FinalCAstSymbol(id, this.exceptionType()));
        }
        context.cfg().addInstruction((SSAInstruction)this.insts.GetCaughtExceptionInstruction(context.cfg().currentInstruction, context.cfg().getCurrentBlock().getNumber(), context.currentScope().lookup(id).valueNumber()));
        context.cfg().addPreNode(n, context.getUnwindState());
        CAstType caughtType = this.getTypeForNode(context, n);
        if (caughtType != null) {
            TypeReference caughtRef = this.makeType(caughtType);
            context.setCatchType(n, caughtRef);
        } else {
            context.setCatchType(n, this.defaultCatchType());
        }
        return false;
    }

    @Override
    protected void leaveCatch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitUnwind(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveUnwind(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    private boolean hasIncomingEdges(CAstNode n, WalkContext context) {
        if (context.cfg().hasDelayedEdges(n)) {
            return true;
        }
        int i = 0;
        while (i < n.getChildCount()) {
            if (this.hasIncomingEdges(n.getChild(i), context)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean visitTry(final CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        final WalkContext context = c;
        boolean addSkipCatchGoto = false;
        visitor.visit(n.getChild(0), context, visitor);
        PreBasicBlock endOfTry = context.cfg().getCurrentBlock();
        if (!this.hasIncomingEdges(n.getChild(1), context)) {
            if (this.loader instanceof CAstAbstractLoader) {
                ((CAstAbstractLoader)this.loader).addMessage(context.getModule(), new Warning(0){

                    public String getMsg() {
                        return "Dead catch block at " + AstTranslator.this.getPosition(context.getSourceMap(), n.getChild(1));
                    }
                });
            }
            return true;
        }
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            addSkipCatchGoto = true;
            context.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
            context.cfg().newBlock(false);
        }
        context.cfg().noteCatchBlock();
        visitor.visit(n.getChild(1), context, visitor);
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            context.cfg().newBlock(true);
        }
        if (addSkipCatchGoto) {
            PreBasicBlock afterBlock = context.cfg().getCurrentBlock();
            context.cfg().addEdge(endOfTry, afterBlock);
        }
        return true;
    }

    @Override
    protected final void leaveTryBlock(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveTry(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitEmpty(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEmpty(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        c.setValue(n, context.currentScope().getConstantValue(null));
    }

    @Override
    protected boolean visitPrimitive(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leavePrimitive(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        this.doPrimitive(result, context, n);
    }

    @Override
    protected boolean visitVoid(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveVoid(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, -1);
    }

    @Override
    protected boolean visitAssert(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveAssert(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        boolean fromSpec = true;
        int result = c.getValue(n.getChild(0));
        if (n.getChildCount() == 2) {
            assert (n.getChild(1).getKind() == 300);
            assert (n.getChild(1).getValue() instanceof Boolean);
            fromSpec = n.getChild(1).getValue().equals(Boolean.TRUE);
        }
        context.cfg().addInstruction(new AstAssertInstruction(context.cfg().currentInstruction, result, fromSpec));
    }

    @Override
    protected boolean visitEachElementGet(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEachElementGet(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int result = c.currentScope().allocateTempValue();
        c.setValue(n, result);
        c.cfg().addInstruction((SSAInstruction)new EachElementGetInstruction(c.cfg().currentInstruction, result, c.getValue(n.getChild(0)), c.getValue(n.getChild(1))));
    }

    @Override
    protected boolean visitEachElementHasNext(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEachElementHasNext(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int result = c.currentScope().allocateTempValue();
        c.setValue(n, result);
        c.cfg().addInstruction((SSAInstruction)new EachElementHasNextInstruction(c.cfg().currentInstruction, result, c.getValue(n.getChild(0)), c.getValue(n.getChild(1))));
    }

    @Override
    protected boolean visitTypeLiteralExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveTypeLiteralExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        assert (n.getChild(0).getKind() == 300);
        String typeNameStr = (String)n.getChild(0).getValue();
        TypeName typeName = TypeName.string2TypeName((String)typeNameStr);
        TypeReference typeRef = TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)typeName);
        int result = wc.currentScope().allocateTempValue();
        c.setValue(n, result);
        wc.cfg().addInstruction((SSAInstruction)this.insts.LoadMetadataInstruction(wc.cfg().currentInstruction, result, this.loader.getLanguage().getConstantType((Object)typeRef), (Object)typeRef));
    }

    @Override
    protected boolean visitIsDefinedExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveIsDefinedExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        int ref = c.getValue(n.getChild(0));
        int result = wc.currentScope().allocateTempValue();
        c.setValue(n, result);
        if (n.getChildCount() == 1) {
            wc.cfg().addInstruction(new AstIsDefinedInstruction(wc.cfg().currentInstruction, result, ref));
        } else {
            this.doIsFieldDefined(wc, result, ref, n.getChild(1));
        }
    }

    @Override
    protected boolean visitEcho(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEcho(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        int[] rvals = new int[n.getChildCount()];
        int i = 0;
        while (i < n.getChildCount()) {
            rvals[i] = c.getValue(n.getChild(i));
            ++i;
        }
        wc.cfg().addInstruction(new AstEchoInstruction(wc.cfg().currentInstruction, rvals));
    }

    public CAstEntity getIncludedEntity(CAstNode n) {
        if (n.getChild(0).getKind() == 405) {
            assert (this.namedEntityResolver != null);
            return (CAstEntity)this.namedEntityResolver.get(n.getChild(0).getChild(0).getValue());
        }
        return (CAstEntity)n.getChild(0).getValue();
    }

    @Override
    protected void leaveInclude(final CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        CAstEntity included = this.getIncludedEntity(n);
        if (included == null) {
            System.err.println("cannot find include for " + CAstPrinter.print(n));
            System.err.println("from:\n" + this.namedEntityResolver);
        } else {
            final boolean isMacroExpansion = included.getKind() == 7;
            System.err.println("found " + included.getName() + " for " + CAstPrinter.print(n));
            final CAstEntity copy = new CAstCloner(new CAstImpl(), true){

                private CAstNode copyIncludeExpr(CAstNode expr) {
                    if (expr.getValue() != null) {
                        return this.Ast.makeConstant(expr.getValue());
                    }
                    if (expr instanceof CAstOperator) {
                        return expr;
                    }
                    CAstNode[] nc = new CAstNode[expr.getChildCount()];
                    int i = 0;
                    while (i < expr.getChildCount()) {
                        nc[i] = this.copyIncludeExpr(expr.getChild(i));
                        ++i;
                    }
                    return this.Ast.makeNode(expr.getKind(), nc);
                }

                @Override
                protected CAstNode copyNodes(CAstNode root, CAstControlFlowMap cfg, CAstBasicRewriter.NonCopyingContext c, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
                    if (isMacroExpansion && root.getKind() == 129) {
                        int arg = ((Number)root.getChild(0).getValue()).intValue();
                        CAstNode expr = this.copyIncludeExpr(n.getChild(arg));
                        nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)c.key()), expr);
                        return expr;
                    }
                    return super.copyNodesHackForEclipse(root, cfg, c, nodeMap);
                }
            }.rewrite(included);
            if (copy.getAST() == null) {
                System.err.println(String.valueOf(copy.getName()) + " has no AST");
            } else {
                this.visit(copy.getAST(), new DelegatingContext(this, wc){

                    @Override
                    public CAstSourcePositionMap getSourceMap() {
                        return copy.getSourceMap();
                    }

                    @Override
                    public CAstControlFlowMap getControlFlow() {
                        return copy.getControlFlow();
                    }
                }, visitor);
                visitor.visitScopedEntities(copy, copy.getAllScopedEntities(), wc, visitor);
            }
        }
    }

    protected final void walkEntities(CAstEntity N, WalkContext c) {
        this.visitEntities(N, c, this);
    }

    @Override
    public void translate(CAstEntity N, ModuleEntry module) {
        ExposedNamesCollector exposedNamesCollector = new ExposedNamesCollector();
        exposedNamesCollector.run(N);
        this.entity2ExposedNames = exposedNamesCollector.getEntity2ExposedNames();
        this.walkEntities(N, new RootContext(N, module));
    }

    public void translate(CAstEntity N, WalkContext context) {
        ExposedNamesCollector exposedNamesCollector = new ExposedNamesCollector();
        exposedNamesCollector.run(N);
        this.entity2ExposedNames = exposedNamesCollector.getEntity2ExposedNames();
        this.walkEntities(N, context);
    }

    public abstract class AbstractScope
    implements Scope {
        private final Scope parent;
        private final Map<String, Symbol> values = new LinkedHashMap<String, Symbol>();
        private final Map<String, String> caseInsensitiveNames = new LinkedHashMap<String, String>();

        protected abstract SymbolTable getUnderlyingSymtab();

        @Override
        public Scope getParent() {
            return this.parent;
        }

        @Override
        public int size() {
            return this.getUnderlyingSymtab().getMaxValueNumber() + 1;
        }

        @Override
        public Iterator<String> getAllNames() {
            return this.values.keySet().iterator();
        }

        @Override
        public int allocateTempValue() {
            return this.getUnderlyingSymtab().newSymbol();
        }

        @Override
        public int getConstantValue(Object o) {
            if (o instanceof Integer) {
                return this.getUnderlyingSymtab().getConstant(((Integer)o).intValue());
            }
            if (o instanceof Float) {
                return this.getUnderlyingSymtab().getConstant(((Float)o).floatValue());
            }
            if (o instanceof Double) {
                return this.getUnderlyingSymtab().getConstant(((Double)o).doubleValue());
            }
            if (o instanceof Long) {
                return this.getUnderlyingSymtab().getConstant(((Long)o).longValue());
            }
            if (o instanceof String) {
                return this.getUnderlyingSymtab().getConstant((String)o);
            }
            if (o instanceof Boolean) {
                return this.getUnderlyingSymtab().getConstant(((Boolean)o).booleanValue());
            }
            if (o instanceof Character) {
                return this.getUnderlyingSymtab().getConstant((int)((Character)o).charValue());
            }
            if (o instanceof Byte) {
                return this.getUnderlyingSymtab().getConstant((int)((Byte)o).byteValue());
            }
            if (o instanceof Short) {
                return this.getUnderlyingSymtab().getConstant((int)((Short)o).shortValue());
            }
            if (o == null) {
                return this.getUnderlyingSymtab().getNullConstant();
            }
            if (o == CAstControlFlowMap.SWITCH_DEFAULT) {
                return this.getUnderlyingSymtab().getConstant("__default label");
            }
            System.err.println("cannot handle constant " + o);
            Assertions.UNREACHABLE();
            return -1;
        }

        @Override
        public boolean isConstant(int valueNumber) {
            return this.getUnderlyingSymtab().isConstant(valueNumber);
        }

        @Override
        public Object getConstantObject(int valueNumber) {
            return this.getUnderlyingSymtab().getConstantValue(valueNumber);
        }

        @Override
        public void declare(CAstSymbol s, int vn) {
            String nm = s.name();
            assert (!this.contains(nm)) : nm;
            if (s.isCaseInsensitive()) {
                this.caseInsensitiveNames.put(nm.toLowerCase(), nm);
            }
            this.values.put(nm, this.makeSymbol(s, vn));
        }

        @Override
        public void declare(CAstSymbol s) {
            String nm = s.name();
            if (!this.contains(nm) || this.lookup(nm).getDefiningScope() != this) {
                if (s.isCaseInsensitive()) {
                    this.caseInsensitiveNames.put(nm.toLowerCase(), nm);
                }
                this.values.put(nm, this.makeSymbol(s));
            } else assert (!s.isFinal()) : "trying to redeclare " + nm;
        }

        protected AbstractScope(Scope parent) {
            this.parent = parent;
        }

        private final String mapName(String nm) {
            String mappedName = this.caseInsensitiveNames.get(nm.toLowerCase());
            return mappedName == null ? nm : mappedName;
        }

        protected Symbol makeSymbol(CAstSymbol s) {
            return this.makeSymbol(s.name(), s.type(), s.isFinal(), s.isInternalName(), s.defaultInitValue(), -1, this);
        }

        protected Symbol makeSymbol(CAstSymbol s, int vn) {
            return this.makeSymbol(s.name(), s.type(), s.isFinal(), s.isInternalName(), s.defaultInitValue(), vn, this);
        }

        protected abstract Symbol makeSymbol(String var1, CAstType var2, boolean var3, boolean var4, Object var5, int var6, Scope var7);

        @Override
        public boolean isCaseInsensitive(String nm) {
            return this.caseInsensitiveNames.containsKey(nm.toLowerCase());
        }

        @Override
        public Symbol lookup(String nm) {
            if (this.contains(nm)) {
                return this.values.get(this.mapName(nm));
            }
            Symbol scoped = this.parent.lookup(nm);
            if (scoped != null && this.getEntityScope() == this && (this.isGlobal(scoped) || this.isLexicallyScoped(scoped))) {
                this.values.put(nm, this.makeSymbol(nm, scoped.type(), scoped.isFinal(), scoped.isInternalName(), scoped.defaultInitValue(), -1, scoped.getDefiningScope()));
                if (scoped.getDefiningScope().isCaseInsensitive(nm)) {
                    this.caseInsensitiveNames.put(nm.toLowerCase(), nm);
                }
                return this.values.get(nm);
            }
            return scoped;
        }

        @Override
        public boolean contains(String nm) {
            String mappedName = this.caseInsensitiveNames.get(nm.toLowerCase());
            return this.values.containsKey(mappedName == null ? nm : mappedName);
        }

        @Override
        public boolean isGlobal(Symbol s) {
            return s.getDefiningScope().type() == ScopeType.GLOBAL;
        }

        @Override
        public abstract boolean isLexicallyScoped(Symbol var1);

        protected abstract AbstractScope getEntityScope();

        @Override
        public abstract CAstEntity getEntity();
    }

    public static abstract class AbstractSymbol
    implements Symbol {
        private Object constantValue;
        private boolean isFinalValue;
        private final Scope definingScope;
        private Object defaultValue;

        protected AbstractSymbol(Scope definingScope, boolean isFinalValue, Object defaultValue) {
            this.definingScope = definingScope;
            this.isFinalValue = isFinalValue;
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean isFinal() {
            return this.isFinalValue;
        }

        @Override
        public Object defaultInitValue() {
            return this.defaultValue;
        }

        @Override
        public Object constant() {
            return this.constantValue;
        }

        @Override
        public void setConstant(Object cv) {
            this.constantValue = cv;
        }

        @Override
        public Scope getDefiningScope() {
            return this.definingScope;
        }
    }

    protected static final class AstCFG
    extends AbstractCFG<SSAInstruction, PreBasicBlock> {
        private final SSAInstruction[] instructions;
        private final int[] instructionToBlockMap;
        private final int[] pcMap;
        private final String functionName;
        private final SymbolTable symtab;

        private void transferEdges(Set<PreBasicBlock> blocks, IncipientCFG icfg, EdgeOperation normal, EdgeOperation except) {
            for (PreBasicBlock src : blocks) {
                Iterator j = icfg.getSuccNodes(src);
                while (j.hasNext()) {
                    PreBasicBlock dst = (PreBasicBlock)j.next();
                    if (this.isCatchBlock(dst.getNumber()) || dst.isExitBlock() && icfg.exceptionalToExit.contains(src)) {
                        except.act(src, dst);
                    }
                    if (!(dst.isExitBlock() ? icfg.normalToExit.contains(src) : !this.isCatchBlock(dst.getNumber()))) continue;
                    normal.act(src, dst);
                }
            }
        }

        private boolean checkBlockBoundaries(IncipientCFG icfg) {
            MutableIntSet boundaries = IntSetUtil.make();
            Iterator iterator = icfg.iterator();
            while (iterator.hasNext()) {
                PreBasicBlock b = (PreBasicBlock)iterator.next();
                if (b.getFirstInstructionIndex() >= 0) {
                    if (boundaries.contains(b.getFirstInstructionIndex())) {
                        return false;
                    }
                    boundaries.add(b.getFirstInstructionIndex());
                }
                if (b.getLastInstructionIndex() < 0 || b.getLastInstructionIndex() == b.getFirstInstructionIndex()) continue;
                if (boundaries.contains(b.getLastInstructionIndex())) {
                    return false;
                }
                boundaries.add(b.getLastInstructionIndex());
            }
            return true;
        }

        AstCFG(CAstEntity n, IncipientCFG icfg, SymbolTable symtab, SSAInstructionFactory insts) {
            super(null);
            HashMap exceptionalEdges;
            boolean hasDeadBlocks;
            Set liveBlocks = DFS.getReachableNodes((Graph)icfg, Collections.singleton(icfg.entryBlock));
            List blocks = icfg.blocks;
            boolean bl = hasDeadBlocks = blocks.size() > liveBlocks.size();
            assert (this.checkBlockBoundaries(icfg));
            this.symtab = symtab;
            this.functionName = n.getName();
            this.instructionToBlockMap = new int[liveBlocks.size()];
            this.pcMap = hasDeadBlocks ? new int[icfg.currentInstruction] : null;
            final HashMap normalEdges = hasDeadBlocks ? HashMapFactory.make() : null;
            HashMap hashMap = exceptionalEdges = hasDeadBlocks ? HashMapFactory.make() : null;
            if (hasDeadBlocks) {
                this.transferEdges(liveBlocks, icfg, new EdgeOperation(){

                    @Override
                    public void act(PreBasicBlock src, PreBasicBlock dst) {
                        if (!normalEdges.containsKey(src)) {
                            normalEdges.put(src, HashSetFactory.make());
                        }
                        ((Collection)normalEdges.get(src)).add(dst);
                    }
                }, new EdgeOperation(){

                    @Override
                    public void act(PreBasicBlock src, PreBasicBlock dst) {
                        if (!exceptionalEdges.containsKey(src)) {
                            exceptionalEdges.put(src, HashSetFactory.make());
                        }
                        ((Collection)exceptionalEdges.get(src)).add(dst);
                    }
                });
            }
            int instruction = 0;
            int i = 0;
            int blockNumber = 0;
            while (i < blocks.size()) {
                PreBasicBlock block = (PreBasicBlock)blocks.get(i);
                block.setGraphNodeId(-1);
                if (liveBlocks.contains(block)) {
                    if (hasDeadBlocks) {
                        int offset = 0;
                        int oldPC = block.getFirstInstructionIndex();
                        while (offset < block.instructions().size()) {
                            this.pcMap[instruction + offset] = oldPC++;
                            ++offset;
                        }
                    }
                    if (block.getFirstInstructionIndex() >= 0) {
                        block.setFirstIndex(instruction);
                        block.setLastIndex((instruction += block.instructions().size()) - 1);
                    }
                    this.instructionToBlockMap[blockNumber] = block.getLastInstructionIndex();
                    this.addNode(block);
                    if (block.isCatchBlock()) {
                        this.setCatchBlock(blockNumber);
                    }
                    ++blockNumber;
                }
                ++i;
            }
            this.init();
            if (hasDeadBlocks) {
                i = 0;
                while (i < blocks.size()) {
                    PreBasicBlock src = (PreBasicBlock)blocks.get(i);
                    if (liveBlocks.contains(src)) {
                        if (normalEdges.containsKey(src)) {
                            for (PreBasicBlock succ : (Collection)normalEdges.get(src)) {
                                this.addNormalEdge(src, succ);
                            }
                        }
                        if (exceptionalEdges.containsKey(src)) {
                            for (PreBasicBlock succ : (Collection)exceptionalEdges.get(src)) {
                                this.addExceptionalEdge(src, succ);
                            }
                        }
                    }
                    ++i;
                }
            } else {
                this.transferEdges(liveBlocks, icfg, new EdgeOperation(){

                    @Override
                    public void act(PreBasicBlock src, PreBasicBlock dst) {
                        AstCFG.this.addNormalEdge(src, dst);
                    }
                }, new EdgeOperation(){

                    @Override
                    public void act(PreBasicBlock src, PreBasicBlock dst) {
                        AstCFG.this.addExceptionalEdge(src, dst);
                    }
                });
            }
            int x = 0;
            this.instructions = new SSAInstruction[icfg.currentInstruction];
            int i2 = 0;
            while (i2 < blocks.size()) {
                if (liveBlocks.contains(blocks.get(i2))) {
                    List bi = ((PreBasicBlock)blocks.get(i2)).instructions();
                    int j = 0;
                    while (j < bi.size()) {
                        Iterator succs;
                        SSAInstruction inst = (SSAInstruction)bi.get(j);
                        if (inst instanceof SSAGetCaughtExceptionInstruction) {
                            SSAGetCaughtExceptionInstruction ci = (SSAGetCaughtExceptionInstruction)inst;
                            if (ci.getBasicBlockNumber() != ((PreBasicBlock)blocks.get(i2)).getNumber()) {
                                inst = insts.GetCaughtExceptionInstruction(x, ((PreBasicBlock)blocks.get(i2)).getNumber(), ci.getException());
                            }
                        } else if (inst instanceof SSAGotoInstruction) {
                            succs = this.getNormalSuccessors((PreBasicBlock)blocks.get(i2)).iterator();
                            if (succs.hasNext()) {
                                PreBasicBlock target = (PreBasicBlock)succs.next();
                                assert (!succs.hasNext()) : "unexpected successors for block " + blocks.get(i2) + ": " + target + " and " + succs.next();
                                inst = insts.GotoInstruction(x, target.firstIndex);
                            } else {
                                inst = null;
                            }
                        } else if (inst instanceof SSAConditionalBranchInstruction) {
                            int target;
                            succs = this.getNormalSuccessors((PreBasicBlock)blocks.get(i2)).iterator();
                            assert (succs.hasNext());
                            int t1 = ((PreBasicBlock)succs.next()).firstIndex;
                            if (succs.hasNext()) {
                                int t2 = ((PreBasicBlock)succs.next()).firstIndex;
                                target = t1 == x + 1 ? t2 : t1;
                            } else {
                                target = t1;
                            }
                            SSAConditionalBranchInstruction branch = (SSAConditionalBranchInstruction)inst;
                            inst = insts.ConditionalBranchInstruction(x, branch.getOperator(), branch.getType(), branch.getUse(0), branch.getUse(1), target);
                        }
                        this.instructions[x++] = inst;
                        ++j;
                    }
                }
                ++i2;
            }
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof AstCFG && this.functionName.equals(((AstCFG)((Object)o)).functionName);
        }

        public PreBasicBlock getBlockForInstruction(int index) {
            int i = 1;
            while (i < this.getNumberOfNodes() - 1) {
                if (index <= this.instructionToBlockMap[i]) {
                    return (PreBasicBlock)this.getNode(i);
                }
                ++i;
            }
            return null;
        }

        public SSAInstruction[] getInstructions() {
            return this.instructions;
        }

        public int getProgramCounter(int index) {
            return this.pcMap == null ? index : this.pcMap[index];
        }

        public String toString() {
            SSAInstruction[] insts = this.getInstructions();
            StringBuffer s = new StringBuffer("CAst CFG of " + this.functionName);
            int[] params = this.symtab.getParameterValueNumbers();
            int i = 0;
            while (i < params.length) {
                s.append(" ").append(params[i]);
                ++i;
            }
            s.append("\n");
            i = 0;
            while (i < this.getNumberOfNodes()) {
                PreBasicBlock bb = (PreBasicBlock)this.getNode(i);
                s.append(bb).append("\n");
                Iterator ss = this.getSuccNodes(bb);
                while (ss.hasNext()) {
                    s.append("    -->" + ss.next() + "\n");
                }
                int j = bb.getFirstInstructionIndex();
                while (j <= bb.getLastInstructionIndex()) {
                    if (insts[j] != null) {
                        s.append("  " + insts[j].toString(this.symtab) + "\n");
                    }
                    ++j;
                }
                ++i;
            }
            s.append("-- END --");
            return s.toString();
        }

        private static interface EdgeOperation {
            public void act(PreBasicBlock var1, PreBasicBlock var2);
        }
    }

    private static class AstDebuggingInformation
    implements AstMethod.DebuggingInformation {
        private CAstSourcePositionMap.Position codeBodyPosition;
        private String[][] valueNumberNames;
        private CAstSourcePositionMap.Position[] instructionPositions;

        AstDebuggingInformation(CAstSourcePositionMap.Position codeBodyPosition, CAstSourcePositionMap.Position[] instructionPositions, String[] names) {
            this.codeBodyPosition = codeBodyPosition;
            this.instructionPositions = instructionPositions;
            this.valueNumberNames = new String[names.length][];
            int i = 0;
            while (i < names.length) {
                this.valueNumberNames[i] = names[i] != null ? new String[]{names[i]} : new String[0];
                ++i;
            }
        }

        @Override
        public CAstSourcePositionMap.Position getCodeBodyPosition() {
            return this.codeBodyPosition;
        }

        @Override
        public CAstSourcePositionMap.Position getInstructionPosition(int instructionOffset) {
            return this.instructionPositions[instructionOffset];
        }

        @Override
        public String[][] getSourceNamesForValues() {
            return this.valueNumberNames;
        }
    }

    public static class AstLexicalInformation
    implements AstMethod.LexicalInformation {
        private final String functionLexicalName;
        private final Pair<String, String>[] exposedNames;
        private final int[][] instructionLexicalUses;
        private final int[] exitLexicalUses;
        private final String[] scopingParents;
        private MutableIntSet allExposedUses = null;
        private final Set<String> readOnlyNames;
        private static final int[] NONE = new int[0];

        public AstLexicalInformation(AstLexicalInformation original) {
            int i;
            this.functionLexicalName = original.functionLexicalName;
            if (original.exposedNames != null) {
                this.exposedNames = new Pair[original.exposedNames.length];
                i = 0;
                while (i < this.exposedNames.length) {
                    this.exposedNames[i] = Pair.make((Object)((String)original.exposedNames[i].fst), (Object)((String)original.exposedNames[i].snd));
                    ++i;
                }
            } else {
                this.exposedNames = null;
            }
            this.instructionLexicalUses = new int[original.instructionLexicalUses.length][];
            i = 0;
            while (i < this.instructionLexicalUses.length) {
                int[] x = original.instructionLexicalUses[i];
                if (x != null) {
                    this.instructionLexicalUses[i] = new int[x.length];
                    int j = 0;
                    while (j < x.length) {
                        this.instructionLexicalUses[i][j] = x[j];
                        ++j;
                    }
                }
                ++i;
            }
            if (original.exitLexicalUses != null) {
                this.exitLexicalUses = new int[original.exitLexicalUses.length];
                i = 0;
                while (i < this.exitLexicalUses.length) {
                    this.exitLexicalUses[i] = original.exitLexicalUses[i];
                    ++i;
                }
            } else {
                this.exitLexicalUses = null;
            }
            if (original.scopingParents != null) {
                this.scopingParents = new String[original.scopingParents.length];
                i = 0;
                while (i < this.scopingParents.length) {
                    this.scopingParents[i] = original.scopingParents[i];
                    ++i;
                }
            } else {
                this.scopingParents = null;
            }
            this.readOnlyNames = original.readOnlyNames;
        }

        private int[] buildLexicalUseArray(Pair<Pair<String, String>, Integer>[] exposedNames, String entityName) {
            if (exposedNames != null) {
                int[] lexicalUses = new int[exposedNames.length];
                int j = 0;
                while (j < exposedNames.length) {
                    lexicalUses[j] = entityName == null || entityName.equals(((Pair)exposedNames[j].fst).snd) ? (Integer)exposedNames[j].snd : -1;
                    ++j;
                }
                return lexicalUses;
            }
            return null;
        }

        private Pair<String, String>[] buildLexicalNamesArray(Pair<Pair<String, String>, Integer>[] exposedNames) {
            if (exposedNames != null) {
                Pair[] lexicalNames = new Pair[exposedNames.length];
                int j = 0;
                while (j < exposedNames.length) {
                    lexicalNames[j] = (Pair)exposedNames[j].fst;
                    ++j;
                }
                return lexicalNames;
            }
            return null;
        }

        AstLexicalInformation(String entityName, Scope scope, SSAInstruction[] instrs, Set<Pair<Pair<String, String>, Integer>> exposedNamesForReadSet, Set<Pair<Pair<String, String>, Integer>> exposedNamesForWriteSet, Set<AstLexicalAccess.Access> accesses) {
            this.functionLexicalName = entityName;
            Pair[] EN = null;
            if (exposedNamesForReadSet != null || exposedNamesForWriteSet != null) {
                HashSet<Pair<Pair<String, String>, Integer>> exposedNamesSet = new HashSet<Pair<Pair<String, String>, Integer>>();
                if (exposedNamesForReadSet != null) {
                    exposedNamesSet.addAll(exposedNamesForReadSet);
                }
                if (exposedNamesForWriteSet != null) {
                    exposedNamesSet.addAll(exposedNamesForWriteSet);
                }
                EN = exposedNamesSet.toArray(new Pair[exposedNamesSet.size()]);
            }
            if (exposedNamesForReadSet != null) {
                HashSet<String> readOnlyNames = new HashSet<String>();
                for (Pair<Pair<String, String>, Integer> v : exposedNamesForReadSet) {
                    if (entityName == null || !entityName.equals(((Pair)v.fst).snd)) continue;
                    readOnlyNames.add((String)((Pair)v.fst).fst);
                }
                if (exposedNamesForWriteSet != null) {
                    for (Pair<Pair<String, String>, Integer> v : exposedNamesForWriteSet) {
                        if (entityName == null || !entityName.equals(((Pair)v.fst).snd)) continue;
                        readOnlyNames.remove(((Pair)v.fst).fst);
                    }
                }
                this.readOnlyNames = readOnlyNames;
            } else {
                this.readOnlyNames = null;
            }
            this.exposedNames = this.buildLexicalNamesArray(EN);
            this.exitLexicalUses = this.buildLexicalUseArray(EN, entityName);
            this.instructionLexicalUses = new int[instrs.length][];
            int i = 0;
            while (i < instrs.length) {
                if (instrs[i] instanceof SSAAbstractInvokeInstruction) {
                    this.instructionLexicalUses[i] = this.buildLexicalUseArray(EN, null);
                }
                ++i;
            }
            if (accesses != null) {
                LinkedHashSet<String> parents = new LinkedHashSet<String>();
                for (AstLexicalAccess.Access AC : accesses) {
                    if (AC.variableDefiner == null) continue;
                    parents.add(AC.variableDefiner);
                }
                this.scopingParents = parents.toArray(new String[parents.size()]);
            } else {
                this.scopingParents = null;
            }
        }

        @Override
        public int[] getExitExposedUses() {
            return this.exitLexicalUses;
        }

        @Override
        public int[] getExposedUses(int instructionOffset) {
            return this.instructionLexicalUses[instructionOffset] == null ? NONE : this.instructionLexicalUses[instructionOffset];
        }

        @Override
        public IntSet getAllExposedUses() {
            if (this.allExposedUses == null) {
                int i;
                this.allExposedUses = IntSetUtil.make();
                if (this.exitLexicalUses != null) {
                    i = 0;
                    while (i < this.exitLexicalUses.length) {
                        if (this.exitLexicalUses[i] > 0) {
                            this.allExposedUses.add(this.exitLexicalUses[i]);
                        }
                        ++i;
                    }
                }
                if (this.instructionLexicalUses != null) {
                    i = 0;
                    while (i < this.instructionLexicalUses.length) {
                        if (this.instructionLexicalUses[i] != null) {
                            int j = 0;
                            while (j < this.instructionLexicalUses[i].length) {
                                if (this.instructionLexicalUses[i][j] > 0) {
                                    this.allExposedUses.add(this.instructionLexicalUses[i][j]);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            return this.allExposedUses;
        }

        @Override
        public Pair<String, String>[] getExposedNames() {
            return this.exposedNames;
        }

        @Override
        public String[] getScopingParents() {
            return this.scopingParents;
        }

        @Override
        public boolean isReadOnly(String name) {
            return this.readOnlyNames != null && this.readOnlyNames.contains(name);
        }

        @Override
        public String getScopingName() {
            return this.functionLexicalName;
        }

        public static boolean hasExposedUses(CGNode caller, CallSiteReference site) {
            int[] uses = ((AstMethod)caller.getMethod()).lexicalInfo().getExposedUses(site.getProgramCounter());
            if (uses != null && uses.length > 0) {
                int[] nArray = uses;
                int n = uses.length;
                int n2 = 0;
                while (n2 < n) {
                    int use = nArray[n2];
                    if (use > 0) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public class CodeEntityContext
    extends EntityContext {
        private final Scope topEntityScope;
        private final Set<Scope> allEntityScopes;
        private final IncipientCFG cfg;
        private final Map<IBasicBlock<SSAInstruction>, TypeReference[]> catchTypes;
        Set<Pair<Pair<String, String>, Integer>> exposedReads;
        Set<Pair<Pair<String, String>, Integer>> exposedWrites;
        Set<AstLexicalAccess.Access> accesses;
        private final Map<CAstNode, Integer> results;

        public CodeEntityContext(WalkContext parent, Scope entityScope, CAstEntity s) {
            super(parent, s);
            this.catchTypes = HashMapFactory.make();
            this.results = new LinkedHashMap<CAstNode, Integer>();
            this.topEntityScope = entityScope;
            this.allEntityScopes = HashSetFactory.make();
            this.allEntityScopes.add(entityScope);
            this.cfg = new IncipientCFG();
        }

        @Override
        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity e) {
            if (e == this.topNode) {
                if (this.accesses == null) {
                    this.accesses = HashSetFactory.make();
                }
                return this.accesses;
            }
            return super.getAccesses(e);
        }

        @Override
        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity entity, boolean writeSet) {
            if (entity == this.topNode) {
                if (writeSet) {
                    if (this.exposedWrites == null) {
                        this.exposedWrites = HashSetFactory.make();
                    }
                    return this.exposedWrites;
                }
                if (this.exposedReads == null) {
                    this.exposedReads = HashSetFactory.make();
                }
                return this.exposedReads;
            }
            return super.exposeNameSet(entity, writeSet);
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.top().getControlFlow();
        }

        @Override
        public IncipientCFG cfg() {
            return this.cfg;
        }

        @Override
        public Scope currentScope() {
            return this.topEntityScope;
        }

        @Override
        public Set<Scope> entityScopes() {
            return this.allEntityScopes;
        }

        @Override
        public UnwindState getUnwindState() {
            return null;
        }

        @Override
        public void setCatchType(CAstNode catchNode, TypeReference catchType) {
            this.setCatchType(this.cfg.getBlock(catchNode), catchType);
        }

        @Override
        public void setCatchType(IBasicBlock bb, TypeReference catchType) {
            if (!this.catchTypes.containsKey(bb)) {
                this.catchTypes.put((IBasicBlock<SSAInstruction>)bb, new TypeReference[]{catchType});
            } else {
                TypeReference[] data = this.catchTypes.get(bb);
                int i = 0;
                while (i < data.length) {
                    if (data[i] == catchType) {
                        return;
                    }
                    ++i;
                }
                TypeReference[] newData = new TypeReference[data.length + 1];
                System.arraycopy(data, 0, newData, 0, data.length);
                newData[data.length] = catchType;
                this.catchTypes.put((IBasicBlock<SSAInstruction>)bb, newData);
            }
        }

        @Override
        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes() {
            return this.catchTypes;
        }

        @Override
        public boolean hasValue(CAstNode n) {
            return this.results.containsKey(n);
        }

        @Override
        public final int setValue(CAstNode n, int v) {
            this.results.put(n, new Integer(v));
            return v;
        }

        @Override
        public final int getValue(CAstNode n) {
            if (this.results.containsKey(n)) {
                return this.results.get(n);
            }
            return -1;
        }
    }

    private abstract class DelegatingContext
    implements WalkContext {
        private final WalkContext parent;

        DelegatingContext(WalkContext parent) {
            this.parent = parent;
        }

        @Override
        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity e) {
            return this.parent.getAccesses(e);
        }

        @Override
        public ModuleEntry getModule() {
            return this.parent.getModule();
        }

        @Override
        public String getName() {
            return this.parent.getName();
        }

        @Override
        public String file() {
            return this.parent.file();
        }

        @Override
        public CAstEntity top() {
            return this.parent.top();
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.parent.getSourceMap();
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.parent.getControlFlow();
        }

        @Override
        public Scope currentScope() {
            return this.parent.currentScope();
        }

        @Override
        public Set<Scope> entityScopes() {
            return this.parent.entityScopes();
        }

        @Override
        public IncipientCFG cfg() {
            return this.parent.cfg();
        }

        @Override
        public UnwindState getUnwindState() {
            return this.parent.getUnwindState();
        }

        @Override
        public void setCatchType(IBasicBlock bb, TypeReference catchType) {
            this.parent.setCatchType(bb, catchType);
        }

        @Override
        public void setCatchType(CAstNode catchNode, TypeReference catchType) {
            this.parent.setCatchType(catchNode, catchType);
        }

        @Override
        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes() {
            return this.parent.getCatchTypes();
        }

        @Override
        public void addEntityName(CAstEntity e, String name) {
            this.parent.addEntityName(e, name);
        }

        @Override
        public String getEntityName(CAstEntity e) {
            return this.parent.getEntityName(e);
        }

        @Override
        public boolean hasValue(CAstNode n) {
            return this.parent.hasValue(n);
        }

        @Override
        public int setValue(CAstNode n, int v) {
            return this.parent.setValue(n, v);
        }

        @Override
        public int getValue(CAstNode n) {
            return this.parent.getValue(n);
        }

        @Override
        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity entity, boolean writeSet) {
            return this.parent.exposeNameSet(entity, writeSet);
        }

        @Override
        public Scope getGlobalScope() {
            return this.parent.getGlobalScope();
        }
    }

    private abstract class EntityContext
    extends DelegatingContext {
        protected final CAstEntity topNode;
        protected final String name;

        EntityContext(WalkContext parent, CAstEntity s) {
            super(parent);
            this.topNode = s;
            this.name = AstTranslator.this.composeEntityName(parent, s);
            this.addEntityName(s, this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CAstEntity top() {
            return this.topNode;
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.top().getSourceMap();
        }
    }

    private class FileContext
    extends DelegatingContext {
        private final String fUnitName;

        public FileContext(WalkContext parent, String unitName) {
            super(parent);
            this.fUnitName = unitName;
        }

        @Override
        public String getName() {
            return this.fUnitName;
        }
    }

    protected class FinalCAstSymbol
    implements CAstSymbol {
        private final String _name;
        private final CAstType type;

        public FinalCAstSymbol(String _name, CAstType type) {
            this._name = _name;
            this.type = type;
            assert (_name != null);
            assert (type != null);
        }

        @Override
        public CAstType type() {
            return this.type;
        }

        @Override
        public String name() {
            return this._name;
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isCaseInsensitive() {
            return false;
        }

        @Override
        public boolean isInternalName() {
            return false;
        }

        @Override
        public Object defaultInitValue() {
            return null;
        }
    }

    public final class IncipientCFG
    extends SparseNumberedGraph<PreBasicBlock> {
        private Unwind unwind = null;
        private final List<PreBasicBlock> blocks = new ArrayList<PreBasicBlock>();
        private PreBasicBlock entryBlock;
        private final Map<CAstNode, PreBasicBlock> nodeToBlock = new LinkedHashMap<CAstNode, PreBasicBlock>();
        private final Map<Object, Set<Pair<PreBasicBlock, Boolean>>> delayedEdges = new LinkedHashMap<Object, Set<Pair<PreBasicBlock, Boolean>>>();
        private final Object exitMarker = new Object();
        private final Set<PreBasicBlock> deadBlocks = new LinkedHashSet<PreBasicBlock>();
        private final Set<PreBasicBlock> normalToExit = new LinkedHashSet<PreBasicBlock>();
        private final Set<PreBasicBlock> exceptionalToExit = new LinkedHashSet<PreBasicBlock>();
        private CAstSourcePositionMap.Position[] linePositions = new CAstSourcePositionMap.Position[10];
        private boolean hasCatchBlock = false;
        private boolean hasMonitorOp = false;
        private int currentInstruction = 0;
        private PreBasicBlock currentBlock;

        public int getCurrentInstruction() {
            return this.currentInstruction;
        }

        public PreBasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        boolean hasCatchBlock() {
            return this.hasCatchBlock;
        }

        boolean hasMonitorOp() {
            return this.hasMonitorOp;
        }

        void noteCatchBlock() {
            this.hasCatchBlock = true;
        }

        CAstSourcePositionMap.Position[] getLinePositionMap() {
            return this.linePositions;
        }

        public PreBasicBlock newBlock(boolean fallThruFromPrior) {
            if (fallThruFromPrior && !this.currentBlock.isEntryBlock() && this.currentBlock.instructions().size() == 0) {
                return this.currentBlock;
            }
            PreBasicBlock previous = this.currentBlock;
            this.currentBlock = new PreBasicBlock();
            this.addNode(this.currentBlock);
            this.blocks.add(this.currentBlock);
            if (fallThruFromPrior) {
                this.addEdge(previous, this.currentBlock);
            } else {
                this.deadBlocks.add(this.currentBlock);
            }
            return this.currentBlock;
        }

        private void addDelayedEdge(PreBasicBlock src, Object dst, boolean exception) {
            MapUtil.findOrCreateSet(this.delayedEdges, (Object)dst).add(Pair.make((Object)src, (Object)exception));
        }

        void makeEntryBlock(PreBasicBlock bb) {
            this.entryBlock = bb;
            bb.makeEntryBlock();
        }

        void makeExitBlock(PreBasicBlock bb) {
            bb.makeExitBlock();
            Iterator ps = this.getPredNodes(bb);
            while (ps.hasNext()) {
                this.normalToExit.add((PreBasicBlock)ps.next());
            }
            this.checkForRealizedExitEdges(bb);
        }

        public void setCurrentBlockAsHandler() {
            this.currentBlock.makeHandlerBlock();
        }

        boolean hasDelayedEdges(CAstNode n) {
            return this.delayedEdges.containsKey(n);
        }

        private void checkForRealizedEdges(CAstNode n) {
            if (this.delayedEdges.containsKey(n)) {
                for (Pair<PreBasicBlock, Boolean> s : this.delayedEdges.get(n)) {
                    PreBasicBlock src = (PreBasicBlock)s.fst;
                    boolean exception = (Boolean)s.snd;
                    if (this.unwind == null) {
                        this.addEdge(src, this.nodeToBlock.get(n));
                        continue;
                    }
                    PreBasicBlock target = this.nodeToBlock.get(n);
                    this.addEdge(src, this.unwind.findOrCreateCode(src, target, exception));
                }
                this.delayedEdges.remove(n);
            }
        }

        private void checkForRealizedExitEdges(PreBasicBlock exitBlock) {
            if (this.delayedEdges.containsKey(this.exitMarker)) {
                for (Pair<PreBasicBlock, Boolean> s : this.delayedEdges.get(this.exitMarker)) {
                    PreBasicBlock src = (PreBasicBlock)s.fst;
                    boolean exception = (Boolean)s.snd;
                    this.addEdge(src, exitBlock);
                    if (exception) {
                        this.exceptionalToExit.add(src);
                        continue;
                    }
                    this.normalToExit.add(src);
                }
                this.delayedEdges.remove(this.exitMarker);
            }
        }

        private void setUnwindState(CAstNode node, UnwindState context) {
            if (this.unwind == null) {
                this.unwind = new Unwind();
            }
            this.unwind.setUnwindState(node, context);
        }

        public void addPreNode(CAstNode n) {
            this.addPreNode(n, null);
        }

        public void addPreNode(CAstNode n, UnwindState context) {
            this.nodeToBlock.put(n, this.currentBlock);
            this.deadBlocks.remove(this.currentBlock);
            if (context != null) {
                this.setUnwindState(n, context);
            }
            this.checkForRealizedEdges(n);
        }

        public void addPreEdge(CAstNode src, CAstNode dst, boolean exception) {
            assert (this.nodeToBlock.containsKey(src));
            this.addPreEdge(this.nodeToBlock.get(src), dst, exception);
        }

        public void addPreEdge(PreBasicBlock src, CAstNode dst, boolean exception) {
            if (dst == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                assert (exception);
                this.addPreEdgeToExit(src, exception);
            } else if (this.nodeToBlock.containsKey(dst)) {
                PreBasicBlock target = this.nodeToBlock.get(dst);
                if (this.unwind == null) {
                    this.addEdge(src, target);
                } else {
                    this.addEdge(src, this.unwind.findOrCreateCode(src, target, exception));
                }
            } else {
                this.addDelayedEdge(src, dst, exception);
            }
        }

        public void addPreEdgeToExit(CAstNode src, boolean exception) {
            assert (this.nodeToBlock.containsKey(src));
            this.addPreEdgeToExit(this.nodeToBlock.get(src), exception);
        }

        public void addPreEdgeToExit(PreBasicBlock src, boolean exception) {
            PreBasicBlock handlers;
            if (this.unwind != null && (handlers = this.unwind.findOrCreateCode(src, null, exception)) != null) {
                this.addEdge(src, handlers);
                return;
            }
            this.addDelayedEdge(src, this.exitMarker, exception);
        }

        public void addEdge(PreBasicBlock src, PreBasicBlock dst) {
            super.addEdge((Object)src, (Object)dst);
            this.deadBlocks.remove(dst);
        }

        public boolean isDeadBlock(PreBasicBlock block) {
            return this.deadBlocks.contains(block);
        }

        public PreBasicBlock getBlock(CAstNode n) {
            return this.nodeToBlock.get(n);
        }

        private void noteLinePosition(int instruction) {
            if (this.linePositions.length < instruction + 1) {
                CAstSourcePositionMap.Position[] newData = new CAstSourcePositionMap.Position[instruction * 2 + 1];
                System.arraycopy(this.linePositions, 0, newData, 0, this.linePositions.length);
                this.linePositions = newData;
            }
            this.linePositions[instruction] = AstTranslator.this.getCurrentPosition();
        }

        public void addInstruction(SSAInstruction n) {
            this.deadBlocks.remove(this.currentBlock);
            int inst = this.currentInstruction++;
            this.noteLinePosition(inst);
            if (this.currentBlock.instructions().size() == 0) {
                this.currentBlock.setFirstIndex(inst);
            } else {
                for (SSAInstruction priorInst : this.currentBlock.instructions()) {
                    assert (!(priorInst instanceof SSAGotoInstruction));
                }
                assert (!(n instanceof SSAGetCaughtExceptionInstruction));
            }
            if (n instanceof SSAMonitorInstruction) {
                this.hasMonitorOp = true;
            }
            this.currentBlock.instructions().add(n);
            this.currentBlock.setLastIndex(inst);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            for (PreBasicBlock b : this.blocks) {
                if (b.firstIndex <= 0) continue;
                sb.append("\n" + b);
                int i = 0;
                while (i < b.instructions.size()) {
                    sb.append("\n" + b.instructions.get(i));
                    ++i;
                }
            }
            return sb.toString();
        }

        protected class Unwind {
            private final Map<PreBasicBlock, UnwindState> unwindData = new LinkedHashMap<PreBasicBlock, UnwindState>();
            private final Map<Pair<UnwindState, Pair<PreBasicBlock, Boolean>>, PreBasicBlock> code = new LinkedHashMap<Pair<UnwindState, Pair<PreBasicBlock, Boolean>>, PreBasicBlock>();

            protected Unwind() {
            }

            void setUnwindState(PreBasicBlock block, UnwindState context) {
                this.unwindData.put(block, context);
            }

            void setUnwindState(CAstNode node, UnwindState context) {
                this.unwindData.put((PreBasicBlock)IncipientCFG.this.nodeToBlock.get(node), context);
            }

            public PreBasicBlock findOrCreateCode(PreBasicBlock source, PreBasicBlock target, final boolean exception) {
                CAstNode dummy;
                UnwindState sourceContext = this.unwindData.get(source);
                CAstNode cAstNode = dummy = exception ? new CAstImpl().makeNode(19) : null;
                if (sourceContext == null) {
                    return target;
                }
                WalkContext astContext = sourceContext.astContext;
                UnwindState targetContext = null;
                if (target != null) {
                    targetContext = this.unwindData.get(target);
                }
                if (targetContext != null && targetContext.covers(sourceContext)) {
                    return target;
                }
                Pair key = Pair.make((Object)sourceContext, (Object)Pair.make((Object)target, (Object)exception));
                if (this.code.containsKey(key)) {
                    return this.code.get(key);
                }
                int e = -1;
                PreBasicBlock currentBlock = IncipientCFG.this.getCurrentBlock();
                if (!IncipientCFG.this.isDeadBlock(currentBlock)) {
                    IncipientCFG.this.addInstruction((SSAInstruction)((IncipientCFG)IncipientCFG.this).AstTranslator.this.insts.GotoInstruction(IncipientCFG.this.currentInstruction, -1));
                    IncipientCFG.this.newBlock(false);
                }
                PreBasicBlock startBlock = IncipientCFG.this.getCurrentBlock();
                if (exception) {
                    IncipientCFG.this.setCurrentBlockAsHandler();
                    e = sourceContext.astContext.currentScope().allocateTempValue();
                    IncipientCFG.this.addInstruction((SSAInstruction)((IncipientCFG)IncipientCFG.this).AstTranslator.this.insts.GetCaughtExceptionInstruction(IncipientCFG.this.currentInstruction, startBlock.getNumber(), e));
                    sourceContext.astContext.setCatchType(startBlock, AstTranslator.this.defaultCatchType());
                }
                while (!(sourceContext == null || targetContext != null && targetContext.covers(sourceContext))) {
                    final CAstRewriter.Rewrite ast = new CAstCloner(new CAstImpl()){

                        @Override
                        protected CAstNode flowOutTo(Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap, CAstNode oldSource, Object label, CAstNode oldTarget, CAstControlFlowMap orig, CAstSourcePositionMap src) {
                            if (exception && !AstTranslator.this.isExceptionLabel(label)) {
                                return dummy;
                            }
                            return oldTarget;
                        }
                    }.copy(sourceContext.unwindAst, sourceContext.astContext.getControlFlow(), sourceContext.astContext.getSourceMap(), sourceContext.astContext.top().getNodeTypeMap(), sourceContext.astContext.top().getAllScopedEntities());
                    sourceContext.astVisitor.visit(ast.newRoot(), new DelegatingContext(AstTranslator.this, sourceContext.astContext){

                        @Override
                        public CAstSourcePositionMap getSourceMap() {
                            return ast.newPos();
                        }

                        @Override
                        public CAstControlFlowMap getControlFlow() {
                            return ast.newCfg();
                        }
                    }, sourceContext.astVisitor);
                    sourceContext = sourceContext.getParent();
                }
                PreBasicBlock endBlock = IncipientCFG.this.getCurrentBlock();
                if (exception) {
                    IncipientCFG.this.addPreNode(dummy);
                    AstTranslator.this.doThrow(astContext, e);
                } else {
                    IncipientCFG.this.addInstruction((SSAInstruction)((IncipientCFG)IncipientCFG.this).AstTranslator.this.insts.GotoInstruction(IncipientCFG.this.currentInstruction, -1));
                }
                IncipientCFG.this.newBlock(false);
                if (target != null) {
                    IncipientCFG.this.addEdge(currentBlock, IncipientCFG.this.getCurrentBlock());
                    IncipientCFG.this.addEdge(endBlock, target);
                } else {
                    if (exception) {
                        IncipientCFG.this.addEdge(currentBlock, IncipientCFG.this.getCurrentBlock());
                    }
                    IncipientCFG.this.addDelayedEdge(endBlock, IncipientCFG.this.exitMarker, exception);
                }
                this.code.put((Pair<UnwindState, Pair<PreBasicBlock, Boolean>>)key, startBlock);
                return startBlock;
            }
        }
    }

    public static class InternalCAstSymbol
    extends CAstSymbolImplBase {
        public InternalCAstSymbol(String _name, CAstType type) {
            super(_name, type, false, false, null);
        }

        public InternalCAstSymbol(String _name, CAstType type, boolean _isFinal) {
            super(_name, type, _isFinal, false, null);
        }

        public InternalCAstSymbol(String _name, CAstType type, boolean _isFinal, boolean _isCaseInsensitive) {
            super(_name, type, _isFinal, _isCaseInsensitive, null);
        }

        public InternalCAstSymbol(String _name, CAstType type, boolean _isFinal, boolean _isCaseInsensitive, Object _defaultInitValue) {
            super(_name, type, _isFinal, _isCaseInsensitive, _defaultInitValue);
        }

        @Override
        public boolean isInternalName() {
            return true;
        }
    }

    private class LocalContext
    extends DelegatingContext {
        private final Scope localScope;

        LocalContext(WalkContext parent, Scope localScope) {
            super(parent);
            this.localScope = localScope;
            parent.entityScopes().add(localScope);
        }

        @Override
        public Scope currentScope() {
            return this.localScope;
        }
    }

    protected static final class PreBasicBlock
    implements INodeWithNumber,
    IBasicBlock<SSAInstruction> {
        private static final int NORMAL = 0;
        private static final int HANDLER = 1;
        private static final int ENTRY = 2;
        private static final int EXIT = 3;
        private int kind = 0;
        private int number = -1;
        private int firstIndex = -1;
        private int lastIndex = -2;
        private final List<SSAInstruction> instructions = new ArrayList<SSAInstruction>();

        protected PreBasicBlock() {
        }

        public int getNumber() {
            return this.getGraphNodeId();
        }

        public int getGraphNodeId() {
            return this.number;
        }

        public void setGraphNodeId(int number) {
            this.number = number;
        }

        public int getFirstInstructionIndex() {
            return this.firstIndex;
        }

        void setFirstIndex(int firstIndex) {
            this.firstIndex = firstIndex;
        }

        public int getLastInstructionIndex() {
            return this.lastIndex;
        }

        void setLastIndex(int lastIndex) {
            this.lastIndex = lastIndex;
        }

        void makeExitBlock() {
            this.kind = 3;
        }

        void makeEntryBlock() {
            this.kind = 2;
        }

        void makeHandlerBlock() {
            this.kind = 1;
        }

        public boolean isEntryBlock() {
            return this.kind == 2;
        }

        public boolean isExitBlock() {
            return this.kind == 3;
        }

        public boolean isHandlerBlock() {
            return this.kind == 1;
        }

        public String toString() {
            return "PreBB" + this.number + ":" + this.firstIndex + ".." + this.lastIndex;
        }

        private List<SSAInstruction> instructions() {
            return this.instructions;
        }

        public boolean isCatchBlock() {
            return this.lastIndex > -1 && this.instructions.get(0) instanceof SSAGetCaughtExceptionInstruction;
        }

        public IMethod getMethod() {
            return null;
        }

        public Iterator<SSAInstruction> iterator() {
            return this.instructions.iterator();
        }
    }

    public final class RootContext
    implements WalkContext {
        private final Scope globalScope;
        private final CAstEntity N;
        private final ModuleEntry module;
        private final Map<CAstEntity, String> entityNames = new LinkedHashMap<CAstEntity, String>();

        public RootContext(CAstEntity N, ModuleEntry module) {
            this.N = N;
            this.module = module;
            this.globalScope = AstTranslator.this.makeGlobalScope();
        }

        @Override
        public ModuleEntry getModule() {
            return this.module;
        }

        @Override
        public String file() {
            return this.module.getName();
        }

        @Override
        public CAstEntity top() {
            return this.N;
        }

        @Override
        public Scope currentScope() {
            return this.globalScope;
        }

        @Override
        public Set<Scope> entityScopes() {
            return Collections.singleton(this.globalScope);
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.N.getSourceMap();
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.N.getControlFlow();
        }

        @Override
        public IncipientCFG cfg() {
            return null;
        }

        @Override
        public UnwindState getUnwindState() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setCatchType(IBasicBlock bb, TypeReference catchType) {
        }

        @Override
        public void setCatchType(CAstNode castNode, TypeReference catchType) {
        }

        @Override
        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes() {
            return null;
        }

        @Override
        public void addEntityName(CAstEntity e, String name) {
            this.entityNames.put(e, name);
        }

        @Override
        public String getEntityName(CAstEntity e) {
            if (e == null) {
                return null;
            }
            assert (this.entityNames.containsKey(e));
            return "L" + this.entityNames.get(e);
        }

        @Override
        public boolean hasValue(CAstNode n) {
            assert (false);
            return false;
        }

        @Override
        public int setValue(CAstNode n, int v) {
            assert (false);
            return 0;
        }

        @Override
        public int getValue(CAstNode n) {
            assert (false);
            return -1;
        }

        @Override
        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity entity, boolean writeSet) {
            assert (false);
            return null;
        }

        @Override
        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity e) {
            assert (false);
            return null;
        }

        @Override
        public Scope getGlobalScope() {
            return this.globalScope;
        }
    }

    public static interface Scope {
        public ScopeType type();

        public int allocateTempValue();

        public int getConstantValue(Object var1);

        public boolean isConstant(int var1);

        public Object getConstantObject(int var1);

        public void declare(CAstSymbol var1);

        public void declare(CAstSymbol var1, int var2);

        public boolean isCaseInsensitive(String var1);

        public boolean contains(String var1);

        public Symbol lookup(String var1);

        public Iterator<String> getAllNames();

        public int size();

        public boolean isGlobal(Symbol var1);

        public boolean isLexicallyScoped(Symbol var1);

        public CAstEntity getEntity();

        public Scope getParent();
    }

    public static enum ScopeType {
        LOCAL,
        GLOBAL,
        SCRIPT,
        FUNCTION,
        TYPE;

    }

    protected static interface Symbol {
        public int valueNumber();

        public Scope getDefiningScope();

        public boolean isParameter();

        public Object constant();

        public void setConstant(Object var1);

        public boolean isFinal();

        public boolean isInternalName();

        public Object defaultInitValue();

        public CAstType type();
    }

    private final class TypeContext
    extends EntityContext {
        private TypeContext(WalkContext parent, CAstEntity n) {
            super(parent, n);
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            Assertions.UNREACHABLE((String)"TypeContext.getControlFlow()");
            return null;
        }

        @Override
        public IncipientCFG cfg() {
            Assertions.UNREACHABLE((String)"TypeContext.cfg()");
            return null;
        }

        @Override
        public UnwindState getUnwindState() {
            Assertions.UNREACHABLE((String)"TypeContext.getUnwindState()");
            return null;
        }
    }

    private class UnwindContext
    extends DelegatingContext {
        private final UnwindState state;

        UnwindContext(CAstNode unwindNode, WalkContext parent, CAstVisitor<WalkContext> visitor) {
            super(parent);
            this.state = new UnwindState(unwindNode, parent, visitor);
        }

        @Override
        public UnwindState getUnwindState() {
            return this.state;
        }
    }

    protected final class UnwindState {
        final CAstNode unwindAst;
        final WalkContext astContext;
        final CAstVisitor<WalkContext> astVisitor;

        UnwindState(CAstNode unwindAst, WalkContext astContext, CAstVisitor<WalkContext> astVisitor) {
            this.unwindAst = unwindAst;
            this.astContext = astContext;
            this.astVisitor = astVisitor;
        }

        public UnwindState getParent() {
            return this.astContext.getUnwindState();
        }

        public int hashCode() {
            return this.astContext.hashCode() * this.unwindAst.hashCode() * this.astVisitor.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof UnwindState) {
                if (((UnwindState)o).unwindAst != this.unwindAst) {
                    return false;
                }
                if (((UnwindState)o).astVisitor != this.astVisitor) {
                    return false;
                }
                if (this.getParent() == null) {
                    return ((UnwindState)o).getParent() == null;
                }
                return this.getParent().equals(((UnwindState)o).getParent());
            }
            return false;
        }

        boolean covers(UnwindState other) {
            if (this.equals(other)) {
                return true;
            }
            if (this.getParent() != null) {
                return this.getParent().covers(other);
            }
            return false;
        }
    }

    public static interface WalkContext
    extends CAstVisitor.Context {
        public ModuleEntry getModule();

        public String getName();

        public String file();

        @Override
        public CAstSourcePositionMap getSourceMap();

        public CAstControlFlowMap getControlFlow();

        public Scope currentScope();

        public Set<Scope> entityScopes();

        public IncipientCFG cfg();

        public UnwindState getUnwindState();

        public void setCatchType(IBasicBlock var1, TypeReference var2);

        public void setCatchType(CAstNode var1, TypeReference var2);

        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes();

        public void addEntityName(CAstEntity var1, String var2);

        public String getEntityName(CAstEntity var1);

        public boolean hasValue(CAstNode var1);

        public int setValue(CAstNode var1, int var2);

        public int getValue(CAstNode var1);

        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity var1, boolean var2);

        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity var1);

        public Scope getGlobalScope();
    }
}

