/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.cha;

import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CrossLanguageClassHierarchy
implements IClassHierarchy {
    private final ClassLoaderFactory loaderFactory;
    private final AnalysisScope analysisScope;
    private final Map<Atom, IClassHierarchy> hierarchies;

    public ClassLoaderFactory getFactory() {
        return this.loaderFactory;
    }

    public AnalysisScope getScope() {
        return this.analysisScope;
    }

    private IClassHierarchy getHierarchy(Atom language) {
        return this.hierarchies.get(language);
    }

    private IClassHierarchy getHierarchy(IClassLoader loader) {
        return this.getHierarchy(loader.getLanguage().getName());
    }

    private IClassHierarchy getHierarchy(ClassLoaderReference loader) {
        return this.getHierarchy(loader.getLanguage());
    }

    private IClassHierarchy getHierarchy(IClass cls) {
        return this.getHierarchy(cls.getClassLoader());
    }

    private IClassHierarchy getHierarchy(TypeReference cls) {
        return this.getHierarchy(cls.getClassLoader());
    }

    private IClassHierarchy getHierarchy(MethodReference ref) {
        return this.getHierarchy(ref.getDeclaringClass());
    }

    private IClassHierarchy getHierarchy(FieldReference ref) {
        return this.getHierarchy(ref.getDeclaringClass());
    }

    public IClassLoader[] getLoaders() {
        HashSet loaders = HashSetFactory.make();
        Iterator ldrs = this.analysisScope.getLoaders().iterator();
        while (ldrs.hasNext()) {
            loaders.add(this.getLoader((ClassLoaderReference)ldrs.next()));
        }
        return loaders.toArray(new IClassLoader[loaders.size()]);
    }

    public IClassLoader getLoader(ClassLoaderReference loaderRef) {
        return this.getHierarchy(loaderRef).getLoader(loaderRef);
    }

    public boolean addClass(IClass klass) {
        return this.getHierarchy(klass).addClass(klass);
    }

    public int getNumberOfClasses() {
        int total = 0;
        Iterator ldrs = this.analysisScope.getLoaders().iterator();
        while (ldrs.hasNext()) {
            total += this.getLoader((ClassLoaderReference)ldrs.next()).getNumberOfClasses();
        }
        return total;
    }

    public boolean isRootClass(IClass c) {
        return this.getHierarchy(c).isRootClass(c);
    }

    public IClass getRootClass() {
        Assertions.UNREACHABLE();
        return null;
    }

    public int getNumber(IClass c) {
        return this.getHierarchy(c).getNumber(c);
    }

    public Set<IMethod> getPossibleTargets(MethodReference ref) {
        return this.getHierarchy(ref).getPossibleTargets(ref);
    }

    public Set<IMethod> getPossibleTargets(IClass receiverClass, MethodReference ref) {
        return this.getHierarchy(ref).getPossibleTargets(receiverClass, ref);
    }

    public IMethod resolveMethod(MethodReference m) {
        return this.getHierarchy(m).resolveMethod(m);
    }

    public IField resolveField(FieldReference f) {
        return this.getHierarchy(f).resolveField(f);
    }

    public IField resolveField(IClass klass, FieldReference f) {
        return this.getHierarchy(klass).resolveField(klass, f);
    }

    public IMethod resolveMethod(IClass receiver, Selector selector) {
        return this.getHierarchy(receiver).resolveMethod(receiver, selector);
    }

    public IClass lookupClass(TypeReference A) {
        return this.getHierarchy(A).lookupClass(A);
    }

    public boolean isInterface(TypeReference type) {
        return this.getHierarchy(type).isInterface(type);
    }

    public IClass getLeastCommonSuperclass(IClass A, IClass B) {
        return this.getHierarchy(A).getLeastCommonSuperclass(A, B);
    }

    public TypeReference getLeastCommonSuperclass(TypeReference A, TypeReference B) {
        return this.getHierarchy(A).getLeastCommonSuperclass(A, B);
    }

    public boolean isSubclassOf(IClass c, IClass T) {
        return this.getHierarchy(c).isSubclassOf(c, T);
    }

    public boolean implementsInterface(IClass c, IClass i) {
        return this.getHierarchy(c).implementsInterface(c, i);
    }

    public Collection<IClass> computeSubClasses(TypeReference type) {
        return this.getHierarchy(type).computeSubClasses(type);
    }

    public Collection<TypeReference> getJavaLangRuntimeExceptionTypes() {
        return this.getHierarchy(TypeReference.JavaLangRuntimeException).getJavaLangErrorTypes();
    }

    public Collection<TypeReference> getJavaLangErrorTypes() {
        return this.getHierarchy(TypeReference.JavaLangError).getJavaLangErrorTypes();
    }

    public Set<IClass> getImplementors(TypeReference type) {
        return this.getHierarchy(type).getImplementors(type);
    }

    public int getNumberOfImmediateSubclasses(IClass klass) {
        return this.getHierarchy(klass).getNumberOfImmediateSubclasses(klass);
    }

    public Collection<IClass> getImmediateSubclasses(IClass klass) {
        return this.getHierarchy(klass).getImmediateSubclasses(klass);
    }

    public boolean isAssignableFrom(IClass c1, IClass c2) {
        return this.getHierarchy(c1).isAssignableFrom(c1, c2);
    }

    public Iterator<IClass> iterator() {
        return new ComposedIterator<ClassLoaderReference, IClass>(this.analysisScope.getLoaders().iterator()){

            public Iterator<IClass> makeInner(ClassLoaderReference o) {
                IClassLoader ldr = CrossLanguageClassHierarchy.this.getLoader(o);
                return ldr.iterateAllClasses();
            }
        };
    }

    private CrossLanguageClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, Map<Atom, IClassHierarchy> hierarchies) {
        this.analysisScope = scope;
        this.loaderFactory = factory;
        this.hierarchies = hierarchies;
    }

    public static CrossLanguageClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory) throws ClassHierarchyException {
        Set languages = scope.getBaseLanguages();
        HashMap hierarchies = HashMapFactory.make();
        for (Language L : languages) {
            HashSet ll = HashSetFactory.make((Collection)L.getDerivedLanguages());
            ll.add(L);
            hierarchies.put(L.getName(), ClassHierarchyFactory.make((AnalysisScope)scope, (ClassLoaderFactory)factory, (Set)ll));
        }
        return new CrossLanguageClassHierarchy(scope, factory, hierarchies);
    }

    public Set<TypeReference> getUnresolvedClasses() {
        return HashSetFactory.make();
    }
}

