/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;

public class StandardFunctionTargetSelector
implements MethodTargetSelector {
    private final IClassHierarchy cha;
    private final MethodTargetSelector base;

    public StandardFunctionTargetSelector(IClassHierarchy cha, MethodTargetSelector base) {
        assert (cha != null);
        this.cha = cha;
        this.base = base;
    }

    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        IClass fun;
        IClass declarer;
        ClassLoaderReference loader = site.isStatic() || receiver == null ? site.getDeclaredTarget().getDeclaringClass().getClassLoader() : receiver.getClassLoader().getReference();
        TypeReference functionTypeRef = TypeReference.findOrCreate((ClassLoaderReference)loader, (TypeName)AstTypeReference.functionTypeName);
        IClass iClass = declarer = site.isStatic() ? this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass()) : receiver;
        if (declarer == null) {
            System.err.println("cannot find declarer for " + site + ", " + receiver + " in " + caller);
        }
        if ((fun = this.cha.lookupClass(functionTypeRef)) == null) {
            System.err.println("cannot find function " + functionTypeRef + " for " + site + ", " + receiver + " in " + caller);
        }
        if (fun != null && declarer != null && this.cha.isSubclassOf(declarer, fun)) {
            return declarer.getMethod(AstMethodReference.fnSelector);
        }
        return this.base.getCalleeTarget(caller, site, receiver);
    }

    public boolean mightReturnSyntheticMethod(CGNode caller, CallSiteReference site) {
        return true;
    }

    public boolean mightReturnSyntheticMethod(MethodReference declaredTarget) {
        return true;
    }
}

