/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt.ecj;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.Java2IRTranslator;
import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDTJava2CAstTranslator;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJSourceLoaderImpl;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.RangePosition;
import com.ibm.wala.classLoader.DirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.JarStreamModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.io.TemporaryFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class ECJSourceModuleTranslator
implements SourceModuleTranslator {
    protected boolean dump;
    protected ECJSourceLoaderImpl sourceLoader;
    private final String[] sources;
    private final String[] libs;

    public ECJSourceModuleTranslator(AnalysisScope scope, ECJSourceLoaderImpl sourceLoader) {
        this(scope, sourceLoader, false);
    }

    public ECJSourceModuleTranslator(AnalysisScope scope, ECJSourceLoaderImpl sourceLoader, boolean dump) {
        this.sourceLoader = sourceLoader;
        this.dump = dump;
        Pair<String[], String[]> paths = this.computeClassPath(scope);
        this.sources = (String[])paths.fst;
        this.libs = (String[])paths.snd;
    }

    private Pair<String[], String[]> computeClassPath(AnalysisScope scope) {
        LinkedList<String> sources = new LinkedList<String>();
        LinkedList<String> libs = new LinkedList<String>();
        for (ClassLoaderReference cl : scope.getLoaders()) {
            while (cl != null) {
                List modules = scope.getModules(cl);
                for (Module m : modules) {
                    if (m instanceof JarFileModule) {
                        JarFileModule jarFileModule = (JarFileModule)m;
                        libs.add(jarFileModule.getAbsolutePath());
                        continue;
                    }
                    if (m instanceof JarStreamModule) {
                        try {
                            File F = File.createTempFile("tmp", "jar");
                            F.deleteOnExit();
                            TemporaryFile.streamToFile((File)F, (InputStream[])new InputStream[]{(JarStreamModule)m});
                            libs.add(F.getAbsolutePath());
                            continue;
                        }
                        catch (IOException e) {
                            assert (false) : e;
                            continue;
                        }
                    }
                    if (!(m instanceof DirectoryTreeModule)) continue;
                    DirectoryTreeModule directoryTreeModule = (DirectoryTreeModule)m;
                    sources.add(directoryTreeModule.getPath());
                }
                cl = cl.getParent();
            }
        }
        return Pair.make((Object)sources.toArray(new String[sources.size()]), (Object)libs.toArray(new String[libs.size()]));
    }

    public void loadAllSources(Set<ModuleEntry> modules) {
        LinkedList<String> sources = new LinkedList<String>();
        HashMap sourceMap = HashMapFactory.make();
        for (ModuleEntry m : modules) {
            if (!m.isSourceFile()) continue;
            SourceFileModule s = (SourceFileModule)m;
            sourceMap.put(s.getAbsolutePath(), s);
            sources.add(s.getAbsolutePath());
        }
        String[] sourceFiles = sources.toArray(new String[sources.size()]);
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setEnvironment(this.libs, this.sources, null, false);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.8");
        parser.setCompilerOptions((Map)options);
        parser.createASTs(sourceFiles, null, new String[0], (FileASTRequestor)new ECJAstToIR(sourceMap), (IProgressMonitor)new NullProgressMonitor());
    }

    protected Java2IRTranslator makeIRTranslator() {
        return new Java2IRTranslator((JavaSourceLoaderImpl)this.sourceLoader);
    }

    protected JDTJava2CAstTranslator makeCAstTranslator(CompilationUnit cu, String fullPath) {
        return new JDTJava2CAstTranslator<CAstSourcePositionMap.Position>((JavaSourceLoaderImpl)this.sourceLoader, cu, fullPath, false, this.dump){

            @Override
            public CAstSourcePositionMap.Position makePosition(int start, int end) {
                try {
                    return new RangePosition(new URL("file://" + this.fullPath), this.cu.getLineNumber(start), start, end);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("bad file: " + this.fullPath, e);
                }
            }
        };
    }

    private final class ECJAstToIR
    extends FileASTRequestor {
        private final Map<String, ModuleEntry> sourceMap;

        public ECJAstToIR(Map<String, ModuleEntry> sourceMap) {
            this.sourceMap = sourceMap;
        }

        public void acceptAST(String source, CompilationUnit ast) {
            IProblem[] problems;
            int length;
            JDTJava2CAstTranslator jdt2cast = ECJSourceModuleTranslator.this.makeCAstTranslator(ast, source);
            Java2IRTranslator java2ir = ECJSourceModuleTranslator.this.makeIRTranslator();
            java2ir.translate(this.sourceMap.get(source), jdt2cast.translateToCAst());
            if (!"true".equals(System.getProperty("wala.jdt.quiet")) && (length = (problems = ast.getProblems()).length) > 0) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < length) {
                    buffer.append(problems[i].getMessage());
                    buffer.append('\n');
                    ++i;
                }
                if (length != 0) {
                    System.err.println("Unexpected problems in " + source + "\n " + buffer.toString());
                }
            }
        }
    }
}

