/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.ecj.util;

import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.java.client.impl.ZeroOneContainerCFABuilderFactory;
import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.warnings.Warnings;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;

public class SourceDirCallGraph {
    public static void main(String[] args) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, IOException {
        long start = System.currentTimeMillis();
        Properties p = CommandLine.parse((String[])args);
        String sourceDir = p.getProperty("sourceDir");
        String mainClass = p.getProperty("mainClass");
        JavaSourceAnalysisScope scope = new JavaSourceAnalysisScope();
        String[] stdlibs = WalaProperties.getJ2SEJarFiles();
        int i = 0;
        while (i < stdlibs.length) {
            scope.addToScope(ClassLoaderReference.Primordial, new JarFile(stdlibs[i]));
            ++i;
        }
        scope.addToScope(JavaSourceAnalysisScope.SOURCE, (Module)new SourceDirectoryTreeModule(new File(sourceDir)));
        ClassHierarchy cha = ClassHierarchyFactory.make((AnalysisScope)scope, (ClassLoaderFactory)new ECJClassLoaderFactory(scope.getExclusions()));
        System.out.println(String.valueOf(cha.getNumberOfClasses()) + " classes");
        System.out.println(Warnings.asString());
        Warnings.clear();
        AnalysisOptions options = new AnalysisOptions();
        Iterable entrypoints = Util.makeMainEntrypoints((ClassLoaderReference)JavaSourceAnalysisScope.SOURCE, (IClassHierarchy)cha, (String[])new String[]{mainClass});
        options.setEntrypoints(entrypoints);
        AnalysisCacheImpl cache = new AnalysisCacheImpl(AstIRFactory.makeDefaultFactory());
        CallGraphBuilder builder = new ZeroOneContainerCFABuilderFactory().make(options, (AnalysisCache)cache, (IClassHierarchy)cha, (AnalysisScope)scope, false);
        System.out.println("building call graph...");
        CallGraph cg = builder.makeCallGraph(options, null);
        long end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("took " + (end - start) + "ms");
        System.out.println(CallGraphStats.getStats((CallGraph)cg));
    }
}

