/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.ui.handlers;

import edu.cuny.hunter.streamrefactoring.ui.messages.Messages;
import edu.cuny.hunter.streamrefactoring.ui.wizards.OptimizeStreamRefactoringWizard;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.FrameworkUtil;

public class OptimizeStreamHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional.empty();
        ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        List list = SelectionUtil.toList((ISelection)currentSelection);
        HashSet<IJavaProject> javaProjectSet = new HashSet<IJavaProject>();
        if (list != null) {
            try {
                for (Object obj : list) {
                    if (!(obj instanceof IJavaElement)) continue;
                    IJavaElement jElem = (IJavaElement)obj;
                    switch (jElem.getElementType()) {
                        case 2: {
                            javaProjectSet.add((IJavaProject)jElem);
                        }
                    }
                }
                Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
                if (javaProjectSet.isEmpty()) {
                    MessageDialog.openError((Shell)shell, (String)Messages.Name, (String)Messages.NoProjects);
                } else {
                    OptimizeStreamRefactoringWizard.startRefactoring(javaProjectSet.toArray(new IJavaProject[javaProjectSet.size()]), shell, Optional.empty());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
                throw new ExecutionException("Failed to start refactoring", (Throwable)e);
            }
        }
        return null;
    }

    private Set<IMethod> extractMethodsFromClass(IType type, Optional<IProgressMonitor> monitor) throws JavaModelException {
        HashSet<IMethod> methodSet = new HashSet<IMethod>();
        if (type.isClass()) {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                this.logPossiblyMigratableMethod(method);
                methodSet.add(method);
                ++n2;
            }
        }
        return methodSet;
    }

    private Set<IMethod> extractMethodsFromCompilationUnit(ICompilationUnit cu, Optional<IProgressMonitor> monitor) throws JavaModelException {
        IType[] types;
        HashSet<IMethod> methodSet = new HashSet<IMethod>();
        IType[] iTypeArray = types = cu.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType = iTypeArray[n2];
            methodSet.addAll(this.extractMethodsFromClass(iType, monitor));
            ++n2;
        }
        return methodSet;
    }

    private Set<IMethod> extractMethodsFromJavaProject(IJavaProject jProj, Optional<IProgressMonitor> monitor) throws JavaModelException {
        IPackageFragmentRoot[] roots;
        HashSet<IMethod> methodSet = new HashSet<IMethod>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jProj.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
            methodSet.addAll(this.extractMethodsFromPackageFragmentRoot(iPackageFragmentRoot, monitor));
            ++n2;
        }
        return methodSet;
    }

    private Set<IMethod> extractMethodsFromPackageFragment(IPackageFragment frag, Optional<IProgressMonitor> monitor) throws JavaModelException {
        ICompilationUnit[] units;
        HashSet<IMethod> methodSet = new HashSet<IMethod>();
        ICompilationUnit[] iCompilationUnitArray = units = frag.getCompilationUnits();
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit iCompilationUnit = iCompilationUnitArray[n2];
            methodSet.addAll(this.extractMethodsFromCompilationUnit(iCompilationUnit, monitor));
            ++n2;
        }
        return methodSet;
    }

    private Set<IMethod> extractMethodsFromPackageFragmentRoot(IPackageFragmentRoot root, Optional<IProgressMonitor> monitor) throws JavaModelException {
        IJavaElement[] children;
        HashSet<IMethod> methodSet = new HashSet<IMethod>();
        IJavaElement[] iJavaElementArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child.getElementType() == 4) {
                methodSet.addAll(this.extractMethodsFromPackageFragment((IPackageFragment)child, monitor));
            }
            ++n2;
        }
        return methodSet;
    }

    private void logMethod(IMethod method, String format) {
        Formatter formatter = new Formatter();
        formatter.format(format, JavaElementLabels.getElementLabel((IJavaElement)method, (long)JavaElementLabels.ALL_FULLY_QUALIFIED));
        JavaPlugin.log((IStatus)new Status(1, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), formatter.toString()));
        formatter.close();
    }

    private void logNonMigratableMethod(IMethod method) {
        this.logMethod(method, "Method: %s is not migratable.");
    }

    private void logPossiblyMigratableMethod(IMethod method) {
        this.logMethod(method, "Method: %s is possibly migratable.");
    }
}

