/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.safe;

import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.unique.UniqueSolver;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import edu.cuny.hunter.streamrefactoring.core.wala.CallStringWithReceivers;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

public class ClientSlicingUniqueSolver
extends UniqueSolver {
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");

    public ClientSlicingUniqueSolver(CallGraph cg, PointerAnalysis pointerAnalysis, ITypeStateDFA dfa, TypeStateOptions options, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, TraceReporter traceReporter, IMergeFunctionFactory mergeFactory) {
        super(cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
    }

    protected Collection<InstanceKey> computeTrackedInstances() throws PropertiesException {
        Collection instances = super.computeTrackedInstances();
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            InstanceKey instanceKey = (InstanceKey)iterator.next();
            CallStringWithReceivers callString = Util.getCallString(instanceKey);
            IMethod[] callingMethods = callString.getMethods();
            IMethod outerMostCallingMethod = callingMethods[1];
            MethodReference reference = outerMostCallingMethod.getReference();
            TypeReference declaringClass = reference.getDeclaringClass();
            TypeName name = declaringClass.getName();
            Atom classPackage = name.getPackage();
            boolean isFromAPI = classPackage.startsWith(Atom.findOrCreateAsciiAtom((String)"java"));
            if (!isFromAPI) continue;
            LOGGER.info(() -> "Removing instance: " + instanceKey);
            iterator.remove();
        }
        return instances;
    }
}

