/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.safe;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallString;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContextSelector;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.Atom;
import edu.cuny.hunter.streamrefactoring.core.safe.NoApplicationCodeExistsInCallStringsException;
import edu.cuny.hunter.streamrefactoring.core.wala.EclipseProjectAnalysisEngine;
import edu.cuny.hunter.streamrefactoring.core.wala.nCFAContextWithReceiversSelector;
import java.util.Iterator;
import java.util.logging.Logger;

public class Util {
    private static final TypeName ARRAYS_TYPE_NAME = TypeName.string2TypeName((String)"Ljava/util/Arrays");
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private static final Atom STREAM_METHOD_NAME_ATOM = Atom.findOrCreateAsciiAtom((String)"stream");
    private static final TypeName STREAM_SUPPORT_TYPE_NAME = TypeName.string2TypeName((String)"Ljava/util/stream/StreamSupport");

    public static boolean instanceKeyCorrespondsWithInstantiationInstruction(InstanceKey instanceKey, SSAInvokeInstruction instruction, MethodReference instructionEnclosingMethod, EclipseProjectAnalysisEngine<InstanceKey> engine) throws NoApplicationCodeExistsInCallStringsException {
        Iterator creationSites = instanceKey.getCreationSites(engine.getCallGraph());
        CallSiteReference instructionCallSite = instruction.getCallSite();
        LOGGER.fine("instruction call site is: " + instructionCallSite);
        boolean applicationCodeInCallString = false;
        boolean allNonApplicationCodeReturnsStreams = true;
        while (creationSites.hasNext()) {
            Pair pair = (Pair)creationSites.next();
            ContextItem contextItem = ((CGNode)pair.fst).getContext().get(CallStringContextSelector.CALL_STRING);
            CallString callString = (CallString)contextItem;
            CallSiteReference[] callSiteRefs = callString.getCallSiteRefs();
            IMethod[] methods = callString.getMethods();
            assert (callSiteRefs.length == methods.length) : "Call sites and methods should correlate.";
            int i = 0;
            while (i < callSiteRefs.length) {
                IMethod target;
                TypeReference type;
                boolean implementsBaseStream;
                CallSiteReference callSiteReference = callSiteRefs[i];
                LOGGER.fine("Call site reference at " + i + " is: " + callSiteReference);
                IMethod method = methods[i];
                LOGGER.fine("Method at " + i + " is: " + method);
                ClassLoaderReference callSiteReferenceClassLoaderReference = callSiteReference.getDeclaredTarget().getDeclaringClass().getClassLoader();
                ClassLoaderReference methodClassLoader = method.getReference().getDeclaringClass().getClassLoader();
                if (!applicationCodeInCallString && (callSiteReferenceClassLoaderReference.equals((Object)ClassLoaderReference.Application) || methodClassLoader.equals((Object)ClassLoaderReference.Application))) {
                    applicationCodeInCallString = true;
                }
                if (allNonApplicationCodeReturnsStreams && !callSiteReferenceClassLoaderReference.equals((Object)ClassLoaderReference.Application) && !(implementsBaseStream = edu.cuny.hunter.streamrefactoring.core.analysis.Util.implementsBaseStream(type = edu.cuny.hunter.streamrefactoring.core.analysis.Util.getEvaluationType(target = engine.getClassHierarchy().resolveMethod(callSiteReference.getDeclaredTarget())), engine.getClassHierarchy()))) {
                    allNonApplicationCodeReturnsStreams = false;
                }
                if (callSiteReference.equals((Object)instructionCallSite) && method.getReference().getSignature().equals(instructionEnclosingMethod.getSignature())) {
                    LOGGER.fine("Match found. Instance key: " + instanceKey + " corresponds with instruction: " + instruction + ".");
                    return true;
                }
                ++i;
            }
        }
        LOGGER.fine("No match found. Instance key: " + instanceKey + " does not correspond with instruction: " + instruction + ".");
        if (!applicationCodeInCallString && allNonApplicationCodeReturnsStreams) {
            throw new NoApplicationCodeExistsInCallStringsException("Could not find application code in call string while processing instance key: " + instanceKey + " and instruction: " + instruction + ". This may indicate that the current value of N (" + ((nCFAContextWithReceiversSelector)((PropagationCallGraphBuilder)engine.getCallGraphBuilder()).getContextSelector()).getContextLengthForStreams() + ") is too small.");
        }
        return false;
    }

    private Util() {
    }
}

