/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.util;

import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaEclipseProjectPath
extends EclipseProjectPath<IClasspathEntry, IJavaProject> {
    protected JavaEclipseProjectPath(EclipseProjectPath.AnalysisScopeType scopeType) throws IOException, CoreException {
        super(scopeType);
    }

    public static JavaEclipseProjectPath make(IJavaProject p, EclipseProjectPath.AnalysisScopeType scopeType) throws IOException, CoreException {
        JavaEclipseProjectPath path = new JavaEclipseProjectPath(scopeType);
        path.create(p.getProject());
        return path;
    }

    protected IJavaProject makeProject(IProject p) {
        try {
            if (p.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)p);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected IClasspathEntry resolve(IClasspathEntry entry) {
        return JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
    }

    protected void resolveClasspathEntry(IJavaProject project, IClasspathEntry entry, EclipseProjectPath.ILoader loader, boolean includeSource, boolean cpeFromMainProject) {
        entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        switch (entry.getEntryKind()) {
            case 3: {
                this.resolveSourcePathEntry(includeSource ? JavaSourceLoader.SOURCE : EclipseProjectPath.Loader.APPLICATION, includeSource, cpeFromMainProject, entry.getPath(), entry.getOutputLocation(), entry.getExclusionPatterns(), "java");
                break;
            }
            case 1: {
                this.resolveLibraryPathEntry(loader, entry.getPath());
                break;
            }
            case 2: {
                this.resolveProjectPathEntry(loader, includeSource, entry.getPath());
                break;
            }
            case 5: {
                try {
                    IClasspathContainer cont = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] entries = cont.getClasspathEntries();
                    this.resolveClasspathEntries(project, Arrays.asList(entries), (EclipseProjectPath.ILoader)(cont.getKind() == 1 ? loader : EclipseProjectPath.Loader.PRIMORDIAL), includeSource, false);
                    break;
                }
                catch (CoreException e) {
                    System.err.println((Object)e);
                    Assertions.UNREACHABLE();
                }
            }
        }
    }

    protected void resolveProjectClasspathEntries(IJavaProject project, boolean includeSource) {
        try {
            this.resolveClasspathEntries(project, Arrays.asList(project.getRawClasspath()), (EclipseProjectPath.ILoader)EclipseProjectPath.Loader.EXTENSION, includeSource, true);
            File output = JavaEclipseProjectPath.makeAbsolute((IPath)project.getOutputLocation()).toFile();
            if (!includeSource && output.exists()) {
                List s = MapUtil.findOrCreateList((Map)this.modules, (Object)EclipseProjectPath.Loader.APPLICATION);
                s.add(new BinaryDirectoryTreeModule(output));
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    public static enum JavaSourceLoader implements EclipseProjectPath.ILoader
    {
        SOURCE(JavaSourceAnalysisScope.SOURCE);

        private ClassLoaderReference ref;

        private JavaSourceLoader(ClassLoaderReference ref) {
            this.ref = ref;
        }

        public ClassLoaderReference ref() {
            return this.ref;
        }
    }
}

