/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.Java2IRTranslator;
import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDTJava2CAstTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDTSourceLoaderImpl;
import com.ibm.wala.classLoader.DirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ide.classloader.EclipseSourceFileModule;
import com.ibm.wala.ide.util.JdtPosition;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JDTSourceModuleTranslator
implements SourceModuleTranslator {
    protected boolean dump;
    protected JDTSourceLoaderImpl sourceLoader;

    public JDTSourceModuleTranslator(AnalysisScope scope, JDTSourceLoaderImpl sourceLoader) {
        this(scope, sourceLoader, false);
    }

    public JDTSourceModuleTranslator(AnalysisScope scope, JDTSourceLoaderImpl sourceLoader, boolean dump) {
        this.computeClassPath(scope);
        this.sourceLoader = sourceLoader;
        this.dump = dump;
    }

    private void computeClassPath(AnalysisScope scope) {
        StringBuffer buf = new StringBuffer();
        ClassLoaderReference cl = scope.getApplicationLoader();
        while (cl != null) {
            List modules = scope.getModules(cl);
            for (Module m : modules) {
                if (buf.length() > 0) {
                    buf.append(File.pathSeparator);
                }
                if (m instanceof JarFileModule) {
                    JarFileModule jarFileModule = (JarFileModule)m;
                    buf.append(jarFileModule.getAbsolutePath());
                    continue;
                }
                if (m instanceof DirectoryTreeModule) {
                    DirectoryTreeModule directoryTreeModule = (DirectoryTreeModule)m;
                    buf.append(directoryTreeModule.getPath());
                    continue;
                }
                Assertions.UNREACHABLE((String)"Module entry is neither jar file nor directory");
            }
            cl = cl.getParent();
        }
    }

    public void loadAllSources(Set<ModuleEntry> modules) {
        HashMap projectsFiles = new HashMap();
        for (ModuleEntry m : modules) {
            assert (m instanceof EclipseSourceFileModule) : "Expecing EclipseSourceFileModule, not " + m.getClass();
            EclipseSourceFileModule entry = (EclipseSourceFileModule)m;
            IProject proj = entry.getIFile().getProject();
            if (!projectsFiles.containsKey(proj)) {
                projectsFiles.put(proj, new HashMap());
            }
            ((Map)projectsFiles.get(proj)).put(JavaCore.createCompilationUnitFrom((IFile)entry.getIFile()), entry);
        }
        ASTParser parser = ASTParser.newParser((int)8);
        for (Map.Entry proj : projectsFiles.entrySet()) {
            parser.setProject(JavaCore.create((IProject)((IProject)proj.getKey())));
            parser.setResolveBindings(true);
            Set units = ((Map)proj.getValue()).keySet();
            parser.createASTs(units.toArray(new ICompilationUnit[units.size()]), new String[0], (ASTRequestor)new JdtAstToIR(proj), null);
        }
    }

    protected Java2IRTranslator makeIRTranslator() {
        return new Java2IRTranslator((JavaSourceLoaderImpl)this.sourceLoader);
    }

    protected JDTJava2CAstTranslator makeCAstTranslator(CompilationUnit cu, final IFile sourceFile, String fullPath) {
        return new JDTJava2CAstTranslator<JdtPosition>((JavaSourceLoaderImpl)this.sourceLoader, cu, fullPath, false, this.dump){

            public JdtPosition makePosition(int start, int end) {
                return new JdtPosition(start, end, this.cu.getLineNumber(start), this.cu.getLineNumber(end), sourceFile, this.fullPath);
            }
        };
    }

    private final class JdtAstToIR
    extends ASTRequestor {
        private final Map.Entry<IProject, Map<ICompilationUnit, EclipseSourceFileModule>> proj;

        private JdtAstToIR(Map.Entry<IProject, Map<ICompilationUnit, EclipseSourceFileModule>> proj) {
            this.proj = proj;
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            IProblem[] problems;
            int length;
            try {
                JDTJava2CAstTranslator jdt2cast = JDTSourceModuleTranslator.this.makeCAstTranslator(ast, this.proj.getValue().get(source).getIFile(), source.getUnderlyingResource().getLocation().toOSString());
                Java2IRTranslator java2ir = JDTSourceModuleTranslator.this.makeIRTranslator();
                java2ir.translate((ModuleEntry)this.proj.getValue().get(source), jdt2cast.translateToCAst());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (!"true".equals(System.getProperty("wala.jdt.quiet")) && (length = (problems = ast.getProblems()).length) > 0) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < length) {
                    buffer.append(problems[i].getMessage());
                    buffer.append('\n');
                    ++i;
                }
                if (length != 0) {
                    System.err.println("Unexpected problems in " + source.getElementName() + buffer.toString());
                }
            }
        }
    }
}

