/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.scope;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class JUnitEntryPoints {
    private static final Logger logger = Logger.getLogger(JUnitEntryPoints.class.getName());
    private static final Set<String> TEST_ENTRY_POINT_ANNOTATION_NAMES = new HashSet<String>(Arrays.asList("org.junit.After", "org.junit.AfterClass", "org.junit.Before", "org.junit.BeforeClass", "org.junit.ClassRule", "org.junit.Rule", "org.junit.Test", "org.junit.runners.Parameterized.Parameters", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.Test"));

    public static Iterable<Entrypoint> make(IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        final HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            IMethod ctor;
            IClassLoader classLoader = klass.getClassLoader();
            ClassLoaderReference reference = classLoader.getReference();
            if (!reference.equals(ClassLoaderReference.Application)) continue;
            if (JUnitEntryPoints.isJUnitTestCase(klass)) {
                Set<IMethod> setUpTearDowns;
                logger.fine(() -> "application class: " + klass);
                Collection<IMethod> methods = klass.getAllMethods();
                for (IMethod m : methods) {
                    if (!JUnitEntryPoints.isJUnitMethod(m)) continue;
                    result.add(new DefaultEntrypoint(m, cha));
                    logger.fine(() -> "- adding test method as entry point: " + m.getName().toString());
                }
                try {
                    setUpTearDowns = JUnitEntryPoints.getSetUpTearDownMethods(klass);
                }
                catch (ClassHierarchyException e) {
                    throw new IllegalArgumentException("Can't find test method entry points using class hierarchy: " + cha, (Throwable)((Object)e));
                }
                Iterator<Object> iterator = setUpTearDowns.iterator();
                while (iterator.hasNext()) {
                    IMethod m = (IMethod)iterator.next();
                    result.add(new DefaultEntrypoint(m, cha));
                }
                continue;
            }
            boolean isTestClass = false;
            for (IMethod method : klass.getDeclaredMethods()) {
                if (!(method instanceof ShrikeCTMethod)) continue;
                for (Annotation annotation : ((ShrikeCTMethod)method).getAnnotations()) {
                    if (!JUnitEntryPoints.isTestEntryPoint(annotation.getType().getName())) continue;
                    result.add(new DefaultEntrypoint(method, cha));
                    isTestClass = true;
                }
            }
            if (!isTestClass) continue;
            IMethod classInitializer = klass.getClassInitializer();
            if (classInitializer != null) {
                result.add(new DefaultEntrypoint(classInitializer, cha));
            }
            if ((ctor = klass.getMethod(MethodReference.initSelector)) == null) continue;
            result.add(new DefaultEntrypoint(ctor, cha));
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    private static boolean isTestEntryPoint(TypeName typeName) {
        String javaName = JUnitEntryPoints.walaTypeNameToJavaName(typeName);
        return TEST_ENTRY_POINT_ANNOTATION_NAMES.contains(javaName);
    }

    private static String walaTypeNameToJavaName(TypeName typeName) {
        String fullyQualifiedName = typeName.getPackage() + "." + typeName.getClassName();
        return fullyQualifiedName.replace("$", ".").replace("/", ".");
    }

    public static Iterable<Entrypoint> makeOne(IClassHierarchy cha, String targetPackageName, String targetSimpleClassName, String targetMethodName) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom targetPackageAtom = Atom.findOrCreateAsciiAtom(targetPackageName);
        Atom targetSimpleClassAtom = Atom.findOrCreateAsciiAtom(targetSimpleClassName);
        TypeName targetType = TypeName.findOrCreateClass(targetPackageAtom, targetSimpleClassAtom);
        Atom targetMethodAtom = Atom.findOrCreateAsciiAtom(targetMethodName);
        logger.finer("finding entrypoint " + targetMethodAtom + " in " + targetType);
        final HashSet entryPts = HashSetFactory.make();
        try {
            for (IClass klass : cha) {
                TypeName klassType = klass.getName();
                if (!klassType.equals(targetType) || !JUnitEntryPoints.isJUnitTestCase(klass)) continue;
                logger.finer("found test class");
                for (IMethod method : klass.getDeclaredMethods()) {
                    Atom methodAtom = method.getName();
                    if (!methodAtom.equals(targetMethodAtom)) continue;
                    entryPts.add(new DefaultEntrypoint(method, cha));
                    logger.fine(() -> "- adding entry point of the call graph: " + methodAtom.toString());
                }
                Set<IMethod> setUpTearDowns = JUnitEntryPoints.getSetUpTearDownMethods(klass);
                for (IMethod m : setUpTearDowns) {
                    entryPts.add(new DefaultEntrypoint(m, cha));
                }
            }
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return entryPts.iterator();
            }
        };
    }

    public static boolean isJUnitTestCase(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        Atom junitPackage = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom junitClass = Atom.findOrCreateAsciiAtom("TestCase");
        Atom junitSuite = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName junitTestCaseType = TypeName.findOrCreateClass(junitPackage, junitClass);
        TypeName junitTestSuiteType = TypeName.findOrCreateClass(junitPackage, junitSuite);
        IClass ancestor = klass.getSuperclass();
        while (ancestor != null) {
            TypeName t = ancestor.getName();
            if (t.equals(junitTestCaseType) || t.equals(junitTestSuiteType)) {
                return true;
            }
            ancestor = ancestor.getSuperclass();
        }
        return false;
    }

    public static boolean isJUnitMethod(IMethod m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (!JUnitEntryPoints.isJUnitTestCase(m.getDeclaringClass())) {
            return false;
        }
        Atom method = m.getName();
        String methodName = method.toString();
        return methodName.startsWith("test") || methodName.equals("setUp") || methodName.equals("tearDown");
    }

    public static Set<IMethod> getSetUpTearDownMethods(IClass testClass) throws ClassHierarchyException {
        Atom junitPackage = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom junitClass = Atom.findOrCreateAsciiAtom("TestCase");
        Atom junitSuite = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName junitTestCaseType = TypeName.findOrCreateClass(junitPackage, junitClass);
        TypeName junitTestSuiteType = TypeName.findOrCreateClass(junitPackage, junitSuite);
        Atom setUpMethodAtom = Atom.findOrCreateAsciiAtom("setUp");
        Atom tearDownMethodAtom = Atom.findOrCreateAsciiAtom("tearDown");
        HashSet result = HashSetFactory.make();
        IClass currClass = testClass;
        while (currClass != null && !currClass.getName().equals(junitTestCaseType) && !currClass.getName().equals(junitTestSuiteType)) {
            for (IMethod method : currClass.getDeclaredMethods()) {
                Atom methodAtom = method.getName();
                if (!methodAtom.equals(setUpMethodAtom) && !methodAtom.equals(tearDownMethodAtom) && !method.isClinit() && !method.isInit()) continue;
                result.add(method);
            }
            currClass = currClass.getSuperclass();
        }
        return result;
    }
}

