/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorKillGen;
import com.ibm.wala.dataflow.graph.BitVectorMinusVector;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.BitVectorUnionVector;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HeapReachingDefs<T extends InstanceKey> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private final ModRef modRef;
    private final ExtendedHeapModel heapModel;

    public HeapReachingDefs(ModRef modRef, ExtendedHeapModel heapModel) {
        this.modRef = modRef;
        this.heapModel = heapModel;
    }

    public Map<Statement, OrdinalSet<Statement>> computeReachingDefs(CGNode node, IR ir, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, Collection<Statement> statements, HeapExclusions exclusions, CallGraph cg) {
        if (statements == null) {
            throw new IllegalArgumentException("statements is null");
        }
        if (pa == null) {
            throw new IllegalArgumentException("pa is null");
        }
        ExplodedControlFlowGraph cfg = ExplodedControlFlowGraph.make(ir);
        OrdinalSetMapping<Statement> domain = HeapReachingDefs.createStatementDomain(statements);
        Map<Integer, NormalStatement> ssaInstructionIndex2Statement = HeapReachingDefs.mapInstructionsToStatements(domain);
        BitVectorFramework rd = new BitVectorFramework((Graph)cfg, (ITransferFunctionProvider)new RD(node, cfg, pa, domain, ssaInstructionIndex2Statement, exclusions), domain);
        BitVectorSolver solver = new BitVectorSolver((IKilldallFramework)rd);
        try {
            solver.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
        return this.makeResult((BitVectorSolver<ISSABasicBlock>)solver, domain, node, this.heapModel, pa, mod, cfg, ssaInstructionIndex2Statement, exclusions, cg);
    }

    private Map<Statement, OrdinalSet<Statement>> makeResult(BitVectorSolver<? extends ISSABasicBlock> solver, OrdinalSetMapping<Statement> domain, CGNode node, ExtendedHeapModel h, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, ExplodedControlFlowGraph cfg, Map<Integer, NormalStatement> ssaInstructionIndex2Statement, HeapExclusions exclusions, CallGraph cg) {
        return new RDMap(solver, domain, node, h, pa, mod, cfg, ssaInstructionIndex2Statement, exclusions, cg);
    }

    private static boolean allCalleesMod(CallGraph cg, HeapStatement.HeapReturnCaller r, Map<CGNode, OrdinalSet<PointerKey>> mod) {
        Set<CGNode> targets = cg.getPossibleTargets(r.getNode(), r.getCall().getCallSite());
        if (targets.isEmpty()) {
            return false;
        }
        for (CGNode t : targets) {
            if (mod.get(t).contains((Object)r.getLocation())) continue;
            return false;
        }
        return true;
    }

    private Collection<PointerKey> getMod(Statement s, CGNode n, ExtendedHeapModel h, PointerAnalysis<? extends InstanceKey> pa, HeapExclusions exclusions) {
        switch (s.getKind()) {
            case NORMAL: {
                NormalStatement ns = (NormalStatement)s;
                return this.modRef.getMod(n, h, pa, ns.getInstruction(), exclusions);
            }
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: {
                HeapStatement hs = (HeapStatement)s;
                return Collections.singleton(hs.getLocation());
            }
            case PHI: 
            case PI: 
            case CATCH: 
            case PARAM_CALLER: 
            case PARAM_CALLEE: 
            case NORMAL_RET_CALLER: 
            case NORMAL_RET_CALLEE: 
            case EXC_RET_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLER: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case METHOD_EXIT: {
                return Collections.emptySet();
            }
        }
        Assertions.UNREACHABLE((String)((Object)((Object)s.getKind()) + " " + s.toString()));
        return null;
    }

    private static Map<Integer, NormalStatement> mapInstructionsToStatements(OrdinalSetMapping<Statement> domain) {
        HashMap result = HashMapFactory.make();
        for (Statement s : domain) {
            if (!s.getKind().equals((Object)Statement.Kind.NORMAL)) continue;
            NormalStatement n = (NormalStatement)s;
            result.put(n.getInstructionIndex(), n);
        }
        return result;
    }

    private static OrdinalSetMapping<Statement> createStatementDomain(Collection<Statement> statements) {
        Statement[] arr = new Statement[statements.size()];
        ObjectArrayMapping domain = new ObjectArrayMapping((Object[])statements.toArray(arr));
        return domain;
    }

    private class RD
    implements ITransferFunctionProvider<IExplodedBasicBlock, BitVectorVariable> {
        private final CGNode node;
        private final ExplodedControlFlowGraph cfg;
        private final OrdinalSetMapping<Statement> domain;
        private final PointerAnalysis<? extends InstanceKey> pa;
        private final Map<Integer, NormalStatement> ssaInstructionIndex2Statement;
        private final HeapExclusions exclusions;
        private final IBinaryNaturalRelation heapReturnCaller = new BasicNaturalRelation();

        public RD(CGNode node, ExplodedControlFlowGraph cfg, PointerAnalysis<? extends InstanceKey> pa2, OrdinalSetMapping<Statement> domain, Map<Integer, NormalStatement> ssaInstructionIndex2Statement, HeapExclusions exclusions) {
            this.node = node;
            this.cfg = cfg;
            this.domain = domain;
            this.pa = pa2;
            this.ssaInstructionIndex2Statement = ssaInstructionIndex2Statement;
            this.exclusions = exclusions;
            this.initHeapReturnCaller();
        }

        private void initHeapReturnCaller() {
            for (Statement s : this.domain) {
                if (!s.getKind().equals((Object)Statement.Kind.HEAP_RET_CALLER)) continue;
                HeapStatement.HeapReturnCaller r = (HeapStatement.HeapReturnCaller)s;
                NormalStatement call = this.ssaInstructionIndex2Statement.get(r.getCallIndex());
                int i = this.domain.getMappedIndex((Object)call);
                int j = this.domain.getMappedIndex((Object)r);
                this.heapReturnCaller.add(i, j);
            }
        }

        public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(IExplodedBasicBlock src, IExplodedBasicBlock dst) {
            if (src.isEntryBlock()) {
                return new BitVectorUnionVector(new BitVectorIntSet(this.heapEntryStatements()).getBitVector());
            }
            if (src.getInstruction() != null && !(src.getInstruction() instanceof SSAAbstractInvokeInstruction) && !this.cfg.getNormalSuccessors(src).contains(dst)) {
                return BitVectorIdentity.instance();
            }
            BitVector kill = this.kill(src);
            IntSet gen = this.gen(src);
            if (kill == null) {
                if (gen == null) {
                    return BitVectorIdentity.instance();
                }
                return new BitVectorUnionVector(new BitVectorIntSet(gen).getBitVector());
            }
            if (gen == null) {
                return new BitVectorMinusVector(kill);
            }
            return new BitVectorKillGen(kill, new BitVectorIntSet(gen).getBitVector());
        }

        public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
            return BitVectorUnion.instance();
        }

        public UnaryOperator<BitVectorVariable> getNodeTransferFunction(IExplodedBasicBlock node) {
            return null;
        }

        public boolean hasEdgeTransferFunctions() {
            return true;
        }

        public boolean hasNodeTransferFunctions() {
            return false;
        }

        IntSet gen(IExplodedBasicBlock b) {
            SSAInstruction s = b.getInstruction();
            if (s == null) {
                return null;
            }
            if (s instanceof SSAAbstractInvokeInstruction) {
                Statement st = this.ssaInstructionIndex2Statement.get(b.getLastInstructionIndex());
                if (st == null) {
                    System.err.println(this.ssaInstructionIndex2Statement);
                    Assertions.UNREACHABLE((String)("bang " + b + " " + b.getLastInstructionIndex() + " " + s));
                }
                int domainIndex = this.domain.getMappedIndex((Object)st);
                assert (domainIndex != -1);
                return this.heapReturnCaller.getRelated(domainIndex);
            }
            Set<PointerKey> gen = HeapReachingDefs.this.modRef.getMod(this.node, HeapReachingDefs.this.heapModel, this.pa, s, this.exclusions);
            if (gen.isEmpty()) {
                return null;
            }
            NormalStatement n = this.ssaInstructionIndex2Statement.get(b.getLastInstructionIndex());
            return SparseIntSet.singleton((int)this.domain.getMappedIndex((Object)n));
        }

        private IntSet heapEntryStatements() {
            BitVectorIntSet result = new BitVectorIntSet();
            for (Statement s : this.domain) {
                if (!s.getKind().equals((Object)Statement.Kind.HEAP_PARAM_CALLEE)) continue;
                result.add(this.domain.getMappedIndex((Object)s));
            }
            return result;
        }

        BitVector kill(IExplodedBasicBlock b) {
            SSAInstruction s = b.getInstruction();
            if (s == null) {
                return null;
            }
            Set<PointerKey> mod = HeapReachingDefs.this.modRef.getMod(this.node, HeapReachingDefs.this.heapModel, this.pa, s, this.exclusions);
            if (mod.isEmpty()) {
                return null;
            }
            Predicate staticFilter = new Predicate(){

                public boolean test(Object o) {
                    return o instanceof StaticFieldKey;
                }
            };
            Iterator2Set kill = Iterator2Collection.toSet((Iterator)new FilterIterator(mod.iterator(), staticFilter));
            if (kill.isEmpty()) {
                return null;
            }
            Predicate f = new Predicate((Collection)kill){
                private final /* synthetic */ Collection val$kill;
                {
                    this.val$kill = collection;
                }

                public boolean test(Object o) {
                    Statement s = (Statement)o;
                    Collection m = HeapReachingDefs.this.getMod(s, RD.this.node, HeapReachingDefs.this.heapModel, RD.this.pa, RD.this.exclusions);
                    for (PointerKey k : this.val$kill) {
                        if (!m.contains(k)) continue;
                        return true;
                    }
                    return false;
                }
            };
            BitVector result = new BitVector();
            for (Statement k : Iterator2Iterable.make((Iterator)new FilterIterator(this.domain.iterator(), f))) {
                result.set(this.domain.getMappedIndex((Object)k));
            }
            return result;
        }
    }

    private class RDMap
    implements Map<Statement, OrdinalSet<Statement>> {
        final Map<Statement, OrdinalSet<Statement>> delegate = HashMapFactory.make();
        private final HeapExclusions exclusions;
        private final CallGraph cg;

        RDMap(BitVectorSolver<? extends ISSABasicBlock> solver, OrdinalSetMapping<Statement> domain, CGNode node, ExtendedHeapModel h, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, ExplodedControlFlowGraph cfg, Map<Integer, NormalStatement> ssaInstructionIndex2Statement, HeapExclusions exclusions, CallGraph cg) {
            this.exclusions = exclusions;
            this.cg = cg;
            Map<PointerKey, MutableIntSet> pointerKeyMod = this.initPointerKeyMod(domain, node, h, pa);
            this.eagerPopulate(pointerKeyMod, solver, domain, node, h, pa, mod, cfg, ssaInstructionIndex2Statement);
        }

        private void eagerPopulate(Map<PointerKey, MutableIntSet> pointerKeyMod, BitVectorSolver<? extends ISSABasicBlock> solver, OrdinalSetMapping<Statement> domain, CGNode node, ExtendedHeapModel h, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, ExplodedControlFlowGraph cfg, Map<Integer, NormalStatement> ssaInstruction2Statement) {
            for (Statement s : domain) {
                this.delegate.put(s, this.computeResult(s, pointerKeyMod, solver, domain, node, h, pa, mod, cfg, ssaInstruction2Statement));
            }
        }

        private Map<PointerKey, MutableIntSet> initPointerKeyMod(OrdinalSetMapping<Statement> domain, CGNode node, ExtendedHeapModel h, PointerAnalysis<? extends InstanceKey> pa) {
            HashMap pointerKeyMod = HashMapFactory.make();
            block3: for (Statement s : domain) {
                switch (s.getKind()) {
                    case HEAP_PARAM_CALLEE: 
                    case HEAP_RET_CALLER: {
                        HeapStatement hs = (HeapStatement)s;
                        MutableIntSet set = this.findOrCreateIntSet(pointerKeyMod, hs.getLocation());
                        set.add(domain.getMappedIndex((Object)s));
                        break;
                    }
                    default: {
                        Collection m = HeapReachingDefs.this.getMod(s, node, h, pa, this.exclusions);
                        for (PointerKey p : m) {
                            MutableIntSet set = this.findOrCreateIntSet(pointerKeyMod, p);
                            set.add(domain.getMappedIndex((Object)s));
                        }
                        continue block3;
                    }
                }
            }
            return pointerKeyMod;
        }

        private MutableIntSet findOrCreateIntSet(Map<PointerKey, MutableIntSet> map, PointerKey key) {
            MutableIntSet result = map.get(key);
            if (result == null) {
                result = MutableSparseIntSet.makeEmpty();
                map.put(key, result);
            }
            return result;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void clear() {
            Assertions.UNREACHABLE();
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            Assertions.UNREACHABLE();
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            Assertions.UNREACHABLE();
            return this.delegate.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Statement, OrdinalSet<Statement>>> entrySet() {
            Assertions.UNREACHABLE();
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            Assertions.UNREACHABLE();
            return this.delegate.equals(o);
        }

        @Override
        public OrdinalSet<Statement> get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public int hashCode() {
            Assertions.UNREACHABLE();
            return this.delegate.hashCode();
        }

        @Override
        public boolean isEmpty() {
            Assertions.UNREACHABLE();
            return this.delegate.isEmpty();
        }

        @Override
        public Set<Statement> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public OrdinalSet<Statement> put(Statement key, OrdinalSet<Statement> value) {
            Assertions.UNREACHABLE();
            return this.delegate.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Statement, ? extends OrdinalSet<Statement>> t) {
            Assertions.UNREACHABLE();
            this.delegate.putAll(t);
        }

        @Override
        public OrdinalSet<Statement> remove(Object key) {
            Assertions.UNREACHABLE();
            return this.delegate.remove(key);
        }

        @Override
        public int size() {
            Assertions.UNREACHABLE();
            return this.delegate.size();
        }

        @Override
        public Collection<OrdinalSet<Statement>> values() {
            Assertions.UNREACHABLE();
            return this.delegate.values();
        }

        OrdinalSet<Statement> computeResult(Statement s, Map<PointerKey, MutableIntSet> pointerKeyMod, BitVectorSolver<? extends ISSABasicBlock> solver, OrdinalSetMapping<Statement> domain, CGNode node, ExtendedHeapModel h, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, ExplodedControlFlowGraph cfg, Map<Integer, NormalStatement> ssaInstructionIndex2Statement) {
            switch (s.getKind()) {
                case NORMAL: {
                    NormalStatement n = (NormalStatement)s;
                    Set<PointerKey> ref = HeapReachingDefs.this.modRef.getRef(node, h, pa, n.getInstruction(), this.exclusions);
                    if (!ref.isEmpty()) {
                        IExplodedBasicBlock bb = cfg.getBlockForInstruction(n.getInstructionIndex());
                        BitVectorVariable v = (BitVectorVariable)solver.getIn((Object)bb);
                        MutableSparseIntSet defs = MutableSparseIntSet.makeEmpty();
                        if (v.getValue() != null) {
                            for (PointerKey p : ref) {
                                if (pointerKeyMod.get(p) == null) continue;
                                defs.addAll(pointerKeyMod.get(p).intersection(v.getValue()));
                            }
                        }
                        return new OrdinalSet((IntSet)defs, domain);
                    }
                    return OrdinalSet.empty();
                }
                case HEAP_RET_CALLEE: {
                    HeapStatement.HeapReturnCallee r = (HeapStatement.HeapReturnCallee)s;
                    PointerKey p = r.getLocation();
                    BitVectorVariable v = (BitVectorVariable)solver.getIn((Object)cfg.exit());
                    if (pointerKeyMod.get(p) == null) {
                        return OrdinalSet.empty();
                    }
                    return new OrdinalSet(pointerKeyMod.get(p).intersection(v.getValue()), domain);
                }
                case HEAP_RET_CALLER: {
                    HeapStatement.HeapReturnCaller r = (HeapStatement.HeapReturnCaller)s;
                    IExplodedBasicBlock bb = cfg.getBlockForInstruction(r.getCallIndex());
                    BitVectorVariable v = (BitVectorVariable)solver.getIn((Object)bb);
                    if (HeapReachingDefs.allCalleesMod(this.cg, r, mod) || pointerKeyMod.get(r.getLocation()) == null || v.getValue() == null) {
                        return OrdinalSet.empty();
                    }
                    return new OrdinalSet(pointerKeyMod.get(r.getLocation()).intersection(v.getValue()), domain);
                }
                case HEAP_PARAM_CALLER: {
                    HeapStatement.HeapParamCaller r = (HeapStatement.HeapParamCaller)s;
                    NormalStatement call = ssaInstructionIndex2Statement.get(r.getCallIndex());
                    IExplodedBasicBlock callBlock = cfg.getBlockForInstruction(call.getInstructionIndex());
                    if (callBlock.isEntryBlock()) {
                        int x = domain.getMappedIndex((Object)new HeapStatement.HeapParamCallee(node, r.getLocation()));
                        assert (x >= 0);
                        SparseIntSet xset = SparseIntSet.singleton((int)x);
                        return new OrdinalSet((IntSet)xset, domain);
                    }
                    BitVectorVariable v = (BitVectorVariable)solver.getIn((Object)callBlock);
                    if (pointerKeyMod.get(r.getLocation()) == null || v.getValue() == null) {
                        return OrdinalSet.empty();
                    }
                    return new OrdinalSet(pointerKeyMod.get(r.getLocation()).intersection(v.getValue()), domain);
                }
                case PHI: 
                case PI: 
                case CATCH: 
                case PARAM_CALLER: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLER: 
                case EXC_RET_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    return OrdinalSet.empty();
                }
                case HEAP_PARAM_CALLEE: {
                    return OrdinalSet.empty();
                }
            }
            Assertions.UNREACHABLE((String)s.getKind().toString());
            return null;
        }
    }
}

