/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg.exceptionpruning.filter;

import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.FilteredException;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.LinkedList;

public class IgnoreExceptionsFilter
implements ExceptionFilter<SSAInstruction> {
    private final Collection<FilteredException> toBeIgnored = new LinkedList<FilteredException>();

    public IgnoreExceptionsFilter(Collection<TypeReference> toBeIgnored) {
        this.addAll(toBeIgnored);
    }

    public IgnoreExceptionsFilter(TypeReference toBeIgnored) {
        LinkedList<TypeReference> list = new LinkedList<TypeReference>();
        list.add(toBeIgnored);
        this.addAll(list);
    }

    private void addAll(Collection<TypeReference> toBeIgnored) {
        for (TypeReference ignored : toBeIgnored) {
            this.toBeIgnored.add(new FilteredException(ignored, true));
        }
    }

    @Override
    public boolean alwaysThrowsException(SSAInstruction instruction) {
        return false;
    }

    @Override
    public Collection<FilteredException> filteredExceptions(SSAInstruction instruction) {
        return this.toBeIgnored;
    }
}

