/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cfg.EdgeFilter;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class PrunedCFG<I, T extends IBasicBlock<I>>
extends AbstractNumberedGraph<T>
implements ControlFlowGraph<I, T> {
    private final ControlFlowGraph<I, T> cfg;
    private final FilteredNodes<T> nodes;
    private final FilteredCFGEdges<I, T> edges;

    public static <I, T extends IBasicBlock<I>> PrunedCFG<I, T> make(ControlFlowGraph<I, T> cfg, EdgeFilter<T> filter) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        return new PrunedCFG<I, T>(cfg, filter);
    }

    private PrunedCFG(final ControlFlowGraph<I, T> cfg, EdgeFilter<T> filter) {
        this.cfg = cfg;
        AbstractNumberedGraph temp = new AbstractNumberedGraph<T>(filter){
            private final NumberedEdgeManager<T> edges;
            {
                this.edges = new FilteredCFGEdges(controlFlowGraph, controlFlowGraph, edgeFilter);
            }

            protected NumberedNodeManager<T> getNodeManager() {
                return cfg;
            }

            protected NumberedEdgeManager<T> getEdgeManager() {
                return this.edges;
            }
        };
        Set reachable = DFS.getReachableNodes((Graph)temp, Collections.singleton((IBasicBlock)cfg.entry()));
        Set back = DFS.getReachableNodes((Graph)GraphInverter.invert((Graph)temp), Collections.singleton((IBasicBlock)cfg.exit()));
        reachable.retainAll(back);
        reachable.add((IBasicBlock)cfg.entry());
        reachable.add((IBasicBlock)cfg.exit());
        this.nodes = new FilteredNodes(cfg, reachable);
        this.edges = new FilteredCFGEdges<I, T>(cfg, this.nodes, filter);
    }

    protected NumberedNodeManager<T> getNodeManager() {
        return this.nodes;
    }

    protected NumberedEdgeManager<T> getEdgeManager() {
        return this.edges;
    }

    @Override
    public List<T> getExceptionalSuccessors(T N) {
        ArrayList<IBasicBlock> result = new ArrayList<IBasicBlock>();
        Iterator<T> it = this.edges.getExceptionalSuccessors(N);
        while (it.hasNext()) {
            result.add((IBasicBlock)it.next());
        }
        return result;
    }

    @Override
    public Collection<T> getNormalSuccessors(T N) {
        return Iterator2Collection.toSet(this.edges.getNormalSuccessors(N));
    }

    @Override
    public Collection<T> getExceptionalPredecessors(T N) {
        return Iterator2Collection.toSet(this.edges.getExceptionalPredecessors(N));
    }

    @Override
    public Collection<T> getNormalPredecessors(T N) {
        return Iterator2Collection.toSet(this.edges.getNormalPredecessors(N));
    }

    @Override
    public T entry() {
        return (T)((IBasicBlock)this.cfg.entry());
    }

    @Override
    public T exit() {
        return (T)((IBasicBlock)this.cfg.exit());
    }

    @Override
    public T getBlockForInstruction(int index) {
        return this.cfg.getBlockForInstruction(index);
    }

    @Override
    public I[] getInstructions() {
        return this.cfg.getInstructions();
    }

    @Override
    public int getProgramCounter(int index) {
        return this.cfg.getProgramCounter(index);
    }

    @Override
    public IMethod getMethod() {
        return this.cfg.getMethod();
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector result = new BitVector();
        BitVector blocks = this.cfg.getCatchBlocks();
        int i = 0;
        while ((i = blocks.nextSetBit(i)) != -1) {
            if (!this.nodes.containsNode((IBasicBlock)this.getNode(i))) continue;
            result.set(i);
        }
        return result;
    }

    public IntSet getPhiIndices(T bb) {
        assert (this.containsNode(bb));
        assert (this.cfg.containsNode(bb));
        int i = 0;
        MutableIntSet valid = IntSetUtil.make();
        Iterator pbs = this.cfg.getPredNodes(bb);
        while (pbs.hasNext()) {
            if (this.nodes.containsNode((IBasicBlock)pbs.next())) {
                valid.add(i);
            }
            ++i;
        }
        return valid;
    }

    private static class FilteredCFGEdges<I, T extends IBasicBlock<I>>
    implements NumberedEdgeManager<T> {
        private final ControlFlowGraph<I, T> cfg;
        private final NumberedNodeManager<T> currentCFGNodes;
        private final EdgeFilter<T> filter;

        FilteredCFGEdges(ControlFlowGraph<I, T> cfg, NumberedNodeManager<T> currentCFGNodes, EdgeFilter<T> filter) {
            this.cfg = cfg;
            this.filter = filter;
            this.currentCFGNodes = currentCFGNodes;
        }

        public Iterator<T> getExceptionalSuccessors(T N) {
            return new FilterIterator(this.cfg.getExceptionalSuccessors(N).iterator(), new Predicate<T>((IBasicBlock)N){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                public boolean test(T o) {
                    return currentCFGNodes.containsNode(o) && filter.hasExceptionalEdge(this.val$N, o);
                }
            });
        }

        public Iterator<T> getNormalSuccessors(T N) {
            return new FilterIterator(this.cfg.getNormalSuccessors(N).iterator(), new Predicate<T>((IBasicBlock)N){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                public boolean test(T o) {
                    return currentCFGNodes.containsNode(o) && filter.hasNormalEdge(this.val$N, o);
                }
            });
        }

        public Iterator<T> getExceptionalPredecessors(T N) {
            return new FilterIterator(this.cfg.getExceptionalPredecessors(N).iterator(), new Predicate<T>((IBasicBlock)N){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                public boolean test(T o) {
                    return currentCFGNodes.containsNode(o) && filter.hasExceptionalEdge(o, this.val$N);
                }
            });
        }

        public Iterator<T> getNormalPredecessors(T N) {
            return new FilterIterator(this.cfg.getNormalPredecessors(N).iterator(), new Predicate<T>((IBasicBlock)N){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                public boolean test(T o) {
                    return currentCFGNodes.containsNode(o) && filter.hasNormalEdge(o, this.val$N);
                }
            });
        }

        public Iterator<T> getSuccNodes(T N) {
            return new FilterIterator(this.cfg.getSuccNodes(N), new Predicate<T>((IBasicBlock)N){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                public boolean test(T o) {
                    return currentCFGNodes.containsNode(o) && (filter.hasNormalEdge(this.val$N, o) || filter.hasExceptionalEdge(this.val$N, o));
                }
            });
        }

        public int getSuccNodeCount(T N) {
            return Iterator2Collection.toSet(this.getSuccNodes(N)).size();
        }

        public IntSet getSuccNodeNumbers(T N) {
            MutableIntSet bits = IntSetUtil.make();
            Iterator<T> EE = this.getSuccNodes(N);
            while (EE.hasNext()) {
                bits.add(((IBasicBlock)EE.next()).getNumber());
            }
            return bits;
        }

        public Iterator<T> getPredNodes(T N) {
            return new FilterIterator(this.cfg.getPredNodes(N), new Predicate<T>((IBasicBlock)N){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                public boolean test(T o) {
                    return currentCFGNodes.containsNode(o) && (filter.hasNormalEdge(o, this.val$N) || filter.hasExceptionalEdge(o, this.val$N));
                }
            });
        }

        public int getPredNodeCount(T N) {
            return Iterator2Collection.toSet(this.getPredNodes(N)).size();
        }

        public IntSet getPredNodeNumbers(T N) {
            MutableIntSet bits = IntSetUtil.make();
            Iterator<T> EE = this.getPredNodes(N);
            while (EE.hasNext()) {
                bits.add(((IBasicBlock)EE.next()).getNumber());
            }
            return bits;
        }

        public boolean hasEdge(T src, T dst) {
            Iterator<T> EE = this.getSuccNodes(src);
            while (EE.hasNext()) {
                if (!EE.next().equals(dst)) continue;
                return true;
            }
            return false;
        }

        public void addEdge(T src, T dst) {
            throw new UnsupportedOperationException();
        }

        public void removeEdge(T src, T dst) {
            throw new UnsupportedOperationException();
        }

        public void removeAllIncidentEdges(T node) {
            throw new UnsupportedOperationException();
        }

        public void removeIncomingEdges(T node) {
            throw new UnsupportedOperationException();
        }

        public void removeOutgoingEdges(T node) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FilteredNodes<T extends IBasicBlock>
    implements NumberedNodeManager<T> {
        private final NumberedNodeManager<T> nodes;
        private final Set subset;

        FilteredNodes(NumberedNodeManager<T> nodes, Set subset) {
            this.nodes = nodes;
            this.subset = subset;
        }

        public int getNumber(T N) {
            if (this.subset.contains(N)) {
                return this.nodes.getNumber(N);
            }
            return -1;
        }

        public T getNode(int number) {
            IBasicBlock N = (IBasicBlock)this.nodes.getNode(number);
            if (this.subset.contains(N)) {
                return (T)N;
            }
            throw new NoSuchElementException();
        }

        public int getMaxNumber() {
            int max = -1;
            for (IBasicBlock N : this.nodes) {
                if (!this.subset.contains(N) || this.getNumber((T)N) <= max) continue;
                max = this.getNumber((T)N);
            }
            return max;
        }

        private Iterator<T> filterNodes(Iterator nodeIterator) {
            return new FilterIterator(nodeIterator, new Predicate(){

                public boolean test(Object o) {
                    return subset.contains(o);
                }
            });
        }

        public Iterator<T> iterateNodes(IntSet s) {
            return this.filterNodes(this.nodes.iterateNodes(s));
        }

        public Iterator<T> iterator() {
            return this.filterNodes(this.nodes.iterator());
        }

        public int getNumberOfNodes() {
            return this.subset.size();
        }

        public void addNode(T n) {
            throw new UnsupportedOperationException();
        }

        public void removeNode(T n) {
            throw new UnsupportedOperationException();
        }

        public boolean containsNode(T N) {
            return this.subset.contains(N);
        }
    }
}

