/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.SelectiveCPAContext;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;

public class CPAContextSelector
implements ContextSelector {
    private final ContextSelector base;

    public CPAContextSelector(ContextSelector base) {
        this.base = base;
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
        Context target = this.base.getCalleeTarget(caller, site, callee, actualParameters);
        if (actualParameters != null && actualParameters.length > 0) {
            return new CPAContext(target, actualParameters);
        }
        return target;
    }

    private static boolean dispatchIndex(CallSiteReference ref, int i) {
        if (ref.isStatic()) {
            return !ref.getDeclaredTarget().getParameterType(i).isPrimitiveType();
        }
        return i == 0 || !ref.getDeclaredTarget().getParameterType(i - 1).isPrimitiveType();
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        MutableIntSet s = IntSetUtil.make();
        int i = 0;
        while (i < caller.getIR().getCalls(site)[0].getNumberOfUses()) {
            if (!caller.getMethod().getDeclaringClass().getClassLoader().getLanguage().methodsHaveDeclaredParameterTypes() || CPAContextSelector.dispatchIndex(site, i)) {
                s.add(i);
            }
            ++i;
        }
        return s;
    }

    public static class CPAContext
    extends SelectiveCPAContext {
        public CPAContext(Context base, InstanceKey[] x) {
            super(base, x);
        }
    }
}

