/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyClassTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXContainerCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.cfa.nCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.BasicRTABuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.BypassClassTargetSelector;
import com.ibm.wala.ipa.summaries.BypassMethodTargetSelector;
import com.ibm.wala.ipa.summaries.LambdaMethodTargetSelector;
import com.ibm.wala.ipa.summaries.XMLMethodSummaryReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.strings.Atom;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Util {
    public static String nativeSpec = "natives.xml";

    public static void setNativeSpec(String xmlFile) {
        nativeSpec = xmlFile;
    }

    public static String getNativeSpec() {
        return nativeSpec;
    }

    public static void addDefaultSelectors(AnalysisOptions options, IClassHierarchy cha) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        options.setSelector(new LambdaMethodTargetSelector(new ClassHierarchyMethodTargetSelector(cha)));
        options.setSelector(new ClassHierarchyClassTargetSelector(cha));
    }

    public static void addBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, String xmlFile, IClassHierarchy cha) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha cannot be null");
        }
        InputStream s = cl.getResourceAsStream(xmlFile);
        XMLMethodSummaryReader summary = new XMLMethodSummaryReader(s, scope);
        Util.addBypassLogic(options, scope, cl, summary, cha);
    }

    public static void addBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, XMLMethodSummaryReader summary, IClassHierarchy cha) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha cannot be null");
        }
        BypassMethodTargetSelector ms = new BypassMethodTargetSelector(options.getMethodTargetSelector(), summary.getSummaries(), summary.getIgnoredPackages(), cha);
        options.setSelector(ms);
        BypassClassTargetSelector cs = new BypassClassTargetSelector(options.getClassTargetSelector(), summary.getAllocatableClasses(), cha, cha.getLoader(scope.getLoader(Atom.findOrCreateUnicodeAtom("Synthetic"))));
        options.setSelector(cs);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        return Util.makeMainEntrypoints(scope.getApplicationLoader(), cha);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(ClassLoaderReference clr, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
        final HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            MethodReference mainRef;
            IMethod m;
            if (!klass.getClassLoader().getReference().equals(clr) || (m = klass.getMethod((mainRef = MethodReference.findOrCreate(klass.getReference(), mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"))).getSelector())) == null) continue;
            result.add(new DefaultEntrypoint(m, cha));
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return result.iterator();
            }
        };
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha, String className) {
        return Util.makeMainEntrypoints(scope, cha, new String[]{className});
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope scope, IClassHierarchy cha, String[] classNames) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        return Util.makeMainEntrypoints(scope.getApplicationLoader(), cha, classNames);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(final ClassLoaderReference loaderRef, final IClassHierarchy cha, final String[] classNames) throws IllegalArgumentException, IllegalArgumentException, IllegalArgumentException {
        if (classNames == null) {
            throw new IllegalArgumentException("classNames == null");
        }
        if (classNames.length == 0) {
            throw new IllegalArgumentException("classNames.length == 0");
        }
        if (classNames[0] == null && classNames.length > 0) {
            throw new IllegalArgumentException("(0 < classNames.length) and (classNames[0] == null)");
        }
        int i = 0;
        while (i < classNames.length) {
            if (classNames[i].indexOf("L") != 0) {
                throw new IllegalArgumentException("Expected class name to start with L " + classNames[i]);
            }
            if (classNames[i].indexOf(".") > 0) {
                Assertions.productionAssertion((boolean)false, (String)("Expected class name formatted with /, not . " + classNames[i]));
            }
            ++i;
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                final Atom mainMethod = Atom.findOrCreateAsciiAtom("main");
                return new Iterator<Entrypoint>(){
                    private int index = 0;

                    @Override
                    public void remove() {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < classNames.length;
                    }

                    @Override
                    public Entrypoint next() {
                        TypeReference T = TypeReference.findOrCreate(loaderRef, TypeName.string2TypeName(classNames[this.index++]));
                        MethodReference mainRef = MethodReference.findOrCreate(T, mainMethod, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"));
                        return new DefaultEntrypoint(mainRef, cha);
                    }
                };
            }
        };
    }

    public static <T> Set<T> setify(Iterator<? extends T> x) {
        if (x == null) {
            throw new IllegalArgumentException("Null x");
        }
        HashSet y = HashSetFactory.make();
        while (x.hasNext()) {
            y.add(x.next());
        }
        return y;
    }

    public static <T> void checkGraphSubset(Graph<T> supG, Graph<T> subG) {
        if (supG == null) {
            throw new IllegalArgumentException("supG is null");
        }
        if (subG == null) {
            throw new IllegalArgumentException("subG is null");
        }
        Set<T> nodeDiff = Util.setify(subG.iterator());
        nodeDiff.removeAll(Util.setify(supG.iterator()));
        if (!nodeDiff.isEmpty()) {
            System.err.println("supergraph: ");
            System.err.println(supG.toString());
            System.err.println("subgraph: ");
            System.err.println(subG.toString());
            System.err.println("nodeDiff: ");
            Iterator<T> it = nodeDiff.iterator();
            while (it.hasNext()) {
                System.err.println(it.next().toString());
            }
            Assertions.productionAssertion((boolean)nodeDiff.isEmpty(), (String)"bad superset, see tracefile\n");
        }
        for (Object m : subG) {
            Set<T> succDiff = Util.setify(subG.getSuccNodes(m));
            succDiff.removeAll(Util.setify(supG.getSuccNodes(m)));
            if (!succDiff.isEmpty()) {
                Assertions.productionAssertion((boolean)succDiff.isEmpty(), (String)("bad superset for successors of " + m + ":" + succDiff));
            }
            Set<T> predDiff = Util.setify(subG.getPredNodes(m));
            predDiff.removeAll(Util.setify(supG.getPredNodes(m)));
            if (predDiff.isEmpty()) continue;
            System.err.println("supergraph: ");
            System.err.println(supG.toString());
            System.err.println("subgraph: ");
            System.err.println(subG.toString());
            System.err.println("predDiff: ");
            Iterator<T> it = predDiff.iterator();
            while (it.hasNext()) {
                System.err.println(it.next().toString());
            }
            Assertions.UNREACHABLE((String)("bad superset for predecessors of " + m + ":" + predDiff));
        }
    }

    public static CallGraphBuilder makeRTABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return new BasicRTABuilder(cha, options, cache, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(cha, options, cache, customSelector, customInterpreter, 0);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroOneCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(cha, options, cache, customSelector, customInterpreter, 33);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeVanillaZeroOneCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector customSelector, SSAContextInterpreter customInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return ZeroXCFABuilder.make(cha, options, cache, customSelector, customInterpreter, 31);
    }

    public static SSAPropagationCallGraphBuilder makeZeroContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, 0);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope) {
        return Util.makeZeroOneContainerCFABuilder(options, cache, cha, scope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, AnalysisScope scope, ContextSelector appSelector, SSAContextInterpreter appInterpreter) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, 31);
    }

    public static SSAPropagationCallGraphBuilder makeNCFABuilder(int n, AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nCFABuilder result = new nCFABuilder(n, cha, options, cache, appSelector, appInterpreter);
        result.setInstanceKeys(new ZeroXInstanceKeys(options, cha, result.getContextInterpreter(), 31));
        return result;
    }

    public static SSAPropagationCallGraphBuilder makeVanillaNCFABuilder(int n, AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nCFABuilder result = new nCFABuilder(n, cha, options, cache, appSelector, appInterpreter);
        result.setInstanceKeys(new ZeroXInstanceKeys(options, cha, result.getContextInterpreter(), 33));
        return result;
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneContainerCFABuilder(AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(options, cha);
        Util.addDefaultBypassLogic(options, scope, Util.class.getClassLoader(), cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        options.setUseConstantSpecificKeys(true);
        return new ZeroXContainerCFABuilder(cha, options, cache, appSelector, appInterpreter, 1);
    }

    public static void addDefaultBypassLogic(AnalysisOptions options, AnalysisScope scope, ClassLoader cl, IClassHierarchy cha) {
        if (nativeSpec == null) {
            return;
        }
        if (cl.getResourceAsStream(nativeSpec) != null) {
            Util.addBypassLogic(options, scope, cl, nativeSpec, cha);
        } else {
            try {
                BufferedInputStream bIn = new BufferedInputStream(new FileInputStream(nativeSpec));
                XMLMethodSummaryReader reader = new XMLMethodSummaryReader(bIn, scope);
                Util.addBypassLogic(options, scope, cl, reader, cha);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not load natives xml file from: " + nativeSpec);
                e.printStackTrace();
            }
        }
    }
}

