/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootClass;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractRootMethod
extends SyntheticMethod {
    protected final ArrayList<SSAInstruction> statements = new ArrayList();
    private Map<ConstantValue, Integer> constant2ValueNumber = HashMapFactory.make();
    protected int nextLocal = 2;
    protected final IClassHierarchy cha;
    private final AnalysisOptions options;
    protected final IAnalysisCacheView cache;
    protected final SSAInstructionFactory insts;

    public AbstractRootMethod(MethodReference method, IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        super(method, declaringClass, true, false);
        this.cha = cha;
        this.options = options;
        this.cache = cache;
        this.insts = declaringClass.getClassLoader().getInstructionFactory();
        if (cache == null) {
            throw new IllegalArgumentException("null cache");
        }
        if (declaringClass instanceof FakeRootClass) {
            ((FakeRootClass)declaringClass).addMethod(this);
        }
    }

    public AbstractRootMethod(MethodReference method, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        this(method, new FakeRootClass(cha), cha, options, cache);
    }

    @Override
    public SSAInstruction[] getStatements(SSAOptions options) {
        SSAInstruction[] result = new SSAInstruction[this.statements.size()];
        int i = 0;
        Iterator<SSAInstruction> it = this.statements.iterator();
        while (it.hasNext()) {
            result[i++] = it.next();
        }
        return result;
    }

    @Override
    public IR makeIR(Context context, SSAOptions options) {
        SSAInstruction[] instrs = this.getStatements(options);
        HashMap constants = null;
        if (!this.constant2ValueNumber.isEmpty()) {
            constants = HashMapFactory.make((int)this.constant2ValueNumber.size());
            for (ConstantValue c : this.constant2ValueNumber.keySet()) {
                int vn = this.constant2ValueNumber.get(c);
                constants.put(vn, c);
            }
        }
        InducedCFG cfg = this.makeControlFlowGraph(instrs);
        return new SyntheticIR(this, Everywhere.EVERYWHERE, cfg, instrs, options, constants);
    }

    public int addLocal() {
        return this.nextLocal++;
    }

    public SSAInvokeInstruction addInvocation(int[] params, CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        CallSiteReference newSite = CallSiteReference.make(this.statements.size(), site.getDeclaredTarget(), site.getInvocationCode());
        SSAInvokeInstruction s = null;
        s = newSite.getDeclaredTarget().getReturnType().equals(TypeReference.Void) ? this.insts.InvokeInstruction(this.statements.size(), params, this.nextLocal++, newSite, null) : this.insts.InvokeInstruction(this.statements.size(), this.nextLocal++, params, this.nextLocal++, newSite, null);
        this.statements.add(s);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return s;
    }

    public SSAReturnInstruction addReturn(int vn, boolean isPrimitive) {
        SSAReturnInstruction s = this.insts.ReturnInstruction(this.statements.size(), vn, isPrimitive);
        this.statements.add(s);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return s;
    }

    public SSANewInstruction addAllocation(TypeReference T) {
        return this.addAllocation(T, true);
    }

    public SSANewInstruction add1DArrayAllocation(TypeReference T, int length) {
        int instance = this.nextLocal++;
        NewSiteReference ref = NewSiteReference.make(this.statements.size(), T);
        assert (T.isArrayType());
        assert (((ArrayClass)this.cha.lookupClass(T)).getDimensionality() == 1);
        int[] sizes = new int[1];
        Arrays.fill(sizes, this.getValueNumberForIntConstant(length));
        SSANewInstruction result = this.insts.NewInstruction(this.statements.size(), instance, ref, sizes);
        this.statements.add(result);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return result;
    }

    public SSANewInstruction addAllocationWithoutCtor(TypeReference T) {
        return this.addAllocation(T, false);
    }

    private SSANewInstruction addAllocation(TypeReference T, boolean invokeCtor) {
        if (T == null) {
            throw new IllegalArgumentException("T is null");
        }
        int instance = this.nextLocal++;
        SSANewInstruction result = null;
        if (T.isReferenceType()) {
            IMethod ctor;
            NewSiteReference ref = NewSiteReference.make(this.statements.size(), T);
            if (T.isArrayType()) {
                int[] sizes = new int[ArrayClass.getArrayTypeDimensionality(T)];
                Arrays.fill(sizes, this.getValueNumberForIntConstant(1));
                result = this.insts.NewInstruction(this.statements.size(), instance, ref, sizes);
            } else {
                result = this.insts.NewInstruction(this.statements.size(), instance, ref);
            }
            this.statements.add(result);
            IClass klass = this.cha.lookupClass(T);
            if (klass == null) {
                Warnings.add(AllocationFailure.create(T));
                return null;
            }
            if (klass.isArrayClass()) {
                int arrayRef = result.getDef();
                TypeReference e = klass.getReference().getArrayElementType();
                while (e != null && !e.isPrimitiveType()) {
                    int alloc;
                    NewSiteReference n = NewSiteReference.make(this.statements.size(), e);
                    ++this.nextLocal;
                    SSANewInstruction ni = null;
                    if (e.isArrayType()) {
                        int[] sizes = new int[((ArrayClass)this.cha.lookupClass(T)).getDimensionality()];
                        Arrays.fill(sizes, this.getValueNumberForIntConstant(1));
                        ni = this.insts.NewInstruction(this.statements.size(), alloc, n, sizes);
                    } else {
                        ni = this.insts.NewInstruction(this.statements.size(), alloc, n);
                    }
                    this.statements.add(ni);
                    SSAArrayStoreInstruction store = this.insts.ArrayStoreInstruction(this.statements.size(), arrayRef, this.getValueNumberForIntConstant(0), alloc, e);
                    this.statements.add(store);
                    e = e.isArrayType() ? e.getArrayElementType() : null;
                    arrayRef = alloc;
                }
            }
            if (invokeCtor && (ctor = this.cha.resolveMethod(klass, MethodReference.initSelector)) != null) {
                this.addInvocation(new int[]{instance}, CallSiteReference.make(this.statements.size(), ctor.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL));
            }
        }
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return result;
    }

    public int getValueNumberForIntConstant(int c) {
        ConstantValue v = new ConstantValue(c);
        Integer result = this.constant2ValueNumber.get(v);
        if (result == null) {
            result = this.nextLocal++;
            this.constant2ValueNumber.put(v, result);
        }
        return result;
    }

    public int getValueNumberForByteConstant(byte c) {
        ConstantValue v = new ConstantValue(c);
        Integer result = this.constant2ValueNumber.get(v);
        if (result == null) {
            result = this.nextLocal++;
            this.constant2ValueNumber.put(v, result);
        }
        return result;
    }

    public int getValueNumberForCharConstant(char c) {
        ConstantValue v = new ConstantValue(c);
        Integer result = this.constant2ValueNumber.get(v);
        if (result == null) {
            result = this.nextLocal++;
            this.constant2ValueNumber.put(v, result);
        }
        return result;
    }

    public int addPhi(int[] values) {
        int result = this.nextLocal++;
        SSAPhiInstruction phi = this.insts.PhiInstruction(this.statements.size(), result, values);
        this.statements.add(phi);
        return result;
    }

    public int addGetInstance(FieldReference ref, int object) {
        int result = this.nextLocal++;
        this.statements.add(this.insts.GetInstruction(this.statements.size(), result, object, ref));
        return result;
    }

    public int addGetStatic(FieldReference ref) {
        int result = this.nextLocal++;
        this.statements.add(this.insts.GetInstruction(this.statements.size(), result, ref));
        return result;
    }

    public int addCheckcast(TypeReference[] types, int rv, boolean isPEI) {
        int lv = this.nextLocal++;
        this.statements.add(this.insts.CheckCastInstruction(this.statements.size(), lv, rv, types, isPEI));
        return lv;
    }

    public void addSetInstance(FieldReference ref, int baseObject, int value) {
        this.statements.add(this.insts.PutInstruction(this.statements.size(), baseObject, value, ref));
    }

    public void addSetStatic(FieldReference ref, int value) {
        this.statements.add(this.insts.PutInstruction(this.statements.size(), value, ref));
    }

    public void addSetArrayField(TypeReference elementType, int baseObject, int indexValue, int value) {
        this.statements.add(this.insts.ArrayStoreInstruction(this.statements.size(), baseObject, indexValue, value, elementType));
    }

    public int addGetArrayField(TypeReference elementType, int baseObject, int indexValue) {
        int result = this.nextLocal++;
        this.statements.add(this.insts.ArrayLoadInstruction(this.statements.size(), result, baseObject, indexValue, elementType));
        return result;
    }

    public RTAContextInterpreter getInterpreter() {
        return new RTAContextInterpreter(){

            @Override
            public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
                ArrayList<NewSiteReference> result = new ArrayList<NewSiteReference>();
                SSAInstruction[] statements = AbstractRootMethod.this.getStatements(AbstractRootMethod.this.options.getSSAOptions());
                int i = 0;
                while (i < statements.length) {
                    if (statements[i] instanceof SSANewInstruction) {
                        SSANewInstruction s = (SSANewInstruction)statements[i];
                        result.add(s.getNewSite());
                    }
                    ++i;
                }
                return result.iterator();
            }

            public Iterator<SSAInstruction> getInvokeStatements() {
                ArrayList<SSAInstruction> result = new ArrayList<SSAInstruction>();
                SSAInstruction[] statements = AbstractRootMethod.this.getStatements(AbstractRootMethod.this.options.getSSAOptions());
                int i = 0;
                while (i < statements.length) {
                    if (statements[i] instanceof SSAInvokeInstruction) {
                        result.add(statements[i]);
                    }
                    ++i;
                }
                return result.iterator();
            }

            @Override
            public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
                final Iterator<SSAInstruction> I = this.getInvokeStatements();
                return new Iterator<CallSiteReference>(){

                    @Override
                    public boolean hasNext() {
                        return I.hasNext();
                    }

                    @Override
                    public CallSiteReference next() {
                        SSAInvokeInstruction s = (SSAInvokeInstruction)I.next();
                        return s.getCallSite();
                    }

                    @Override
                    public void remove() {
                        Assertions.UNREACHABLE();
                    }
                };
            }

            @Override
            public boolean understands(CGNode node) {
                return node.getMethod().getDeclaringClass().getReference().equals(FakeRootClass.FAKE_ROOT_CLASS);
            }

            @Override
            public boolean recordFactoryType(CGNode node, IClass klass) {
                return false;
            }

            @Override
            public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
                return EmptyIterator.instance();
            }

            @Override
            public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
                return EmptyIterator.instance();
            }
        };
    }

    private static class AllocationFailure
    extends Warning {
        final TypeReference t;

        AllocationFailure(TypeReference t) {
            super((byte)2);
            this.t = t;
        }

        @Override
        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.t;
        }

        public static AllocationFailure create(TypeReference t) {
            return new AllocationFailure(t);
        }
    }
}

