/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.cha;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.cha.CHAContextInterpreter;
import com.ibm.wala.ipa.callgraph.cha.ContextInsensitiveCHAContextInterpreter;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CHACallGraph
extends BasicCallGraph<CHAContextInterpreter> {
    private final IClassHierarchy cha;
    private final AnalysisOptions options;
    private final IAnalysisCacheView cache;
    private boolean isInitialized = false;
    private int clinitPC = 0;
    private Stack<CGNode> newNodes = new Stack();

    public CHACallGraph(IClassHierarchy cha) {
        this.cha = cha;
        this.options = new AnalysisOptions();
        this.cache = new AnalysisCacheImpl();
        this.setInterpreter(new ContextInsensitiveCHAContextInterpreter());
    }

    public void init(Iterable<Entrypoint> entrypoints) throws CancelException {
        super.init();
        CGNode root = this.getFakeRootNode();
        int programCounter = 0;
        for (Entrypoint e : entrypoints) {
            root.addTarget(e.makeSite(programCounter++), null);
        }
        this.newNodes.push(root);
        this.closure();
        this.isInitialized = true;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private Iterator<IMethod> getPossibleTargets(CallSiteReference site) {
        if (site.isDispatch()) {
            return this.cha.getPossibleTargets(site.getDeclaredTarget()).iterator();
        }
        IMethod m = this.cha.resolveMethod(site.getDeclaredTarget());
        if (m != null) {
            return new NonNullSingletonIterator((Object)m);
        }
        return EmptyIterator.instance();
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        return Iterator2Collection.toSet((Iterator)new MapIterator((Iterator)new FilterIterator(this.getPossibleTargets(site), (Predicate)new Predicate<IMethod>(){

            public boolean test(IMethod o) {
                return !o.isAbstract();
            }
        }), (Function)new Function<IMethod, CGNode>(){

            public CGNode apply(IMethod object) {
                try {
                    return CHACallGraph.this.findOrCreateNode(object, Everywhere.EVERYWHERE);
                }
                catch (CancelException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)e.toString());
                    }
                    return null;
                }
            }
        }));
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        return IteratorUtil.count(this.getPossibleTargets(site));
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(final CGNode src, final CGNode target) {
        return new FilterIterator(((CHAContextInterpreter)this.getInterpreter(src)).iterateCallSites(src), (Predicate)new Predicate<CallSiteReference>(){

            public boolean test(CallSiteReference o) {
                return CHACallGraph.this.getPossibleTargets(src, o).contains(target);
            }
        });
    }

    @Override
    protected CGNode makeFakeRootNode() throws CancelException {
        return new CHARootNode((IMethod)new FakeRootMethod(this.cha, this.options, this.cache), (Context)Everywhere.EVERYWHERE);
    }

    @Override
    protected CGNode makeFakeWorldClinitNode() throws CancelException {
        return new CHARootNode((IMethod)new FakeWorldClinitMethod(this.cha, this.options, this.cache), (Context)Everywhere.EVERYWHERE);
    }

    @Override
    public CGNode findOrCreateNode(IMethod method, Context C) throws CancelException {
        assert (C.equals(Everywhere.EVERYWHERE));
        assert (!method.isAbstract());
        CGNode n = this.getNode(method, C);
        if (n == null) {
            assert (!this.isInitialized);
            n = this.makeNewNode(method, C);
            IMethod clinit = method.getDeclaringClass().getClassInitializer();
            if (clinit != null && this.getNode(clinit, Everywhere.EVERYWHERE) == null) {
                CGNode cln = this.makeNewNode(clinit, Everywhere.EVERYWHERE);
                CGNode clinits = this.getFakeWorldClinitNode();
                clinits.addTarget(CallSiteReference.make(this.clinitPC++, clinit.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC), cln);
            }
        }
        return n;
    }

    private void closure() throws CancelException {
        while (!this.newNodes.isEmpty()) {
            CGNode n = this.newNodes.pop();
            Iterator<CallSiteReference> sites = n.iterateCallSites();
            while (sites.hasNext()) {
                Iterator<IMethod> methods = this.getPossibleTargets(sites.next());
                while (methods.hasNext()) {
                    CGNode callee;
                    IMethod target = methods.next();
                    if (target.isAbstract() || (callee = this.getNode(target, Everywhere.EVERYWHERE)) != null) continue;
                    callee = this.findOrCreateNode(target, Everywhere.EVERYWHERE);
                    if (n != this.getFakeRootNode()) continue;
                    this.registerEntrypoint(callee);
                }
            }
        }
    }

    private CGNode makeNewNode(IMethod method, Context C) throws CancelException {
        BasicCallGraph.Key k = new BasicCallGraph.Key(method, C);
        CHANode n = new CHANode(method, C);
        this.registerNode(k, n);
        this.newNodes.push(n);
        return n;
    }

    protected NumberedEdgeManager<CGNode> getEdgeManager() {
        return new NumberedEdgeManager<CGNode>(){
            private final Map<CGNode, SoftReference<Set<CGNode>>> predecessors = HashMapFactory.make();

            private Set<CGNode> getPreds(CGNode n) {
                if (this.predecessors.containsKey(n) && this.predecessors.get(n).get() != null) {
                    return this.predecessors.get(n).get();
                }
                HashSet preds = HashSetFactory.make();
                Iterator<CGNode> iterator = CHACallGraph.this.iterator();
                while (iterator.hasNext()) {
                    CGNode node = iterator.next();
                    if (!CHACallGraph.this.getPossibleSites(node, n).hasNext()) continue;
                    preds.add(node);
                }
                this.predecessors.put(n, new SoftReference<HashSet>(preds));
                return preds;
            }

            public Iterator<CGNode> getPredNodes(CGNode n) {
                return this.getPreds(n).iterator();
            }

            public int getPredNodeCount(CGNode n) {
                return this.getPreds(n).size();
            }

            public Iterator<CGNode> getSuccNodes(final CGNode n) {
                return new FilterIterator((Iterator)new ComposedIterator<CallSiteReference, CGNode>(n.iterateCallSites()){

                    public Iterator<? extends CGNode> makeInner(CallSiteReference outer) {
                        return CHACallGraph.this.getPossibleTargets(n, outer).iterator();
                    }
                }, (Predicate)new Predicate<CGNode>(){
                    private final MutableIntSet nodes = IntSetUtil.make();

                    public boolean test(CGNode o) {
                        if (this.nodes.contains(o.getGraphNodeId())) {
                            return false;
                        }
                        this.nodes.add(o.getGraphNodeId());
                        return true;
                    }
                });
            }

            public int getSuccNodeCount(CGNode N) {
                return IteratorUtil.count(this.getSuccNodes(N));
            }

            public void addEdge(CGNode src, CGNode dst) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public void removeEdge(CGNode src, CGNode dst) throws UnsupportedOperationException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public void removeAllIncidentEdges(CGNode node) throws UnsupportedOperationException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public void removeIncomingEdges(CGNode node) throws UnsupportedOperationException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public void removeOutgoingEdges(CGNode node) throws UnsupportedOperationException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public boolean hasEdge(CGNode src, CGNode dst) {
                return CHACallGraph.this.getPossibleSites(src, dst).hasNext();
            }

            public IntSet getSuccNodeNumbers(CGNode node) {
                MutableIntSet result = IntSetUtil.make();
                Iterator<CGNode> ss = this.getSuccNodes(node);
                while (ss.hasNext()) {
                    result.add(ss.next().getGraphNodeId());
                }
                return result;
            }

            public IntSet getPredNodeNumbers(CGNode node) {
                MutableIntSet result = IntSetUtil.make();
                Iterator<CGNode> ss = this.getPredNodes(node);
                while (ss.hasNext()) {
                    result.add(ss.next().getGraphNodeId());
                }
                return result;
            }
        };
    }

    private class CHANode
    extends BasicCallGraph.NodeImpl {
        protected CHANode(IMethod method, Context C) {
            super(CHACallGraph.this, method, C);
        }

        @Override
        public IR getIR() {
            assert (false);
            return null;
        }

        @Override
        public DefUse getDU() {
            assert (false);
            return null;
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites() {
            assert (false);
            return null;
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return ((CHAContextInterpreter)CHACallGraph.this.getInterpreter(this)).iterateCallSites(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass() && this.getMethod().equals(((CHANode)obj).getMethod());
        }

        @Override
        public int hashCode() {
            return this.getMethod().hashCode();
        }

        @Override
        public boolean addTarget(CallSiteReference reference, CGNode target) {
            return false;
        }
    }

    private class CHARootNode
    extends CHANode {
        private final Set<CallSiteReference> calls;

        protected CHARootNode(IMethod method, Context C) {
            super(method, C);
            this.calls = HashSetFactory.make();
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return this.calls.iterator();
        }

        @Override
        public boolean addTarget(CallSiteReference reference, CGNode target) {
            return this.calls.add(reference);
        }
    }
}

