/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AbstractDemandFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.PointerParamValueNumIterator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DemandPointerFlowGraph
extends AbstractDemandFlowGraph
implements IFlowGraph {
    public DemandPointerFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap mam, IClassHierarchy cha) {
        super(cg, heapModel, mam, cha);
    }

    @Override
    protected void addNodesForParameters(CGNode node, IR ir) {
        PointerParamValueNumIterator iter = new PointerParamValueNumIterator(node);
        while (iter.hasNext()) {
            int parameter = (Integer)iter.next();
            PointerKey paramPk = this.heapModel.getPointerKeyForLocal(node, parameter);
            this.addNode(paramPk);
            this.params.put(paramPk, node);
        }
        PointerKey returnKey = this.heapModel.getPointerKeyForReturnValue(node);
        this.addNode(returnKey);
        this.returns.put(returnKey, node);
        PointerKey exceptionReturnKey = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        this.addNode(exceptionReturnKey);
        this.returns.put(exceptionReturnKey, node);
    }

    @Override
    protected AbstractDemandFlowGraph.FlowStatementVisitor makeVisitor(CGNode node) {
        return new StatementVisitor(this.heapModel, this, this.cha, this.cg, node);
    }

    public static NewMultiDimInfo getInfoForNewMultiDim(SSANewInstruction instruction, HeapModel heapModel, CGNode node) {
        if (heapModel == null) {
            throw new IllegalArgumentException("null heapModel");
        }
        HashSet newInstrs = HashSetFactory.make();
        HashSet arrStoreInstrs = HashSetFactory.make();
        InstanceKey iKey = heapModel.getInstanceKeyForAllocation(node, instruction.getNewSite());
        if (iKey == null) {
            return null;
        }
        IClass klass = iKey.getConcreteType();
        if (!klass.isArrayClass() || ((ArrayClass)klass).getElementClass() == null || !((ArrayClass)klass).getElementClass().isArrayClass()) {
            return null;
        }
        PointerKey def = heapModel.getPointerKeyForLocal(node, instruction.getDef());
        int dim = 0;
        InstanceKey lastInstance = iKey;
        PointerKey lastVar = def;
        while (klass != null && klass.isArrayClass()) {
            if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
            InstanceKey ik = heapModel.getInstanceKeyForMultiNewArray(node, instruction.getNewSite(), dim);
            PointerKey pk = heapModel.getPointerKeyForArrayContents(lastInstance);
            newInstrs.add(Pair.make((Object)pk, (Object)ik));
            arrStoreInstrs.add(Pair.make((Object)lastVar, (Object)pk));
            lastInstance = ik;
            lastVar = pk;
            ++dim;
        }
        return new NewMultiDimInfo(newInstrs, arrStoreInstrs);
    }

    public static class NewMultiDimInfo {
        public final Collection<Pair<PointerKey, InstanceKey>> newInstrs;
        public final Collection<Pair<PointerKey, PointerKey>> arrStoreInstrs;

        public NewMultiDimInfo(Collection<Pair<PointerKey, InstanceKey>> newInstrs, Collection<Pair<PointerKey, PointerKey>> arrStoreInstrs) {
            this.newInstrs = newInstrs;
            this.arrStoreInstrs = arrStoreInstrs;
        }
    }

    public static class StatementVisitor
    extends SSAInstruction.Visitor
    implements AbstractDemandFlowGraph.FlowStatementVisitor {
        private final HeapModel heapModel;
        private final IFlowGraph g;
        private final IClassHierarchy cha;
        private final CallGraph cg;
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public StatementVisitor(HeapModel heapModel, IFlowGraph g, IClassHierarchy cha, CallGraph cg, CGNode node) {
            this.heapModel = heapModel;
            this.g = g;
            this.cha = cha;
            this.cg = cg;
            this.node = node;
            this.ir = node.getIR();
            this.du = node.getDU();
            this.symbolTable = this.ir.getSymbolTable();
            assert (this.symbolTable != null);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey result = this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey arrayRef = this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            this.g.addNode(result);
            this.g.addNode(arrayRef);
            this.g.addEdge(result, arrayRef, GetFieldLabel.make(ArrayContents.v()));
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey value = this.heapModel.getPointerKeyForLocal(this.node, instruction.getValue());
            PointerKey arrayRef = this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            this.g.addNode(value);
            this.g.addNode(arrayRef);
            this.g.addEdge(arrayRef, value, PutFieldLabel.make(ArrayContents.v()));
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            HashSet types = HashSetFactory.make();
            TypeReference[] typeReferenceArray = instruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference t = typeReferenceArray[n2];
                IClass cls = this.cha.lookupClass(t);
                if (cls == null) {
                    return;
                }
                types.add(cls);
                ++n2;
            }
            FilteredPointerKey.MultipleClassesFilter filter = new FilteredPointerKey.MultipleClassesFilter(types.toArray(new IClass[types.size()]));
            PointerKey result = this.heapModel.getPointerKeyForLocal(this.node, instruction.getResult());
            PointerKey value = this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            this.g.addNode(result);
            this.g.addNode(value);
            this.g.addEdge(result, value, AssignLabel.make(filter));
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsPrimitiveType() || instruction.returnsVoid()) {
                return;
            }
            PointerKey def = this.heapModel.getPointerKeyForLocal(this.node, instruction.getResult());
            this.g.addNode(def);
            PointerKey returnValue = this.heapModel.getPointerKeyForReturnValue(this.node);
            this.g.addNode(returnValue);
            this.g.addEdge(returnValue, def, AssignLabel.noFilter());
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey def = this.heapModel.getPointerKeyForLocal(this.node, lval);
            assert (def != null);
            if (isStatic) {
                PointerKey fKey = this.heapModel.getPointerKeyForStaticField(f);
                this.g.addNode(def);
                this.g.addNode(fKey);
                this.g.addEdge(def, fKey, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = this.heapModel.getPointerKeyForLocal(this.node, ref);
                this.g.addNode(def);
                this.g.addNode(refKey);
                this.g.addEdge(def, refKey, GetFieldLabel.make(f));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey use = this.heapModel.getPointerKeyForLocal(this.node, rval);
            assert (use != null);
            if (isStatic) {
                PointerKey fKey = this.heapModel.getPointerKeyForStaticField(f);
                this.g.addNode(use);
                this.g.addNode(fKey);
                this.g.addEdge(fKey, use, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = this.heapModel.getPointerKeyForLocal(this.node, ref);
                this.g.addNode(use);
                this.g.addNode(refKey);
                this.g.addEdge(refKey, use, PutFieldLabel.make(f));
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = this.heapModel.getInstanceKeyForAllocation(this.node, instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            this.g.addNode(iKey);
            this.g.addNode(def);
            this.g.addEdge(def, iKey, NewLabel.v());
            NewMultiDimInfo multiDimInfo = DemandPointerFlowGraph.getInfoForNewMultiDim(instruction, this.heapModel, this.node);
            if (multiDimInfo != null) {
                for (Pair<PointerKey, InstanceKey> pair : multiDimInfo.newInstrs) {
                    this.g.addNode(pair.fst);
                    this.g.addNode(pair.snd);
                    this.g.addEdge(pair.fst, pair.snd, NewLabel.v());
                }
                for (Pair pair : multiDimInfo.arrStoreInstrs) {
                    this.g.addNode(pair.fst);
                    this.g.addNode(pair.snd);
                    this.g.addEdge(pair.fst, pair.snd, PutFieldLabel.make(ArrayContents.v()));
                }
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            Set<IClass> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            this.addExceptionDefConstraints(this.ir, this.node, peis, def, types);
        }

        protected void addExceptionDefConstraints(IR ir, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set<IClass> catchClasses) {
            for (ProgramCounter peiLoc : peis) {
                PointerKey e;
                SSAInstruction s;
                SSAInstruction pei = ir.getPEI(peiLoc);
                if (pei instanceof SSAAbstractInvokeInstruction) {
                    s = (SSAAbstractInvokeInstruction)pei;
                    e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                    this.g.addNode(exceptionVar);
                    this.g.addNode(e);
                    this.g.addEdge(exceptionVar, e, AssignLabel.noFilter());
                } else if (pei instanceof SSAAbstractThrowInstruction) {
                    s = (SSAAbstractThrowInstruction)pei;
                    e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                    this.g.addNode(exceptionVar);
                    this.g.addNode(e);
                    this.g.addEdge(exceptionVar, e, AssignLabel.noFilter());
                }
                Collection<TypeReference> types = pei.getExceptionTypes();
                if (types == null) continue;
                for (TypeReference type : types) {
                    InstanceKey ik;
                    if (type == null || (ik = this.heapModel.getInstanceKeyForPEI(node, peiLoc, type)) == null) continue;
                    assert (ik instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + ik;
                    ConcreteTypeKey ck = (ConcreteTypeKey)ik;
                    IClass klass = ck.getType();
                    if (!PropagationCallGraphBuilder.catches(catchClasses, klass, this.cha)) continue;
                    this.g.addNode(exceptionVar);
                    this.g.addNode(ik);
                    this.g.addEdge(exceptionVar, ik, NewLabel.v());
                }
            }
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            PointerKey def = this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey use = this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            this.g.addNode(def);
            this.g.addNode(use);
            this.g.addEdge(def, use, AssignLabel.noFilter());
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        @Override
        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            PointerKey def = this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            assert (instruction.getType() == TypeReference.JavaLangClass);
            InstanceKey iKey = this.heapModel.getInstanceKeyForMetadataObject(instruction.getToken(), (TypeReference)instruction.getToken());
            this.g.addNode(iKey);
            this.g.addNode(def);
            this.g.addEdge(def, iKey, NewLabel.v());
        }
    }
}

