/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseLongIntVector;
import com.ibm.wala.util.math.LongUtil;

public class LocalSummaryEdges {
    private final SparseVector<IBinaryNaturalRelation> summaries = new SparseVector(1, 1.1f);
    private static final int UNASSIGNED = -1;
    private final SparseLongIntVector entryExitMap = new SparseLongIntVector(-1);
    private int nextEntryExitIndex = 0;

    public void insertSummaryEdge(int s_p, int x, int d1, int d2) {
        int n = this.getIndexForEntryExitPair(s_p, x);
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.summaries.get(n);
        if (R == null) {
            R = new BasicNaturalRelation(new byte[]{2}, 0);
            this.summaries.set(n, (Object)R);
        }
        R.add(d1, d2);
    }

    public boolean contains(int s_p, int x, int d1, int d2) {
        int n = this.getIndexForEntryExitPair(s_p, x);
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.summaries.get(n);
        if (R == null) {
            return false;
        }
        return R.contains(d1, d2);
    }

    public IntSet getSummaryEdges(int s_p, int x, int d1) {
        int n = this.getIndexForEntryExitPair(s_p, x);
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.summaries.get(n);
        if (R == null) {
            return null;
        }
        return R.getRelated(d1);
    }

    public IntSet getInvertedSummaryEdgesForTarget(int s_p, int x, int d2) {
        int n = this.getIndexForEntryExitPair(s_p, x);
        IBinaryNaturalRelation R = (IBinaryNaturalRelation)this.summaries.get(n);
        if (R == null) {
            return null;
        }
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        for (IntPair p : R) {
            if (p.getY() != d2) continue;
            result.add(p.getX());
        }
        return result;
    }

    private int getIndexForEntryExitPair(int c, int r) {
        long id = LongUtil.pack((int)c, (int)r);
        int result = this.entryExitMap.get(id);
        if (result == -1) {
            result = this.nextEntryExitIndex++;
            this.entryExitMap.set(id, result);
        }
        return result;
    }
}

