/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.exc.intra.OperatorUtil;
import com.ibm.wala.cfg.exc.intra.ParameterState;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.fixpoint.AbstractVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Collection;

public class NullPointerState
extends AbstractVariable<NullPointerState> {
    private final State[] vars;

    NullPointerState(int maxVarNum, SymbolTable symbolTable, ParameterState parameterState) {
        this(maxVarNum, symbolTable, parameterState, State.UNKNOWN);
    }

    NullPointerState(int maxVarNum, SymbolTable symbolTable, ParameterState parameterState, State defaultState) {
        this.vars = new State[maxVarNum + 1];
        int i = 0;
        while (i < this.vars.length) {
            this.vars[i] = symbolTable.isConstant(i) ? (symbolTable.isNullConstant(i) ? State.NULL : State.NOT_NULL) : defaultState;
            ++i;
        }
        if (parameterState != null) {
            i = 0;
            while (i < parameterState.getStates().size()) {
                assert (parameterState.getState(i) != null);
                this.vars[i + 1] = parameterState.getState(i);
                assert (this.vars[i + 1] != null);
                ++i;
            }
        }
    }

    static AbstractMeetOperator<NullPointerState> meetOperator() {
        return StateMeet.INSTANCE;
    }

    static UnaryOperator<NullPointerState> phiValueMeetFunction(int varNum, int[] fromVars) {
        return new PhiValueMeet(varNum, fromVars);
    }

    static UnaryOperator<NullPointerState> nullifyFunction(int varNum) {
        return new NullifyFunction(varNum);
    }

    static UnaryOperator<NullPointerState> denullifyFunction(int varNum) {
        return new DenullifyFunction(varNum);
    }

    static UnaryOperator<NullPointerState> identityFunction() {
        return IndentityFunction.INSTANCE;
    }

    static UnaryOperator<NullPointerState> phisFunction(Collection<UnaryOperator<NullPointerState>> phiFunctions) {
        return new OperatorUtil.UnaryOperatorSequence<NullPointerState>(phiFunctions);
    }

    boolean isNeverNull(int varNum) {
        assert (varNum > 0 && varNum < this.vars.length);
        return this.vars[varNum] == State.NOT_NULL;
    }

    boolean isAlwaysNull(int varNum) {
        assert (varNum > 0 && varNum < this.vars.length);
        return this.vars[varNum] == State.NULL;
    }

    public void copyState(NullPointerState v) {
        assert (v.vars.length == this.vars.length);
        int i = 0;
        while (i < v.vars.length) {
            this.vars[i] = v.vars[i];
            ++i;
        }
    }

    boolean meet(int varNum, State rhs) {
        State lhs = this.vars[varNum];
        if (lhs != State.BOTH && rhs != lhs && rhs != State.UNKNOWN) {
            if (lhs == State.UNKNOWN) {
                this.vars[varNum] = rhs;
                return true;
            }
            this.vars[varNum] = State.BOTH;
            return true;
        }
        return false;
    }

    boolean meet(NullPointerState other) {
        assert (other.vars.length == this.vars.length);
        boolean changed = false;
        int i = 0;
        while (i < this.vars.length) {
            changed |= this.meet(i, other.vars[i]);
            ++i;
        }
        return changed;
    }

    boolean nullify(int varNum) {
        if (this.vars[varNum] != State.NULL) {
            this.vars[varNum] = State.NULL;
            return true;
        }
        return false;
    }

    boolean denullify(int varNum) {
        if (this.vars[varNum] != State.NOT_NULL) {
            this.vars[varNum] = State.NOT_NULL;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullPointerState) {
            NullPointerState other = (NullPointerState)((Object)obj);
            assert (this.vars.length == other.vars.length);
            int i = 0;
            while (i < this.vars.length) {
                if (this.vars[i] != other.vars[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public State getState(int ssaVarNum) {
        return this.vars[ssaVarNum];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<");
        int i = 0;
        while (i < this.vars.length) {
            switch (this.vars[i]) {
                case BOTH: {
                    buf.append('*');
                    break;
                }
                case NOT_NULL: {
                    buf.append('1');
                    break;
                }
                case NULL: {
                    buf.append('0');
                    break;
                }
                case UNKNOWN: {
                    buf.append('?');
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        buf.append('>');
        return buf.toString();
    }

    private static class DenullifyFunction
    extends UnaryOperator<NullPointerState> {
        private final int varNum;

        private DenullifyFunction(int varNum) {
            assert (varNum >= 0);
            this.varNum = varNum;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            byte state = 0;
            if (!lhs.equals((Object)rhs)) {
                lhs.copyState(rhs);
                state = 1;
            }
            if (lhs.denullify(this.varNum)) {
                state = 1;
            }
            return state;
        }

        public boolean equals(Object o) {
            return o instanceof DenullifyFunction && ((DenullifyFunction)((Object)o)).varNum == this.varNum;
        }

        public int hashCode() {
            return -47000 - this.varNum;
        }

        public String toString() {
            return "Denullify(" + this.varNum + ")";
        }
    }

    private static class IndentityFunction
    extends UnaryOperator<NullPointerState> {
        private static final IndentityFunction INSTANCE = new IndentityFunction();

        private IndentityFunction() {
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            if (lhs.equals((Object)rhs)) {
                return 0;
            }
            lhs.copyState(rhs);
            return 1;
        }

        public boolean equals(Object o) {
            return o instanceof IndentityFunction;
        }

        public int hashCode() {
            return 8911;
        }

        public String toString() {
            return "Id";
        }
    }

    private static class NullifyFunction
    extends UnaryOperator<NullPointerState> {
        private final int varNum;

        private NullifyFunction(int varNum) {
            this.varNum = varNum;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            byte state = 0;
            if (!lhs.equals((Object)rhs)) {
                lhs.copyState(rhs);
                state = 1;
            }
            if (lhs.nullify(this.varNum)) {
                state = 1;
            }
            return state;
        }

        public boolean equals(Object o) {
            return o instanceof NullifyFunction && ((NullifyFunction)((Object)o)).varNum == this.varNum;
        }

        public int hashCode() {
            return 47000 + this.varNum;
        }

        public String toString() {
            return "Nullify(" + this.varNum + ")";
        }
    }

    private static class PhiValueMeet
    extends UnaryOperator<NullPointerState> {
        private final int varNum;
        private final int[] fromVars;

        private PhiValueMeet(int varNum, int[] fromVars) {
            this.varNum = varNum;
            this.fromVars = fromVars;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            boolean changed = false;
            if (!lhs.equals((Object)rhs)) {
                lhs.copyState(rhs);
                changed = true;
            }
            ((NullPointerState)lhs).vars[this.varNum] = State.UNKNOWN;
            int[] nArray = this.fromVars;
            int n = this.fromVars.length;
            int n2 = 0;
            while (n2 < n) {
                int from = nArray[n2];
                changed |= lhs.meet(this.varNum, rhs.vars[from]);
                ++n2;
            }
            return changed ? (byte)1 : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PhiValueMeet) {
                PhiValueMeet other = (PhiValueMeet)((Object)o);
                if (this.varNum == other.varNum && this.fromVars.length == other.fromVars.length) {
                    int i = 0;
                    while (i < this.fromVars.length) {
                        if (this.fromVars[i] != other.fromVars[i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return 11000 + this.varNum;
        }

        public String toString() {
            StringBuffer str = new StringBuffer("PhiValueMeet(" + this.varNum + ", [");
            int i = 0;
            while (i < this.fromVars.length) {
                str.append(this.fromVars[i]);
                str.append(i == this.fromVars.length - 1 ? "" : ",");
                ++i;
            }
            str.append("])");
            return str.toString();
        }
    }

    public static enum State {
        UNKNOWN,
        BOTH,
        NULL,
        NOT_NULL;

    }

    private static class StateMeet
    extends AbstractMeetOperator<NullPointerState> {
        private static final StateMeet INSTANCE = new StateMeet();

        private StateMeet() {
        }

        public boolean equals(Object o) {
            return o instanceof StateMeet;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState[] rhs) {
            boolean changed = false;
            NullPointerState[] nullPointerStateArray = rhs;
            int n = rhs.length;
            int n2 = 0;
            while (n2 < n) {
                NullPointerState state = nullPointerStateArray[n2];
                changed |= lhs.meet(state);
                ++n2;
            }
            return changed ? (byte)1 : 0;
        }

        public int hashCode() {
            return 4711;
        }

        public String toString() {
            return "NullPointerStateMeet";
        }
    }
}

