/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MutableCFG<X, T extends IBasicBlock<X>>
extends SparseNumberedGraph<T>
implements ControlFlowGraph<X, T> {
    private final ControlFlowGraph<X, T> orig;

    private MutableCFG(ControlFlowGraph<X, T> orig) {
        this.orig = orig;
    }

    public static <I, T extends IBasicBlock<I>> MutableCFG<I, T> copyFrom(ControlFlowGraph<I, T> cfg) {
        IBasicBlock node;
        MutableCFG<I, T> mutable = new MutableCFG<I, T>(cfg);
        Iterator iterator = cfg.iterator();
        while (iterator.hasNext()) {
            node = (IBasicBlock)iterator.next();
            mutable.addNode(node);
        }
        iterator = cfg.iterator();
        while (iterator.hasNext()) {
            node = (IBasicBlock)iterator.next();
            for (IBasicBlock succ : cfg.getNormalSuccessors(node)) {
                mutable.addEdge(node, succ);
            }
            for (IBasicBlock succ : cfg.getExceptionalSuccessors(node)) {
                mutable.addEdge(node, succ);
            }
        }
        return mutable;
    }

    @Override
    public T entry() {
        return (T)((IBasicBlock)this.orig.entry());
    }

    @Override
    public T exit() {
        return (T)((IBasicBlock)this.orig.exit());
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector bvOrig = this.orig.getCatchBlocks();
        BitVector bvThis = new BitVector();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IBasicBlock block = (IBasicBlock)iterator.next();
            bvThis.set(block.getNumber());
        }
        bvThis.and(bvOrig);
        return bvThis;
    }

    @Override
    public T getBlockForInstruction(int index) {
        T block = this.orig.getBlockForInstruction(index);
        return (T)(this.containsNode(block) ? block : null);
    }

    @Override
    public X[] getInstructions() {
        return this.orig.getInstructions();
    }

    @Override
    public int getProgramCounter(int index) {
        return this.orig.getProgramCounter(index);
    }

    @Override
    public IMethod getMethod() {
        return this.orig.getMethod();
    }

    @Override
    public List<T> getExceptionalSuccessors(T b) {
        List origSucc = this.orig.getExceptionalSuccessors(b);
        IntSet allSuccs = this.getSuccNodeNumbers(b);
        LinkedList<IBasicBlock> thisSuccs = new LinkedList<IBasicBlock>();
        for (IBasicBlock block : origSucc) {
            if (!allSuccs.contains(block.getNumber())) continue;
            thisSuccs.add(block);
        }
        return thisSuccs;
    }

    @Override
    public Collection<T> getNormalSuccessors(T b) {
        List<T> excSuccs = this.getExceptionalSuccessors(b);
        LinkedList<IBasicBlock> thisSuccs = new LinkedList<IBasicBlock>();
        Iterator succs = this.getSuccNodes(b);
        while (succs.hasNext()) {
            IBasicBlock succ = (IBasicBlock)succs.next();
            if (excSuccs.contains(succ)) continue;
            thisSuccs.add(succ);
        }
        return thisSuccs;
    }

    @Override
    public Collection<T> getExceptionalPredecessors(T b) {
        Collection origPreds = this.orig.getExceptionalPredecessors(b);
        IntSet allPreds = this.getPredNodeNumbers(b);
        LinkedList<IBasicBlock> thisPreds = new LinkedList<IBasicBlock>();
        for (IBasicBlock block : origPreds) {
            if (!allPreds.contains(block.getNumber())) continue;
            thisPreds.add(block);
        }
        return thisPreds;
    }

    @Override
    public Collection<T> getNormalPredecessors(T b) {
        Collection<T> excPreds = this.getExceptionalPredecessors(b);
        LinkedList<IBasicBlock> thisPreds = new LinkedList<IBasicBlock>();
        Iterator preds = this.getPredNodes(b);
        while (preds.hasNext()) {
            IBasicBlock pred = (IBasicBlock)preds.next();
            if (excPreds.contains(pred)) continue;
            thisPreds.add(pred);
        }
        return thisPreds;
    }
}

