/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.cdg;

import com.ibm.wala.cfg.MinimalCFG;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ControlDependenceGraph<T>
extends AbstractNumberedGraph<T> {
    private final MinimalCFG<T> cfg;
    private final NumberedEdgeManager<T> edgeManager;
    private Map<Pair<T, T>, Set<? extends Object>> edgeLabels;

    private Map<T, Set<T>> buildControlDependence(boolean wantEdgeLabels) {
        HashMap controlDependence = HashMapFactory.make((int)this.cfg.getNumberOfNodes());
        DominanceFrontiers RDF = new DominanceFrontiers((Graph)GraphInverter.invert(this.cfg), this.cfg.exit());
        if (wantEdgeLabels) {
            this.edgeLabels = HashMapFactory.make();
        }
        Iterator ns = this.cfg.iterator();
        while (ns.hasNext()) {
            HashSet s = HashSetFactory.make((int)2);
            controlDependence.put(ns.next(), s);
        }
        ns = this.cfg.iterator();
        while (ns.hasNext()) {
            Object y = ns.next();
            Iterator ns2 = RDF.getDominanceFrontier(y);
            while (ns2.hasNext()) {
                Object x = ns2.next();
                ((Set)controlDependence.get(x)).add(y);
                if (!wantEdgeLabels) continue;
                HashSet labels = HashSetFactory.make();
                this.edgeLabels.put(Pair.make(x, y), labels);
                Iterator ss = this.cfg.getSuccNodes(x);
                while (ss.hasNext()) {
                    Object s = ss.next();
                    if (!RDF.isDominatedBy(s, y)) continue;
                    labels.add(this.makeEdgeLabel(x, y, s));
                }
            }
        }
        return controlDependence;
    }

    protected Object makeEdgeLabel(T x, T y, T s) {
        return s;
    }

    private NumberedEdgeManager<T> constructGraphEdges(final Map<T, Set<T>> forwardEdges) {
        return new NumberedEdgeManager<T>(){
            Map<T, Set<T>> backwardEdges;
            {
                this.backwardEdges = HashMapFactory.make((int)map.size());
                Iterator x = ControlDependenceGraph.this.cfg.iterator();
                while (x.hasNext()) {
                    HashSet s = HashSetFactory.make();
                    this.backwardEdges.put(x.next(), s);
                }
                for (Object p : map.keySet()) {
                    for (Object n : (Set)map.get(p)) {
                        this.backwardEdges.get(n).add(p);
                    }
                }
            }

            public Iterator<T> getPredNodes(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).iterator();
                }
                return EmptyIterator.instance();
            }

            public IntSet getPredNodeNumbers(T node) {
                MutableIntSet x = IntSetUtil.make();
                if (this.backwardEdges.containsKey(node)) {
                    for (Object pred : this.backwardEdges.get(node)) {
                        x.add(ControlDependenceGraph.this.cfg.getNumber(pred));
                    }
                }
                return x;
            }

            public int getPredNodeCount(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).size();
                }
                return 0;
            }

            public Iterator<T> getSuccNodes(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).iterator();
                }
                return EmptyIterator.instance();
            }

            public IntSet getSuccNodeNumbers(T node) {
                MutableIntSet x = IntSetUtil.make();
                if (forwardEdges.containsKey(node)) {
                    for (Object succ : (Set)forwardEdges.get(node)) {
                        x.add(ControlDependenceGraph.this.cfg.getNumber(succ));
                    }
                }
                return x;
            }

            public int getSuccNodeCount(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).size();
                }
                return 0;
            }

            public boolean hasEdge(T src, T dst) {
                return forwardEdges.containsKey(src) && ((Set)forwardEdges.get(src)).contains(dst);
            }

            public void addEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            public void removeEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            public void removeAllIncidentEdges(T node) {
                throw new UnsupportedOperationException();
            }

            public void removeIncomingEdges(T node) {
                throw new UnsupportedOperationException();
            }

            public void removeOutgoingEdges(T node) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator ns = this.iterator();
        while (ns.hasNext()) {
            Object n = ns.next();
            sb.append(n.toString()).append("\n");
            Iterator ss = this.getSuccNodes(n);
            while (ss.hasNext()) {
                Object s = ss.next();
                sb.append("  --> ").append(s);
                if (this.edgeLabels != null) {
                    Iterator<? extends Object> labels = this.edgeLabels.get(Pair.make(n, s)).iterator();
                    while (labels.hasNext()) {
                        sb.append("\n   label: ").append(labels.next());
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public ControlDependenceGraph(MinimalCFG<T> cfg, boolean wantEdgeLabels) {
        if (cfg == null) {
            throw new IllegalArgumentException("null cfg");
        }
        this.cfg = cfg;
        this.edgeManager = this.constructGraphEdges(this.buildControlDependence(wantEdgeLabels));
    }

    public ControlDependenceGraph(MinimalCFG<T> cfg) {
        this(cfg, false);
    }

    public MinimalCFG getControlFlowGraph() {
        return this.cfg;
    }

    public Set<? extends Object> getEdgeLabels(T from, T to) {
        return this.edgeLabels.get(Pair.make(from, to));
    }

    public NumberedNodeManager<T> getNodeManager() {
        return this.cfg;
    }

    public NumberedEdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public boolean controlEquivalent(T bb1, T bb2) {
        if (this.getPredNodeCount(bb1) != this.getPredNodeCount(bb2)) {
            return false;
        }
        Iterator pbs1 = this.getPredNodes(bb1);
        while (pbs1.hasNext()) {
            if (this.hasEdge(pbs1.next(), bb2)) continue;
            return false;
        }
        return true;
    }
}

