/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural.xml;

import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.rules.RuleLevel;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.structural.impl.StructuralMessage;
import com.ibm.safe.structural.xml.XMLDOMUtils;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLQueryEvaluator {
    protected String filename = null;

    public static StructuralMessage[] execute(StructuralRule rule, Document doc) throws Exception {
        ArrayList<StructuralMessage> messages = new ArrayList<StructuralMessage>(10);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xpathExpression = xpath.compile(rule.getQuery());
        NodeList nodeList = (NodeList)xpathExpression.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node ithNode = nodeList.item(i);
            Node methodNode = XMLQueryEvaluator.getMethodNode(ithNode);
            String repLoc = rule.getReportLocationQuery().getName().toLowerCase();
            boolean found = false;
            String locationString = null;
            Node child = methodNode.getFirstChild();
            while (child != null && !found) {
                if (child.getNodeName().equals(repLoc)) {
                    found = true;
                    locationString = XMLDOMUtils.getTextContents(child);
                }
                child = child.getNextSibling();
            }
            int lineNumber = -1;
            Node lineAttrNode = ithNode.getAttributes().getNamedItem("line");
            if (lineAttrNode != null) {
                lineNumber = Integer.valueOf(lineAttrNode.getNodeValue());
            }
            Object location = null;
            location = rule.getLevel() == RuleLevel.CLASS_LEVEL_LITERAL ? Location.createClassLocation((String)locationString, (int)lineNumber) : (rule.getLevel() == RuleLevel.METHOD_LEVEL_LITERAL ? Location.createMethodLocation((String)locationString, (int)lineNumber) : Location.createUnknownLocation());
            messages.add(new StructuralMessage(rule, (Location)location));
            ++i;
        }
        return messages.toArray(new StructuralMessage[messages.size()]);
    }

    private static Node getMethodNode(Node resultNode) {
        if (resultNode.getNodeName().equals("method") || resultNode.getNodeName().equals("class")) {
            return resultNode;
        }
        return XMLQueryEvaluator.getMethodNode(resultNode.getParentNode());
    }
}

