/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural.xml;

import com.ibm.safe.processors.InstructionProcessor;
import com.ibm.safe.processors.MethodProcessor;
import com.ibm.safe.structural.xml.InstructionXMLProcessor;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MethodXMLProcessor
implements MethodProcessor {
    private static final String BODY_TAG = "body";
    private static final String ID_TAG = "id";
    private InstructionXMLProcessor instXMLModel = new InstructionXMLProcessor();
    protected IClassHierarchy cha;
    protected CallGraph callGraph;
    protected Document doc;
    private Element bodyRoot;

    public MethodXMLProcessor(IClassHierarchy cha, CallGraph callGraph) {
        this.cha = cha;
        this.callGraph = callGraph;
    }

    @Override
    public void setup(IClass c, Object context) {
    }

    public void setup(IMethod method, Document doc) {
        this.doc = doc;
    }

    @Override
    public void addInstructionProcessor(InstructionProcessor ip) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processProlog(IMethod method) {
        this.bodyRoot = this.doc.createElement(BODY_TAG);
    }

    @Override
    public void processEpilog(IMethod method) {
    }

    @Override
    public Object getResult() {
        return this.bodyRoot;
    }

    @Override
    public void process(IMethod method) {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        IR methodIR = new AnalysisCacheImpl().getSSACache().findOrCreateIR(method, (Context)Everywhere.EVERYWHERE, SSAOptions.defaultOptions());
        int i = 0;
        this.instXMLModel.setDocument(this.doc);
        this.instXMLModel.setEnvironment(methodIR);
        int j = 0;
        int size = methodIR.getInstructions().length;
        while (j < size) {
            SSAInstruction instr = methodIR.getInstructions()[j];
            if (instr != null) {
                this.instXMLModel.processProlog(instr);
                this.instXMLModel.process(instr, methodIR.getControlFlowGraph().getProgramCounter(j));
                this.instXMLModel.processEpilog(instr);
                Element instrElement = this.instXMLModel.getResultElement();
                instrElement.setAttribute(ID_TAG, String.valueOf(i));
                ++i;
                this.bodyRoot.appendChild(instrElement);
            }
            ++j;
        }
    }
}

