/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural.xml;

import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.safe.processors.InstructionProcessor;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.structural.xml.XMLDOMUtils;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstructionXMLProcessor
implements InstructionProcessor {
    public static final String ID_TAG = "id";
    public static final String TYPE_TAG = "type";
    public static final String VALUE_TAG = "value";
    public static final String PARAM_TAG = "param";
    public static final String RHS1_TAG = "rhs1";
    public static final String RHS2_TAG = "rhs2";
    public static final String OPCODE_TAG = "opcode";
    public static final String LHS_TAG = "lhs";
    public static final String TARGET_TAG = "target";
    public static final String OPERAND_TAG = "op";
    public static final String GOTO_INST = "goto";
    public static final String ARRAY_LOAD_INST = "arrayload";
    public static final String ARRAY_STORE_INST = "arraystore";
    public static final String BINARY_OP_INST = "binaryop";
    public static final String UNARY_OP_INST = "unaryop";
    public static final String CONVERSION_INST = "conversion";
    public static final String COMPARISON_INST = "comparison";
    public static final String CONDITIONAL_BRANCH_INST = "condbranch";
    public static final String SWITCH_INST = "switch";
    public static final String RETURN_INST = "return";
    public static final String GET_INST = "get";
    public static final String PUT_INST = "put";
    public static final String INVOKE_INST = "invoke";
    public static final String NEW_INST = "new";
    public static final String ARRAY_LEN_INST = "arraylen";
    public static final String THROW_INST = "throw";
    public static final String MONITOR_ENTER_INST = "monitorenter";
    public static final String MONITOR_EXIT_INST = "monitorexit";
    public static final String CHECK_CAST_INST = "checkcast";
    public static final String INSTANCEOF_INST = "instanceof";
    public static final String PHI_INST = "phi";
    public static final String PI_INST = "pi";
    public static final String GET_CAUGHT_EXCEPTION_INST = "getcaught";
    public static final String RETURN_TYPE = "rettype";
    public static final String USED_ATTR = "used";
    public static final String LINE_ATTR = "line";
    public static final String LOAD_CLASS_INST = "load_class";
    private XMLInstructionVisitor visitor = new XMLInstructionVisitor();

    public void setDocument(Document doc) {
        this.visitor.setDocument(doc);
    }

    public void setEnvironment(IR ir) {
        this.visitor.setEnvironment(ir);
    }

    @Override
    public void setup(IMethod method, Map<Integer, SCCPValue> context, IR ir) {
    }

    public Element getResultElement() {
        return this.visitor.getResultElement();
    }

    @Override
    public void processProlog(SSAInstruction instruction) {
    }

    @Override
    public void processEpilog(SSAInstruction instruction) {
    }

    @Override
    public void process(SSAInstruction instruction, int bcIndex) {
        this.visitor.setBcIndex(bcIndex);
        instruction.visit((SSAInstruction.IVisitor)this.visitor);
    }

    @Override
    public Collection<? extends Message> getResult() {
        Assertions.UNREACHABLE();
        return null;
    }

    public static class XMLInstructionVisitor
    extends SSAInstruction.Visitor {
        protected Element result;
        protected Document doc;
        private SymbolTable st;
        private TypeInference typeInference;
        private int bcIndex;

        public void setEnvironment(IR ir) {
            this.st = ir.getSymbolTable();
            this.typeInference = TypeInference.make((IR)ir, (boolean)true);
        }

        public void setDocument(Document doc) {
            this.doc = doc;
        }

        public Element getResultElement() {
            return this.result;
        }

        protected Element createOperandElement(Document doc, String tag, int valNumber) {
            Value operandValue;
            Element resultElement = XMLDOMUtils.createTaggedElement(doc, tag, valNumber);
            if (valNumber == -1) {
                return resultElement;
            }
            TypeAbstraction operandType = this.typeInference.getType(valNumber);
            if (this.st != null && this.st.isConstant(valNumber)) {
                if (this.st.isStringConstant(valNumber)) {
                    resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.TYPE_TAG, "Ljava/lang/String"));
                } else if (this.st.isFloatConstant(valNumber)) {
                    resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.TYPE_TAG, "float"));
                } else if (this.st.isDoubleConstant(valNumber)) {
                    resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.TYPE_TAG, "double"));
                } else if (this.st.isIntegerConstant(valNumber)) {
                    resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.TYPE_TAG, "int"));
                }
            } else if (operandType != null) {
                if (operandType.getType() != null) {
                    resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.TYPE_TAG, operandType.getType().getName().toString()));
                } else {
                    resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.TYPE_TAG, operandType.toString()));
                }
            }
            if (this.st != null && (operandValue = this.st.getValue(valNumber)) != null) {
                resultElement.appendChild(XMLDOMUtils.createTaggedElement(doc, InstructionXMLProcessor.VALUE_TAG, operandValue.toString()));
            }
            return resultElement;
        }

        public void visitGoto(SSAGotoInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.GOTO_INST);
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.ARRAY_LOAD_INST);
            String value = String.valueOf(instruction.getArrayRef());
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.OPERAND_TAG, value));
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.ARRAY_STORE_INST);
            String value = String.valueOf(instruction.getArrayRef());
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.OPERAND_TAG, value));
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.BINARY_OP_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            Element rhs2Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS2_TAG, instruction.getUse(1));
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            this.result.appendChild(lhsElement);
            this.result.appendChild(rhs1Element);
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.OPCODE_TAG, instruction.getOperator().toString()));
            this.result.appendChild(rhs2Element);
        }

        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.UNARY_OP_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            String opcode = String.valueOf(instruction.getOpcode());
            this.result.appendChild(lhsElement);
            this.result.appendChild(rhs1Element);
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.OPCODE_TAG, opcode));
        }

        public void visitConversion(SSAConversionInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.CONVERSION_INST);
            String rhs1 = String.valueOf(instruction.getUse(0));
            String lhs = String.valueOf(instruction.getDef());
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.LHS_TAG, lhs));
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.RHS1_TAG, rhs1));
        }

        public void visitComparison(SSAComparisonInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.COMPARISON_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            Element rhs2Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS2_TAG, instruction.getUse(1));
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            this.result.appendChild(lhsElement);
            this.result.appendChild(rhs1Element);
            this.result.appendChild(rhs2Element);
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.CONDITIONAL_BRANCH_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            Element rhs2Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS2_TAG, instruction.getUse(1));
            this.result.appendChild(rhs1Element);
            this.result.appendChild(rhs2Element);
            try {
                this.result.setAttribute(InstructionXMLProcessor.LINE_ATTR, String.valueOf(this.typeInference.getIR().getMethod().getLineNumber(this.bcIndex)));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }

        public void visitSwitch(SSASwitchInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.SWITCH_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            this.result.appendChild(rhs1Element);
        }

        public void visitReturn(SSAReturnInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.RETURN_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            this.result.appendChild(rhs1Element);
        }

        public void visitGet(SSAGetInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.GET_INST);
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            this.result.appendChild(lhsElement);
            if (instruction.getNumberOfUses() > 0) {
                Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
                this.result.appendChild(rhs1Element);
            }
        }

        public void visitPut(SSAPutInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.PUT_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            this.result.appendChild(rhs1Element);
            if (!instruction.isStatic()) {
                Element rhs2Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS2_TAG, instruction.getUse(1));
                this.result.appendChild(rhs2Element);
            }
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            int lhs;
            this.result = this.doc.createElement(InstructionXMLProcessor.INVOKE_INST);
            CallSiteReference site = instruction.getCallSite();
            String opcode = "";
            switch ((IInvokeInstruction.Dispatch)site.getInvocationCode()) {
                case STATIC: {
                    opcode = "static";
                    break;
                }
                case INTERFACE: {
                    opcode = "interface";
                    break;
                }
                case SPECIAL: {
                    opcode = "special";
                    break;
                }
                case VIRTUAL: {
                    opcode = "virtual";
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.OPCODE_TAG, opcode));
            this.result.setAttribute(InstructionXMLProcessor.LINE_ATTR, String.valueOf(this.typeInference.getIR().getMethod().getLineNumber(site.getProgramCounter())));
            if (instruction.getNumberOfReturnValues() > 0 && (lhs = instruction.getDef()) != -1) {
                Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, lhs);
                DefUse du = new DefUse(this.typeInference.getIR());
                lhsElement.setAttribute(InstructionXMLProcessor.USED_ATTR, String.valueOf(du.getUses(instruction.getDef()).hasNext()));
                this.result.appendChild(lhsElement);
            }
            int nParam = instruction.getNumberOfUses();
            int i = 0;
            while (i < nParam) {
                int param = instruction.getUse(i);
                Element paramElement = this.createOperandElement(this.doc, InstructionXMLProcessor.PARAM_TAG, param);
                paramElement.setAttribute(InstructionXMLProcessor.ID_TAG, String.valueOf(i));
                this.result.appendChild(paramElement);
                ++i;
            }
            MethodReference declaredTarget = instruction.getDeclaredTarget();
            if (declaredTarget != null) {
                TypeReference retType = declaredTarget.getReturnType();
                if (retType != null) {
                    Element returnTypeElement = XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.RETURN_TYPE, retType.getName().toString());
                    this.result.appendChild(returnTypeElement);
                }
                this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.TARGET_TAG, declaredTarget.getSignature()));
            }
        }

        public void visitNew(SSANewInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.NEW_INST);
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            this.result.appendChild(lhsElement);
            TypeReference declaredType = instruction.getNewSite().getDeclaredType();
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.TYPE_TAG, declaredType.toString()));
        }

        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.ARRAY_LEN_INST);
            String lhs = String.valueOf(instruction.getDef());
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.LHS_TAG, lhs));
        }

        public void visitThrow(SSAThrowInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.THROW_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getException());
            this.result.appendChild(rhs1Element);
        }

        public void visitMonitor(SSAMonitorInstruction instruction) {
            this.result = instruction.isMonitorEnter() ? this.doc.createElement(InstructionXMLProcessor.MONITOR_ENTER_INST) : this.doc.createElement(InstructionXMLProcessor.MONITOR_EXIT_INST);
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getRef());
            this.result.appendChild(rhs1Element);
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.CHECK_CAST_INST);
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            this.result.appendChild(lhsElement);
            this.result.appendChild(rhs1Element);
            TypeReference resultType = instruction.getDeclaredResultType();
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.TYPE_TAG, resultType.toString()));
        }

        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.INSTANCEOF_INST);
            Element lhsElement = this.createOperandElement(this.doc, InstructionXMLProcessor.LHS_TAG, instruction.getDef());
            Element rhs1Element = this.createOperandElement(this.doc, InstructionXMLProcessor.RHS1_TAG, instruction.getUse(0));
            this.result.appendChild(lhsElement);
            this.result.appendChild(rhs1Element);
            TypeReference checkedType = instruction.getCheckedType();
            this.result.appendChild(XMLDOMUtils.createTaggedElement(this.doc, InstructionXMLProcessor.TYPE_TAG, checkedType.toString()));
        }

        public void visitPi(SSAPhiInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.PI_INST);
        }

        public void visitPhi(SSAPhiInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.PHI_INST);
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            this.result = this.doc.createElement(InstructionXMLProcessor.GET_CAUGHT_EXCEPTION_INST);
        }

        public void setBcIndex(int index) {
            this.bcIndex = index;
        }
    }
}

