/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural.xml;

import com.ibm.safe.cha.J2SEClassHierarchyEngine;
import com.ibm.safe.io.XMLUtil;
import com.ibm.safe.lightweight.options.IStructuralOptions;
import com.ibm.safe.processors.ClassProcessor;
import com.ibm.safe.processors.MethodProcessor;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.structural.impl.StructuralMessage;
import com.ibm.safe.structural.xml.MethodXMLProcessor;
import com.ibm.safe.structural.xml.XMLDOMUtils;
import com.ibm.safe.structural.xml.XMLQueryEvaluator;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClassXMLProcessor
implements ClassProcessor {
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_STATIC = "static";
    private static final String MODIFIER_ABSTRACT = "abstract";
    private static final String MODIFIER_NATIVE = "native";
    private static final String MODIFIER_SYNCHRONIZED = "synchronized";
    private static final String CLASS_TAG = "class";
    private static final String NAME_TAG = "name";
    private static final String MODIFIERS_TAG = "modifiers";
    private static final String MODIFIER_TAG = "modifier";
    private static final String EXTENDS_TAG = "extends";
    private static final String IMPLEMENTS_LIST_TAG = "implements-list";
    private static final String IMPLEMENTS_TAG = "implements";
    private static final String PARAMETER_TAG = "parameter";
    private static final String ID_TAG = "id";
    private static final String TYPE_TAG = "type";
    private static final String DEFINE_METHODS_TAG = "define-methods";
    private static final String DEFINE_FIELDS_TAG = "define-fields";
    private static final String METHOD_TAG = "method";
    private static final String FIELD_TAG = "field";
    private static final String STATIC_FIELD_TAG = "static-field";
    private static final String SIGNATURE_TAG = "signature";
    private static final String RETURN_TYPE_TAG = "returntype";
    private static final char SLASH_REPLACEMENT = '.';
    private MethodXMLProcessor methodXMLModel;
    protected IClassHierarchy classHierarchy;
    protected CallGraph callGraph;
    private Collection<? extends Message> result;
    private Set<Message> allMessages;
    private IStructuralOptions structuralOptions;

    public ClassXMLProcessor(IClassHierarchy hierarchy, CallGraph callGraph, IStructuralOptions structuralSafeOptions) {
        this.classHierarchy = hierarchy;
        this.callGraph = callGraph;
        this.allMessages = HashSetFactory.make();
        this.methodXMLModel = new MethodXMLProcessor(hierarchy, callGraph);
        this.structuralOptions = structuralSafeOptions;
    }

    @Override
    public void process(IClass currentClass) {
        HashSet messages = HashSetFactory.make();
        if (J2SEClassHierarchyEngine.isApplicationClass((IClass)currentClass)) {
            Document classDoc;
            try {
                classDoc = this.analyzeClass(currentClass);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new RuntimeException("Something went terribly wrong :(");
            }
            StructuralRule[] rules = this.structuralOptions.getRules();
            int i = 0;
            while (i < rules.length) {
                try {
                    if (rules[i].getQuery() != null) {
                        StructuralMessage[] msg = XMLQueryEvaluator.execute(rules[i], classDoc);
                        int j = 0;
                        while (j < msg.length) {
                            messages.add(msg[j]);
                            ++j;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Something went terribly wrong :(");
                }
                ++i;
            }
        }
        this.result = messages;
    }

    @Override
    public void processProlog(IClass currentClass) {
    }

    @Override
    public void processEpilog(IClass currentClass) {
        this.allMessages.addAll(this.result);
    }

    @Override
    public void addMethodProcessor(MethodProcessor mp) {
        throw new UnsupportedOperationException("Cannot add method processors to this class processor");
    }

    public Document analyzeClass(IClass klass) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            String xmlDir;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation domImplementation = documentBuilder.getDOMImplementation();
            Document document = domImplementation.createDocument("safe", "safe", null);
            Element root = document.getDocumentElement();
            Element classElement = document.createElement(CLASS_TAG);
            Element methodsRoot = document.createElement(DEFINE_METHODS_TAG);
            Element fieldsRoot = document.createElement(DEFINE_FIELDS_TAG);
            String classSimpleName = this.simplify(klass.getName().toString());
            IClass superClass = klass.getSuperclass();
            if (superClass != null) {
                String superClassName = superClass.getName().toString();
                classElement.appendChild(XMLDOMUtils.createTaggedElement(document, EXTENDS_TAG, superClassName));
                this.addImplementsList(klass, classElement, document);
            }
            classElement.appendChild(XMLDOMUtils.createTaggedElement(document, NAME_TAG, classSimpleName));
            root.appendChild(classElement);
            classElement.appendChild(methodsRoot);
            this.addMethodDefinitions(klass, document, methodsRoot);
            classElement.appendChild(fieldsRoot);
            this.addFieldDefinitions(klass, document, fieldsRoot);
            if (this.structuralOptions.shouldDumpXML() && this.directoryCreated(xmlDir = this.structuralOptions.getXMLDumpingDir())) {
                StringBuffer buf = new StringBuffer(xmlDir);
                buf.append(File.separatorChar).append(classSimpleName).append(".xml");
                StreamResult outStream = new StreamResult(buf.toString());
                XMLUtil.writeXMLDocument((Document)document, (StreamResult)outStream);
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException("DOM builder error.");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("Error writing XML output");
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException("Error writing XML output");
        }
    }

    private boolean directoryCreated(String xmlDir) {
        File dir = new File(xmlDir);
        if (!dir.exists() && !dir.mkdirs()) {
            SafeLogger.severe((String)("Unable to create XML directory " + xmlDir + ". Writing of XML file aborted."));
            return false;
        }
        return true;
    }

    public void addImplementsList(IClass klass, Element classElement, Document doc) {
        if (!klass.isInterface() && !klass.getAllImplementedInterfaces().isEmpty()) {
            Element implementsElement = doc.createElement(IMPLEMENTS_LIST_TAG);
            classElement.appendChild(implementsElement);
            for (IClass curr : klass.getAllImplementedInterfaces()) {
                String intName = curr.getName().toString().substring(1).replace('/', '.');
                implementsElement.appendChild(XMLDOMUtils.createTaggedElement(doc, IMPLEMENTS_TAG, intName));
            }
        }
    }

    public void addFieldDefinitions(IClass klass, Document doc, Element fieldsRoot) {
        Element fieldElement;
        String fieldSignature;
        String typeString;
        String fieldName;
        for (IField iFld : klass.getDeclaredInstanceFields()) {
            FieldReference fld = iFld.getReference();
            fieldName = this.simplify(fld.getName().toString());
            typeString = this.simplify(fld.getFieldType().toString());
            fieldSignature = this.simplify(fld.getSignature());
            fieldElement = doc.createElement(FIELD_TAG);
            fieldElement.appendChild(XMLDOMUtils.createTaggedElement(doc, SIGNATURE_TAG, fieldSignature));
            fieldElement.appendChild(XMLDOMUtils.createTaggedElement(doc, NAME_TAG, fieldName));
            fieldElement.appendChild(XMLDOMUtils.createTaggedElement(doc, RETURN_TYPE_TAG, typeString));
            fieldsRoot.appendChild(fieldElement);
        }
        for (IField iFld : klass.getDeclaredStaticFields()) {
            FieldReference sfld = iFld.getReference();
            fieldName = this.simplify(sfld.getName().toString());
            typeString = this.simplify(sfld.getFieldType().toString());
            fieldSignature = this.simplify(sfld.getSignature());
            fieldElement = doc.createElement(STATIC_FIELD_TAG);
            fieldElement.appendChild(XMLDOMUtils.createTaggedElement(doc, SIGNATURE_TAG, fieldSignature));
            fieldElement.appendChild(XMLDOMUtils.createTaggedElement(doc, NAME_TAG, fieldName));
            fieldElement.appendChild(XMLDOMUtils.createTaggedElement(doc, RETURN_TYPE_TAG, typeString));
            fieldsRoot.appendChild(fieldElement);
        }
    }

    public void addMethodDefinitions(IClass klass, Document doc, Element methodsRoot) {
        try {
            for (IMethod method : klass.getDeclaredMethods()) {
                Element methodElement = this.addMethod(klass, method, doc);
                methodsRoot.appendChild(methodElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Element addMethod(IClass klass, IMethod method, Document doc) {
        String methodName = this.simplify(method.getName().toString());
        String returnTypeString = this.simplify(method.getReference().getReturnType().getName().toString());
        String methodSignature = this.simplify(method.getSignature());
        Element methodElement = doc.createElement(METHOD_TAG);
        methodElement.appendChild(XMLDOMUtils.createTaggedElement(doc, SIGNATURE_TAG, methodSignature));
        methodElement.appendChild(XMLDOMUtils.createTaggedElement(doc, NAME_TAG, methodName));
        methodElement.appendChild(XMLDOMUtils.createTaggedElement(doc, RETURN_TYPE_TAG, returnTypeString));
        Set<String> modifiers = this.getMethodModifiers(method);
        if (!modifiers.isEmpty()) {
            Element modifiersListElement = doc.createElement(MODIFIERS_TAG);
            methodElement.appendChild(modifiersListElement);
            for (String mod : modifiers) {
                modifiersListElement.appendChild(XMLDOMUtils.createTaggedElement(doc, MODIFIER_TAG, mod));
            }
        }
        int params = method.getNumberOfParameters();
        int i = 0;
        while (i < params) {
            TypeReference typeRef = method.getParameterType(i);
            Element param = doc.createElement(PARAMETER_TAG);
            param.appendChild(XMLDOMUtils.createTaggedElement(doc, TYPE_TAG, this.simplify(typeRef.getName().toString())));
            param.setAttribute(ID_TAG, String.valueOf(i));
            methodElement.appendChild(param);
            ++i;
        }
        this.methodXMLModel.setup(method, doc);
        this.methodXMLModel.processProlog(method);
        this.methodXMLModel.process(method);
        Element bodyElement = (Element)this.methodXMLModel.getResult();
        if (bodyElement != null) {
            methodElement.appendChild(bodyElement);
        }
        return methodElement;
    }

    public Set<String> getMethodModifiers(IMethod method) {
        HashSet result = HashSetFactory.make();
        if (method.isSynchronized()) {
            result.add(MODIFIER_SYNCHRONIZED);
        }
        if (method.isPrivate()) {
            result.add(MODIFIER_PRIVATE);
        }
        if (method.isStatic()) {
            result.add(MODIFIER_STATIC);
        }
        if (method.isAbstract()) {
            result.add(MODIFIER_ABSTRACT);
        }
        if (method.isNative()) {
            result.add(MODIFIER_NATIVE);
        }
        return result;
    }

    @Override
    public Object getResult() {
        return this.allMessages;
    }

    public Set<? extends Message> getMessages() {
        return this.allMessages;
    }

    private String simplify(String str) {
        return str.replace('/', '.');
    }
}

