/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural.statistics;

import com.ibm.safe.metrics.ClassStatistics;
import com.ibm.safe.metrics.ProgramStatistics;
import com.ibm.safe.processors.BaseClassProcessor;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;

public class StatisticsClassProcessor
extends BaseClassProcessor {
    private final ProgramStatistics programStats;

    public StatisticsClassProcessor(IClassHierarchy hierarchy, CallGraph callGraph, ProgramStatistics programStatistics) {
        super(hierarchy, callGraph);
        this.programStats = programStatistics;
    }

    @Override
    public void process(IClass klass) {
        ClassStatistics cs = new ClassStatistics();
        int methodNumber = 0;
        int staticMethodNumber = 0;
        int syncMethodNumber = 0;
        int numberOfFinalStaticFields = 0;
        int numberOfFinalInstanceFields = 0;
        long lob = 0L;
        cs.className = klass.getName().toString();
        cs.numberOfStaticFields = klass.getDeclaredStaticFields().size();
        cs.numberOfInstanceFields = klass.getDeclaredInstanceFields().size();
        for (IField fld : klass.getDeclaredStaticFields()) {
            if (fld == null || !fld.isFinal()) continue;
            ++numberOfFinalStaticFields;
        }
        cs.numberOfFinalStaticFields = numberOfFinalStaticFields;
        for (IField fld : klass.getDeclaredInstanceFields()) {
            if (fld == null || !fld.isFinal()) continue;
            ++numberOfFinalInstanceFields;
        }
        cs.numberOfFinalInstanceFields = numberOfFinalInstanceFields;
        if (klass.isAbstract()) {
            this.programStats.incrementEntry(2);
        }
        if (klass.isInterface()) {
            this.programStats.incrementEntry(1);
        }
        this.programStats.incrementEntry(0);
        for (IMethod method : klass.getDeclaredMethods()) {
            ShrikeCTMethod shrikeMethod;
            if (method instanceof ShrikeCTMethod && (shrikeMethod = (ShrikeCTMethod)method).getBytecodeStream() != null) {
                lob += (long)shrikeMethod.getBytecodeStream().length();
            }
            if (method.isStatic()) {
                ++staticMethodNumber;
            }
            if (method.isSynchronized()) {
                ++syncMethodNumber;
            }
            ++methodNumber;
        }
        cs.numberOfMethods = methodNumber;
        this.programStats.incrementEntry(4, (long)methodNumber);
        cs.numberOfStaticMethods = staticMethodNumber;
        cs.numberOfSynchronizedMethods = syncMethodNumber;
        cs.numberOfByteCodeLocs = lob;
        this.programStats.incrementEntry(3, lob);
        this.programStats.classStats.put(cs.className, cs);
    }
}

