/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural.impl;

import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.StructuralRule;

public class StructuralMessage
implements Message {
    protected StructuralRule rule;
    protected Location location;

    public StructuralMessage(StructuralRule rule, Location location) {
        assert (rule != null && location != null) : "message with null rule or location";
        this.rule = rule;
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMessageType() {
        return "structural";
    }

    public String getText() {
        return this.rule.getName();
    }

    public IRule getRule() {
        return this.rule;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StructuralMessage)) {
            return false;
        }
        StructuralMessage otherMessage = (StructuralMessage)other;
        return this.rule.equals((Object)otherMessage.rule) && this.location.equals((Object)otherMessage.location);
    }

    public int hashCode() {
        return this.rule.hashCode() + this.location.hashCode();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.rule.getName()).append(" (").append(this.getLocation().getSourceLocation()).append(')');
        return strBuilder.toString();
    }
}

