/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.structural;

import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.intraproc.ConstantConditionInstructionProcessor;
import com.ibm.safe.intraproc.InfiniteRecursionMethodProcessor;
import com.ibm.safe.intraproc.SCCPMethodProcessor;
import com.ibm.safe.lightweight.options.IStructuralOptions;
import com.ibm.safe.metrics.ProgramStatistics;
import com.ibm.safe.processors.AccessControlProgramProcessor;
import com.ibm.safe.processors.BaseClassProcessor;
import com.ibm.safe.processors.BaseProgramProcessor;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.secure.accessibility.AccessibilityConstants;
import com.ibm.safe.structural.SafeStructuralSolverResult;
import com.ibm.safe.structural.statistics.StatisticsClassProcessor;
import com.ibm.safe.structural.xml.ClassXMLProcessor;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class StructuralSolver
implements ISafeSolver,
AccessibilityConstants {
    protected CallGraph cg;
    protected IClassHierarchy classHierarchy;
    protected PointerAnalysis pointerAnalysis;
    private IStructuralOptions structuralOptions;
    private IReporter reporter;
    private Predicate<IClass> classFilter;
    private static final String NULL_DEREF_RULE_NAME = "Potential null dereference";
    private static final String CONSTANT_CONDITION_RULE_NAME = "Suspicious condition over a constant value";
    private static final String INFINITE_RECURSION_RULE_NAME = "Potential infinite recursion";
    private static final boolean REVERT_TO_OLD = false;

    public StructuralSolver(IClassHierarchy classHierarchy, Predicate<IClass> classFilter, CallGraph cg, PointerAnalysis pointerAnalysis, IStructuralOptions structuralSafeOptions, IReporter safeReporter) {
        assert (classHierarchy != null);
        this.cg = cg;
        this.pointerAnalysis = pointerAnalysis;
        this.classHierarchy = classHierarchy;
        this.structuralOptions = structuralSafeOptions;
        this.reporter = safeReporter;
        this.classFilter = classFilter;
    }

    public ISolverResult perform(IProgressMonitor monitor) throws CancelException {
        SafeStructuralSolverResult result = new SafeStructuralSolverResult();
        assert (this.classHierarchy != null);
        BaseProgramProcessor bpp = new BaseProgramProcessor(this.classHierarchy, this.cg, this.reporter, this.classFilter, monitor);
        BaseClassProcessor bcp = bpp.getBaseClassProcessor();
        ClassXMLProcessor cxp = new ClassXMLProcessor(this.classHierarchy, this.cg, this.structuralOptions);
        bpp.addClassProcessor(cxp);
        StatisticsClassProcessor csp = null;
        ProgramStatistics programStatistics = null;
        if (this.structuralOptions.shouldCollectStatistics()) {
            programStatistics = new ProgramStatistics();
            csp = new StatisticsClassProcessor(this.classHierarchy, this.cg, programStatistics);
            bpp.addClassProcessor(csp);
        }
        SCCPMethodProcessor sndmp = new SCCPMethodProcessor(this.classHierarchy);
        StructuralRule constantConditionRule = this.getConstantConditionRule();
        ConstantConditionInstructionProcessor ccip = new ConstantConditionInstructionProcessor(constantConditionRule);
        if (constantConditionRule != null) {
            sndmp.addInstructionProcessor(ccip);
        }
        this.getNullDeRefRule();
        if (constantConditionRule != null) {
            bcp.addMethodProcessor(sndmp);
        }
        StructuralRule infiniteRecursionRule = this.getInfiniteRecursionRule();
        InfiniteRecursionMethodProcessor irmp = new InfiniteRecursionMethodProcessor(infiniteRecursionRule, this.classHierarchy);
        if (infiniteRecursionRule != null) {
            bcp.addMethodProcessor(irmp);
        }
        bpp.process();
        result.addMessages((Set)sndmp.getResult());
        result.addMessages((Set)cxp.getResult());
        result.addMessages((Set)irmp.getResult());
        if (this.findRuleByName("Public method could be made protected") != null) {
            AccessControlProgramProcessor acpp = new AccessControlProgramProcessor(this.classHierarchy, this.structuralOptions.getRules(), this.classFilter);
            acpp.process();
            result.addMessages((Set)acpp.getResult());
        }
        if (this.structuralOptions.shouldCollectStatistics()) {
            this.reporter.reportStatistics(programStatistics);
        }
        return result;
    }

    private StructuralRule findRuleByName(String ruleName) {
        StructuralRule[] rules = this.structuralOptions.getRules();
        int i = 0;
        while (i < rules.length) {
            if (rules[i].getName().equals(ruleName)) {
                return rules[i];
            }
            ++i;
        }
        return null;
    }

    private StructuralRule getInfiniteRecursionRule() {
        return this.findRuleByName(INFINITE_RECURSION_RULE_NAME);
    }

    private StructuralRule getConstantConditionRule() {
        return this.findRuleByName(CONSTANT_CONDITION_RULE_NAME);
    }

    private StructuralRule getNullDeRefRule() {
        return this.findRuleByName(NULL_DEREF_RULE_NAME);
    }

    public IReporter getReporter() {
        return this.reporter;
    }
}

