/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.secure.accessibility;

import com.ibm.safe.secure.accessibility.AccessibilityMember;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMember;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import java.util.HashMap;
import java.util.Map;

public final class AccessibilityTarget
extends AccessibilityMember {
    private int currentModifier;
    private int suggestedModifier;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private int superModifier;
    private static Map<IMember, AccessibilityTarget> cache = new HashMap<IMember, AccessibilityTarget>();

    private AccessibilityTarget(IMember member) {
        super(member);
        if (member instanceof IMethod) {
            ShrikeCTMethod method = (ShrikeCTMethod)member;
            this.currentModifier = method.isPrivate() ? 0 : (method.isProtected() ? 2 : (method.isPublic() ? 3 : 1));
            if (method.isStatic()) {
                this.isStatic = true;
            }
            if (method.isFinal()) {
                this.isFinal = true;
            }
        } else {
            IField field = (IField)member;
            this.currentModifier = field.isPrivate() ? 0 : (field.isProtected() ? 2 : (field.isPublic() ? 3 : 1));
            if (field.isStatic()) {
                this.isStatic = true;
            }
            if (field.isFinal()) {
                this.isFinal = true;
            }
        }
        this.suggestedModifier = -1;
    }

    public static AccessibilityTarget getAccessibilityTarget(IMember member) {
        AccessibilityTarget at = cache.get(member);
        if (at == null) {
            at = new AccessibilityTarget(member);
            cache.put(member, at);
        }
        return at;
    }

    public int getCurrentModifier() {
        return this.currentModifier;
    }

    public int getSuggestedModifier() {
        return this.suggestedModifier;
    }

    void setSuggestedModifier(int suggestedModifier) {
        this.suggestedModifier = suggestedModifier;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("Modifiers: ");
        if (this.currentModifier == 0) {
            buf.append("private ");
        } else if (this.currentModifier == 1) {
            buf.append("default ");
        } else if (this.currentModifier == 2) {
            buf.append("protected ");
        } else {
            buf.append("public ");
        }
        if (this.isStatic) {
            buf.append("static ");
        }
        if (this.isFinal) {
            buf.append("final");
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setSuperModifier(int superModifier) {
        this.superModifier = superModifier;
    }

    public int getSuperModifier() {
        return this.superModifier;
    }
}

