/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.secure.accessibility;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMember;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.TypeName;

class AccessibilityMember {
    private String memberName;
    private TypeName className;
    private String packageName;
    private String classLoaderName;
    private boolean isField = false;

    AccessibilityMember(IMember iMember) {
        if (iMember instanceof IField) {
            this.memberName = iMember.getName().toString();
            this.isField = true;
        } else {
            IMethod method = (IMethod)iMember;
            this.memberName = method.getSelector().toString();
        }
        IClass declaringClass = iMember.getDeclaringClass();
        this.className = declaringClass.getName();
        this.classLoaderName = declaringClass.getClassLoader().getName().toString();
        this.packageName = AccessibilityMember.computePackageName(this.className.toString());
    }

    public static String computePackageName(String className) {
        int lastSlash = className.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return className.substring(0, lastSlash).replace('/', '.');
    }

    public String getMemberName() {
        return this.memberName;
    }

    public TypeName getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    public boolean isField() {
        return this.isField;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessibilityMember)) {
            return false;
        }
        AccessibilityMember that = (AccessibilityMember)obj;
        return this.isField == that.isField && this.memberName.equals(that.memberName) && this.className.equals((Object)that.className) && this.packageName.equals(that.packageName) && this.classLoaderName.equals(that.classLoaderName);
    }

    public int hashCode() {
        return this.memberName.hashCode() ^ this.className.hashCode() ^ this.packageName.hashCode() ^ this.classLoaderName.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isField()) {
            buf.append("Field Name: ");
        } else {
            buf.append("Method Name: ");
        }
        buf.append(String.valueOf(this.getMemberName().replaceAll("<init>", "()")) + "\n");
        buf.append("Class Name: " + this.getClassName().toString().replace('/', '.') + "\n");
        buf.append("Package Name: " + this.getPackageName().replace('/', '.') + "\n");
        buf.append("Class Loader Name: " + this.getClassLoaderName() + "\n");
        return buf.toString();
    }
}

