/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.secure.accessibility;

import com.ibm.safe.cha.J2SEClassHierarchyEngine;
import com.ibm.safe.reporting.message.ClassLocation;
import com.ibm.safe.reporting.message.FieldLocation;
import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.MethodLocation;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.secure.accessibility.AccessibilityConstants;
import com.ibm.safe.secure.accessibility.AccessibilityMember;
import com.ibm.safe.secure.accessibility.AccessibilityMessage;
import com.ibm.safe.secure.accessibility.AccessibilityTarget;
import com.ibm.safe.secure.accessibility.Accessor;
import com.ibm.safe.secure.accessibility.Modifier;
import com.ibm.safe.structural.impl.StructuralMessage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMember;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccessibilityAnalyzer
implements AccessibilityConstants {
    private final boolean DEBUG = false;
    private List<IClass> classes = new ArrayList<IClass>();

    public Set<StructuralMessage> process(IClassHierarchy cha, StructuralRule[] rules, Predicate<IClass> classFilter) {
        Map<AccessibilityTarget, ArrayList<Accessor>> targetsToAccessors = this.computeAccessibility(cha, classFilter);
        Map<Integer, StructuralRule> accessibilityRulesMap = this.getAccessibilityRules(rules);
        return this.computeMemberViolations(targetsToAccessors, accessibilityRulesMap, cha);
    }

    private void printAccessibility(Map<AccessibilityTarget, ArrayList<Accessor>> targetsToAccessors) {
        for (Map.Entry<AccessibilityTarget, ArrayList<Accessor>> entry : targetsToAccessors.entrySet()) {
            AccessibilityTarget target = entry.getKey();
            System.out.println(target);
            for (AccessibilityMember accessor : (List)entry.getValue()) {
                System.out.println(accessor);
            }
            System.out.println("=======================");
        }
    }

    private Set<StructuralMessage> computeMemberViolations(Map<AccessibilityTarget, ArrayList<Accessor>> targetsToAccessors, Map<Integer, StructuralRule> accessibilityRulesMap, IClassHierarchy cha) {
        HashSet<StructuralMessage> messages = new HashSet<StructuralMessage>();
        block0: for (Map.Entry<AccessibilityTarget, ArrayList<Accessor>> entry : targetsToAccessors.entrySet()) {
            StructuralRule rule;
            boolean okNotToBePrivate;
            StructuralRule rule2;
            AccessibilityTarget target = entry.getKey();
            if (target.isField() && target.isStatic() && !target.isFinal()) {
                FieldLocation location = Location.createFieldLocation((TypeName)target.getClassName(), (String)target.getMemberName());
                StructuralRule rule3 = accessibilityRulesMap.get(FIELD_MAKE_FINAL_ID);
                messages.add(new AccessibilityMessage(rule3, (Location)location, target));
            }
            int currentModifier = target.getCurrentModifier();
            List accessors = entry.getValue();
            if (accessors.isEmpty() && !target.getMemberName().endsWith("<clinit>()V")) {
                MethodLocation location = Location.createMethodLocation((TypeName)target.getClassName(), (String)target.getMemberName());
                StructuralRule rule4 = null;
                rule4 = target.isField() ? accessibilityRulesMap.get(FIELD_UNREFERENCED_ID) : (currentModifier == 3 ? accessibilityRulesMap.get(PUBLIC_METHOD_UNREACHABLE_ID) : (currentModifier == 2 ? accessibilityRulesMap.get(PROTECTED_METHOD_UNREACHABLE_ID) : (currentModifier == 1 ? accessibilityRulesMap.get(DEFAULT_METHOD_UNREACHABLE_ID) : accessibilityRulesMap.get(PRIVATE_METHOD_UNREACHABLE_ID))));
                messages.add(new AccessibilityMessage(rule4, (Location)location, target));
                continue;
            }
            if (currentModifier == 0) {
                target.setSuggestedModifier(0);
                continue;
            }
            int superModifier = target.getSuperModifier();
            if (superModifier == currentModifier) {
                target.setSuggestedModifier(currentModifier);
                continue;
            }
            Iterator accessorsIter = accessors.iterator();
            if (currentModifier == 1) {
                boolean okToBeDefault = false;
                while (accessorsIter.hasNext()) {
                    FieldLocation location;
                    Accessor accessor = (Accessor)accessorsIter.next();
                    if (!(target.getClassLoaderName().equals(accessor.getClassLoaderName()) && target.getClassName().equals((Object)accessor.getClassName()) && target.getClassLoaderName().equals(accessor.getAccessingClassLoaderName()) && target.getClassName().equals((Object)accessor.getAccessingClassName()))) {
                        okToBeDefault = true;
                        target.setSuggestedModifier(1);
                        continue block0;
                    }
                    if (okToBeDefault) continue;
                    target.setSuggestedModifier(0);
                    if (target.isField()) {
                        location = Location.createFieldLocation((TypeName)target.getClassName(), (String)target.getMemberName());
                        rule2 = accessibilityRulesMap.get(DEFAULT_FIELD_PRIVATE_ID);
                    } else {
                        location = Location.createMethodLocation((TypeName)target.getClassName(), (String)target.getMemberName());
                        rule2 = accessibilityRulesMap.get(DEFAULT_METHOD_PRIVATE_ID);
                    }
                    messages.add(new AccessibilityMessage(rule2, (Location)location, target));
                }
                continue;
            }
            if (currentModifier == 2) {
                okNotToBePrivate = false;
                boolean okNotToBeDefault = false;
                while (accessorsIter.hasNext()) {
                    Accessor accessor = (Accessor)accessorsIter.next();
                    if (!target.getClassLoaderName().equals(accessor.getClassLoaderName()) || !target.getClassLoaderName().equals(accessor.getAccessingClassLoaderName())) {
                        okNotToBePrivate = true;
                        okNotToBeDefault = true;
                        target.setSuggestedModifier(2);
                        break;
                    }
                    if (!target.getClassName().equals((Object)accessor.getClassName()) || !target.getClassName().equals((Object)accessor.getAccessingClassName())) {
                        okNotToBePrivate = true;
                    }
                    if (target.getPackageName().equals(accessor.getPackageName()) && target.getPackageName().equals(accessor.getAccessingPackageName())) continue;
                    okNotToBeDefault = true;
                    target.setSuggestedModifier(2);
                    break;
                }
                if (okNotToBeDefault) continue;
                Object location = target.isField() ? Location.createFieldLocation((TypeName)target.getClassName(), (String)target.getMemberName()) : Location.createMethodLocation((TypeName)target.getClassName(), (String)target.getMemberName());
                if (!okNotToBePrivate && currentModifier > superModifier) {
                    target.setSuggestedModifier(0);
                    rule2 = target.isField() ? accessibilityRulesMap.get(PROTECTED_FIELD_PRIVATE_ID) : accessibilityRulesMap.get(PROTECTED_METHOD_PRIVATE_ID);
                    messages.add(new AccessibilityMessage(rule2, (Location)location, target));
                    continue;
                }
                target.setSuggestedModifier(1);
                rule2 = target.isField() ? accessibilityRulesMap.get(PROTECTED_FIELD_DEFAULT_ID) : accessibilityRulesMap.get(PROTECTED_METHOD_DEFAULT_ID);
                messages.add(new AccessibilityMessage(rule2, (Location)location, target));
                continue;
            }
            if (currentModifier != 3) continue;
            okNotToBePrivate = false;
            boolean okNotToBeDefault = false;
            boolean okNotToBeProtected = false;
            while (accessorsIter.hasNext()) {
                Accessor accessor = (Accessor)accessorsIter.next();
                if (!target.getClassLoaderName().equals(accessor.getClassLoaderName()) || !target.getClassLoaderName().equals(accessor.getAccessingClassLoaderName())) {
                    okNotToBePrivate = true;
                    okNotToBeDefault = true;
                } else {
                    if (!target.getClassName().equals((Object)accessor.getClassName()) || !target.getClassName().equals((Object)accessor.getAccessingClassName())) {
                        okNotToBePrivate = true;
                    }
                    if (!target.getPackageName().equals(accessor.getPackageName()) || !target.getPackageName().equals(accessor.getAccessingPackageName())) {
                        okNotToBeDefault = true;
                    }
                }
                if (target.getPackageName().equals(accessor.getPackageName()) || accessor.getClassName().equals((Object)accessor.getAccessingClassName())) continue;
                okNotToBeProtected = true;
                target.setSuggestedModifier(3);
                break;
            }
            if (okNotToBeProtected || currentModifier <= superModifier) continue;
            Object location = target.isField() ? Location.createFieldLocation((TypeName)target.getClassName(), (String)target.getMemberName()) : Location.createMethodLocation((TypeName)target.getClassName(), (String)target.getMemberName());
            if (!okNotToBeDefault) {
                if (!okNotToBePrivate) {
                    target.setSuggestedModifier(0);
                    rule = target.isField() ? accessibilityRulesMap.get(PUBLIC_FIELD_PRIVATE_ID) : accessibilityRulesMap.get(PUBLIC_METHOD_PRIVATE_ID);
                    messages.add(new AccessibilityMessage(rule, (Location)location, target));
                    continue;
                }
                target.setSuggestedModifier(1);
                rule = target.isField() ? accessibilityRulesMap.get(PUBLIC_FIELD_DEFAULT_ID) : accessibilityRulesMap.get(PUBLIC_METHOD_DEFAULT_ID);
                messages.add(new AccessibilityMessage(rule, (Location)location, target));
                continue;
            }
            target.setSuggestedModifier(2);
            rule = target.isField() ? accessibilityRulesMap.get(PUBLIC_FIELD_PROTECTED_ID) : accessibilityRulesMap.get(PUBLIC_METHOD_PROTECTED_ID);
            messages.add(new AccessibilityMessage(rule, (Location)location, target));
        }
        for (IClass klass : this.classes) {
            if (Modifier.isDefault(klass.getModifiers())) continue;
            String thisPackageName = AccessibilityMember.computePackageName(klass.getName().toString());
            Iterator subclasses = cha.getImmediateSubclasses(klass).iterator();
            boolean okToBePublic = false;
            while (subclasses.hasNext()) {
                IClass subclass = (IClass)subclasses.next();
                String thatPackageName = AccessibilityMember.computePackageName(subclass.getName().toString());
                if (thisPackageName.equals(thatPackageName)) continue;
                okToBePublic = true;
                break;
            }
            if (!okToBePublic) {
                for (IField instanceField : klass.getDeclaredInstanceFields()) {
                    AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)instanceField);
                    int currentMod = target.getCurrentModifier();
                    if (currentMod < 2) continue;
                    okToBePublic = true;
                    break;
                }
                for (IField staticField : klass.getDeclaredStaticFields()) {
                    AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)staticField);
                    int currentMod = target.getCurrentModifier();
                    if (currentMod < 2) continue;
                    okToBePublic = true;
                    break;
                }
                for (IMethod method : klass.getDeclaredMethods()) {
                    AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)method);
                    int currentMod = target.getCurrentModifier();
                    if (currentMod < 2 || target.getMemberName().endsWith("<init>()V") && currentMod == 3) continue;
                    okToBePublic = true;
                    break;
                }
            }
            if (okToBePublic) continue;
            ClassLocation location = Location.createClassLocation((String)klass.getName().toString(), (int)-1);
            StructuralRule rule = accessibilityRulesMap.get(PUBLIC_CLASS_DEFAULT_ID);
            messages.add(new StructuralMessage(rule, (Location)location));
        }
        return messages;
    }

    private Map<AccessibilityTarget, ArrayList<Accessor>> computeAccessibility(IClassHierarchy cha, Predicate<IClass> classFilter) {
        HashMap<AccessibilityTarget, ArrayList<Accessor>> targetsToAccessors = new HashMap<AccessibilityTarget, ArrayList<Accessor>>();
        IClassLoader appLoader = cha.getLoader(ClassLoaderReference.Application);
        Iterator appClassesIter = appLoader.iterateAllClasses();
        while (appClassesIter.hasNext()) {
            IClass klass = (IClass)appClassesIter.next();
            if (!classFilter.test((Object)klass)) continue;
            this.classes.add(klass);
            if (klass.isInterface()) continue;
            for (IField field : klass.getAllFields()) {
                if (!field.getDeclaringClass().getClassLoader().equals(appLoader) || field.getName().toString().indexOf(36) > -1) continue;
                AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)field);
                targetsToAccessors.put(target, new ArrayList(3));
            }
            for (IMethod method : klass.getAllMethods()) {
                if (method.isAbstract() || !method.getDeclaringClass().getClassLoader().equals(appLoader) || method.getName().toString().indexOf(36) > -1) continue;
                AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)method);
                targetsToAccessors.put(target, new ArrayList(3));
            }
        }
        for (IClass klass : cha) {
            if (!J2SEClassHierarchyEngine.isApplicationClass((IClass)klass)) continue;
            for (IMethod method : klass.getDeclaredMethods()) {
                try {
                    for (FieldReference fieldRef : CodeScanner.getFieldsRead((IMethod)method)) {
                        IField iField;
                        if (!fieldRef.getDeclaringClass().getClassLoader().equals((Object)ClassLoaderReference.Application) || fieldRef.getName().toString().indexOf(36) > -1 || !(iField = appLoader.lookupClass(fieldRef.getDeclaringClass().getName()).getField(fieldRef.getName())).getDeclaringClass().getClassLoader().equals(ClassLoaderReference.Application) || iField.getName().toString().indexOf(36) > -1) continue;
                        AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)iField);
                        List accessors = (List)targetsToAccessors.get(target);
                        accessors.add(new Accessor((IMember)method, fieldRef.getDeclaringClass().getName().toString(), fieldRef.getDeclaringClass().getClassLoader().getName().toString()));
                    }
                    for (FieldReference fieldRef : CodeScanner.getFieldsWritten((IMethod)method)) {
                        IField iField;
                        if (!fieldRef.getDeclaringClass().getClassLoader().equals((Object)ClassLoaderReference.Application) || fieldRef.getName().toString().indexOf(36) > -1 || !(iField = appLoader.lookupClass(fieldRef.getDeclaringClass().getName()).getField(fieldRef.getName())).getDeclaringClass().getClassLoader().equals(ClassLoaderReference.Application) || iField.getName().toString().indexOf(36) > -1) continue;
                        AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)iField);
                        List accessors = (List)targetsToAccessors.get(target);
                        accessors.add(new Accessor((IMember)method, fieldRef.getDeclaringClass().getName().toString(), fieldRef.getDeclaringClass().getClassLoader().getName().toString()));
                    }
                    for (CallSiteReference callSiteRef : CodeScanner.getCallSites((IMethod)method)) {
                        IMethod superMethod;
                        IMethod iMethod;
                        IClass iClass;
                        MethodReference methodRef = callSiteRef.getDeclaredTarget();
                        if (!methodRef.getDeclaringClass().getClassLoader().equals((Object)ClassLoaderReference.Application) || methodRef.getName().toString().indexOf(36) > -1 || !J2SEClassHierarchyEngine.isApplicationClass((IClass)(iClass = (iMethod = appLoader.lookupClass(methodRef.getDeclaringClass().getName()).getMethod(methodRef.getSelector())).getDeclaringClass())) || iMethod.getName().toString().indexOf(36) > -1) continue;
                        int superModifier = -1;
                        int modifier = iMethod.isPublic() ? 3 : (iMethod.isProtected() ? 2 : (iMethod.isPrivate() ? 0 : 1));
                        IClass superClass = iClass.getSuperclass();
                        if (superClass != null && (superMethod = superClass.getMethod(iMethod.getSelector())) != null) {
                            superModifier = superMethod.isPublic() ? 3 : (superMethod.isProtected() ? 2 : (superMethod.isPrivate() ? 0 : 1));
                        }
                        if (modifier > superModifier) {
                            Collection interfaces = iClass.getAllImplementedInterfaces();
                            for (IClass intf : interfaces) {
                                IMethod intfMethod = intf.getMethod(iMethod.getSelector());
                                if (intfMethod == null) continue;
                                int intfModifier = -1;
                                intfModifier = intfMethod.isPublic() ? 3 : (intfMethod.isProtected() ? 2 : (intfMethod.isPrivate() ? 0 : 1));
                                if (modifier == (superModifier = Math.max(superModifier, intfModifier))) break;
                            }
                        }
                        AccessibilityTarget target = AccessibilityTarget.getAccessibilityTarget((IMember)iMethod);
                        target.setSuperModifier(superModifier);
                        List accessors = (List)targetsToAccessors.get(target);
                        accessors.add(new Accessor((IMember)method, methodRef.getDeclaringClass().getName().toString(), methodRef.getDeclaringClass().getClassLoader().getName().toString()));
                    }
                }
                catch (InvalidClassFileException ice) {
                    ice.printStackTrace();
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return targetsToAccessors;
    }

    private Map<Integer, StructuralRule> getAccessibilityRules(StructuralRule[] rules) {
        HashMap<Integer, StructuralRule> accessibilityRulesMap = new HashMap<Integer, StructuralRule>();
        int i = 0;
        while (i < rules.length) {
            if (rules[i].getName().equals("Public field could be made protected")) {
                accessibilityRulesMap.put(PUBLIC_FIELD_PROTECTED_ID, rules[i]);
            } else if (rules[i].getName().equals("Public field could be made default")) {
                accessibilityRulesMap.put(PUBLIC_FIELD_DEFAULT_ID, rules[i]);
            } else if (rules[i].getName().equals("Public field could be made private")) {
                accessibilityRulesMap.put(PUBLIC_FIELD_PRIVATE_ID, rules[i]);
            } else if (rules[i].getName().equals("Protected field could be made default")) {
                accessibilityRulesMap.put(PROTECTED_FIELD_DEFAULT_ID, rules[i]);
            } else if (rules[i].getName().equals("Protected field could be made private")) {
                accessibilityRulesMap.put(PROTECTED_FIELD_PRIVATE_ID, rules[i]);
            } else if (rules[i].getName().equals("Default field could be made private")) {
                accessibilityRulesMap.put(DEFAULT_FIELD_PRIVATE_ID, rules[i]);
            } else if (rules[i].getName().equals("Public method could be made protected")) {
                accessibilityRulesMap.put(PUBLIC_METHOD_PROTECTED_ID, rules[i]);
            } else if (rules[i].getName().equals("Public method could be made default")) {
                accessibilityRulesMap.put(PUBLIC_METHOD_DEFAULT_ID, rules[i]);
            } else if (rules[i].getName().equals("Public method could be made private")) {
                accessibilityRulesMap.put(PUBLIC_METHOD_PRIVATE_ID, rules[i]);
            } else if (rules[i].getName().equals("Protected method could be made default")) {
                accessibilityRulesMap.put(PROTECTED_METHOD_DEFAULT_ID, rules[i]);
            } else if (rules[i].getName().equals("Protected method could be made private")) {
                accessibilityRulesMap.put(PROTECTED_METHOD_PRIVATE_ID, rules[i]);
            } else if (rules[i].getName().equals("Default method could be made private")) {
                accessibilityRulesMap.put(DEFAULT_METHOD_PRIVATE_ID, rules[i]);
            } else if (rules[i].getName().equals("Unreferenced field")) {
                accessibilityRulesMap.put(FIELD_UNREFERENCED_ID, rules[i]);
            } else if (rules[i].getName().equals("Unreachable public method: Dead code? Entry Point?")) {
                accessibilityRulesMap.put(PUBLIC_METHOD_UNREACHABLE_ID, rules[i]);
            } else if (rules[i].getName().equals("Unreachable protected method: Dead code? Entry Point?")) {
                accessibilityRulesMap.put(PROTECTED_METHOD_UNREACHABLE_ID, rules[i]);
            } else if (rules[i].getName().equals("Unreachable default method: Dead code")) {
                accessibilityRulesMap.put(DEFAULT_METHOD_UNREACHABLE_ID, rules[i]);
            } else if (rules[i].getName().equals("Unreachable private method: Dead code")) {
                accessibilityRulesMap.put(PRIVATE_METHOD_UNREACHABLE_ID, rules[i]);
            } else if (rules[i].getName().equals("Non-private, non-final, static field")) {
                accessibilityRulesMap.put(FIELD_MAKE_FINAL_ID, rules[i]);
            } else if (rules[i].getName().equals("Public class could be made default")) {
                accessibilityRulesMap.put(PUBLIC_CLASS_DEFAULT_ID, rules[i]);
            }
            ++i;
        }
        return accessibilityRulesMap;
    }
}

