/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.processors;

import com.ibm.safe.cha.J2SEClassHierarchyEngine;
import com.ibm.safe.processors.BaseClassProcessor;
import com.ibm.safe.processors.ClassProcessor;
import com.ibm.safe.processors.ProgramProcessor;
import com.ibm.safe.reporting.IReporter;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class BaseProgramProcessor
implements ProgramProcessor {
    private final Predicate<IClass> classFilter;
    private final IReporter reporter;
    protected IClassHierarchy classHierarchy;
    protected CallGraph callGraph;
    protected List<ClassProcessor> classProcessors;
    protected BaseClassProcessor baseClassProcessor;
    private final IProgressMonitor progressMonitor;

    public BaseProgramProcessor(IClassHierarchy hierarchy, CallGraph callGraph, IReporter safeReporter, Predicate<IClass> classFilter, IProgressMonitor monitor) {
        assert (hierarchy != null);
        this.classHierarchy = hierarchy;
        this.callGraph = callGraph;
        this.classProcessors = new ArrayList<ClassProcessor>();
        this.baseClassProcessor = new BaseClassProcessor(hierarchy, callGraph);
        this.reporter = safeReporter;
        this.classFilter = classFilter;
        this.progressMonitor = monitor;
        this.classProcessors.add(this.baseClassProcessor);
    }

    @Override
    public void addClassProcessor(ClassProcessor cp) {
        this.classProcessors.add(cp);
    }

    public BaseClassProcessor getBaseClassProcessor() {
        return this.baseClassProcessor;
    }

    @Override
    public void process() throws CancelException {
        this.progressMonitor.beginTask(null, 10);
        IClass[] classes = this.getAcceptedClasses();
        this.progressMonitor.worked(2);
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.progressMonitor, 8);
        subMonitor.beginTask(null, classes.length);
        int i = 0;
        while (i < classes.length) {
            IClass currentClass = classes[i];
            this.reporter.process(currentClass);
            if (this.progressMonitor.isCanceled()) break;
            subMonitor.subTask("Process structural rules on class " + this.getClassName(currentClass));
            for (ClassProcessor cp : this.classProcessors) {
                cp.processProlog(currentClass);
                cp.process(currentClass);
                cp.processEpilog(currentClass);
            }
            subMonitor.worked(1);
            ++i;
        }
    }

    private IClass[] getAcceptedClasses() {
        LinkedList<IClass> classesList = new LinkedList<IClass>();
        for (IClass currentClass : this.classHierarchy) {
            if (!J2SEClassHierarchyEngine.isApplicationClass((IClass)currentClass) || !this.classFilter.test((Object)currentClass)) continue;
            classesList.add(currentClass);
        }
        return classesList.toArray(new IClass[classesList.size()]);
    }

    private String getClassName(IClass currentClass) {
        return currentClass.getName().toString().substring(1).replace('/', '.');
    }

    @Override
    public Object getResult() {
        return null;
    }
}

