/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.processors;

import com.ibm.safe.processors.InstructionProcessor;
import com.ibm.safe.processors.MethodProcessor;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.CompoundPiPolicy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.InstanceOfPiPolicy;
import com.ibm.wala.ssa.NullTestPiPolicy;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.util.CancelException;
import java.util.ArrayList;
import java.util.List;

public class BaseMethodProcessor
implements MethodProcessor {
    protected List<InstructionProcessor> instructionProcessors = new ArrayList<InstructionProcessor>();
    protected final IClassHierarchy cha;

    public BaseMethodProcessor(IClassHierarchy cha) {
        this.cha = cha;
    }

    @Override
    public void processProlog(IMethod method) {
    }

    @Override
    public void setup(IClass c, Object context) {
    }

    @Override
    public void process(IMethod method) throws CancelException {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        AnalysisOptions options = new AnalysisOptions();
        CompoundPiPolicy policy = CompoundPiPolicy.createCompoundPiPolicy((SSAPiNodePolicy)InstanceOfPiPolicy.createInstanceOfPiPolicy(), (SSAPiNodePolicy)NullTestPiPolicy.createNullTestPiPolicy());
        options.getSSAOptions().setPiNodePolicy((SSAPiNodePolicy)policy);
        IR ir = new AnalysisCacheImpl().getSSACache().findOrCreateIR(method, (Context)Everywhere.EVERYWHERE, options.getSSAOptions());
        if (ir == null) {
            return;
        }
        for (InstructionProcessor processor : this.instructionProcessors) {
            processor.setup(method, null, ir);
        }
        int i = 0;
        int size = ir.getInstructions().length;
        while (i < size) {
            SSAInstruction curr = ir.getInstructions()[i];
            if (curr != null) {
                for (InstructionProcessor ip : this.instructionProcessors) {
                    ip.processProlog(curr);
                    ip.process(curr, ir.getControlFlowGraph().getProgramCounter(i));
                    ip.processEpilog(curr);
                }
            }
            ++i;
        }
    }

    @Override
    public void processEpilog(IMethod method) {
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public void addInstructionProcessor(InstructionProcessor ip) {
        this.instructionProcessors.add(ip);
    }
}

