/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.processors;

import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.safe.processors.InstructionProcessor;
import com.ibm.safe.reporting.message.Message;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import java.util.Collection;
import java.util.Map;

public abstract class BaseInstructionProcessor
implements InstructionProcessor {
    protected IMethod method;
    protected IR ir;
    protected ObjectArrayMapping<SSAInstruction> instMapping;

    @Override
    public void setup(IMethod method, Map<Integer, SCCPValue> context, IR ir) throws CancelException {
        this.method = method;
        this.ir = ir;
        this.instMapping = new ObjectArrayMapping((Object[])ir.getInstructions());
    }

    @Override
    public abstract void processProlog(SSAInstruction var1);

    @Override
    public abstract void process(SSAInstruction var1, int var2);

    @Override
    public abstract void processEpilog(SSAInstruction var1);

    @Override
    public abstract Collection<? extends Message> getResult();

    protected int getPC(SSAInstruction inst) {
        int index = this.instMapping.getMappedIndex((Object)inst);
        int pc = this.ir.getControlFlowGraph().getProgramCounter(index);
        return pc;
    }

    protected int getInstructionIndex(SSAInstruction inst) {
        return this.instMapping.getMappedIndex((Object)inst);
    }

    public int getLineNumber(SSAInstruction inst) {
        int index = this.instMapping.getMappedIndex((Object)inst);
        int pc = this.ir.getControlFlowGraph().getProgramCounter(index);
        int lineNum = -1;
        lineNum = this.method.getLineNumber(pc);
        return lineNum;
    }

    public boolean instructionInCatchBlock(SSAInstruction inst) {
        ISSABasicBlock bb = this.ir.getBasicBlockForInstruction(inst);
        return bb.isCatchBlock();
    }
}

