/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.processors;

import com.ibm.safe.cha.J2SEClassHierarchyEngine;
import com.ibm.safe.processors.ClassProcessor;
import com.ibm.safe.processors.MethodProcessor;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import java.util.ArrayList;
import java.util.List;

public class BaseClassProcessor
implements ClassProcessor {
    private static final boolean DEBUG = false;
    protected IClassHierarchy classHierarchy;
    protected CallGraph callGraph;
    protected List<MethodProcessor> methodProcessors;

    public BaseClassProcessor(IClassHierarchy hierarchy, CallGraph callGraph) {
        this.classHierarchy = hierarchy;
        this.callGraph = callGraph;
        this.methodProcessors = new ArrayList<MethodProcessor>();
    }

    @Override
    public void processProlog(IClass klass) {
    }

    @Override
    public void processEpilog(IClass klass) {
    }

    @Override
    public void addMethodProcessor(MethodProcessor mp) {
        this.methodProcessors.add(mp);
    }

    @Override
    public void process(IClass klass) throws CancelException {
        for (MethodProcessor processor : this.methodProcessors) {
            processor.setup(klass, this.classHierarchy);
        }
        for (IMethod method : klass.getDeclaredMethods()) {
            if (!J2SEClassHierarchyEngine.isApplicationClass((IClass)method.getDeclaringClass())) continue;
            for (MethodProcessor mp : this.methodProcessors) {
                mp.processProlog(method);
                mp.process(method);
                mp.processEpilog(method);
            }
        }
    }

    @Override
    public Object getResult() {
        return null;
    }
}

