/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.lightweight.options;

import com.ibm.safe.internal.filtering.AlwaysTrueClassFilter;
import com.ibm.safe.internal.filtering.OrFilter;
import com.ibm.safe.internal.filtering.QualifiedNameFilter;
import com.ibm.safe.internal.filtering.RegularExpressionFilter;
import com.ibm.safe.lightweight.options.IStructuralOptions;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.util.Predicate;

public final class StructuralOptions
implements IStructuralOptions {
    private final Predicate<IClass> classFilter;
    private final IRule[] rules;
    private final String dumpXMLDir;
    private final boolean collectStatistics;
    private boolean pessimisticEval;
    private static final char[] REGULAR_EXP_CHARS = new char[]{'*', '[', '(', '{', '\\', '|', '?', '+'};

    public StructuralOptions(IRule[] structuralRules, String[] classFilterList, String dumpXMLDirectory, boolean shouldCollectStatistics, boolean pessimisticEval) {
        this.classFilter = this.createClassFilter(classFilterList);
        this.rules = structuralRules;
        this.dumpXMLDir = dumpXMLDirectory;
        this.collectStatistics = shouldCollectStatistics;
        this.pessimisticEval = pessimisticEval;
    }

    @Override
    public Predicate<IClass> getClassFilter() {
        return this.classFilter;
    }

    @Override
    public StructuralRule[] getRules() {
        return (StructuralRule[])this.rules;
    }

    @Override
    public String getXMLDumpingDir() {
        return this.dumpXMLDir;
    }

    private Predicate<IClass> createClassFilter(String[] classFilterList) {
        if (classFilterList.length == 0) {
            return new AlwaysTrueClassFilter();
        }
        OrFilter composedFilter = new OrFilter();
        int i = 0;
        while (i < classFilterList.length) {
            if (this.hasCharacter(classFilterList[i], REGULAR_EXP_CHARS)) {
                composedFilter.addFilter((Predicate)new RegularExpressionFilter(classFilterList[i]));
            } else {
                composedFilter.addFilter((Predicate)new QualifiedNameFilter(classFilterList[i]));
            }
            ++i;
        }
        return composedFilter;
    }

    private boolean hasCharacter(String theClass, char[] theChars) {
        int i = 0;
        while (i < theChars.length) {
            if (theClass.indexOf(theChars[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean shouldCollectStatistics() {
        return this.collectStatistics;
    }

    @Override
    public boolean shouldDumpXML() {
        return this.getXMLDumpingDir() != null;
    }

    @Override
    public boolean pessimisticEval() {
        return this.pessimisticEval;
    }
}

