/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.lightweight.options;

import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.wala.util.debug.Assertions;

public class LightweightProperties {
    public static void register() {
        PropertiesManager.registerProperties((PropertiesManager.IPropertyDescriptor[])Props.values());
        CommonProperties.register();
    }

    public static enum Props implements PropertiesManager.IPropertyDescriptor
    {
        DUMP_XML_DIRECTORY("dump_xml", PropertiesManager.Type.STRING, "Specifies that we should dump created XMLs for Java code inspected."),
        SELECT_CLASSES("select_classes", PropertiesManager.Type.STRING, "Selects a set of classes to analyze among the modules identified."),
        SELECT_STRUCTURAL_RULES("select_structural_rules", PropertiesManager.Type.STRING, "Selects a list of structural rules to apply (file name without extension XMI)."),
        PESSIMISTIC_EVAL("pessimistic_eval", PropertiesManager.Type.BOOLEAN, "Use pessimistic evaluation.");

        private final String name;
        private final boolean cmdLine;
        private final PropertiesManager.Type type;
        private final String defaultString;
        private final String description;

        private Props(String name, PropertiesManager.Type type, String description) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.cmdLine = true;
            switch (type) {
                case BOOLEAN: {
                    this.defaultString = "false";
                    break;
                }
                case INT: {
                    this.defaultString = null;
                    break;
                }
                case STRING: {
                    this.defaultString = null;
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                    this.defaultString = null;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isCommandLineOption() {
            return this.cmdLine;
        }

        public PropertiesManager.Type getType() {
            return this.type;
        }

        public String getDefaultAsString() {
            return this.defaultString;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

