/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.lightweight.controller;

import com.ibm.safe.cha.J2SEClassHierarchyEngine;
import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.lightweight.options.IStructuralOptions;
import com.ibm.safe.lightweight.options.LightWeightOptions;
import com.ibm.safe.lightweight.options.LightweightProperties;
import com.ibm.safe.lightweight.options.StructuralOptions;
import com.ibm.safe.options.CommonOptions;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.Messages;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.structural.StructuralSolver;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class StructuralSolverRunner
extends AbstractSolverRunner {
    private IRule[] rules;

    public StructuralSolverRunner(PropertiesManager properties, IRule[] structuralRules, PerformanceTracker perfoTracker, IReporter reporter) {
        super((PropertiesManager)new LightWeightOptions(properties), perfoTracker, reporter);
        this.rules = structuralRules;
    }

    public void run(IResultObserver observer, IProgressMonitor monitor) throws SafeException, SetUpException, CancelException, CoreException {
        CommonOptions commonOptions = this.getCommonOptions();
        ISafeSolver[] solvers = null;
        StructuralOptions structuralOptions = new StructuralOptions(this.rules, this.getClassFilterList(), this.getDumpXMLDirectory(), this.shouldCollectStatistics(), this.pessimisticEval());
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 5);
        try {
            if (this.getModulesCodeKind(commonOptions) == AbstractSolverRunner.CodeKind.J2SE) {
                IClassHierarchy cha = StructuralSolverRunner.createJ2SEClassHierarchy(this.getManager(), this.getPerformanceTracker(), monitor);
                solvers = StructuralSolverRunner.createSolversStatic(cha, structuralOptions.getClassFilter(), structuralOptions, this.getReporter());
            } else {
                IClassHierarchy cha = StructuralSolverRunner.createJ2EEClassHierarchy(this.getManager(), this.getPerformanceTracker(), monitor);
                solvers = StructuralSolverRunner.createSolversStatic(cha, structuralOptions.getClassFilter(), structuralOptions, this.getReporter());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        monitor.beginTask(null, 10);
        monitor.subTask(Messages.StructuralSolverRunner_ClassHierarchyConstruction);
        this.runSolvers(solvers, observer, AbstractSolverRunner.AnalysisKind.STRUCTURAL, PerformanceTracker.Stages.STRUCTURAL, (IProgressMonitor)subProgressMonitor);
    }

    protected final String[] getClassFilterList() throws PropertiesException {
        String filterCommand = this.propertiesManager.getStringValue((PropertiesManager.IPropertyDescriptor)LightweightProperties.Props.SELECT_CLASSES);
        return filterCommand == null ? new String[]{} : filterCommand.split("[,;]\\s*");
    }

    public void setRules(StructuralRule[] structuralRules) {
        this.rules = structuralRules;
    }

    public String toString() {
        return "Structural";
    }

    private String getDumpXMLDirectory() throws PropertiesException {
        return this.getManager().getStringValue(LightweightProperties.Props.DUMP_XML_DIRECTORY);
    }

    protected final boolean pessimisticEval() throws PropertiesException {
        return this.propertiesManager.getBooleanValue((PropertiesManager.IPropertyDescriptor)LightweightProperties.Props.PESSIMISTIC_EVAL);
    }

    public static ISafeSolver[] createSolversStatic(IClassHierarchy cha, Predicate<IClass> classFilter, IStructuralOptions sOptions, IReporter reporter) {
        return new ISafeSolver[]{new StructuralSolver(cha, classFilter, null, null, sOptions, reporter)};
    }

    public static IClassHierarchy createJ2SEClassHierarchy(LightWeightOptions analysisOptions, PerformanceTracker perfoTracker, IProgressMonitor monitor) throws SafeException {
        J2SEClassHierarchyEngine x = new J2SEClassHierarchyEngine((CommonOptions)analysisOptions, perfoTracker, monitor);
        return x.buildClassHierarchy();
    }

    public static IClassHierarchy createJ2EEClassHierarchy(LightWeightOptions analysisOptions, PerformanceTracker perfoTracker, IProgressMonitor monitor) throws PropertiesException {
        return null;
    }

    protected LightWeightOptions getManager() {
        return (LightWeightOptions)this.propertiesManager;
    }
}

