/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.lightweight.controller;

import com.ibm.safe.controller.AbstractSafeController;
import com.ibm.safe.controller.BasicResultObserver;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.runners.CompositeSolverRunner;
import com.ibm.safe.lightweight.controller.LightweightRulesManager;
import com.ibm.safe.lightweight.controller.StructuralSolverRunner;
import com.ibm.safe.lightweight.options.LightWeightOptions;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.runners.ISolverRunner;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.util.CancelException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class LightweightController
extends AbstractSafeController {
    public static final String NO_SOLVER_OPTIONS = "No solver options have been identified.\nAt least one structural or typestate option and rule should be activated.";
    protected static final String VERSION_PROPERTIES_FILE = "com/ibm/safe/version.properties";

    public LightweightController(PropertiesManager thePropertiesManager) {
        super(thePropertiesManager);
    }

    public void execute(IRule[] rules, IReporter reporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        if (rules == null || rules.length == 0) {
            throw new SetUpException("No SAFE rules have been provided.");
        }
        CompositeSolverRunner solverRunner = new CompositeSolverRunner();
        PerformanceTracker perfoTracker = this.shouldUsePerfomanceTracker() ? new PerformanceTracker("Safe engine tracking report\n", PerformanceTracker.Kind.GLOBAL) : null;
        LightweightRulesManager lwRulesManager = new LightweightRulesManager(rules);
        lwRulesManager.applyFilters(this.propertiesManager);
        StructuralRule[] structuralRules = lwRulesManager.getStructuralRules();
        this.reportStructuralRulesActivated(reporter, structuralRules);
        if (this.hasStructuralOptionsActivated() && structuralRules.length > 0) {
            LightWeightOptions lwo = new LightWeightOptions(this.propertiesManager);
            solverRunner.addSolverRunner((ISolverRunner)new StructuralSolverRunner((PropertiesManager)lwo, (IRule[])structuralRules, perfoTracker, reporter));
        }
        if (solverRunner.isEmpty()) {
            throw new SetUpException(NO_SOLVER_OPTIONS);
        }
        this.execute(solverRunner, perfoTracker, reporter, reporter, monitor);
    }

    protected void execute(CompositeSolverRunner solverRunner, PerformanceTracker perfoTracker, IReporter originalReporter, IReporter realReporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        try {
            try {
                if (this.shouldCreateDomoReport()) {
                    Trace.setTraceFile((String)this.propertiesManager.getStringValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.DOMO_REPORT));
                }
                if (this.isVerboseMode()) {
                    this.displaySafeVersion(realReporter);
                }
                BasicResultObserver resultObserver = new BasicResultObserver(realReporter);
                monitor.beginTask(null, 1);
                solverRunner.run((IResultObserver)resultObserver, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                originalReporter.reportNumberOfFindings(resultObserver.getNumberOfFindings());
            }
            catch (SafeException except) {
                realReporter.reportException((Throwable)except);
                throw except;
            }
        }
        finally {
            if (perfoTracker != null) {
                realReporter.reportPerformanceTracking(perfoTracker);
            }
            try {
                realReporter.produceFinalReport();
            }
            catch (Exception except) {
                except.printStackTrace();
                SafeLogger.severe((String)"Unable to create XML report.", (Throwable)except);
            }
        }
    }

    protected void reportStructuralRulesActivated(IReporter reporter, StructuralRule[] structuralRules) throws SetUpException {
        if (structuralRules.length == 0) {
            throw new SetUpException("No SAFE rules have been activated.");
        }
        this.reportRulesActivated(reporter, (IRule[])structuralRules);
    }

    protected void reportRulesActivated(IReporter reporter, IRule[] rules) {
        int i = 0;
        while (i < rules.length) {
            reporter.reportRuleLoading(rules[i]);
            ++i;
        }
        if (rules.length > 0) {
            reporter.reportNumberOfRulesActivated(rules.length);
        }
    }
}

