/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.safe.intraproc.sccp.SCCPBooleanValue;
import com.ibm.safe.intraproc.sccp.SCCPBottomValue;
import com.ibm.safe.intraproc.sccp.SCCPIntegerValue;
import com.ibm.safe.intraproc.sccp.SCCPNullValue;
import com.ibm.safe.intraproc.sccp.SCCPObjectValue;
import com.ibm.safe.intraproc.sccp.SCCPStringValue;
import com.ibm.safe.intraproc.sccp.SCCPTopValue;

public abstract class SCCPValue {
    public static final SCCPBottomValue BOTTOM = SCCPBottomValue.instance();
    public static final SCCPTopValue TOP = SCCPTopValue.instance();
    public static final SCCPNullValue NULL = SCCPNullValue.instance();
    protected final Object value;

    public static SCCPValue createValue(Object val) {
        if (val == null) {
            return NULL;
        }
        if (val instanceof String) {
            return new SCCPStringValue(val);
        }
        if (val instanceof Integer) {
            return new SCCPIntegerValue(val);
        }
        if (val instanceof Boolean) {
            return new SCCPBooleanValue(val);
        }
        return new SCCPObjectValue(val);
    }

    public static SCCPValue createValue(int val) {
        return new SCCPIntegerValue(new Integer(val));
    }

    public static SCCPValue createValue(boolean val) {
        return new SCCPBooleanValue(val);
    }

    public abstract SCCPValue copy();

    protected SCCPValue(Object val) {
        this.value = val;
    }

    protected SCCPValue(Object val, boolean b) {
        this.value = val;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "#null";
    }

    public SCCPValue join(SCCPValue other) {
        assert (other != null) : "cannot join with null";
        if (this.equals(other)) {
            return this.copy();
        }
        if (this.equals(BOTTOM)) {
            return other.copy();
        }
        if (other.equals(BOTTOM)) {
            return this.copy();
        }
        return TOP;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SCCPValue)) {
            return false;
        }
        SCCPValue otherValue = (SCCPValue)other;
        if (this.value == null) {
            return otherValue.value == null;
        }
        return this.value.equals(otherValue.value);
    }

    public SCCPValue evaluateBinaryOp(SCCPValue rhs2) {
        return TOP;
    }

    public boolean isNullConstant() {
        return this == NULL;
    }

    public boolean isStringConstant() {
        return this.value != null && this.value instanceof String;
    }

    public boolean isIntConstant() {
        return this.value != null && this.value instanceof Integer;
    }

    public boolean isBooleanConstant() {
        return this.value != null && this.value instanceof Boolean;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

