/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.safe.intraproc.sccp.ExpandedControlFlowGraph;
import com.ibm.safe.intraproc.sccp.SCCPBooleanValue;
import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.safe.intraproc.sccp.SCCPVariable;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Deprecated
public class SCCPSolver {
    protected static final boolean DEBUG = false;
    private static final MutableIntSet EMPTY_INTSET = MutableSparseIntSet.makeEmpty();
    private IR ir;
    private ExpandedControlFlowGraph cfg;
    private BitVectorIntSet trueCaseEdges = new BitVectorIntSet();
    protected SymbolTable st;
    protected IVariable[] vars;
    protected BitVectorIntSet flowWorkList;
    protected BitVectorIntSet ssaWorkList;
    private BitVectorIntSet execFlag;
    private BitVectorIntSet edges = new BitVectorIntSet();
    private Map<Integer, BitVectorIntSet> incomingEdges = HashMapFactory.make();
    private Map<Integer, BitVectorIntSet> outgoingCFGEdges = HashMapFactory.make();
    private Map<Integer, BitVectorIntSet> outgoingSSAEdges = HashMapFactory.make();
    private DefUse defUse;
    private ExpressionInstructionVisitor evalVisitor;
    private EdgeDictionary edgeDictionary;

    public SCCPSolver(IR ir) {
        assert (ir != null);
        this.ir = ir;
        this.cfg = new ExpandedControlFlowGraph(ir);
        this.edgeDictionary = new EdgeDictionary();
        this.defUse = new DefUse(ir);
        this.st = ir.getSymbolTable();
        SCCPSolver sCCPSolver = this;
        sCCPSolver.getClass();
        this.init(ir, sCCPSolver.new SCCPVarFactory());
        this.evalVisitor = new ExpressionInstructionVisitor();
    }

    protected void init(IR ir, SSAInference.VariableFactory varFactory) {
        this.createVariables(varFactory);
        this.createEdges();
        this.initializeVariables();
    }

    protected BitVectorIntSet findOrCreateSet(Map<Integer, BitVectorIntSet> m, Integer key) {
        BitVectorIntSet result = m.get(key);
        if (result == null) {
            result = new BitVectorIntSet();
            m.put(key, result);
        }
        return result;
    }

    private int addEdge(int src, int dest, boolean isCFG) {
        int newEdge = this.edgeDictionary.createEdge(src, dest, isCFG);
        this.edges.add(newEdge);
        BitVectorIntSet incoming = this.findOrCreateSet(this.incomingEdges, dest);
        incoming.add(newEdge);
        if (isCFG) {
            BitVectorIntSet outgoing = this.findOrCreateSet(this.outgoingCFGEdges, src);
            outgoing.add(newEdge);
        } else {
            BitVectorIntSet outgoing = this.findOrCreateSet(this.outgoingSSAEdges, src);
            outgoing.add(newEdge);
        }
        return newEdge;
    }

    protected void createEdges() {
        Iterator<ISSABasicBlock> it = this.cfg.iterator();
        while (it.hasNext()) {
            ExpandedControlFlowGraph.SingleInstructionBasicBlock srcNode = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)it.next();
            int src = srcNode.getNumber();
            Iterator<ISSABasicBlock> destIt = this.cfg.getSuccNodes(srcNode);
            while (destIt.hasNext()) {
                ExpandedControlFlowGraph.SingleInstructionBasicBlock destNode = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)destIt.next();
                int dest = destNode.getNumber();
                Assertions.productionAssertion((src < this.cfg.getNumberOfNodes() && dest < this.cfg.getNumberOfNodes() ? 1 : 0) != 0);
                int newEdge = this.addEdge(src, dest, true);
                SSAInstruction srcInst = srcNode.getInstruction();
                if (!(srcInst instanceof SSAConditionalBranchInstruction) || this.cfg.isFallThroughTarget((IBasicBlock)srcNode, (IBasicBlock)destNode)) continue;
                this.trueCaseEdges.add(newEdge);
            }
        }
        int mvn = this.st.getMaxValueNumber();
        int i = 0;
        while (i <= mvn) {
            SSAInstruction defInst = this.defUse.getDef(i);
            if (defInst != null) {
                ExpandedControlFlowGraph.SingleInstructionBasicBlock defBlock = this.cfg.getInstructionBlock(defInst);
                Iterator it2 = this.defUse.getUses(i);
                while (it2.hasNext()) {
                    SSAInstruction useInst = (SSAInstruction)it2.next();
                    ExpandedControlFlowGraph.SingleInstructionBasicBlock useBlock = this.cfg.getInstructionBlock(useInst);
                    int def = defBlock.getNumber();
                    int use = useBlock.getNumber();
                    Assertions.productionAssertion((def < this.cfg.getNumberOfNodes() && use < this.cfg.getNumberOfNodes() ? 1 : 0) != 0);
                    this.addEdge(def, use, false);
                }
            }
            ++i;
        }
    }

    protected void initialize() {
        this.flowWorkList = new BitVectorIntSet();
        this.ssaWorkList = new BitVectorIntSet();
        this.execFlag = new BitVectorIntSet();
        ExpandedControlFlowGraph.SingleInstructionBasicBlock entryBlock = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)this.cfg.entry();
        int src = entryBlock.getNumber();
        Iterator<ISSABasicBlock> it = this.cfg.getSuccNodes(entryBlock);
        while (it.hasNext()) {
            ExpandedControlFlowGraph.SingleInstructionBasicBlock destBlock = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)it.next();
            int dest = destBlock.getNumber();
            int edge = this.edgeDictionary.createEdge(src, dest, true);
            this.flowWorkList.add(edge);
        }
        for (SSAInstruction inst : this.cfg.getAllInstructions()) {
            int defNum;
            if (inst == null || !inst.hasDef() || (defNum = inst.getDef()) == -1) continue;
            this.setValue(defNum, SCCPValue.BOTTOM);
        }
    }

    private int selectAndRemove(BitVectorIntSet bv) {
        IntIterator it = bv.intIterator();
        int edgeId = it.next();
        bv.remove(edgeId);
        return edgeId;
    }

    public void solve() {
        this.initialize();
        while (!this.flowWorkList.isEmpty() || !this.ssaWorkList.isEmpty()) {
            SSAPhiInstruction phi;
            SSAInstruction destInst;
            ExpandedControlFlowGraph.SingleInstructionBasicBlock destBlock;
            int b;
            Edge edge;
            int e;
            if (!this.flowWorkList.isEmpty()) {
                e = this.selectAndRemove(this.flowWorkList);
                edge = this.edgeDictionary.get(e);
                assert (edge != null);
                b = edge.dest;
                assert (b >= 0);
                if (!this.execFlag.contains(e)) {
                    this.execFlag.add(e);
                    destBlock = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)this.cfg.getNode(b);
                    destInst = destBlock.getInstruction();
                    if (destInst instanceof SSAPhiInstruction) {
                        phi = (SSAPhiInstruction)destInst;
                        this.visitPhi(b, phi);
                    } else if (this.singleEdge(b)) {
                        this.visitInst(b, destInst);
                    }
                }
            }
            if (this.ssaWorkList.isEmpty()) continue;
            e = this.selectAndRemove(this.ssaWorkList);
            edge = this.edgeDictionary.get(e);
            assert (edge != null);
            b = edge.dest;
            Assertions.productionAssertion((b >= 0 && b < this.cfg.getNumberOfNodes() ? 1 : 0) != 0);
            destBlock = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)this.cfg.getNode(b);
            destInst = destBlock.getInstruction();
            if (destInst instanceof SSAPhiInstruction) {
                phi = (SSAPhiInstruction)destInst;
                this.visitPhi(b, phi);
                continue;
            }
            if (!this.hasEdge(b)) continue;
            this.visitInst(b, destInst);
        }
    }

    protected void printSolution() {
    }

    public Map<Integer, SCCPValue> getConstantValues() {
        HashMap result = HashMapFactory.make();
        for (SSAInstruction inst : this.cfg.getAllInstructions()) {
            int defNum;
            if (inst == null || !inst.hasDef() || (defNum = inst.getDef()) == -1) continue;
            result.put(new Integer(defNum), this.getValue(defNum));
        }
        int maxVal = this.st.getMaxValueNumber();
        int i = 0;
        while (i <= maxVal) {
            Value val = this.st.getValue(i);
            if (val != null && val instanceof ConstantValue) {
                ConstantValue cVal = (ConstantValue)val;
                if (cVal.isNullConstant()) {
                    result.put(new Integer(i), SCCPValue.createValue(null));
                } else {
                    Object value = cVal.getValue();
                    if (value != null) {
                        result.put(new Integer(i), SCCPValue.createValue(value));
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected SCCPValue join(SCCPValue lhs, SCCPValue rhs) {
        return lhs.join(rhs);
    }

    protected void visitPhi(int b, SSAPhiInstruction phi) {
        int lhs = phi.getDef();
        int uses = phi.getNumberOfUses();
        SCCPValue lhsVal = this.getValue(lhs).copy();
        int j = 0;
        while (j < uses) {
            SCCPValue currVal;
            int currUse = phi.getUse(j);
            if (currUse != -1 && (currVal = this.getValue(currUse)) != null && lhsVal != null) {
                lhsVal = this.join(lhsVal, currVal);
            }
            ++j;
        }
        if (!lhsVal.equals(this.getValue(lhs))) {
            this.setValue(lhs, lhsVal);
            if (this.getValue(lhs).equals(lhsVal)) {
                this.ssaWorkList.addAll((IntSet)this.getSSASuccessors(b));
            }
        }
        this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
    }

    protected void visitInst(int b, SSAInstruction inst) {
        block9: {
            IntIterator it;
            MutableIntSet cfgSucc;
            block10: {
                SCCPValue val;
                block8: {
                    int defNum;
                    if (inst == null) {
                        this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
                        return;
                    }
                    val = this.latticeEvaluate(inst);
                    this.checkInstruction(inst);
                    if (val == null) {
                        this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
                    } else if (inst.hasDef() && (defNum = inst.getDef()) != -1) {
                        SCCPValue lhsVal = this.getValue(defNum);
                        Assertions.productionAssertion((lhsVal != null ? 1 : 0) != 0, (String)"got null constant");
                        if (!val.equals(lhsVal)) {
                            lhsVal = lhsVal.join(val);
                            this.setValue(defNum, lhsVal);
                            this.ssaWorkList.addAll((IntSet)this.getSSASuccessors(b));
                        }
                    }
                    if (val != SCCPValue.TOP) break block8;
                    this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
                    break block9;
                }
                if (val == SCCPValue.BOTTOM) break block9;
                cfgSucc = this.getCFGSuccessors(b);
                if (cfgSucc.size() <= 1) break block10;
                it = cfgSucc.intIterator();
                while (it.hasNext()) {
                    int edge = it.next();
                    if (val instanceof SCCPBooleanValue) {
                        SCCPBooleanValue bVal = (SCCPBooleanValue)val;
                        boolean boolVal = bVal.getBooleanValue();
                        if ((!boolVal || !this.trueCaseEdges.contains(edge)) && (boolVal || this.trueCaseEdges.contains(edge))) continue;
                        this.flowWorkList.add(edge);
                        continue;
                    }
                    this.flowWorkList.add(edge);
                }
                break block9;
            }
            if (cfgSucc.size() != 1) break block9;
            it = cfgSucc.intIterator();
            while (it.hasNext()) {
                int edge = it.next();
                this.flowWorkList.add(edge);
            }
        }
    }

    protected void checkInstruction(SSAInstruction inst) {
    }

    protected MutableIntSet getSSASuccessors(int node) {
        MutableIntSet result = (MutableIntSet)this.outgoingSSAEdges.get(node);
        return result != null ? result : EMPTY_INTSET;
    }

    protected MutableIntSet getCFGSuccessors(int node) {
        MutableIntSet result = (MutableIntSet)this.outgoingCFGEdges.get(node);
        return result != null ? result : EMPTY_INTSET;
    }

    protected SCCPValue latticeEvaluate(SSAInstruction inst) {
        this.evalVisitor.init();
        inst.visit((SSAInstruction.IVisitor)this.evalVisitor);
        return this.evalVisitor.getResult();
    }

    private boolean singleEdge(int b) {
        int count = 0;
        MutableIntSet incoming = (MutableIntSet)this.incomingEdges.get(b);
        IntIterator it = incoming.intIterator();
        while (it.hasNext()) {
            int e = it.next();
            if (!this.execFlag.contains(e) || ++count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    private boolean hasEdge(int b) {
        MutableIntSet incoming = (MutableIntSet)this.incomingEdges.get(b);
        IntIterator it = incoming.intIterator();
        while (it.hasNext()) {
            int e = it.next();
            if (!this.execFlag.contains(e)) continue;
            return true;
        }
        return false;
    }

    private void createVariables(SSAInference.VariableFactory factory) {
        this.vars = new IVariable[this.st.getMaxValueNumber() + 1];
        int i = 1;
        while (i < this.vars.length) {
            this.vars[i] = factory.makeVariable(i);
            ++i;
        }
    }

    protected SCCPVariable getVariable(int valueNumber) {
        assert (this.vars != null) : "null vars array";
        return (SCCPVariable)this.vars[valueNumber];
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Type inference : \n");
        int i = 0;
        while (i < this.vars.length) {
            result.append("v").append(i).append("  ").append(this.vars[i]).append("\n");
            ++i;
        }
        return result.toString();
    }

    protected void initializeVariables() {
        int maxValNum = this.st.getMaxValueNumber();
        int i = 1;
        while (i <= maxValNum) {
            SCCPVariable v = this.getVariable(i);
            if (this.st.isParameter(i)) {
                v.setValue(SCCPValue.TOP);
            } else {
                Value val = this.st.getValue(i);
                if (val == null) {
                    v.setValue(SCCPValue.BOTTOM);
                } else if (val instanceof ConstantValue) {
                    ConstantValue cval = (ConstantValue)val;
                    Object theValue = cval.getValue();
                    v.setValue(theValue);
                }
            }
            ++i;
        }
    }

    public SCCPValue getValue(int valueNumber) {
        assert (this.getVariable(valueNumber) != null) : "null variable for value number " + valueNumber;
        return this.getVariable(valueNumber).getValue();
    }

    public void setValue(int valueNumber, SCCPValue val) {
        assert (this.getVariable(valueNumber) != null) : "null variable for value number " + valueNumber;
        this.getVariable(valueNumber).setValue(val);
    }

    public static class Edge {
        public int src;
        public int dest;
        public boolean isCFG;

        public Edge(int src, int dest, boolean isCFG) {
            this.src = src;
            this.dest = dest;
            this.isCFG = isCFG;
        }

        public boolean isCFG() {
            return this.isCFG;
        }

        public boolean isSSA() {
            return !this.isCFG;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge otherEdge = (Edge)other;
            return otherEdge.src == this.src && otherEdge.dest == this.dest && otherEdge.isCFG == this.isCFG;
        }

        public int hashCode() {
            return 31 * this.src + this.dest;
        }

        public String toString() {
            return "(" + this.src + "," + this.dest + "," + (this.isCFG ? "CFG" : "SSA") + ")";
        }
    }

    public static final class EdgeDictionary {
        protected Map<Edge, Integer> edge2int = HashMapFactory.make();
        protected Map<Integer, Edge> int2edge = HashMapFactory.make();
        private int id = 0;

        public int createEdge(int src, int dest, boolean isCFG) {
            Edge newEdge = new Edge(src, dest, isCFG);
            Integer key = this.edge2int.get(newEdge);
            if (key == null) {
                key = new Integer(this.id++);
                this.edge2int.put(newEdge, key);
                this.int2edge.put(key, newEdge);
            }
            return key;
        }

        public Edge get(int edgeId) {
            return this.int2edge.get(edgeId);
        }
    }

    public class ExpressionInstructionVisitor
    extends SSAInstruction.Visitor {
        private SCCPValue result = SCCPValue.TOP;

        public void init() {
            this.result = SCCPValue.TOP;
        }

        public SCCPValue getResult() {
            return this.result;
        }

        public void visitGoto(SSAGotoInstruction instruction) {
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        }

        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            int rhs1 = instruction.getUse(0);
            SCCPValue rhs1ProgramValue = this.getConstantValue(rhs1);
            if (rhs1ProgramValue != null) {
                this.result = rhs1ProgramValue;
            }
        }

        public void visitConversion(SSAConversionInstruction instruction) {
        }

        public void visitComparison(SSAComparisonInstruction instruction) {
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            int rhs1 = instruction.getUse(0);
            int rhs2 = instruction.getUse(1);
            IConditionalBranchInstruction.IOperator operator = instruction.getOperator();
            SCCPValue rhs1Value = SCCPSolver.this.getValue(rhs1);
            SCCPValue rhs2Value = SCCPSolver.this.getValue(rhs2);
            this.result = rhs1Value == SCCPValue.TOP || rhs2Value == SCCPValue.TOP ? SCCPValue.TOP : (rhs1Value != null && rhs2Value != null && rhs2Value != SCCPValue.TOP || rhs2Value != SCCPValue.TOP ? this.evaluateConditionalBranch(rhs1Value, rhs2Value, operator) : SCCPValue.TOP);
        }

        public void visitSwitch(SSASwitchInstruction instruction) {
        }

        public void visitReturn(SSAReturnInstruction instruction) {
        }

        public void visitGet(SSAGetInstruction instruction) {
            instruction.isStatic();
        }

        public void visitPut(SSAPutInstruction instruction) {
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
        }

        public void visitNew(SSANewInstruction instruction) {
        }

        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
        }

        public void visitThrow(SSAThrowInstruction instruction) {
        }

        public void visitMonitor(SSAMonitorInstruction instruction) {
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
        }

        public void visitInstanceof(SSAInstanceofInstruction instruction) {
        }

        public void visitPhi(SSAPhiInstruction instruction) {
        }

        public void visitPi(SSAPiInstruction instruction) {
            SCCPValue piRhsConstant;
            int piLhs = instruction.getDef();
            int piRhs = instruction.getVal();
            SCCPValue piRhsProgramValue = this.getConstantValue(piRhs);
            SCCPValue sCCPValue = piRhsConstant = piRhsProgramValue != null ? piRhsProgramValue : SCCPSolver.this.getValue(piRhs);
            if (piRhsConstant != null && piRhsConstant != SCCPValue.TOP && piRhsConstant != SCCPValue.BOTTOM) {
                SCCPSolver.this.setValue(piLhs, piRhsConstant);
                this.result = SCCPSolver.this.getValue(piLhs);
                return;
            }
            SSAInstruction cause = instruction.getCause();
            if (cause instanceof SSAConditionalBranchInstruction) {
                SSAConditionalBranchInstruction cond = (SSAConditionalBranchInstruction)cause;
                IConditionalBranchInstruction.IOperator operator = cond.getOperator();
                boolean isTruePi = SCCPSolver.this.cfg.getTrueCasePiInstructions().contains(instruction);
                int rhs1 = cause.getUse(0);
                int rhs2 = cause.getUse(1);
                Assertions.productionAssertion((rhs1 == piRhs || rhs2 == piRhs ? 1 : 0) != 0, (String)"cause condition does not contain pi variable");
                SCCPValue rhs1ProgramValue = this.getConstantValue(rhs1);
                SCCPValue rhs2ProgramValue = this.getConstantValue(rhs2);
                SCCPValue rhs1Constant = rhs1ProgramValue != null ? rhs1ProgramValue : SCCPSolver.this.getValue(rhs1);
                SCCPValue rhs2Constant = rhs2ProgramValue != null ? rhs2ProgramValue : SCCPSolver.this.getValue(rhs2);
                boolean rhs1IsConstant = rhs1Constant != null && rhs1Constant != SCCPValue.TOP && rhs1Constant != SCCPValue.BOTTOM;
                boolean rhs2IsConstant = rhs2Constant != null && rhs2Constant != SCCPValue.TOP && rhs2Constant != SCCPValue.BOTTOM;
                SCCPValue constant = null;
                if (rhs1IsConstant && rhs2IsConstant || !rhs1IsConstant && !rhs2IsConstant) {
                    this.result = null;
                    return;
                }
                if (rhs1IsConstant && !rhs2IsConstant) {
                    constant = rhs1Constant;
                } else if (!rhs1IsConstant && rhs2IsConstant) {
                    constant = rhs2Constant;
                }
                Assertions.productionAssertion((constant != null ? 1 : 0) != 0, (String)"got null constant");
                switch ((IConditionalBranchInstruction.Operator)operator) {
                    case EQ: {
                        if (isTruePi) {
                            SCCPSolver.this.setValue(piLhs, constant);
                            break;
                        }
                        SCCPSolver.this.setValue(piLhs, SCCPValue.TOP);
                        break;
                    }
                    case NE: {
                        if (!isTruePi) {
                            SCCPSolver.this.setValue(piLhs, constant);
                            break;
                        }
                        SCCPSolver.this.setValue(piLhs, SCCPValue.TOP);
                    }
                }
                this.result = SCCPSolver.this.getValue(piLhs);
            }
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        }

        private SCCPValue getConstantValue(int valNumber) {
            SCCPValue result = null;
            Value value = SCCPSolver.this.st.getValue(valNumber);
            if (value != null && value instanceof ConstantValue) {
                ConstantValue constVal = (ConstantValue)value;
                result = SCCPValue.createValue(constVal.getValue());
            }
            return result;
        }

        private SCCPValue evaluateConditionalBranch(SCCPValue op1, SCCPValue op2, IConditionalBranchInstruction.IOperator operator) {
            switch ((IConditionalBranchInstruction.Operator)operator) {
                case EQ: {
                    boolean outcome = op1.equals(op2);
                    return SCCPValue.createValue(outcome);
                }
                case NE: {
                    return SCCPValue.createValue(!op1.equals(op2));
                }
            }
            return SCCPValue.TOP;
        }
    }

    private class SCCPVarFactory
    implements SSAInference.VariableFactory {
        private SCCPVarFactory() {
        }

        public IVariable makeVariable(int valueNumber) {
            return new SCCPVariable(valueNumber, SCCPValue.BOTTOM, 797 * valueNumber);
        }
    }
}

