/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.util.debug.Assertions;

public class SCCPIntegerValue
extends SCCPValue {
    private static final int DEBUG_LEVEL = 0;

    protected SCCPIntegerValue(Object val) {
        super(val);
        Assertions.productionAssertion((val != null ? 1 : 0) != 0);
    }

    public Integer getIntegerValue() {
        return (Integer)this.value;
    }

    @Override
    public SCCPValue copy() {
        return new SCCPIntegerValue(this.value);
    }

    public SCCPValue evaluateBinaryOp(SCCPValue rhs2, IBinaryOpInstruction.Operator operator) {
        int result;
        if (rhs2 == null) {
            return SCCPValue.TOP;
        }
        SCCPIntegerValue rhs2int = (SCCPIntegerValue)rhs2;
        int rhs1Val = this.getIntegerValue();
        int rhs2Val = rhs2int.getIntegerValue();
        switch (operator) {
            case ADD: {
                result = rhs1Val + rhs2Val;
                break;
            }
            case SUB: {
                result = rhs1Val - rhs2Val;
                break;
            }
            case MUL: {
                result = rhs1Val * rhs2Val;
                break;
            }
            default: {
                return SCCPValue.TOP;
            }
        }
        SCCPValue resultValue = SCCPValue.createValue(result);
        return resultValue;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SCCPIntegerValue)) {
            return false;
        }
        SCCPIntegerValue otherValue = (SCCPIntegerValue)other;
        return this.getIntegerValue().equals(otherValue.getIntegerValue());
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

