/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.safe.intraproc.sccp.ExplodedCFGDotWriter;
import com.ibm.safe.intraproc.sccp.SCCPBooleanValue;
import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.safe.intraproc.sccp.SCCPVariable;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NewSCCPSolver {
    protected static final boolean DEBUG = false;
    private static final MutableIntSet EMPTY_INTSET = MutableSparseIntSet.makeEmpty();
    private IR ir;
    private ExplodedControlFlowGraph cfg;
    private BitVectorIntSet trueCaseEdges = new BitVectorIntSet();
    protected SymbolTable st;
    protected IVariable[] vars;
    protected BitVectorIntSet flowWorkList;
    protected BitVectorIntSet ssaWorkList;
    private BitVectorIntSet execFlag;
    private BitVectorIntSet edges = new BitVectorIntSet();
    private Map<Integer, BitVectorIntSet> incomingEdges = HashMapFactory.make();
    private Map<Integer, BitVectorIntSet> outgoingCFGEdges = HashMapFactory.make();
    private Map<Integer, BitVectorIntSet> outgoingSSAEdges = HashMapFactory.make();
    private DefUse defUse;
    private ExpressionInstructionVisitor evalVisitor;
    private EdgeDictionary edgeDictionary;
    private Map<SSAInstruction, ISSABasicBlock> instruction2block = HashMapFactory.make();
    private Map<SSAInstruction, ISSABasicBlock> instruction2Oldblock = HashMapFactory.make();
    private final Set<SSAPiInstruction> trueCasePiInstructions = HashSetFactory.make();

    public NewSCCPSolver(IR ir) {
        assert (ir != null);
        this.ir = ir;
        this.cfg = ExplodedControlFlowGraph.make((IR)ir);
        this.initBlockTable((ControlFlowGraph<SSAInstruction, ? extends ISSABasicBlock>)this.cfg, this.instruction2block);
        this.initBlockTable((ControlFlowGraph<SSAInstruction, ? extends ISSABasicBlock>)ir.getControlFlowGraph(), this.instruction2Oldblock);
        this.edgeDictionary = new EdgeDictionary();
        this.defUse = new DefUse(ir);
        this.st = ir.getSymbolTable();
        NewSCCPSolver newSCCPSolver = this;
        newSCCPSolver.getClass();
        this.init(ir, newSCCPSolver.new SCCPVarFactory());
        this.evalVisitor = new ExpressionInstructionVisitor();
    }

    private void initBlockTable(ControlFlowGraph<SSAInstruction, ? extends ISSABasicBlock> cfg, Map<SSAInstruction, ISSABasicBlock> map) {
        for (ISSABasicBlock bb : cfg) {
            if (bb instanceof IExplodedBasicBlock) {
                SSAInstruction inst = ((IExplodedBasicBlock)bb).getInstruction();
                if (inst != null) {
                    map.put(inst, bb);
                }
            } else {
                for (SSAInstruction inst : bb) {
                    if (inst == null) continue;
                    map.put(inst, bb);
                }
            }
            Iterator piIt = bb.iteratePis();
            while (piIt.hasNext()) {
                SSAPiInstruction currPi = (SSAPiInstruction)piIt.next();
                if (currPi == null) continue;
                map.put((SSAInstruction)currPi, bb);
            }
            Iterator phiIt = bb.iteratePhis();
            while (phiIt.hasNext()) {
                SSAPhiInstruction currPhi = (SSAPhiInstruction)phiIt.next();
                if (currPhi == null) continue;
                map.put((SSAInstruction)currPhi, bb);
            }
        }
    }

    public void dumpDotFiles() {
        ExplodedCFGDotWriter.write("c:/temp/original.dt", this.ir.getControlFlowGraph());
        ExplodedCFGDotWriter.write("c:/temp/expanded.dt", this.cfg);
    }

    protected void init(IR ir, SSAInference.VariableFactory varFactory) {
        this.createVariables(varFactory);
        this.createEdges();
        this.initializeVariables();
    }

    private void dumpDotFile(ExplodedControlFlowGraph cfg2) {
    }

    protected BitVectorIntSet findOrCreateSet(Map<Integer, BitVectorIntSet> m, Integer key) {
        BitVectorIntSet result = m.get(key);
        if (result == null) {
            result = new BitVectorIntSet();
            m.put(key, result);
        }
        return result;
    }

    private int addEdge(int src, int dest, boolean isCFG) {
        int newEdge = this.edgeDictionary.createEdge(src, dest, isCFG);
        this.edges.add(newEdge);
        BitVectorIntSet incoming = this.findOrCreateSet(this.incomingEdges, dest);
        incoming.add(newEdge);
        if (isCFG) {
            BitVectorIntSet outgoing = this.findOrCreateSet(this.outgoingCFGEdges, src);
            outgoing.add(newEdge);
        } else {
            BitVectorIntSet outgoing = this.findOrCreateSet(this.outgoingSSAEdges, src);
            outgoing.add(newEdge);
        }
        return newEdge;
    }

    protected void createEdges() {
        for (IExplodedBasicBlock srcNode : this.cfg) {
            int src = srcNode.getNumber();
            Iterator destIt = this.cfg.getSuccNodes(srcNode);
            while (destIt.hasNext()) {
                IExplodedBasicBlock takenDest;
                IExplodedBasicBlock destNode = (IExplodedBasicBlock)destIt.next();
                int dest = destNode.getNumber();
                Assertions.productionAssertion((src < this.cfg.getNumberOfNodes() && dest < this.cfg.getNumberOfNodes() ? 1 : 0) != 0);
                if (src == dest) continue;
                int newEdge = this.addEdge(src, dest, true);
                SSAInstruction srcInst = srcNode.getInstruction();
                if (!(srcInst instanceof SSAConditionalBranchInstruction)) continue;
                SSACFG origCFG = this.ir.getControlFlowGraph();
                ISSABasicBlock origBlock = this.instruction2Oldblock.get(srcInst);
                if (origBlock != null && Util.endsWithConditionalBranch((ControlFlowGraph)origCFG, (IBasicBlock)origBlock) && this.hasTakenSuccessor((ControlFlowGraph)origCFG, (IBasicBlock)origBlock)) {
                    ISSABasicBlock origTaken = (ISSABasicBlock)Util.getTakenSuccessor((ControlFlowGraph)origCFG, (IBasicBlock)origBlock);
                    int takenNumber = origTaken.getNumber();
                    Iterator piIterator = srcNode.iteratePis();
                    while (piIterator.hasNext()) {
                        SSAPiInstruction currPi = (SSAPiInstruction)piIterator.next();
                        int successorBlockNumber = currPi.getSuccessor();
                        if (takenNumber != successorBlockNumber) continue;
                        Trace.println((String)("added trueCasePi: " + currPi));
                        this.trueCasePiInstructions.add(currPi);
                    }
                }
                if (!this.hasTakenSuccessor((ControlFlowGraph)this.cfg, (IBasicBlock)srcNode) || (takenDest = (IExplodedBasicBlock)Util.getTakenSuccessor((ControlFlowGraph)this.cfg, (IBasicBlock)srcNode)) == null || !takenDest.equals(destNode)) continue;
                this.trueCaseEdges.add(newEdge);
            }
        }
        int mvn = this.st.getMaxValueNumber();
        int i = 0;
        while (i <= mvn) {
            SSAInstruction defInst = this.defUse.getDef(i);
            if (defInst != null) {
                IExplodedBasicBlock defBlock = this.getInstructionBlock(defInst);
                Iterator it = this.defUse.getUses(i);
                while (it.hasNext()) {
                    SSAInstruction useInst = (SSAInstruction)it.next();
                    IExplodedBasicBlock useBlock = this.getInstructionBlock(useInst);
                    if (defBlock == null) continue;
                    int def = defBlock.getNumber();
                    int use = useBlock.getNumber();
                    Assertions.productionAssertion((def < this.cfg.getNumberOfNodes() && use < this.cfg.getNumberOfNodes() ? 1 : 0) != 0);
                    if (def == use) continue;
                    this.addEdge(def, use, false);
                }
            }
            ++i;
        }
    }

    private boolean hasTakenSuccessor(ControlFlowGraph aCFG, IBasicBlock aBlock) {
        IBasicBlock nts = Util.getNotTakenSuccessor((ControlFlowGraph)aCFG, (IBasicBlock)aBlock);
        Iterator it = aCFG.getSuccNodes((Object)aBlock);
        while (it.hasNext()) {
            IBasicBlock s = (IBasicBlock)it.next();
            if (s == nts) continue;
            return true;
        }
        return false;
    }

    private IExplodedBasicBlock getInstructionBlock(SSAInstruction inst) {
        IExplodedBasicBlock result = (IExplodedBasicBlock)this.instruction2block.get(inst);
        if (result == null) {
            Trace.println((String)("Got null block for instruction " + inst));
        }
        return result;
    }

    protected void initialize() {
        this.flowWorkList = new BitVectorIntSet();
        this.ssaWorkList = new BitVectorIntSet();
        this.execFlag = new BitVectorIntSet();
        IExplodedBasicBlock entryBlock = this.cfg.entry();
        assert (entryBlock.isEntryBlock());
        int src = entryBlock.getNumber();
        src = -1;
        Iterator it = this.cfg.getSuccNodes(entryBlock);
        while (it.hasNext()) {
            IExplodedBasicBlock destBlock = (IExplodedBasicBlock)it.next();
            int dest = destBlock.getNumber();
            int edge = this.addEdge(src, dest, true);
            this.flowWorkList.add(edge);
        }
        SSAInstruction[] instructions = this.cfg.getInstructions();
        int instSize = instructions.length;
        int i = 0;
        while (i < instSize) {
            SSAInstruction inst = instructions[i];
            this.initDefValue(inst);
            ++i;
        }
        for (ISSABasicBlock bb : this.cfg) {
            Iterator phiIt = bb.iteratePhis();
            while (phiIt.hasNext()) {
                SSAPhiInstruction phiInst = (SSAPhiInstruction)phiIt.next();
                this.initDefValue((SSAInstruction)phiInst);
            }
            Iterator piIt = bb.iteratePis();
            while (piIt.hasNext()) {
                SSAPiInstruction piInst = (SSAPiInstruction)piIt.next();
                this.initDefValue((SSAInstruction)piInst);
            }
        }
    }

    private void initDefValue(SSAInstruction inst) {
        int defNum;
        if (inst != null && inst.hasDef() && (defNum = inst.getDef()) != -1) {
            this.setValue(defNum, SCCPValue.BOTTOM);
        }
    }

    private int selectAndRemove(BitVectorIntSet bv) {
        IntIterator it = bv.intIterator();
        int edgeId = it.next();
        bv.remove(edgeId);
        return edgeId;
    }

    public void solve() {
        this.initialize();
        while (!this.flowWorkList.isEmpty() || !this.ssaWorkList.isEmpty()) {
            SSAInstruction destInst;
            IExplodedBasicBlock destBlock;
            int b;
            Edge edge;
            int e;
            if (!this.flowWorkList.isEmpty()) {
                e = this.selectAndRemove(this.flowWorkList);
                edge = this.edgeDictionary.get(e);
                assert (edge != null);
                b = edge.dest;
                assert (b >= 0);
                if (!this.execFlag.contains(e)) {
                    this.execFlag.add(e);
                    destBlock = this.cfg.getNode(b);
                    destInst = destBlock.getInstruction();
                    this.visitPhiInstructions(b, destBlock);
                    if (this.singleEdge(b)) {
                        this.visitInst(b, destInst);
                    }
                    this.visitPiInstructions(b, destBlock);
                }
            }
            if (this.ssaWorkList.isEmpty()) continue;
            e = this.selectAndRemove(this.ssaWorkList);
            edge = this.edgeDictionary.get(e);
            assert (edge != null);
            b = edge.dest;
            Assertions.productionAssertion((b >= 0 && b < this.cfg.getNumberOfNodes() ? 1 : 0) != 0);
            destBlock = this.cfg.getNode(b);
            destInst = destBlock.getInstruction();
            this.visitPhiInstructions(b, destBlock);
            if (this.hasEdge(b)) {
                this.visitInst(b, destInst);
            }
            this.visitPiInstructions(b, destBlock);
        }
    }

    private void visitPhiInstructions(int blockNum, IExplodedBasicBlock destBlock) {
        Iterator phiIt = destBlock.iteratePhis();
        while (phiIt.hasNext()) {
            SSAPhiInstruction currPhi = (SSAPhiInstruction)phiIt.next();
            this.handlePhiDefinition(blockNum, currPhi);
        }
    }

    private void visitPiInstructions(int blockNum, IExplodedBasicBlock destBlock) {
        Iterator piIt = destBlock.iteratePis();
        while (piIt.hasNext()) {
            SSAPiInstruction currPi = (SSAPiInstruction)piIt.next();
            this.handlePiDefinition(blockNum, currPi);
        }
    }

    private void handlePhiDefinition(int blockNum, SSAPhiInstruction inst) {
        Trace.println((String)("HandlePhiDefinition: " + inst));
        this.visitPhi(blockNum, inst);
    }

    private void handlePiDefinition(int blockNum, SSAPiInstruction inst) {
        Trace.println((String)("HandlePiDefinition: " + inst));
        int defNum = inst.getDef();
        if (defNum != -1) {
            SCCPValue lhsVal = this.getValue(defNum);
            Assertions.productionAssertion((lhsVal != null ? 1 : 0) != 0, (String)"got null constant");
            SCCPValue val = this.latticeEvaluate((SSAInstruction)inst);
            if (!val.equals(lhsVal)) {
                lhsVal = lhsVal.join(val);
                this.setValue(defNum, lhsVal);
                if (this.getValue(defNum).equals(lhsVal)) {
                    this.ssaWorkList.addAll((IntSet)this.getSSASuccessors(blockNum));
                }
            }
        }
    }

    protected void printSolution() {
    }

    public Map<Integer, SCCPValue> getConstantValues() {
        HashMap result = HashMapFactory.make();
        int size = this.vars.length;
        int i = 1;
        while (i < size) {
            result.put(i, this.getValue(i));
            ++i;
        }
        int maxVal = this.st.getMaxValueNumber();
        int i2 = 0;
        while (i2 <= maxVal) {
            Value val = this.st.getValue(i2);
            if (val != null && val instanceof ConstantValue) {
                ConstantValue cVal = (ConstantValue)val;
                if (cVal.isNullConstant()) {
                    result.put(new Integer(i2), SCCPValue.createValue(null));
                } else {
                    Object value = cVal.getValue();
                    if (value != null) {
                        result.put(new Integer(i2), SCCPValue.createValue(value));
                    }
                }
            }
            ++i2;
        }
        return result;
    }

    protected SCCPValue join(SCCPValue lhs, SCCPValue rhs) {
        return lhs.join(rhs);
    }

    protected void visitPhi(int b, SSAPhiInstruction phi) {
        int lhs = phi.getDef();
        int uses = phi.getNumberOfUses();
        SCCPValue lhsVal = this.getValue(lhs).copy();
        int j = 0;
        while (j < uses) {
            SCCPValue currVal;
            int currUse = phi.getUse(j);
            if (currUse != -1 && (currVal = this.getValue(currUse)) != null && lhsVal != null) {
                lhsVal = this.join(lhsVal, currVal);
            }
            ++j;
        }
        if (!lhsVal.equals(this.getValue(lhs))) {
            this.setValue(lhs, lhsVal);
            if (this.getValue(lhs).equals(lhsVal)) {
                this.ssaWorkList.addAll((IntSet)this.getSSASuccessors(b));
            }
        }
        this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
    }

    protected void visitInst(int b, SSAInstruction inst) {
        block10: {
            IntIterator it;
            MutableIntSet cfgSucc;
            block11: {
                SCCPValue val;
                block9: {
                    int defNum;
                    if (inst == null) {
                        this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
                        return;
                    }
                    val = this.latticeEvaluate(inst);
                    this.checkInstruction(inst);
                    if (val == null) {
                        this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
                    } else if (inst.hasDef() && (defNum = inst.getDef()) != -1) {
                        SCCPValue lhsVal = this.getValue(defNum);
                        Assertions.productionAssertion((lhsVal != null ? 1 : 0) != 0, (String)"got null constant");
                        if (!val.equals(lhsVal)) {
                            lhsVal = lhsVal.join(val);
                            this.setValue(defNum, lhsVal);
                            if (this.getValue(defNum).equals(lhsVal)) {
                                this.ssaWorkList.addAll((IntSet)this.getSSASuccessors(b));
                            }
                        }
                    }
                    if (val != SCCPValue.TOP) break block9;
                    this.flowWorkList.addAll((IntSet)this.getCFGSuccessors(b));
                    break block10;
                }
                if (val == SCCPValue.BOTTOM) break block10;
                cfgSucc = this.getCFGSuccessors(b);
                if (cfgSucc.size() <= 1) break block11;
                it = cfgSucc.intIterator();
                while (it.hasNext()) {
                    int edge = it.next();
                    if (val instanceof SCCPBooleanValue) {
                        SCCPBooleanValue bVal = (SCCPBooleanValue)val;
                        boolean boolVal = bVal.getBooleanValue();
                        if ((!boolVal || !this.trueCaseEdges.contains(edge)) && (boolVal || this.trueCaseEdges.contains(edge))) continue;
                        this.flowWorkList.add(edge);
                        continue;
                    }
                    this.flowWorkList.add(edge);
                }
                break block10;
            }
            if (cfgSucc.size() != 1) break block10;
            it = cfgSucc.intIterator();
            while (it.hasNext()) {
                int edge = it.next();
                this.flowWorkList.add(edge);
            }
        }
    }

    protected void checkInstruction(SSAInstruction inst) {
    }

    protected MutableIntSet getSSASuccessors(int node) {
        MutableIntSet result = (MutableIntSet)this.outgoingSSAEdges.get(node);
        return result != null ? result : EMPTY_INTSET;
    }

    protected MutableIntSet getCFGSuccessors(int node) {
        MutableIntSet result = (MutableIntSet)this.outgoingCFGEdges.get(node);
        return result != null ? result : EMPTY_INTSET;
    }

    protected SCCPValue latticeEvaluate(SSAInstruction inst) {
        this.evalVisitor.init();
        inst.visit((SSAInstruction.IVisitor)this.evalVisitor);
        return this.evalVisitor.getResult();
    }

    private boolean singleEdge(int b) {
        int count = 0;
        MutableIntSet incoming = (MutableIntSet)this.incomingEdges.get(b);
        IntIterator it = incoming.intIterator();
        while (it.hasNext()) {
            int e = it.next();
            if (!this.execFlag.contains(e) || ++count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    private boolean hasEdge(int b) {
        MutableIntSet incoming = (MutableIntSet)this.incomingEdges.get(b);
        IntIterator it = incoming.intIterator();
        while (it.hasNext()) {
            int e = it.next();
            if (!this.execFlag.contains(e)) continue;
            return true;
        }
        return false;
    }

    private void createVariables(SSAInference.VariableFactory factory) {
        this.vars = new IVariable[this.st.getMaxValueNumber() + 1];
        int i = 1;
        while (i < this.vars.length) {
            this.vars[i] = factory.makeVariable(i);
            ++i;
        }
    }

    protected SCCPVariable getVariable(int valueNumber) {
        return (SCCPVariable)this.vars[valueNumber];
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Type inference : \n");
        int i = 0;
        while (i < this.vars.length) {
            result.append("v").append(i).append("  ").append(this.vars[i]).append("\n");
            ++i;
        }
        return result.toString();
    }

    protected void initializeVariables() {
        int maxValNum = this.st.getMaxValueNumber();
        int i = 1;
        while (i <= maxValNum) {
            SCCPVariable v = this.getVariable(i);
            if (this.st.isParameter(i)) {
                v.setValue(SCCPValue.TOP);
            } else {
                Value val = this.st.getValue(i);
                if (val == null) {
                    v.setValue(SCCPValue.BOTTOM);
                } else if (val instanceof ConstantValue) {
                    ConstantValue cval = (ConstantValue)val;
                    Object theValue = cval.getValue();
                    v.setValue(theValue);
                }
            }
            ++i;
        }
    }

    public SCCPValue getValue(int valueNumber) {
        assert (this.getVariable(valueNumber) != null) : "null variable for value number " + valueNumber;
        return this.getVariable(valueNumber).getValue();
    }

    public void setValue(int valueNumber, SCCPValue val) {
        assert (this.getVariable(valueNumber) != null) : "null variable for value number " + valueNumber;
        Trace.println((String)("Setting the value of " + valueNumber + " to " + val));
        this.getVariable(valueNumber).setValue(val);
    }

    public static class Edge {
        public int src;
        public int dest;
        public boolean isCFG;

        public Edge(int src, int dest, boolean isCFG) {
            this.src = src;
            this.dest = dest;
            this.isCFG = isCFG;
        }

        public boolean isCFG() {
            return this.isCFG;
        }

        public boolean isSSA() {
            return !this.isCFG;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge otherEdge = (Edge)other;
            return otherEdge.src == this.src && otherEdge.dest == this.dest && otherEdge.isCFG == this.isCFG;
        }

        public int hashCode() {
            return 31 * this.src + this.dest;
        }

        public String toString() {
            return "(" + this.src + "," + this.dest + "," + (this.isCFG ? "CFG" : "SSA") + ")";
        }
    }

    public static final class EdgeDictionary {
        protected Map<Edge, Integer> edge2int = HashMapFactory.make();
        protected Map<Integer, Edge> int2edge = HashMapFactory.make();
        private int id = 0;

        public int createEdge(int src, int dest, boolean isCFG) {
            Edge newEdge = new Edge(src, dest, isCFG);
            Integer key = this.edge2int.get(newEdge);
            if (key == null) {
                key = new Integer(this.id++);
                this.edge2int.put(newEdge, key);
                this.int2edge.put(key, newEdge);
            }
            return key;
        }

        public Edge get(int edgeId) {
            return this.int2edge.get(edgeId);
        }
    }

    public class ExpressionInstructionVisitor
    extends SSAInstruction.Visitor {
        private SCCPValue result = SCCPValue.TOP;

        public void init() {
            this.result = SCCPValue.TOP;
        }

        public SCCPValue getResult() {
            return this.result;
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        }

        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            int rhs1 = instruction.getUse(0);
            SCCPValue rhs1ProgramValue = this.getConstantValue(rhs1);
            if (rhs1ProgramValue != null) {
                this.result = rhs1ProgramValue;
            }
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            int rhs1 = instruction.getUse(0);
            int rhs2 = instruction.getUse(1);
            IConditionalBranchInstruction.IOperator operator = instruction.getOperator();
            SCCPValue rhs1Value = NewSCCPSolver.this.getValue(rhs1);
            SCCPValue rhs2Value = NewSCCPSolver.this.getValue(rhs2);
            this.result = rhs1Value == SCCPValue.TOP || rhs2Value == SCCPValue.TOP ? SCCPValue.TOP : (rhs1Value != null && rhs2Value != null && rhs2Value != SCCPValue.TOP || rhs2Value != SCCPValue.TOP ? this.evaluateConditionalBranch(rhs1Value, rhs2Value, operator) : SCCPValue.TOP);
        }

        public void visitGet(SSAGetInstruction instruction) {
            instruction.isStatic();
        }

        public void visitPi(SSAPiInstruction instruction) {
            int piLhs = instruction.getDef();
            int piRhs = instruction.getVal();
            SCCPValue piRhsProgramValue = this.getConstantValue(piRhs);
            SCCPValue piRhsConstant = piRhsProgramValue != null ? piRhsProgramValue : NewSCCPSolver.this.getValue(piRhs);
            SSAInstruction cause = instruction.getCause();
            if (cause instanceof SSAConditionalBranchInstruction) {
                SSAConditionalBranchInstruction cond = (SSAConditionalBranchInstruction)cause;
                IConditionalBranchInstruction.IOperator operator = cond.getOperator();
                int rhs1 = cause.getUse(0);
                int rhs2 = cause.getUse(1);
                Assertions.productionAssertion((rhs1 == piRhs || rhs2 == piRhs ? 1 : 0) != 0, (String)"cause condition does not contain pi variable");
                SCCPValue rhs1ProgramValue = this.getConstantValue(rhs1);
                SCCPValue rhs2ProgramValue = this.getConstantValue(rhs2);
                SCCPValue rhs1Constant = rhs1ProgramValue != null ? rhs1ProgramValue : NewSCCPSolver.this.getValue(rhs1);
                SCCPValue rhs2Constant = rhs2ProgramValue != null ? rhs2ProgramValue : NewSCCPSolver.this.getValue(rhs2);
                boolean rhs1IsConstant = rhs1Constant != null && rhs1Constant != SCCPValue.TOP && rhs1Constant != SCCPValue.BOTTOM;
                boolean rhs2IsConstant = rhs2Constant != null && rhs2Constant != SCCPValue.TOP && rhs2Constant != SCCPValue.BOTTOM;
                SCCPValue constant = null;
                if (!rhs1IsConstant && !rhs2IsConstant) {
                    this.result = null;
                    return;
                }
                if (rhs1IsConstant && rhs2IsConstant) {
                    this.handleConstantCondition(instruction, rhs1Constant, rhs2Constant);
                    return;
                }
                if (rhs1IsConstant && !rhs2IsConstant) {
                    constant = rhs1Constant;
                } else if (!rhs1IsConstant && rhs2IsConstant) {
                    constant = rhs2Constant;
                }
                Assertions.productionAssertion((constant != null ? 1 : 0) != 0, (String)"got null constant");
                Trace.println((String)("Conditional Operator: " + operator));
                switch ((IConditionalBranchInstruction.Operator)operator) {
                    case EQ: {
                        if (this.isTruePi(instruction)) {
                            NewSCCPSolver.this.setValue(piLhs, constant);
                            break;
                        }
                        NewSCCPSolver.this.setValue(piLhs, SCCPValue.TOP);
                        break;
                    }
                    case NE: {
                        if (!this.isTruePi(instruction)) {
                            NewSCCPSolver.this.setValue(piLhs, constant);
                            break;
                        }
                        NewSCCPSolver.this.setValue(piLhs, SCCPValue.TOP);
                    }
                }
                this.result = NewSCCPSolver.this.getValue(piLhs);
            } else if (piRhsConstant != null && piRhsConstant != SCCPValue.TOP && piRhsConstant != SCCPValue.BOTTOM) {
                NewSCCPSolver.this.setValue(piLhs, piRhsConstant);
                this.result = NewSCCPSolver.this.getValue(piLhs);
            }
        }

        private void handleConstantCondition(SSAPiInstruction instruction, SCCPValue rhs1Constant, SCCPValue rhs2Constant) {
            SSAInstruction cause = instruction.getCause();
            SSAConditionalBranchInstruction cond = (SSAConditionalBranchInstruction)cause;
            IConditionalBranchInstruction.IOperator operator = cond.getOperator();
            int piLhs = instruction.getDef();
            boolean isTruePi = this.isTruePi(instruction);
            boolean constantsEqual = rhs1Constant.equals(rhs2Constant);
            switch ((IConditionalBranchInstruction.Operator)operator) {
                case EQ: {
                    Trace.println((String)"EQ:");
                    Trace.println((String)("ConstantEqual:" + constantsEqual));
                    boolean isConstant = constantsEqual && isTruePi || !constantsEqual && !isTruePi;
                    Trace.println((String)("isConstant:" + isConstant));
                    NewSCCPSolver.this.setValue(piLhs, isConstant ? rhs1Constant : SCCPValue.BOTTOM);
                    break;
                }
                case NE: {
                    Trace.println((String)"NEQ:");
                    Trace.println((String)("ConstantEqual:" + constantsEqual));
                    boolean isAssign = !constantsEqual && isTruePi || constantsEqual && !isTruePi;
                    Trace.println((String)("isAssign:" + isAssign));
                    NewSCCPSolver.this.setValue(piLhs, isAssign ? rhs1Constant : SCCPValue.BOTTOM);
                }
            }
            this.result = NewSCCPSolver.this.getValue(piLhs);
        }

        private boolean isTruePi(SSAPiInstruction instruction) {
            boolean result = NewSCCPSolver.this.trueCasePiInstructions.contains(instruction);
            return result;
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        }

        private SCCPValue getConstantValue(int valNumber) {
            SCCPValue result = null;
            Value value = NewSCCPSolver.this.st.getValue(valNumber);
            if (value != null && value instanceof ConstantValue) {
                ConstantValue constVal = (ConstantValue)value;
                result = SCCPValue.createValue(constVal.getValue());
            }
            return result;
        }

        private SCCPValue evaluateConditionalBranch(SCCPValue op1, SCCPValue op2, IConditionalBranchInstruction.IOperator operator) {
            switch ((IConditionalBranchInstruction.Operator)operator) {
                case EQ: {
                    boolean outcome = op1.equals(op2);
                    return SCCPValue.createValue(outcome);
                }
                case NE: {
                    return SCCPValue.createValue(!op1.equals(op2));
                }
            }
            return SCCPValue.TOP;
        }
    }

    private class SCCPVarFactory
    implements SSAInference.VariableFactory {
        private SCCPVarFactory() {
        }

        public IVariable makeVariable(int valueNumber) {
            return new SCCPVariable(valueNumber, SCCPValue.BOTTOM, 797 * valueNumber);
        }
    }
}

