/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import java.io.FileWriter;
import java.util.Iterator;

public class ExplodedCFGDotWriter {
    public static void write(String fileName, ExplodedControlFlowGraph cfg) throws IllegalArgumentException {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg cannot be null");
        }
        StringBuffer result = new StringBuffer();
        result.append(ExplodedCFGDotWriter.dotOutput(cfg));
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(result.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    public static void write(String fileName, SSACFG cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg cannot be null");
        }
        StringBuffer result = new StringBuffer();
        result.append(ExplodedCFGDotWriter.dotOutput(cfg));
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(result.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    private static StringBuffer dotOutput(ExplodedControlFlowGraph cfg) {
        StringBuffer result = new StringBuffer("digraph \"ExpandedControlFlowGraph:\" {\n");
        result.append("center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        for (IExplodedBasicBlock bb : cfg) {
            result.append(ExplodedCFGDotWriter.dotOutput(bb));
            if (bb.isEntryBlock()) {
                result.append(" [color=green]\n");
                continue;
            }
            if (bb.isExitBlock()) {
                result.append(" [color=red]\n");
                continue;
            }
            result.append("\n");
        }
        for (IExplodedBasicBlock bb : cfg) {
            Iterator succIt = cfg.getSuccNodes(bb);
            while (succIt.hasNext()) {
                IExplodedBasicBlock succ = (IExplodedBasicBlock)succIt.next();
                result.append(ExplodedCFGDotWriter.dotOutput(bb));
                result.append(" -> ");
                result.append(ExplodedCFGDotWriter.dotOutput(succ));
                result.append("\n");
            }
        }
        result.append("}");
        return result;
    }

    private static StringBuffer dotOutput(SSACFG cfg) {
        StringBuffer result = new StringBuffer("digraph \"ControlFlowGraph:\" {\n");
        result.append("center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        for (SSACFG.BasicBlock bb : cfg) {
            result.append(ExplodedCFGDotWriter.dotOutput(bb));
            if (bb.isEntryBlock()) {
                result.append(" [color=green]\n");
                continue;
            }
            if (bb.isExitBlock()) {
                result.append(" [color=red]\n");
                continue;
            }
            result.append("\n");
        }
        for (SSACFG.BasicBlock bb : cfg) {
            Iterator succIt = cfg.getSuccNodes((ISSABasicBlock)bb);
            while (succIt.hasNext()) {
                SSACFG.BasicBlock succ = (SSACFG.BasicBlock)succIt.next();
                result.append(ExplodedCFGDotWriter.dotOutput(bb));
                result.append(" -> ");
                result.append(ExplodedCFGDotWriter.dotOutput(succ));
                result.append("\n");
            }
        }
        result.append("}");
        return result;
    }

    private static StringBuffer dotOutput(SSACFG.BasicBlock bb) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(bb.getNumber());
        result.append("\"");
        return result;
    }

    private static StringBuffer dotOutput(IExplodedBasicBlock bb) {
        StringBuffer result = new StringBuffer();
        SSAInstruction inst = bb.getInstruction();
        result.append("\"");
        result.append(bb.getNumber());
        result.append("-");
        Iterator phiIt = bb.iteratePhis();
        while (phiIt.hasNext()) {
            SSAPhiInstruction currPhi = (SSAPhiInstruction)phiIt.next();
            result.append(currPhi);
            result.append("\\n");
        }
        result.append(inst);
        result.append("\\n");
        Iterator piIt = bb.iteratePis();
        while (piIt.hasNext()) {
            SSAPiInstruction currPi = (SSAPiInstruction)piIt.next();
            result.append(currPi);
            result.append("\\n");
        }
        result.append("\"");
        return result;
    }
}

