/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.safe.intraproc.sccp.ExpandedCFGDotWriter;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class ExpandedControlFlowGraph
implements ControlFlowGraph<SSAInstruction, ISSABasicBlock> {
    private static final boolean DEBUG = false;
    private SingleInstructionBasicBlock[] basicBlocks;
    final Map<SSAInstruction, SingleInstructionBasicBlock> instructionToBlock = HashMapFactory.make();
    private final IR ir;
    private final Map<ISSABasicBlock, List<ISSABasicBlock>> successors;
    private final Map<ISSABasicBlock, List<ISSABasicBlock>> predecessors;
    private int entry;
    private int exit;
    private final Set<SSAPiInstruction> trueCasePiInstructions = HashSetFactory.make();
    SingleInstructionBasicBlock entryBlock;
    SingleInstructionBasicBlock exitBlock;
    private final Map<IBasicBlock, IBasicBlock> fallThroughTargets = HashMapFactory.make();

    public ExpandedControlFlowGraph(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.ir = ir;
        this.successors = HashMapFactory.make();
        this.predecessors = HashMapFactory.make();
        this.createBasicBlocks();
        this.createGraphEdges();
    }

    private void dumpBasicBlocks() {
        int i = 0;
        while (i < this.basicBlocks.length) {
            Trace.println((String)("BB[" + i + "] = " + this.basicBlocks[i]));
            ++i;
        }
    }

    private void dumpGraphEdges() {
        Trace.println((String)("Succ: " + this.successors.toString()));
        Trace.println((String)("Pred: " + this.predecessors.toString()));
    }

    @Deprecated
    public SingleInstructionBasicBlock getInstructionBlock(SSAInstruction inst) {
        return this.instructionToBlock.get(inst);
    }

    public Collection<SSAInstruction> getAllInstructions() {
        return this.instructionToBlock.keySet();
    }

    private void createBasicBlocks() {
        ArrayList<SingleInstructionBasicBlock> basicBlockList = new ArrayList<SingleInstructionBasicBlock>();
        this.entry = 0;
        this.entryBlock = new SingleInstructionBasicBlock(this.entry, null, -1);
        this.entryBlock.setIsEntryBlock(true);
        basicBlockList.add(this.entryBlock);
        for (SSACFG.BasicBlock bb : this.ir.getControlFlowGraph()) {
            SSACFG.ExceptionHandlerBasicBlock ebb;
            SSAGetCaughtExceptionInstruction catchInst;
            int blockNum;
            Iterator phiIt = bb.iteratePhis();
            while (phiIt.hasNext()) {
                SSAPhiInstruction phi = (SSAPhiInstruction)phiIt.next();
                if (phi == null) continue;
                blockNum = basicBlockList.size();
                basicBlockList.add(new SingleInstructionBasicBlock(blockNum, (SSAInstruction)phi, -1));
            }
            Iterator piIt = bb.iteratePis();
            while (piIt.hasNext()) {
                SSAPiInstruction pi = (SSAPiInstruction)piIt.next();
                if (pi == null) continue;
                blockNum = basicBlockList.size();
                basicBlockList.add(new SingleInstructionBasicBlock(blockNum, (SSAInstruction)pi, -1));
            }
            int i = bb.getFirstInstructionIndex();
            while (i <= bb.getLastInstructionIndex()) {
                SSAInstruction s = this.ir.getInstructions()[i];
                if (s != null) {
                    blockNum = basicBlockList.size();
                    basicBlockList.add(new SingleInstructionBasicBlock(blockNum, s, i));
                }
                ++i;
            }
            if (!(bb instanceof SSACFG.ExceptionHandlerBasicBlock) || (catchInst = (ebb = (SSACFG.ExceptionHandlerBasicBlock)bb).getCatchInstruction()) == null) continue;
            blockNum = basicBlockList.size();
            basicBlockList.add(new SingleInstructionExceptionHandlerBlock(blockNum, (SSAInstruction)catchInst));
        }
        this.exit = basicBlockList.size();
        this.exitBlock = new SingleInstructionBasicBlock(this.exit, null, -1);
        this.exitBlock.setIsExitBlock(true);
        basicBlockList.add(this.exitBlock);
        this.basicBlocks = new SingleInstructionBasicBlock[basicBlockList.size()];
        int i = 0;
        while (i < basicBlockList.size()) {
            SingleInstructionBasicBlock sibb;
            this.basicBlocks[i] = sibb = (SingleInstructionBasicBlock)basicBlockList.get(i);
            SSAInstruction blockInstruction = sibb.getInstruction();
            if (blockInstruction != null) {
                this.instructionToBlock.put(blockInstruction, sibb);
            }
            ++i;
        }
    }

    private void createGraphEdges() {
        for (SSACFG.BasicBlock bb : this.ir.getControlFlowGraph()) {
            if (!this.basicBlockHasNonNullInstruction(bb) && bb.isEntryBlock()) {
                this.handleLastInstruction(bb, this.entryBlock);
                continue;
            }
            List<SSAInstruction> blockInstrctions = this.getBlockInstructions(bb);
            Object[] blockInstructionArray = blockInstrctions.toArray();
            if (bb.isEntryBlock()) {
                SSAInstruction inst = (SSAInstruction)blockInstructionArray[0];
                Assertions.productionAssertion((inst != null ? 1 : 0) != 0);
                SingleInstructionBasicBlock currBlock = this.getInstructionBlock(inst);
                this.addEdge(this.entryBlock, currBlock);
            }
            if (bb.isExitBlock()) {
                // empty if block
            }
            if (!this.basicBlockHasPi(bb)) {
                this.processNoPi(bb, blockInstructionArray);
                continue;
            }
            this.processWithPi(bb, blockInstructionArray);
        }
    }

    private void processNoPi(SSACFG.BasicBlock bb, Object[] blockInstructionArray) {
        int size = blockInstructionArray.length;
        int i = 0;
        while (i < size) {
            SSAInstruction inst = (SSAInstruction)blockInstructionArray[i];
            Assertions.productionAssertion((inst != null ? 1 : 0) != 0);
            SingleInstructionBasicBlock currBlock = this.getInstructionBlock(inst);
            if (currBlock == null) {
                Assertions.UNREACHABLE((String)("bang " + inst));
            }
            if (i < size - 1) {
                SSAInstruction nextInst = (SSAInstruction)blockInstructionArray[i + 1];
                Assertions.productionAssertion((nextInst != null ? 1 : 0) != 0);
                SingleInstructionBasicBlock nextBlock = this.getInstructionBlock(nextInst);
                this.addEdge(currBlock, nextBlock);
                this.fallThroughTargets.put((IBasicBlock)currBlock, (IBasicBlock)nextBlock);
            } else {
                this.handleLastInstruction(bb, currBlock);
            }
            ++i;
        }
    }

    private void processWithPi(SSACFG.BasicBlock bb, Object[] blockInstructionArray) {
        int size = blockInstructionArray.length;
        int i = 0;
        while (i < size) {
            SSAInstruction inst = (SSAInstruction)blockInstructionArray[i];
            Assertions.productionAssertion((inst != null ? 1 : 0) != 0);
            SingleInstructionBasicBlock currBlock = this.getInstructionBlock(inst);
            if (i < size - 1 && !(inst instanceof SSAPiInstruction)) {
                int j = i + 1;
                SSAInstruction nextInst = (SSAInstruction)blockInstructionArray[j];
                while (j < size - 1 && nextInst instanceof SSAPiInstruction) {
                    nextInst = (SSAInstruction)blockInstructionArray[++j];
                }
                Assertions.productionAssertion((nextInst != null ? 1 : 0) != 0);
                SingleInstructionBasicBlock nextBlock = this.getInstructionBlock(nextInst);
                if (!nextBlock.isPiBlock()) {
                    this.addEdge(currBlock, nextBlock);
                    this.fallThroughTargets.put((IBasicBlock)currBlock, (IBasicBlock)nextBlock);
                }
            } else if (i == size - 1) {
                Iterator it = bb.iteratePis();
                while (it.hasNext()) {
                    SSAPiInstruction pi = (SSAPiInstruction)it.next();
                    SingleInstructionBasicBlock piBlock = this.getInstructionBlock((SSAInstruction)pi);
                    int piSuccNumber = pi.getSuccessor();
                    int currBlockNum = bb.getNumber();
                    if (currBlockNum + 1 != piSuccNumber) {
                        this.trueCasePiInstructions.add(pi);
                    } else {
                        this.fallThroughTargets.put((IBasicBlock)currBlock, (IBasicBlock)piBlock);
                    }
                    this.addEdge(currBlock, piBlock);
                }
            } else {
                this.handleLastInstruction(bb, currBlock);
            }
            ++i;
        }
    }

    private void handleLastInstruction(SSACFG.BasicBlock bb, SingleInstructionBasicBlock instbb) {
        assert (instbb != null);
        HashSet edgeWorkSet = HashSetFactory.make();
        if (!instbb.isPiBlock()) {
            Iterator sit = this.ir.getControlFlowGraph().getSuccNodes((ISSABasicBlock)bb);
            while (sit.hasNext()) {
                SSACFG.BasicBlock succNode = (SSACFG.BasicBlock)sit.next();
                boolean fallThrough = this.isFallThroughEdge((ISSABasicBlock)bb, (ISSABasicBlock)succNode);
                edgeWorkSet.add(new BBEdge(bb, succNode, fallThrough));
            }
        } else {
            SSAPiInstruction pi = (SSAPiInstruction)instbb.getInstruction();
            int succNum = pi.getSuccessor();
            SSACFG.BasicBlock succNode = this.ir.getControlFlowGraph().getNode(succNum);
            boolean fallThrough = this.isFallThroughEdge((ISSABasicBlock)bb, (ISSABasicBlock)succNode);
            edgeWorkSet.add(new BBEdge(bb, succNode, fallThrough));
        }
        if (bb.isExitBlock()) {
            this.addEdge(instbb, this.exitBlock);
        }
        while (!edgeWorkSet.isEmpty()) {
            SingleInstructionBasicBlock succBlock;
            Iterator workIt = edgeWorkSet.iterator();
            BBEdge edge = (BBEdge)workIt.next();
            boolean fallThru = false;
            if (this.isFallThroughEdge((ISSABasicBlock)edge.src, (ISSABasicBlock)edge.dest)) {
                fallThru = true;
            }
            workIt.remove();
            if (edge.dest.isEntryBlock()) {
                this.addEdge(instbb, this.entryBlock);
                if (!fallThru) continue;
                this.fallThroughTargets.put((IBasicBlock)instbb, (IBasicBlock)this.entryBlock);
                continue;
            }
            if (edge.dest.isExitBlock()) {
                if (this.basicBlockHasNonNullInstruction(edge.dest)) {
                    SSAInstruction succInst = this.getBasicBlockEntry(edge.dest);
                    succBlock = this.getInstructionBlock(succInst);
                    this.addEdge(instbb, succBlock);
                    if (!fallThru) continue;
                    this.fallThroughTargets.put((IBasicBlock)instbb, (IBasicBlock)succBlock);
                    continue;
                }
                this.addEdge(instbb, this.exitBlock);
                if (!fallThru) continue;
                this.fallThroughTargets.put((IBasicBlock)instbb, (IBasicBlock)this.exitBlock);
                continue;
            }
            if (this.basicBlockHasNonNullInstruction(edge.dest)) {
                SSAInstruction succInst = this.getBasicBlockEntry(edge.dest);
                succBlock = this.getInstructionBlock(succInst);
                this.addEdge(instbb, succBlock);
                if (!fallThru) continue;
                this.fallThroughTargets.put((IBasicBlock)instbb, (IBasicBlock)succBlock);
                continue;
            }
            Iterator sit = this.ir.getControlFlowGraph().getSuccNodes((ISSABasicBlock)edge.dest);
            while (sit.hasNext()) {
                SSACFG.BasicBlock succNode = (SSACFG.BasicBlock)sit.next();
                edgeWorkSet.add(new BBEdge(bb, succNode, edge.isFallThrough));
            }
        }
    }

    public Set<SSAPiInstruction> getTrueCasePiInstructions() {
        return this.trueCasePiInstructions;
    }

    private List<SSAInstruction> getBlockInstructions(SSACFG.BasicBlock bb) {
        SSACFG.ExceptionHandlerBasicBlock ebb;
        SSAGetCaughtExceptionInstruction catchInst;
        ArrayList<SSAInstruction> result = new ArrayList<SSAInstruction>();
        Iterator phiIt = bb.iteratePhis();
        while (phiIt.hasNext()) {
            SSAPhiInstruction phi = (SSAPhiInstruction)phiIt.next();
            if (phi == null) continue;
            result.add((SSAInstruction)phi);
        }
        Iterator piIt = bb.iteratePis();
        while (piIt.hasNext()) {
            SSAPiInstruction pi = (SSAPiInstruction)piIt.next();
            if (pi == null) continue;
            result.add((SSAInstruction)pi);
        }
        int i = bb.getFirstInstructionIndex();
        while (i <= bb.getLastInstructionIndex()) {
            SSAInstruction s = this.ir.getInstructions()[i];
            if (s != null) {
                result.add(s);
            }
            ++i;
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock && (catchInst = (ebb = (SSACFG.ExceptionHandlerBasicBlock)bb).getCatchInstruction()) != null) {
            result.add((SSAInstruction)catchInst);
        }
        return result;
    }

    private boolean basicBlockHasPhi(SSACFG.BasicBlock bb) {
        ArrayList<SSAPhiInstruction> result = new ArrayList<SSAPhiInstruction>();
        Iterator phiIt = bb.iteratePhis();
        while (phiIt.hasNext()) {
            SSAPhiInstruction phi = (SSAPhiInstruction)phiIt.next();
            if (phi == null) continue;
            result.add(phi);
        }
        return !result.isEmpty();
    }

    private boolean basicBlockHasNonNullInstruction(SSACFG.BasicBlock bb) {
        for (SSAInstruction inst : bb) {
            if (inst == null) continue;
            return true;
        }
        return false;
    }

    private boolean basicBlockHasPi(SSACFG.BasicBlock bb) {
        ArrayList<SSAPiInstruction> result = new ArrayList<SSAPiInstruction>();
        Iterator piIt = bb.iteratePis();
        while (piIt.hasNext()) {
            SSAPiInstruction pi = (SSAPiInstruction)piIt.next();
            if (pi == null) continue;
            result.add(pi);
        }
        return !result.isEmpty();
    }

    private SSAInstruction getBasicBlockEntry(SSACFG.BasicBlock bb) {
        if (!this.basicBlockHasPhi(bb)) {
            int origIndex = bb.getFirstInstructionIndex();
            SSAInstruction origInst = this.ir.getInstructions()[origIndex];
            if (origInst == null) {
                int i = origIndex;
                while (origInst == null && i < bb.getLastInstructionIndex()) {
                    origInst = this.ir.getInstructions()[++i];
                }
            }
            if (bb.isCatchBlock() && origInst == null) {
                origInst = ((SSACFG.ExceptionHandlerBasicBlock)bb).getCatchInstruction();
            }
            Assertions.productionAssertion((origInst != null ? 1 : 0) != 0);
            return origInst;
        }
        SSAInstruction origInst = null;
        Iterator it = bb.iteratePhis();
        while (it.hasNext() && origInst == null) {
            origInst = (SSAInstruction)it.next();
        }
        Assertions.productionAssertion((origInst != null ? 1 : 0) != 0);
        return origInst;
    }

    private void addEdge(SingleInstructionBasicBlock src, SingleInstructionBasicBlock dest) {
        if (this.successors.get(src) == null) {
            this.successors.put(src, new ArrayList());
        }
        if (this.predecessors.get(dest) == null) {
            this.predecessors.put(dest, new ArrayList());
        }
        List<ISSABasicBlock> succList = this.successors.get(src);
        succList.add(dest);
        List<ISSABasicBlock> predList = this.predecessors.get(dest);
        predList.add(src);
    }

    public List<ISSABasicBlock> getSuccessors(SSACFG.BasicBlock src) {
        return this.successors.get(src);
    }

    public List<ISSABasicBlock> getPredecessors(SSACFG.BasicBlock dest) {
        return this.predecessors.get(dest);
    }

    public ISSABasicBlock entry() {
        return this.basicBlocks[this.entry];
    }

    public ISSABasicBlock exit() {
        return this.basicBlocks[this.exit];
    }

    public BitVector getCatchBlocks() {
        return this.ir.getControlFlowGraph().getCatchBlocks();
    }

    public ISSABasicBlock getBlockForInstruction(int index) {
        SSAInstruction s = null;
        while ((s = this.ir.getInstructions()[index++]) == null) {
        }
        return this.instructionToBlock.get(s);
    }

    public SSAInstruction[] getInstructions() {
        return this.ir.getControlFlowGraph().getInstructions();
    }

    public int getProgramCounter(int index) {
        return this.ir.getControlFlowGraph().getProgramCounter(index);
    }

    public IMethod getMethod() {
        return this.ir.getMethod();
    }

    public List<ISSABasicBlock> getExceptionalSuccessors(ISSABasicBlock b) {
        return this.ir.getControlFlowGraph().getExceptionalSuccessors(b);
    }

    public Collection<ISSABasicBlock> getNormalSuccessors(ISSABasicBlock b) {
        return Collections.unmodifiableCollection((Collection)this.successors.get(b));
    }

    public int getPredNodeCount(ISSABasicBlock node) {
        List<ISSABasicBlock> l = this.predecessors.get(node);
        return l == null ? 0 : l.size();
    }

    public Iterator<ISSABasicBlock> getSuccNodes(ISSABasicBlock node) {
        List<ISSABasicBlock> succNodes = this.successors.get(node);
        if (succNodes != null) {
            return succNodes.iterator();
        }
        List l = Collections.emptyList();
        return l.iterator();
    }

    public int getSuccNodeCount(ISSABasicBlock node) {
        return this.successors.get(node).size();
    }

    public void addEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(ISSABasicBlock src, ISSABasicBlock dst) {
        throw new UnsupportedOperationException();
    }

    public void removeAllIncidentEdges(ISSABasicBlock node) {
        throw new UnsupportedOperationException();
    }

    public void removeIncomingEdges(ISSABasicBlock node) {
        throw new UnsupportedOperationException();
    }

    public void removeOutgoingEdges(ISSABasicBlock node) {
        throw new UnsupportedOperationException();
    }

    public Iterator<ISSABasicBlock> iterateNodes(IntSet set) {
        throw new UnsupportedOperationException();
    }

    public boolean containsNode(ISSABasicBlock n) {
        throw new UnsupportedOperationException();
    }

    public int getMaxNumber() {
        throw new UnsupportedOperationException();
    }

    public Iterator<ISSABasicBlock> iterator() {
        ArrayList<SingleInstructionBasicBlock> a = new ArrayList<SingleInstructionBasicBlock>();
        SingleInstructionBasicBlock[] singleInstructionBasicBlockArray = this.basicBlocks;
        int n = this.basicBlocks.length;
        int n2 = 0;
        while (n2 < n) {
            SingleInstructionBasicBlock b = singleInstructionBasicBlockArray[n2];
            a.add(b);
            ++n2;
        }
        return a.iterator();
    }

    public void removeNode(ISSABasicBlock obj) {
        throw new UnsupportedOperationException();
    }

    public Iterator<ISSABasicBlock> getPredNodes(ISSABasicBlock node) {
        List<ISSABasicBlock> predNodes = this.predecessors.get(node);
        if (predNodes != null) {
            return predNodes.iterator();
        }
        return EmptyIterator.instance();
    }

    public void addNode(ISSABasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeNodeAndEdges(ISSABasicBlock n) {
        throw new UnsupportedOperationException();
    }

    public int getNumber(ISSABasicBlock n) {
        throw new UnsupportedOperationException();
    }

    public ISSABasicBlock getNode(int i) {
        return this.basicBlocks[i];
    }

    public int getNumberOfNodes() {
        return this.basicBlocks.length;
    }

    private boolean isFallThroughEdge(ISSABasicBlock src, ISSABasicBlock dest) {
        if (this.ir.getControlFlowGraph().getSuccNodeCount(src) == 2) {
            return src.getNumber() + 1 == dest.getNumber();
        }
        return false;
    }

    public boolean isFallThroughTarget(IBasicBlock src, IBasicBlock dest) {
        IBasicBlock ftt = this.getFallThroughTarget(src);
        return ftt != null && ftt.equals(dest);
    }

    public IBasicBlock getFallThroughTarget(IBasicBlock src) {
        return this.fallThroughTargets.get(src);
    }

    public void dumpDotFile() {
        ExpandedCFGDotWriter.write("c:/temp/original.dt", this.ir.getControlFlowGraph());
        ExpandedCFGDotWriter.write("c:/temp/expanded.dt", this);
    }

    private void debugDump() {
        Trace.println((String)("IR INST: " + this.ir.getInstructions().length));
        Trace.println((String)("CFG INST: " + this.ir.getControlFlowGraph().getInstructions().length));
        SSAInstruction[] debugInstIR = this.ir.getInstructions();
        int countDebugIR = 0;
        int i = 0;
        while (i < debugInstIR.length) {
            if (debugInstIR[i] != null) {
                ++countDebugIR;
            }
            ++i;
        }
        Trace.println((String)("The countDebugIR is:" + countDebugIR));
        int countInst = 0;
        Iterator it = this.ir.iterateAllInstructions();
        while (it.hasNext()) {
            SSAInstruction inst = (SSAInstruction)it.next();
            if (inst == null) {
                Trace.println((String)"*KABOOM*");
            }
            ++countInst;
        }
        Trace.println((String)("The countInst is:" + countInst));
        Iterator debugIt = this.ir.iteratePhis();
        while (debugIt.hasNext()) {
            SSAPhiInstruction phi = (SSAPhiInstruction)debugIt.next();
            Trace.println((Object)phi);
        }
    }

    public Collection<ISSABasicBlock> getExceptionalPredecessors(ISSABasicBlock b) {
        Assertions.UNREACHABLE();
        return null;
    }

    public Collection<ISSABasicBlock> getNormalPredecessors(ISSABasicBlock b) {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean hasEdge(ISSABasicBlock src, ISSABasicBlock dst) {
        Assertions.UNREACHABLE();
        return false;
    }

    public IntSet getSuccNodeNumbers(ISSABasicBlock node) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(ISSABasicBlock node) {
        Assertions.UNREACHABLE();
        return null;
    }

    private class BBEdge {
        public final boolean isFallThrough;
        public final SSACFG.BasicBlock src;
        public final SSACFG.BasicBlock dest;

        public BBEdge(SSACFG.BasicBlock src, SSACFG.BasicBlock dest, boolean isFallThrough) {
            this.src = src;
            this.dest = dest;
            this.isFallThrough = isFallThrough;
        }

        public boolean equals(Object other) {
            if (!(other instanceof BBEdge)) {
                return false;
            }
            BBEdge otherEdge = (BBEdge)other;
            return this.src.equals((Object)otherEdge.src) && this.dest.equals((Object)otherEdge.dest) && this.isFallThrough == otherEdge.isFallThrough;
        }

        public int hashCode() {
            return this.src.hashCode() + this.dest.hashCode();
        }

        public String toString() {
            return this.src + " -> " + this.dest;
        }
    }

    public class SingleInstructionBasicBlock
    implements ISSABasicBlock {
        private int number;
        private final SSAInstruction instruction;
        private final int normalInstructionIndex;
        private boolean isExit = false;
        private boolean isEntry = false;

        public SingleInstructionBasicBlock(int number, SSAInstruction instruction, int normalInstructionIndex) {
            this.number = number;
            this.instruction = instruction;
            this.normalInstructionIndex = normalInstructionIndex;
        }

        public SSAInstruction getInstruction() {
            return this.instruction;
        }

        public int getFirstInstructionIndex() {
            return this.normalInstructionIndex;
        }

        public int getLastInstructionIndex() {
            return this.normalInstructionIndex;
        }

        public boolean isCatchBlock() {
            return false;
        }

        public boolean isPiBlock() {
            return this.instruction instanceof SSAPiInstruction;
        }

        public void setIsEntryBlock(boolean val) {
            this.isEntry = val;
        }

        public void setIsExitBlock(boolean val) {
            this.isExit = val;
        }

        public boolean isExitBlock() {
            return this.isExit;
        }

        public boolean isEntryBlock() {
            return this.isEntry;
        }

        public IMethod getMethod() {
            return ExpandedControlFlowGraph.this.ir.getMethod();
        }

        public ExpandedControlFlowGraph getCFG() {
            return ExpandedControlFlowGraph.this;
        }

        public int getNumber() {
            return this.number;
        }

        public int getGraphNodeId() {
            return this.number;
        }

        public void setGraphNodeId(int id) {
            this.number = id;
        }

        public Iterator<SSAPhiInstruction> iteratePhis() {
            throw new UnsupportedOperationException("NYI");
        }

        public Iterator<SSAPiInstruction> iteratePis() {
            throw new UnsupportedOperationException("NYI");
        }

        public Iterator<SSAInstruction> iterator() {
            Set<SSAInstruction> s = Collections.singleton(this.instruction);
            return s.iterator();
        }

        public boolean equals(Object other) {
            if (!(other instanceof SingleInstructionBasicBlock)) {
                return false;
            }
            SingleInstructionBasicBlock otherBlock = (SingleInstructionBasicBlock)other;
            return otherBlock.number == this.number;
        }

        public int hashCode() {
            return this.number;
        }

        public String toString() {
            if (this.isEntry) {
                return "entry";
            }
            if (this.isExit) {
                return "exit";
            }
            return String.valueOf(this.number) + " : " + this.instruction.toString();
        }

        public SSAInstruction getLastInstruction() {
            return this.instruction;
        }

        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return null;
        }
    }

    public class SingleInstructionExceptionHandlerBlock
    extends SingleInstructionBasicBlock {
        public SingleInstructionExceptionHandlerBlock(int number, SSAInstruction instruction) {
            super(number, instruction, -1);
        }

        @Override
        public boolean isCatchBlock() {
            return true;
        }
    }
}

