/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc.sccp;

import com.ibm.safe.intraproc.sccp.ExpandedControlFlowGraph;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import java.io.FileWriter;
import java.util.Iterator;

public class ExpandedCFGDotWriter {
    public static void write(String fileName, ExpandedControlFlowGraph cfg) throws IllegalArgumentException {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg cannot be null");
        }
        StringBuffer result = new StringBuffer();
        result.append(ExpandedCFGDotWriter.dotOutput(cfg));
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(result.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    public static void write(String fileName, SSACFG cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg cannot be null");
        }
        StringBuffer result = new StringBuffer();
        result.append(ExpandedCFGDotWriter.dotOutput(cfg));
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(result.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    private static StringBuffer dotOutput(ExpandedControlFlowGraph cfg) {
        ExpandedControlFlowGraph.SingleInstructionBasicBlock bb;
        StringBuffer result = new StringBuffer("digraph \"ExpandedControlFlowGraph:\" {\n");
        result.append("center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        Iterator<ISSABasicBlock> it = cfg.iterator();
        while (it.hasNext()) {
            bb = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)it.next();
            result.append(ExpandedCFGDotWriter.dotOutput(bb));
            if (bb.isEntryBlock()) {
                result.append(" [color=green]\n");
                continue;
            }
            if (bb.isExitBlock()) {
                result.append(" [color=red]\n");
                continue;
            }
            result.append("\n");
        }
        it = cfg.iterator();
        while (it.hasNext()) {
            bb = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)it.next();
            Iterator<ISSABasicBlock> succIt = cfg.getSuccNodes(bb);
            while (succIt.hasNext()) {
                ExpandedControlFlowGraph.SingleInstructionBasicBlock succ = (ExpandedControlFlowGraph.SingleInstructionBasicBlock)succIt.next();
                result.append(ExpandedCFGDotWriter.dotOutput(bb));
                result.append(" -> ");
                result.append(ExpandedCFGDotWriter.dotOutput(succ));
                result.append("\n");
            }
        }
        result.append("}");
        return result;
    }

    private static StringBuffer dotOutput(SSACFG cfg) {
        StringBuffer result = new StringBuffer("digraph \"ControlFlowGraph:\" {\n");
        result.append("center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        for (SSACFG.BasicBlock bb : cfg) {
            result.append(ExpandedCFGDotWriter.dotOutput(bb));
            if (bb.isEntryBlock()) {
                result.append(" [color=green]\n");
                continue;
            }
            if (bb.isExitBlock()) {
                result.append(" [color=red]\n");
                continue;
            }
            result.append("\n");
        }
        for (SSACFG.BasicBlock bb : cfg) {
            Iterator succIt = cfg.getSuccNodes((ISSABasicBlock)bb);
            while (succIt.hasNext()) {
                SSACFG.BasicBlock succ = (SSACFG.BasicBlock)succIt.next();
                result.append(ExpandedCFGDotWriter.dotOutput(bb));
                result.append(" -> ");
                result.append(ExpandedCFGDotWriter.dotOutput(succ));
                result.append("\n");
            }
        }
        result.append("}");
        return result;
    }

    private static StringBuffer dotOutput(SSACFG.BasicBlock bb) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(bb.getNumber());
        result.append("\"");
        return result;
    }

    private static StringBuffer dotOutput(ExpandedControlFlowGraph.SingleInstructionBasicBlock bb) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(bb.getNumber());
        result.append("-");
        result.append(bb.getInstruction());
        result.append("\"");
        return result;
    }
}

