/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc;

import com.ibm.safe.intraproc.sccp.NewSCCPSolver;
import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.safe.processors.BaseMethodProcessor;
import com.ibm.safe.processors.InstructionProcessor;
import com.ibm.safe.reporting.message.Message;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.CompoundPiPolicy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.InstanceOfPiPolicy;
import com.ibm.wala.ssa.NullTestPiPolicy;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.util.CancelException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SCCPMethodProcessor
extends BaseMethodProcessor {
    private static final boolean DEBUG = false;
    private static final boolean NEW_SOLVER = true;
    private Set<Object> violations = new HashSet<Object>();

    public SCCPMethodProcessor(IClassHierarchy cha) {
        super(cha);
    }

    @Override
    public void process(IMethod method) throws CancelException {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        AnalysisOptions options = new AnalysisOptions();
        CompoundPiPolicy policy = CompoundPiPolicy.createCompoundPiPolicy((SSAPiNodePolicy)InstanceOfPiPolicy.createInstanceOfPiPolicy(), (SSAPiNodePolicy)NullTestPiPolicy.createNullTestPiPolicy());
        options.getSSAOptions().setPiNodePolicy((SSAPiNodePolicy)policy);
        IR ir = new AnalysisCacheImpl().getSSACache().findOrCreateIR(method, (Context)Everywhere.EVERYWHERE, options.getSSAOptions());
        if (ir == null) {
            return;
        }
        Map<Integer, SCCPValue> methodConstants = null;
        NewSCCPSolver solver = new NewSCCPSolver(ir);
        solver.solve();
        methodConstants = solver.getConstantValues();
        for (InstructionProcessor processor : this.instructionProcessors) {
            processor.setup(method, methodConstants, ir);
        }
        int i = 0;
        int size = ir.getInstructions().length;
        while (i < size) {
            SSAInstruction curr = ir.getInstructions()[i];
            if (curr != null) {
                for (InstructionProcessor processor : this.instructionProcessors) {
                    processor.processProlog(curr);
                    processor.process(curr, ir.getControlFlowGraph().getProgramCounter(i));
                    processor.processEpilog(curr);
                    Collection<? extends Message> resultMessages = processor.getResult();
                    this.violations.addAll(resultMessages);
                }
            }
            ++i;
        }
    }

    @Override
    public void processEpilog(IMethod method) {
    }

    @Override
    public Object getResult() {
        return this.violations;
    }
}

